

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetLiveSyncV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetLiveSyncV3.sp,v $ $Id: LicGetLiveSyncV3.sp,v 1.1.2.3 2020/08/14 14:35:18 scheppuri Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetLiveSyncV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetLiveSyncV3 <<<'
	drop procedure LicGetLiveSyncV3
END
IF EXISTS (select * from GxQscripts where name='LicGetLiveSyncV3')
	delete from GxQscripts where name = 'LicGetLiveSyncV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLiveSyncV3')
	delete from GXDBVersions where aliasname = 'LicGetLiveSyncV3'
GO
print '... Creating Procedure: LicGetLiveSyncV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetLiveSyncV3
AS
--Calculate LiveSync Pairs
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetLiveSyncV3'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @LiveSyncType int = 26
DECLARE @LiveSyncLicType int = 200016
DECLARE @current_LiveSyncPairs int = 0
DECLARE @last_LiveSyncPairs    int = 0
IF object_id('tempdb.dbo.#LiveSyncPairs') IS NOT null DROP TABLE #LiveSyncPairs
CREATE TABLE #LiveSyncPairs (t_SourceName NVARCHAR(max), t_SourceGuid VARCHAR(255), t_destinationName NVARCHAR(max), t_SourceClientid INT)
INSERT INTO #LiveSyncPairs
SELECT DISTINCT A.sourceName,A.sourceGuid,A.destinationName,
	   CASE WHEN isnumeric(VSARep.propertyValue) = 1 THEN cast(VSARep.propertyValue AS int)
			ELSE 0
	   END
FROM APP_VSAReplication A WITH (NOLOCK)
INNER JOIN TM_Task T WITH (NOLOCK) ON A.taskId = T.taskId AND T.disabled <> 1
LEFT JOIN APP_VSAReplicationProp VSARep ON A.replicationId = VSARep.replicationId AND propertyTypeId = 2221
UPDATE LSP
SET t_SourceClientid = T.componentNameId
FROM #LiveSyncPairs LSP INNER JOIN
(	SELECT attrval, max(componentNameId) AS componentNameId, row_number() over (partition by attrval ORDER BY created desc) as seqnum
	FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Machine Instance UUID' and modified=0
	GROUP BY attrVal,created
) AS T ON LSP.t_SourceGuid = T.attrVal
WHERE LSP.t_SourceClientid = 0 AND T.seqnum = 1
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @LiveSyncType)
DELETE FROM Lic_CurrentUsage WHERE UsageType = @LiveSyncType
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,LicType,ClientName,SubclientName,CapacityFlag, VMFlag, ObjectName)
SELECT DISTINCT @LiveSyncType,t_SourceClientid,@LiveSyncLicType,t_SourceName,t_SourceGuid,-1,0,t_destinationName
FROM  #LiveSyncPairs
SELECT @current_LiveSyncPairs = COUNT(ClientName) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @LiveSyncType
SELECT @last_LiveSyncPairs   = COUNT(ClientName) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @LiveSyncType AND PeakType = @CCLPeakType
IF @current_LiveSyncPairs >= @last_LiveSyncPairs AND @current_LiveSyncPairs > 0
BEGIN
DELETE Lic_PeakUsage WHERE MonthStart = @monthStart AND UsageType = @LiveSyncType AND PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,LicType,ClientName,SubclientName,CapacityFlag,VMFlag, ObjectName)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,LicType,ClientName,SubclientName,CapacityFlag,VMFlag,ObjectName
FROM Lic_CurrentUsage WITH (NOLOCK)
WHERE UsageType = @LiveSyncType
END
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,LicType,ClientName,SubclientName,CapacityFlag, VMFlag, ObjectName FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType  = @LiveSyncType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ClientName = S.ClientName AND T.ObjectName = S.ObjectName
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate,UsageType,PeakType,ClientId,LicType,ClientName,SubclientName,CapacityFlag, VMFlag, ObjectName)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.ClientId,S.LicType,S.ClientName,S.SubclientName,S.CapacityFlag,S.VMFlag,S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #LiveSyncPairs
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetLiveSyncV3')
	delete from GxQscripts where name = 'LicGetLiveSyncV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLiveSyncV3')
	delete from GXDBVersions where aliasname = 'LicGetLiveSyncV3'
GO

insert into GXDBVersions values(2, 'LicGetLiveSyncV3',  '00010001000200030000', 'LicGetLiveSyncV3', '00010001000200030000')
GO

