

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetLicenseUsagesV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Author: Lima Rose George
--		  Date:   05/18/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetLicenseUsagesV2.sp,v $ $Id: LicGetLicenseUsagesV2.sp,v 1.1.4.4 2018/08/27 14:53:50 leiwang Exp $";
SET ANSI_NULLS ON
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetLicenseUsagesV2 <<<'

IF EXISTS (select * from sysobjects where name='LicGetLicenseUsagesV2')
	drop procedure LicGetLicenseUsagesV2
IF EXISTS (select * from GxQscripts where name='LicGetLicenseUsagesV2')
	delete from GxQscripts where name = 'LicGetLicenseUsagesV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseUsagesV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseUsagesV2'
GO
print '... Creating Procedure: LicGetLicenseUsagesV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetLicenseUsagesV2
AS
--create current usage tables
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentUsageDetails')) DROP TABLE tempdb.dbo.LicCSCurrentUsageDetails
	CREATE TABLE tempdb.dbo.LicCSCurrentUsageDetails (EnterpriseBackupSize	BIGINT, CoreBackupSize	BIGINT, EnterpriseArchiveSize BIGINT, CoreArchiveSize BIGINT, SnapshotSize BIGINT, ReplicationSize	BIGINT,  nJobType INT, AppId INT, JobId INT, ClientName NVARCHAR(255), ClientId INT, AppTypeId INT, AppTypeName	NVARCHAR(255), BackupSetName NVARCHAR(128), InstanceName NVARCHAR(512), SubclientName NVARCHAR(128), SPId INT, SPName NVARCHAR(144), UncompBytes BIGINT, DedupEnabled INT, SecondaryEncryption INT, CapacityFlag INT, Snapshot INT, LicType INT, IsVM INT, ClientGroup NVARCHAR(1024), Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024))
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentCALDetails')) DROP TABLE tempdb.dbo.LicCSCurrentCALDetails
	CREATE TABLE tempdb.dbo.LicCSCurrentCALDetails (ObjectType INT, TypeName VARCHAR(64), ClientId INT, AppId INT, AppTypeName NVARCHAR(MAX), AppTypeId INT, LicType INT, JobId INT, ObjectName NVARCHAR(MAX), ObjectId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024))
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSLicenseInfo')) DROP TABLE tempdb.dbo.LicCSLicenseInfo
	CREATE TABLE tempdb.dbo.LicCSLicenseInfo (LicType INT, LicenseName VARCHAR(128), PermanentTotal INT, PermanentUsed INT,EvaluationTotal INT, EvaluationUsed INT,TermEndDate VARCHAR(128), UsedBy INT, Agent INT, InstallDate VARCHAR(128), ExpirationDate VARCHAR(128))
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicLSRConfig')) DROP TABLE tempdb.dbo.LicLSRConfig
	CREATE TABLE tempdb.dbo.LicLSRConfig (name VARCHAR(25), value INT)
IF OBJECT_ID('tempdb.dbo.#LicCurrentCALDetails') IS NOT NULL DROP TABLE #LicCurrentCALDetails
	CREATE TABLE #LicCurrentCALDetails (ObjectType INT, TypeName VARCHAR(64), ClientId INT, AppId INT, AppTypeName NVARCHAR(MAX), AppTypeId INT, LicType INT, JobId INT, ObjectName NVARCHAR(MAX), ObjectId INT, AppSizeMB BIGINT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024))
INSERT INTO tempdb.dbo.LicLSRConfig VALUES ('LSR running', 1);
INSERT INTO tempdb.dbo.LicLSRConfig VALUES ('Collection Time', dbo.GetUnixTime(GETDATE()));
DECLARE @ErrorCode INTEGER = 0
BEGIN TRY
	--get the current usage details
	--these stored procedures will inturn populate the commcell peak tables & subclient peak tables. Current usages will be returned back as output which is stored in tempdb tables
	IF (OBJECT_ID('LicGetCapacityDetailsV2') IS NOT NULL)
	BEGIN
		INSERT tempdb.dbo.LicCSCurrentUsageDetails
		EXEC LicGetCapacityDetailsV2
		SELECT @ErrorCode = @@ERROR
	END
	IF (OBJECT_ID('LicGetCALDetailsV2') IS NOT NULL) AND @ErrorCode = 0
	BEGIN
		EXEC LicGetCALDetailsV2
		SELECT @ErrorCode = @@ERROR
		INSERT tempdb.dbo.LicCSCurrentCALDetails
		SELECT ObjectType, TypeName, ClientId, AppId, AppTypeName, AppTypeId, LicType, JobId, ObjectName, ObjectId, AppSizeMB, Organization, OrgGUID, PlanName FROM #LicCurrentCALDetails
	END
	IF (OBJECT_ID('LicGetLicenseInfoV2') IS NOT NULL) AND @ErrorCode = 0
	BEGIN
		INSERT tempdb.dbo.LicCSLicenseInfo
		EXEC LicGetLicenseInfoV2
		SELECT @ErrorCode = @@ERROR
	END
END TRY
BEGIN CATCH
	SET @ErrorCode = -1
	GOTO LIC_ERROR
END CATCH
LIC_ERROR:
IF @ErrorCode <> 0
BEGIN
	IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentUsageDetails')) DROP TABLE tempdb.dbo.LicCSCurrentUsageDetails
	IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentCALDetails')) DROP TABLE tempdb.dbo.LicCSCurrentCALDetails
	IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSLicenseInfo')) DROP TABLE tempdb.dbo.LicCSLicenseInfo
END
DELETE FROM tempdb.dbo.LicLSRConfig WHERE name='LSR running'
DROP TABLE #LicCurrentCALDetails
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetLicenseUsagesV2')
	delete from GxQscripts where name = 'LicGetLicenseUsagesV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseUsagesV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseUsagesV2'
GO

insert into GXDBVersions values(2, 'LicGetLicenseUsagesV2',  '00010001000400040000', 'LicGetLicenseUsagesV2', '00010001000400040000')
GO

