

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetLicenseInfoV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetLicenseInfoV3.sp,v $ $Id: LicGetLicenseInfoV3.sp,v 1.1.2.4 2019/04/17 17:16:41 leiwang Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetLicenseInfoV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetLicenseInfoV3 <<<'
	drop procedure LicGetLicenseInfoV3
END
IF EXISTS (select * from GxQscripts where name='LicGetLicenseInfoV3')
	delete from GxQscripts where name = 'LicGetLicenseInfoV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseInfoV3')
	delete from GXDBVersions where aliasname = 'LicGetLicenseInfoV3'
GO
print '... Creating Procedure: LicGetLicenseInfoV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetLicenseInfoV3
AS
--Populate total/used count and expiration information for each type of purchased licenses
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @attrName varchar (256) ='LicGetLicenseInfoV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'   --0 successful  --1 failed
DECLARE @evalFld    varchar(1024)
DECLARE @permFld    varchar(1024)
DECLARE @licTypeId  integer
DECLARE @evalTotal  integer
DECLARE @evalUsed   integer
DECLARE @bEval      integer
DECLARE @evalExpiry integer
DECLARE @permTotal  integer
DECLARE @permUsed   integer
DECLARE @expDate	integer = 0
DECLARE @licKey			varchar(8000)
DECLARE @MachID			integer
DECLARE @DRMachID		integer
DECLARE @newRepMachID	integer
DECLARE @csId			integer
DECLARE @OEMId			integer
DECLARE @plattype		integer
DECLARE @relnum			integer
DECLARE @keyType		integer
DECLARE @rmkc			integer
DECLARE @evalDays		integer
DECLARE @enclic			varchar(5000)
DECLARE @licTypeList	varchar(5000)
DECLARE @csGUIDInKey	varchar(64)
DECLARE @softCap		integer
SET @licKey = (SELECT TOP 1 EncLicKey FROM LicCsl WITH (NOLOCK) ORDER BY id DESC)
EXEC dbo.xp_RetrieveValidateLicKeyInfo @licKey,
        @MachID OUTPUT, @DRMachID OUTPUT, @newRepMachID OUTPUT, @csId OUTPUT, @OEMId OUTPUT, @plattype OUTPUT,
        @relnum OUTPUT, @keyType OUTPUT, @rmkc OUTPUT, @evalDays OUTPUT, @expDate OUTPUT, @enclic OUTPUT, @licTypeList OUTPUT,@csGUIDInKey OUTPUT, @softCap OUTPUT
IF (@plattype = 1 )
BEGIN
    DECLARE @expDT1 DATETIME
    SELECT @expDT1 = MAX(ExpiryDateUTC) FROM licUsage WITH (NOLOCK) WHERE eval = 1 AND OpType = 'Install' AND ExpiryDateUTC > '1970-01-01' AND CID = 2
    SET @expDate = ISNULL(dbo.GetUnixTime(@expDT1), 0)
END
IF object_id('tempdb.dbo.#LicData') IS NOT null DROP TABLE #LicData
CREATE TABLE #LicData  (
    LicType                     INTEGER,
	TotalPermLicensesIssued     INTEGER,
    TotalPermLicensesUsed       INTEGER,
    TotalEvalLicensesIssued     INTEGER,
    TotalEvalLicensesUsed       INTEGER,
	EvalLicenseExpiryDate       INTEGER
)
IF object_id('tempdb.dbo.#LicAppType') IS NOT null DROP TABLE  #LicAppType
CREATE TABLE #LicAppType (simLicAppTypeId INT, eval_fld1 VARCHAR(64), perm_fld1 VARCHAR(64))
EXEC sp_executesql N'INSERT INTO #LicAppType SELECT simLicAppTypeId, RTRIM(eval_fld1), RTRIM(perm_fld1) FROM licAAL A WITH (NOLOCK) WHERE  commcellId = 2'
DECLARE licList CURSOR FOR
    SELECT B.id, eval_fld1, perm_fld1
    FROM #LicAppType A INNER JOIN simLicAppTypeV2 B WITH (NOLOCK) ON A.simLicAppTypeId = B.id
OPEN licList
FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
WHILE @@FETCH_STATUS <> -1
BEGIN
    SET @evalTotal  = 0
    SET @evalUsed   = 0
    SET @bEval      = 0
    SET @evalExpiry = 0
    SET @permTotal  = 0
    SET @permUsed   = 0
    IF len(@evalFld) > 0
       EXEC dbo.xp_getAALInfo2 @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
    IF len(@permFld) > 0
        EXEC dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
    INSERT INTO #LicData
    SELECT  @licTypeId, @permTotal, @permUsed, @evalTotal, @evalUsed, @evalExpiry
    FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
END
CLOSE licList
DEALLOCATE licList
BEGIN TRY
BEGIN TRAN
TRUNCATE TABLE Lic_LicenseInfo
INSERT INTO Lic_LicenseInfo
SELECT D.LicType,D.TotalPermLicensesIssued,D.TotalPermLicensesUsed,D.TotalEvalLicensesIssued,D.TotalEvalLicensesUsed,
	dbo.GetDateTime(D.EvalLicenseExpiryDate),
	ISNULL(C.id,0),C.name,ISNULL(A.type,0),ISNULL(L.OpTimeUTC,dbo.GetDateTime(0)),
	dbo.GetDateTime(@expDate)
FROM #LicData D
LEFT JOIN LicUsage L WITH(NOLOCK) ON D.LicType = L.LicType and L.OpType = 'Install'
LEFT JOIN APP_iDAType A WITH(NOLOCK) ON A.type = L.AppType
LEFT JOIN app_client C WITH(NOLOCK) ON L.cid = C.id
WHERE D.LicType < 1000
UNION
SELECT D.LicType,D.TotalPermLicensesIssued,D.TotalPermLicensesUsed,D.TotalEvalLicensesIssued,D.TotalEvalLicensesUsed,
	dbo.GetDateTime(D.EvalLicenseExpiryDate),
	0,NULL,0,dbo.GetDateTime(0),dbo.GetDateTime(@expDate)
FROM #LicData D
WHERE D.LicType >= 1000
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #LicAppType
DROP TABLE #LicData
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetLicenseInfoV3')
	delete from GxQscripts where name = 'LicGetLicenseInfoV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseInfoV3')
	delete from GXDBVersions where aliasname = 'LicGetLicenseInfoV3'
GO

insert into GXDBVersions values(2, 'LicGetLicenseInfoV3',  '00010001000200040000', 'LicGetLicenseInfoV3', '00010001000200040000')
GO

