

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetLicenseInfoV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetLicenseInfoV2.sp,v $ $Id: LicGetLicenseInfoV2.sp,v 1.1.4.4 2019/01/30 19:20:04 miyengar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetLicenseInfoV2')
BEGIN
	print '>>> Drop Stored Procedure: LicGetLicenseInfoV2 <<<'
	drop procedure LicGetLicenseInfoV2
END
IF EXISTS (select * from GxQscripts where name='LicGetLicenseInfoV2')
	delete from GxQscripts where name = 'LicGetLicenseInfoV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseInfoV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseInfoV2'
GO
print '... Creating Procedure: LicGetLicenseInfoV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetLicenseInfoV2
AS
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @evalFld    varchar(1024)
DECLARE @permFld    varchar(1024)
DECLARE @licName    varchar(1024)
DECLARE @licTypeId  integer
DECLARE @evalTotal  integer
DECLARE @evalUsed   integer
DECLARE @bEval      integer
DECLARE @evalExpiry integer
DECLARE @permTotal  integer
DECLARE @permUsed   integer
DECLARE @expDate	integer = 0
IF EXISTS (SELECT 1 FROM APP_Client WITH (NOLOCK) WHERE id = 2 AND releaseId >= 15)
BEGIN
    DECLARE @licKey			varchar(8000)
    DECLARE @MachID			integer
    DECLARE @DRMachID		integer
    DECLARE @newRepMachID	integer
    DECLARE @csId			integer
    DECLARE @OEMId			integer
    DECLARE @plattype		integer
    DECLARE @relnum			integer
    DECLARE @keyType		integer
    DECLARE @rmkc			integer
    DECLARE @evalDays		integer
    DECLARE @enclic			varchar(5000)
    DECLARE @licTypeList	varchar(5000)
    DECLARE @csGUIDInKey	varchar(64)
    DECLARE @csVersion		integer = 15
    DECLARE @softCap		integer
    SET @licKey = (SELECT TOP 1 EncLicKey FROM LicCsl WITH (NOLOCK) ORDER BY id DESC)
	SELECT @csVersion = MAX(id) FROM simAllGalaxyRel WITH(NOLOCK)
	IF  @csVersion >=16 --if CSVERSION >=11 use extra field @csGUIDInKey
    BEGIN
    EXEC dbo.xp_RetrieveValidateLicKeyInfo @licKey,
        @MachID OUTPUT, @DRMachID OUTPUT, @newRepMachID OUTPUT, @csId OUTPUT, @OEMId OUTPUT, @plattype OUTPUT,
        @relnum OUTPUT, @keyType OUTPUT, @rmkc OUTPUT, @evalDays OUTPUT, @expDate OUTPUT, @enclic OUTPUT, @licTypeList OUTPUT,@csGUIDInKey OUTPUT, @softCap OUTPUT
    END
    ELSE
    BEGIN
    EXEC dbo.xp_RetrieveValidateLicKeyInfo @licKey,
        @MachID OUTPUT, @DRMachID OUTPUT, @newRepMachID OUTPUT, @csId OUTPUT, @OEMId OUTPUT, @plattype OUTPUT,
        @relnum OUTPUT, @keyType OUTPUT, @rmkc OUTPUT, @evalDays OUTPUT, @expDate OUTPUT, @enclic OUTPUT, @licTypeList OUTPUT
    END
    IF (@plattype = 1 )
    BEGIN
                    DECLARE @expDT1 DATETIME
                    IF  @csVersion =15
                                    SELECT @expDT1 = MAX(ExpiryDateUTC) FROM licUsage WITH (NOLOCK) WHERE eval = 1 AND OpType = 'Install' AND ExpiryDateUTC > '1970-01-01' AND CID = 2 AND LicType IN (SELECT simLicAppType FROM simAppTypeLicTypeMap WITH (NOLOCK) WHERE isCellLevel > 0)
                    ELSE
                                    SELECT @expDT1 = MAX(ExpiryDateUTC) FROM licUsage WITH (NOLOCK) WHERE eval = 1 AND OpType = 'Install' AND ExpiryDateUTC > '1970-01-01' AND CID = 2
                    SET @expDate = ISNULL(dbo.GetUnixTime(@expDT1), 0)
    END
END
ELSE
BEGIN
    DECLARE @expDT DATETIME
    SELECT @expDT = MAX(ExpiryDateUTC) FROM licUsage WITH (NOLOCK) WHERE eval = 0 AND OpType = 'Install' AND ExpiryDateUTC > '1970-01-01'
    SET @expDate = ISNULL(dbo.GetUnixTime(@expDT), 0)
END
IF object_id('tempdb.dbo.#LicData') IS NOT null DROP TABLE #LicData
CREATE TABLE #LicData  (
    LicType                     INTEGER,
	LicName						VARCHAR(1024),
    TotalPermLicensesIssued     INTEGER,
    TotalPermLicensesUsed       INTEGER,
    TotalEvalLicensesIssued     INTEGER,
    TotalEvalLicensesUsed       INTEGER,
	EvalLicenseExpiryDate       INTEGER
)
IF object_id('tempdb.dbo. #LicAppType') IS NOT null DROP TABLE  #LicAppType
CREATE TABLE #LicAppType (simLicAppTypeId INT, eval_fld1 CHAR(64), perm_fld1 CHAR(64))
IF  EXISTS (SELECT id FROM APP_Client WITH(NOLOCK) WHERE id = 2 AND releaseId >= 15)
    EXEC sp_executesql N'INSERT INTO #LicAppType SELECT simLicAppTypeId, eval_fld1, perm_fld1 FROM licAAL A WITH (NOLOCK) WHERE  commcellId = 2'
ELSE
    EXEC sp_executesql N'INSERT INTO #LicAppType SELECT simLicAppTypeId, eval_fld1, perm_fld1 FROM licAAL A WITH (NOLOCK)'
DECLARE licList CURSOR FOR
    SELECT B.id, B.short_name, eval_fld1, perm_fld1
    FROM #LicAppType A INNER JOIN simLicAppTypeV2 B WITH (NOLOCK) ON A.simLicAppTypeId = B.id
OPEN licList
FETCH NEXT FROM licList INTO @licTypeId, @licName, @evalFld, @permFld
WHILE @@FETCH_STATUS <> -1
BEGIN
    SET @evalTotal  = 0
    SET @evalUsed   = 0
    SET @bEval      = 0
    SET @evalExpiry = 0
    SET @permTotal  = 0
    SET @permUsed   = 0
    IF len(@evalFld) > 0
    BEGIN
        IF  EXISTS (SELECT id FROM APP_Client WITH (NOLOCK) WHERE id = 2 AND releaseId >= 16)
            EXEC dbo.xp_getAALInfo2 @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
        ELSE
            EXEC dbo.xp_getAALInfo @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT
    END
	IF len(@permFld) > 0
        EXEC dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
    INSERT INTO #LicData
    SELECT  @licTypeId, @licName, @permTotal, @permUsed, @evalTotal, @evalUsed, @evalExpiry
    FETCH NEXT FROM licList INTO @licTypeId, @licName, @evalFld, @permFld
END
CLOSE licList
DEALLOCATE licList
DROP TABLE #LicAppType
IF object_id('tempdb.dbo.#LicInfo') IS NOT NULL
BEGIN
    TRUNCATE TABLE #LicInfo
    INSERT INTO #LicInfo
	SELECT D.LicType,D.LicName,D.TotalPermLicensesIssued,D.TotalPermLicensesUsed,D.TotalEvalLicensesIssued,D.TotalEvalLicensesUsed,
	(case D.EvalLicenseExpiryDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(D.EvalLicenseExpiryDate), 101) end),
	ISNULL(C.id,0),ISNULL(A.type,0),ISNULL(convert(nvarchar(MAX), L.OpTimeUTC, 101),'N/A'),
	(case @expDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(@expDate), 101) end)
	FROM #LicData D
	left join LicUsage L WITH(NOLOCK) ON D.LicType = L.LicType and L.OpType = 'Install'
	left join APP_iDAType A WITH(NOLOCK) ON A.type = L.AppType
	left join app_client C WITH(NOLOCK) ON L.cid = C.id
	WHERE D.LicType < 1000
	UNION
	SELECT D.LicType,D.LicName,D.TotalPermLicensesIssued,D.TotalPermLicensesUsed,D.TotalEvalLicensesIssued,D.TotalEvalLicensesUsed,
	(case D.EvalLicenseExpiryDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(D.EvalLicenseExpiryDate), 101) end),
	0,0,NULL,(case @expDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(@expDate), 101) end)
	FROM #LicData D
	WHERE D.LicType >= 1000
END
ELSE
	SELECT D.LicType AS License_Type,
	D.LicName AS License_Name,
	D.TotalPermLicensesIssued AS Permanent_Total,
	D.TotalPermLicensesUsed AS Permanent_Used,
	D.TotalEvalLicensesIssued AS Evaluation_Total,
	D.TotalEvalLicensesUsed AS Evaluation_Used,
	(case D.EvalLicenseExpiryDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(D.EvalLicenseExpiryDate), 101) end) AS Term_End_Date,
	ISNULL(C.id,0) AS Used_By,
	ISNULL(A.type,0) AS Agent,
	ISNULL(convert(nvarchar(MAX), L.OpTimeUTC, 101),'N/A') AS Install_Date,
	(case @expDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(@expDate), 101) end)as Expiration_Date
	FROM #LicData D
	left join LicUsage L WITH(NOLOCK) ON D.LicType = L.LicType and L.OpType = 'Install'
	left join APP_iDAType A WITH(NOLOCK) ON A.type = L.AppType
	left join app_client C WITH(NOLOCK) ON L.cid = C.id
	WHERE D.LicType < 1000
	UNION
	SELECT D.LicType AS License_Type,
	D.LicName AS License_Name,
	D.TotalPermLicensesIssued AS Permanent_Total,
	D.TotalPermLicensesUsed AS Permanent_Used,
	D.TotalEvalLicensesIssued AS Evaluation_Total,
	D.TotalEvalLicensesUsed AS Evaluation_Used,
	(case D.EvalLicenseExpiryDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(D.EvalLicenseExpiryDate), 101) end) AS Term_End_Date,
	0 AS Used_By,
	0 AS Agent,
	NULL AS Install_Date,
	(case @expDate when 0 then 'N/A' else convert(nvarchar(MAX), dbo.GetDateTime(@expDate), 101) end) AS Expiration_Date
	FROM #LicData D
	WHERE D.LicType >= 1000
	Order BY D.LicName,Used_By,Install_Date
DROP TABLE #LicData
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetLicenseInfoV2')
	delete from GxQscripts where name = 'LicGetLicenseInfoV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseInfoV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseInfoV2'
GO

insert into GXDBVersions values(2, 'LicGetLicenseInfoV2',  '00010001000400040000', 'LicGetLicenseInfoV2', '00010001000400040000')
GO

