

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetLicenseDetailsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Author: Lima Rose George
--		  Date:   05/18/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetLicenseDetailsV2.sp,v $ $Id: LicGetLicenseDetailsV2.sp,v 1.1.4.9 2018/08/30 16:20:14 lgeorge Exp $";
SET ANSI_NULLS ON
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetLicenseDetailsV2 <<<'

IF EXISTS (select * from sysobjects where name='LicGetLicenseDetailsV2')
	drop procedure LicGetLicenseDetailsV2
IF EXISTS (select * from GxQscripts where name='LicGetLicenseDetailsV2')
	delete from GxQscripts where name = 'LicGetLicenseDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseDetailsV2'
GO
print '... Creating Procedure: LicGetLicenseDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetLicenseDetailsV2
  @option INTEGER = 0,
  @noOfMonths INTEGER = 12,
  @monthString VARCHAR(20) = ''
AS
--@option=0 - details for backup dial
--@option=1 - details for archive dial
--@option=2 - details for snap dial
--@option=3 - details for replication dial
--@option=4 - all protected vms
--@option=5 - all jobs excluded from capacity when vmSockets license is purchased
--@option=6 - list of vm sockets
--@option=7 - list of archived vms
--@option=8 - list of appClassVirtual VMs
--@option=9 - list of end point users
--@option=10 - list of end point sharing users
--@option=11 - list of end point ediscovery users
--@option=12 - list of vm only
--@option=13 - list of advanced vms
--@option=14 - list of jobs on appServers
--@option=15 - list of jobs on DLO
--@option=16 - list of jobs on FSO server
--@option=17 - list of mbArchiveSolutions
--@option=18 - all mSim jobs excluded from capacity
--@option=19 - all jobs excluded from capacity when ACV license is purchased
--@option=20 - all DLP jobs excluded from capacity
--@option=21 - all edge drive jobs excluded from capacity
--@option=22 - all jobs excluded from capacity when protected vm license is purchased
--@option=23 - display aggregated current usage if stored procedure is invoked from the landing page of the UI report
--@option=24 - list of appServers without usages
--@option=25 - list of DLOs without usages
--@option=26 - list of FSOs without usages
--@option=27 - list of all other licenses and usages (rest of the licenses that are purchased but not displayed anywhere)
--@option=28 - list of remaining usage based licenses
--@option=29 - all jobs excluded from capacity when archivedVM license is purchased
--------following options are to draw peak license graphs
--@option=30 - data to draw capacity peak usage graphs for past N months
--@option=31 - data to draw CAL peak usage graphs for past N months
--------following options will give CCL peak usage details
--@option=32 - CCL peak backup details for the given month
--@option=33 - CCL peak archive details for the given month
--@option=34 - CCL peak snaphot details for the given month
--@option=35 - CCL peak replication details for the given month
--@option=36 - CCL peak vmsocket details for the given month
--@option=37 - CCL peak protected vm details for the given month
--@option=38 - CCL peak acv vm details for the given month
--@option=39 - CCL peak archived vm details for the given month
--@option=40 - CCL peak msim user details for the given month
--@option=41 - CCL peak endpoint user details for the given month
--@option=42 - CCL peak ep sharing user details for the given month
--@option=43 - CCL peak ep ediscovery user details for the given month
--@option=44 - CCL peak FSO details for the given month
--@option=45 - CCL peak DLO details for the given month
--@option=46 - CCL peak app server details for the given month
--@option=47 - CCL peak VM only details for the given month
--@option=48 - CCL peak advanced vms details for the given month
--@option=50 - CCL peak usages excluded from capacity when vm sockets license is purchased
--@option=51 - CCL peak usages excluded from capacity when protected vm license is purchased
--@option=52 - CCL peak usages excluded from capacity when ACV license is purchased
--@option=53 - CCL peak usages excluded from capacity when archived vm license is purchased
--@option=54 - CCL peak DLP jobs excluded from capacity
--@option=55 - CCL peak edge drive jobs excluded from capacity
--@option=56 - CCL peak mSim jobs excluded from capacity
--@option=57 - CCL peak appServers without usages
--@option=58 - CCL peak DLOs without usages
--@option=59 - CCL peak FSOs without usages
--------get misc details
--@option=49 - get last collection time
--@option=60 - Get list of past N months for peak usages
DECLARE @lastCollectionTime DATETIME = NULL
DECLARE @month DATETIME = NULL
BEGIN TRY
	--check if LSR is already running by any other user. If yes, wait till it completes
	DECLARE @lsrRunning INT=0
	IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicLSRConfig'))
		SELECT @lsrRunning=1 FROM tempdb.dbo.LicLSRConfig WITH (NOLOCK) WHERE name='LSR running'
	DECLARE @retryCount INT = 0
	WHILE @lsrRunning=1
	BEGIN
		--wait for 20 seconds and check again
		WAITFOR DELAY '00:00:20'
		SET @lsrRunning=0
		SELECT @lsrRunning=1 FROM tempdb.dbo.LicLSRConfig WITH (NOLOCK) WHERE name='LSR running'
		SET @retryCount = @retryCount+1
		IF @retryCount > 15--wait in this loop only for a maximum of 5 minutes
			GOTO LIC_ERROR
	END
	--Next step, is to check for the existence of current usage tables. If any of these tables do not exist, then run the stored procedure to populate it
	--in the first 2 tables, if plan column is not present, then also run the stored procedure to repopulate the tables
	DECLARE @usageExists INT=0
	IF NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentUsageDetails'))
		SET @usageExists = 1
	ELSE
	BEGIN
		IF COL_LENGTH('tempdb.dbo.LicCSCurrentUsageDetails','PlanName') IS NULL
			SET @usageExists = 1
	END
	IF NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentCALDetails'))
		SET @usageExists = 1
	ELSE
	BEGIN
		IF COL_LENGTH('tempdb.dbo.LicCSCurrentCALDetails','PlanName') IS NULL
			SET @usageExists = 1
	END
	IF NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSLicenseInfo')) OR NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicLSRConfig'))
		SET @usageExists = 1
	IF @option NOT IN (49, 60)
	BEGIN
		IF @usageExists=1--generate LSR if any of the current usage table is missing
			EXEC LicGetLicenseUsagesV2
		--check once again if all temp tables exists. If not, exit
		IF NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentUsageDetails')) OR NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSCurrentCALDetails')) OR NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicCSLicenseInfo')) OR NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicLSRConfig'))
			GOTO LIC_ERROR
	END
	IF NOT EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb.dbo.LicLSRConfig'))
		SET @lastCollectionTime=0
	ELSE
		SELECT @lastCollectionTime=dbo.GetDateTime(value) FROM tempdb.dbo.LicLSRConfig WITH (NOLOCK) WHERE name='Collection Time'
	SET @month=CONVERT(DATE,@monthString)
	IF @month=NULL OR @month > GETDATE()
	BEGIN
		SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
	END
END TRY
BEGIN CATCH
	GOTO LIC_ERROR
END CATCH
--Next, based on the input option, return appropriate resultset
IF @option BETWEEN 0 AND 3--details for backup/archive/snap/replication dials
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE njobtype=@option AND CapacityFlag=0
END
ELSE IF @option=4--all protected vms
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=20
	UNION
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=18 AND JobId>0
	ORDER BY ObjectName
END
ELSE IF @option=5--all jobs excluded from capacity when vmSockets license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=1
END
ELSE IF @option=6--list of vm sockets
BEGIN
	SELECT ObjectName AS 'Hypervisor Host', ISNULL(AppSizeMB,0) AS 'Sockets', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=19 ORDER BY ObjectName
END
ELSE IF @option=7--list of archived vms
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Archived Job', ISNULL(AppSizeMB,0) AS 'Archived VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=21 ORDER BY ObjectName
END
ELSE IF @option=8--list of appClassVirtual VMs
BEGIN
	DECLARE @vms TABLE(vmId INT, vmName NVARCHAR(1024),isProtected VARCHAR(5), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
	INSERT @vms
	SELECT DISTINCT ObjectId, ObjectName, CASE WHEN JobId>0 THEN 'Yes' ELSE 'No' END, AppTypeName, JobId, ISNULL(AppSizeMB,0),OrgGUID, Organization, PlanName
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=18 ORDER BY ObjectName
	SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
	STUFF(
		(SELECT ', ' + CONVERT(VARCHAR(1024),package)
		FROM @vms
		WHERE vmId=V.vmId AND vmName=V.vmName
		FOR XML PATH (''))
		, 1, 1, '')  AS 'Package',
	isProtected AS 'Is VM Protected', jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
	FROM @vms V
	GROUP BY vmId,vmName,isProtected, jobId,orgId,org,planName
	ORDER BY vmName
END
ELSE IF @option=9--list of end point users
BEGIN
	SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM tempdb.dbo.LicCSCurrentCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=22 ORDER BY ObjectName
END
ELSE IF @option=10--list of end point sharing users
BEGIN
	SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM tempdb.dbo.LicCSCurrentCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=23 ORDER BY ObjectName
END
ELSE IF @option=11--list of end point ediscovery users
BEGIN
	SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM tempdb.dbo.LicCSCurrentCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=24 ORDER BY ObjectName
END
ELSE IF @option=12--list of vm only
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=20 ORDER BY ObjectName
END
ELSE IF @option=13--list of advanced VMs
BEGIN
	DECLARE @advVms TABLE(vmId INT, vmName NVARCHAR(1024), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
	INSERT @advVms
	SELECT DISTINCT ObjectId, ObjectName, AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=26 ORDER BY ObjectName
	SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
	STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @advVms
			WHERE vmId=V.vmId AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
			jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
	FROM @advVms V
	GROUP BY vmId,vmName,jobId,orgId,org,planName
	ORDER BY vmName
END
ELSE IF @option=14--list of jobs on appServers
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE ClientId IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=1)
END
ELSE IF @option=15--list of jobs on DLO
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE ClientId IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=2)
END
ELSE IF @option=16--list of jobs on FSO server
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE ClientId IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=3)
END
ELSE IF @option=17--list of mbArchiveSolutions
BEGIN
	SELECT ObjectName AS 'SMTP', AppTypeName AS 'Name', ISNULL(A.name,'') AS 'Client', ISNULL(B.subclientName,'') AS 'Subclient', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM tempdb.dbo.LicCSCurrentCALDetails L WITH (NOLOCK)
	LEFT JOIN APP_Client A WITH (NOLOCK) ON L.ClientId = A.id
	LEFT JOIN APP_Application B WITH (NOLOCK) ON AppId = B.id
	WHERE L.ClientId > 0 AND L.AppId > 0 AND ObjectType=17 ORDER BY ObjectName
END
ELSE IF @option=18--all mSim jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=2
END
ELSE IF @option=19--all jobs excluded from capacity when ACV license is purchased (vms may be protected or non protected)
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=4
END
ELSE IF @option=20--all DLP jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=16
END
ELSE IF @option=21--all edge drive jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=8
END
ELSE IF @option=22--all jobs excluded from capacity when protected vm license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=1
END
ELSE IF @option=23 --display aggregated current usage if stored procedure is invoked from the landing page of the UI report
BEGIN
	DECLARE @dials TABLE(dialName VARCHAR(20),licType INT, purchased INT, permTotal INT, evalTotal INT, termEndDate VARCHAR(128), usage FLOAT)
	INSERT @dials VALUES('backup',100002,0,0,0,'N/A',0)
	INSERT @dials VALUES('archive',100004,0,0,0,'N/A',0)
	INSERT @dials VALUES('snapshot',100005,0,0,0,'N/A',0)
	INSERT @dials VALUES('replication',100006,0,0,0,'N/A',0)
	INSERT @dials VALUES('vmSockets',100018,0,0,0,'N/A',0)
	INSERT @dials VALUES('protectedVMs',100019,0,0,0,'N/A',0)
	INSERT @dials VALUES('appClassVirtual',100027,0,0,0,'N/A',0)
	INSERT @dials VALUES('archivedVMs',100021,0,0,0,'N/A',0)
	INSERT @dials VALUES('epUser',100024,0,0,0,'N/A',0)
	INSERT @dials VALUES('epSharingUser',100025,0,0,0,'N/A',0)
	INSERT @dials VALUES('epEDiscoveryUser',100026,0,0,0,'N/A',0)
	INSERT @dials VALUES('mbArchivedSolution',100028,0,0,0,'N/A',0)
	INSERT @dials VALUES('FSO',100029,0,0,0,'N/A',0)
	INSERT @dials VALUES('DLO',200002,0,0,0,'N/A',0)
	INSERT @dials VALUES('appServer',100030,0,0,0,'N/A',0)
	INSERT @dials VALUES('vmOnly',200001,0,0,0,'N/A',0)
	INSERT @dials VALUES('advancedVM',200003,0,0,0,'N/A',0)
	--get capacity license quantities purchased
	UPDATE D SET
		D.permTotal=ISNULL(PermanentTotal,0)/1024,
		D.evalTotal=ISNULL(EvaluationTotal,0)/1024,
		D.purchased=CASE WHEN (ISNULL(PermanentTotal,0)>=0 AND ISNULL(EvaluationTotal,0)>=0) THEN (ISNULL(PermanentTotal,0)/1024+ISNULL(EvaluationTotal,0)/1024)
						 ELSE CASE WHEN (ISNULL(PermanentTotal,0)=-1 OR ISNULL(EvaluationTotal,0)=-1) THEN -1
								   ELSE 0
							  END
					END,
		D.termEndDate=CASE WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN L.TermEndDate
						   ELSE 'N/A'
					  END
	FROM @dials D INNER JOIN tempdb.dbo.LicCSLicenseInfo L ON L.LicType=D.licType
	WHERE D.licType IN (100002,100004,100005,100006)
	--get usage based license quantities purchased
	UPDATE D SET
		D.permTotal=ISNULL(PermanentTotal,0),
		D.evalTotal=ISNULL(EvaluationTotal,0),
		D.purchased=CASE WHEN (ISNULL(PermanentTotal,0)>0 OR ISNULL(PermanentTotal,0)=-1) THEN ISNULL(PermanentTotal,0)
						 WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN ISNULL(EvaluationTotal,0)
						 ELSE 0
					END,
		D.termEndDate=CASE WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN L.TermEndDate
						   ELSE 'N/A'
					  END
	FROM @dials D INNER JOIN tempdb.dbo.LicCSLicenseInfo L ON L.LicType=D.licType
	WHERE D.LicType IN (100018,100019,100021,100024,100025,100026,100027,100028)
	--get capacity based licenses used
	UPDATE @dials SET usage=(SELECT CEILING(ISNULL(SUM(UncompBytes),0)/1024/1024) FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK) WHERE CapacityFlag=0 AND nJobType=0) WHERE licType=100002
	UPDATE @dials SET usage=(SELECT CEILING(ISNULL(SUM(UncompBytes),0)/1024/1024) FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK) WHERE CapacityFlag=0 AND nJobType=1) WHERE licType=100004
	UPDATE @dials SET usage=(SELECT CEILING(ISNULL(SUM(UncompBytes),0)/1024/1024) FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK) WHERE CapacityFlag=0 AND nJobType=2) WHERE licType=100005
	UPDATE @dials SET usage=(SELECT CEILING(ISNULL(SUM(UncompBytes),0)/1024/1024) FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK) WHERE CapacityFlag=0 AND nJobType=3) WHERE licType=100006
	--get usage based licenses used
    DECLARE @protVm INT=0
	DECLARE @acvProt INT=0
	SELECT @protVm=COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=20
	SELECT @acvProt=COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=18 AND jobId>0
	UPDATE @dials SET usage=(SELECT ISNULL(SUM(AppSizeMB),0) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=19) WHERE licType=100018
	UPDATE @dials SET usage=(@protVM+@acvProt) WHERE licType=100019
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=18) WHERE licType=100027
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=21) WHERE licType=100021
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=22) WHERE licType=100024
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=23) WHERE licType=100025
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=24) WHERE licType=100026
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectName) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=17) WHERE licType=100028
	--get new licenses used
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ClientId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=3) WHERE licType=100029
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ClientId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=2) WHERE licType=200002
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ClientId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=1) WHERE licType=100030
	UPDATE @dials SET usage=(SELECT COUNT(DISTINCT ObjectId) FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=26) WHERE licType=200003
	UPDATE @dials SET usage=(@protVm) WHERE licType=200001
	SELECT dialName AS 'Dial', licType AS 'License ID', purchased AS 'Purchased', permTotal AS 'Permanent Total', evalTotal AS 'evaluationTotal', usage AS 'Used', termEndDate AS 'Term End Date' FROM @dials
END
ELSE IF @option=24--list of appServers
BEGIN
	SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
	WHERE ClientId > 0 AND ObjectType=1
	AND ClientId NOT IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK))
	ORDER BY [Client]
END
ELSE IF @option=25--list of DLOs
BEGIN
	SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
	WHERE ClientId > 0 AND ObjectType=2
	AND ClientId NOT IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK))
	ORDER BY [Client]
END
ELSE IF @option=26--list of FSOs
BEGIN
	SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
	WHERE ClientId > 0 AND ObjectType=3
	AND ClientId NOT IN (SELECT DISTINCT ClientId FROM tempdb.dbo.LicCSCurrentUsageDetails WITH (NOLOCK))
	ORDER BY [Client]
END
ELSE IF @option=27--list of all other licenses and usages (rest of the licenses that are purchased but not displayed anywhere)
BEGIN--required only when displaying current license usage
	SELECT LicType AS 'License ID', LicenseName AS 'License', PermanentTotal AS 'Permanent Total', PermanentUsed AS 'Permanent Used', EvaluationTotal AS 'Evaluation Total', EvaluationUsed AS 'Evaluation Used',
	TermEndDate AS 'Term End Date', CASE WHEN UsedBy<=0 THEN 'N/A' ELSE A.name END AS 'Used By', CASE WHEN Agent<=0 THEN 'N/A' ELSE AT.name END AS 'Agent', InstallDate AS 'Install Date', ExpirationDate AS 'Expiration Date'
	FROM tempdb.dbo.LicCSLicenseInfo WITH (NOLOCK)
	LEFT JOIN APP_Client A WITH (NOLOCK) ON UsedBy = A.id
	LEFT JOIN APP_iDAType AT WITH(NOLOCK) ON Agent=AT.type
	WHERE LicType < 1000 ORDER BY LicenseName, A.name, AT.name
END
ELSE IF @option=28--list of remaining usage based licenses
BEGIN--required only when displaying current license usage
	DECLARE @usageLicenses TABLE(licType INT,usage BIGINT, purchased INT, permTotal INT, evalTotal INT, termEndDate VARCHAR(128))
	INSERT @usageLicenses
	SELECT LicType, ISNULL(AppSizeMB,0), 0, 0, 0,'N/A'
	FROM tempdb.dbo.LicCSCurrentCALDetails C WITH (NOLOCK) WHERE ObjectType IN (4,7,8)
	--get purchased quantities of these licenses
	UPDATE U SET
		U.permTotal=ISNULL(PermanentTotal,0),
		U.evalTotal=ISNULL(EvaluationTotal,0),
		U.purchased=CASE WHEN (ISNULL(PermanentTotal,0)>0 OR ISNULL(PermanentTotal,0)=-1) THEN ISNULL(PermanentTotal,0)
						 WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN ISNULL(EvaluationTotal,0)
						 ELSE 0
					END,
		U.termEndDate=CASE WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN L.TermEndDate
						   ELSE 'N/A'
					  END
	FROM @usageLicenses U INNER JOIN tempdb.dbo.LicCSLicenseInfo L ON L.LicType=U.licType
	SELECT L.id AS 'License ID', ISNULL(L.short_name,'') AS 'License', MAX(purchased) AS 'Purchased', MAX(permTotal) AS 'Permanent Total', MAX(evalTotal) AS 'Evaluation Total', SUM(usage) AS 'Used', MAX(termEndDate) AS 'Term End Date'
	FROM @usageLicenses U LEFT JOIN simLicAppTypeV2 L ON L.id=U.LicType
	GROUP BY L.id,L.short_name
END
ELSE IF @option=29--all jobs excluded from capacity when archivedVM license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',CEILING(ISNULL(UncompBytes,0)/1024/1024) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM tempdb.dbo.LicCSCurrentUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=32
END
ELSE IF @option=30--data to draw capacity peak usage graphs for past N months
BEGIN
	DECLARE @monthStart DATETIME = GETDATE()
	DECLARE @monthTable TABLE (MonthStart DATETIME)
    DECLARE @cnt INT = @noOfMonths
    WHILE @cnt > 0
    BEGIN
        INSERT @monthTable
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStart), 0)
        SET @monthStart=DATEADD(month, -1, @monthStart)
        SET @cnt=@cnt-1
    END
    SELECT MonthStart AS Month, ISNULL(CCLBackup,0.000) AS 'CCLBackup', ISNULL(CCLArchive,0.000) AS 'CCLArchive', ISNULL(CCLSnapshot,0.000) AS 'CCLSnapshot', ISNULL(CCLReplication,0.000) AS 'CCLReplication'
	FROM @monthTable M
	LEFT JOIN
	(
		SELECT TOP (@noOfMonths) Month AS 'Month',
		CAST(MAX(BackupSize)*1.0/1024/1024/1024/1024 AS DECIMAL(18,3)) AS 'CCLBackup', CAST(MAX(ArchiveSize)*1.0/1024/1024/1024/1024 AS DECIMAL(18,3)) AS 'CCLArchive',
		CAST(MAX(SnapSize)*1.0/1024/1024/1024/1024 AS DECIMAL(18,3)) AS 'CCLSnapshot',CAST(MAX(ReplicationSize)*1.0/1024/1024/1024/1024 AS DECIMAL(18,3)) AS 'CCLReplication' FROM
		(
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(CCLPeakEnterpriseBackupSize,0)) AS 'BackupSize' ,
			MAX(ISNULL(CCLPeakEnterpriseArchiveSize,0)) AS 'ArchiveSize',MAX(ISNULL(CCLPeakSnapSize,0)) AS 'SnapSize',MAX(ISNULL(CCLPeakReplicationSize,0)) AS 'ReplicationSize'
			FROM LicPeakUsageHistory WITH (NOLOCK)
			GROUP BY date
		)[CCLCapacityUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @option=31--data to draw CAL peak usage graphs for past N months
BEGIN
	DECLARE @monthStartCAL DATETIME = GETDATE()
	DECLARE @monthTableCAL TABLE (MonthStart DATETIME)
    DECLARE @cntCAL INT = @noOfMonths
    WHILE @cntCAL > 0
    BEGIN
        INSERT @monthTableCAL
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStartCAL), 0)
        SET @monthStartCAL=DATEADD(month, -1, @monthStartCAL)
        SET @cntCAL=@cntCAL-1
    END
    SELECT MonthStart AS Month, ISNULL(VMSockets,0) AS 'VMSockets', ISNULL(ProtectedVMs,0) AS 'ProtectedVMs', ISNULL(AcvVMs,0) AS 'AcvVMs', ISNULL(ArchivedVMs,0) AS 'ArchivedVMs',
	ISNULL(MSimUsers,0) AS 'MSimUsers',	ISNULL(EpUsers,0) AS 'EpUsers', ISNULL(EpSharingUsers,0) AS 'EpSharingUsers', ISNULL(EpEdiscoveryUsers,0) AS 'EpEdiscoveryUsers',
	ISNULL(FSOnlyServer,0) AS 'FSOnlyServer', ISNULL(DLO,0) AS 'DLO', ISNULL(AppServer,0) AS 'AppServer', ISNULL(VMOnly,0) AS 'VMOnly', ISNULL(AdvancedVM,0) AS 'AdvancedVM'
	FROM @monthTableCAL M
	LEFT JOIN
	(
		SELECT TOP (@noOfMonths) Month AS 'Month', MAX(VMSockets) AS 'VMSockets', (MAX(VMOnly)+MAX(AdvancedVM)) AS 'ProtectedVMs', MAX(AcvVMs) AS 'AcvVMs', MAX(ArchivedVMs) AS 'ArchivedVMs',
		MAX(MSimUsers) AS 'MSimUsers', MAX(EpUsers) AS 'EpUsers', MAX(EpSharingUsers) AS 'EpSharingUsers', MAX(EpEdiscoveryUsers) AS 'EpEdiscoveryUsers', MAX(FSOnlyServer) AS 'FSOnlyServer',
		MAX(DLO) AS 'DLO', MAX(AppServer) AS 'AppServer', MAX(VMOnly) AS 'VMOnly', MAX(AdvancedVM) AS 'AdvancedVM'
		FROM (
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(CCLVMSocket,0)) AS 'VMSockets', MAX(ISNULL(CCLVMOnly,0)) AS 'ProtectedVMs', MAX(ISNULL(CCLACV,0)) AS 'AcvVMs', MAX(ISNULL(CCLArchivedVM,0)) AS 'ArchivedVMs',
			MAX(ISNULL(CCLMSimUsers,0)) AS 'MSimUsers', MAX(ISNULL(CCLEpUsers,0)) AS 'EpUsers', MAX(ISNULL(CCLEpSharingUsers,0)) AS 'EpSharingUsers', MAX(ISNULL(CCLEpEdiscoveryUsers,0)) AS 'EpEdiscoveryUsers',
			MAX(ISNULL(CCLFSOnlyServer,0)) AS 'FSOnlyServer',MAX(ISNULL(CCLDLO,0)) AS 'DLO',MAX(ISNULL(CCLApplicationServer,0)) AS 'AppServer',MAX(ISNULL(CCLVMOnly,0)) AS 'VMOnly',MAX(ISNULL(CCLVMWithApp,0)) AS 'AdvancedVM'
			FROM LicPeakCALClientCountHistory WITH (NOLOCK)
			GROUP BY date
		)[CCLCALUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @option=32--CCL peak backup details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE njobtype=0 AND CapacityFlag=0 AND MonthStart=@month
END
ELSE IF @option=33--CCL peak archive details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE njobtype=1 AND CapacityFlag=0 AND MonthStart=@month
END
ELSE IF @option=34--CCL peak snapshot details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE njobtype=2 AND CapacityFlag=0 AND MonthStart=@month
END
ELSE IF @option=35--CCL peak replication details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE njobtype=3 AND CapacityFlag=0 AND MonthStart=@month
END
ELSE IF @option=36--CCL peak vmsocket details for the given month
BEGIN
	SELECT ObjectName AS 'Hypervisor Host', ISNULL(AppSizeMB,0) AS 'Sockets', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM LicCCLPeakCALDetails C WITH (NOLOCK)
	WHERE ObjectType=19 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=37--CCL peak protected vm details for the given month
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=20 AND MonthStart=@month
	UNION
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=18 AND JobId>0 AND MonthStart=@month
	ORDER BY ObjectName
END
ELSE IF @option=38--CCL peak acv vm details for the given month
BEGIN
	DECLARE @cclvms TABLE(vmId INT, vmName NVARCHAR(1024),isProtected VARCHAR(5), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
	INSERT @cclvms
	SELECT DISTINCT ObjectId, ObjectName, CASE WHEN JobId>0 THEN 'Yes' ELSE 'No' END, AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=18 AND MonthStart=@month ORDER BY ObjectName
	SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
	STUFF(
		(SELECT ', ' + CONVERT(VARCHAR(1024),package)
		FROM @cclvms
		WHERE vmId=V.vmId AND vmName=V.vmName
		FOR XML PATH (''))
		, 1, 1, '')  AS 'Package',
	isProtected AS 'Is VM Protected', jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
	FROM @cclvms V
	GROUP BY vmId,vmName,isProtected, jobId,orgId,org,planName
	ORDER BY vmName
END
ELSE IF @option=39--CCL peak archived vm details for the given month
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Archived Job', ISNULL(AppSizeMB,0) AS 'Archived VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=21 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=40--CCL peak msim user details for the given month
BEGIN
	SELECT ObjectName AS 'SMTP', AppTypeName AS 'Name', ISNULL(A.name,'') AS 'Client', ISNULL(B.subclientName,'') AS 'Subclient', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM LicCCLPeakCALDetails L WITH (NOLOCK)
	LEFT JOIN APP_Client A WITH (NOLOCK) ON L.ClientId = A.id
	LEFT JOIN APP_Application B WITH (NOLOCK) ON L.SubclientId = B.id
	WHERE L.ClientId > 0 AND L.SubclientId > 0 AND ObjectType=17 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=41--CCL peak endpoint user details for the given month
BEGIN
SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM LicCCLPeakCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=22 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=42--CCL peak ep sharing user details for the given month
BEGIN
SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM LicCCLPeakCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=23 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=43--CCL peak ep ediscovery user details for the given month
BEGIN
SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', ISNULL(U.login,'') AS 'User Login',ISNULL(U.email,'') AS 'E Mail',AppTypeName AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan' FROM LicCCLPeakCALDetails L WITH (NOLOCK)
	LEFT JOIN UMUsers U WITH (NOLOCK) ON U.id=L.ObjectId
	WHERE ObjectType=24 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=44--CCL peak FSO details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE MonthStart=@month
	AND ClientId IN (SELECT DISTINCT ClientId FROM LicCCLPeakCALDetails WITH (NOLOCK) WHERE ObjectType=3 AND MonthStart=@month)
END
ELSE IF @option=45--CCL peak DLO details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE MonthStart=@month
	AND ClientId IN (SELECT DISTINCT ClientId FROM LicCCLPeakCALDetails WITH (NOLOCK) WHERE ObjectType=2 AND MonthStart=@month)
END
ELSE IF @option=46--CCL peak app server details for the given month
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE MonthStart=@month
	AND ClientId IN (SELECT DISTINCT ClientId FROM LicCCLPeakCALDetails WITH (NOLOCK) WHERE ObjectType=1 AND MonthStart=@month)
END
ELSE IF @option=47--CCL peak VM only details for the given month
BEGIN
	SELECT ObjectId AS 'VM ID', ObjectName AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=20 AND MonthStart=@month ORDER BY ObjectName
END
ELSE IF @option=48--CCL peak advanced vms details for the given month
BEGIN
	DECLARE @cclAdvVms TABLE(vmId INT, vmName NVARCHAR(1024), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
	INSERT @cclAdvVms
	SELECT DISTINCT ObjectId, ObjectName, AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
	FROM LicCCLPeakCALDetails C WITH (NOLOCK) WHERE ObjectType=26 AND MonthStart=@month ORDER BY ObjectName
	SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
	STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @cclAdvVms
			WHERE vmId=V.vmId AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
			jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
	FROM @cclAdvVms V
	GROUP BY vmId,vmName,jobId,orgId,org,planName
	ORDER BY vmName
END
ELSE IF @option=49--get last collection time
BEGIN
    SELECT @lastCollectionTime AS 'Last Collection Time'
END
ELSE IF @option=50--CCL peak usages excluded from capacity when vm sockets license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=1 AND MonthStart=@month
END
ELSE IF @option=51--CCL peak usages excluded from capacity when protected vm license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=1 AND MonthStart=@month
END
ELSE IF @option=52--CCL peak usages excluded from capacity when ACV license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=4 AND MonthStart=@month
END
ELSE IF @option=53--CCL peak usages excluded from capacity when archived vm license is purchased
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=32 AND MonthStart=@month
END
ELSE IF @option=54--CCL peak DLP jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=16 AND MonthStart=@month
END
ELSE IF @option=55--CCL peak edge drive jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=8 AND MonthStart=@month
END
ELSE IF @option=56--CCL peak msim jobs excluded from capacity
BEGIN
	SELECT
	LicType AS 'License ID',ISNULL(L.short_name,'') AS 'License',ClientId AS 'Client ID',ClientName AS 'Client',AppTypeId AS 'Agent ID',AppTypeName AS 'Agent',AppId AS 'Subclient ID',SubclientName AS 'Subclient',
	SPId AS 'Storage Policy ID',SPName AS 'Storage Policy',BackupSetName AS 'Backupset',InstanceName AS 'Instance',
	CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
	JobId AS 'Job ID',ISNULL(AppSizeMB,0) AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
	FROM LicCCLPeakUsageDetails C WITH (NOLOCK) LEFT JOIN simLicAppTypeV2 L ON L.id=C.LicType
	WHERE CapacityFlag=2 AND MonthStart=@month
END
ELSE IF @option=57--CCL peak appServers without usages
BEGIN
    SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
    FROM LicCCLPeakCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
    WHERE ClientId > 0 AND ObjectType=1 AND MonthStart=@month
    AND ClientId NOT IN (SELECT DISTINCT ClientId FROM LicCCLPeakUsageDetails WITH (NOLOCK) WHERE MonthStart=@month)
    ORDER BY [Client]
END
ELSE IF @option=58--CCL peak DLOs without usages
BEGIN
	SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
    FROM LicCCLPeakCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
    WHERE ClientId > 0 AND ObjectType=2 AND MonthStart=@month
    AND ClientId NOT IN (SELECT DISTINCT ClientId FROM LicCCLPeakUsageDetails WITH (NOLOCK) WHERE MonthStart=@month)
    ORDER BY [Client]
END
ELSE IF @option=59--CCL peak FSOs without usages
BEGIN
	SELECT DISTINCT ClientId AS 'Client ID',ISNULL(A.name,'') AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
    FROM LicCCLPeakCALDetails WITH (NOLOCK) LEFT JOIN APP_Client A WITH (NOLOCK) ON ClientId = A.id
    WHERE ClientId > 0 AND ObjectType=3 AND MonthStart=@month
    AND ClientId NOT IN (SELECT DISTINCT ClientId FROM LicCCLPeakUsageDetails WITH (NOLOCK) WHERE MonthStart=@month)
    ORDER BY [Client]
END
ELSE IF @option=60--Get list of past N months for peak usages
BEGIN
	DECLARE @dateTable TABLE (monthValue VARCHAR(20), monthLabel VARCHAR(20))
	DECLARE @date DATETIME = GETDATE()
	DECLARE @counter INT = @noOfMonths
	--default month to be diplayed in list
	INSERT INTO @dateTable VALUES('9999-01-01','Current Month')
	WHILE @counter > 0
	BEGIN
		INSERT @dateTable
		SELECT CAST(DATEADD(DAY,-DAY(@date)+1, CAST(@date AS DATE)) AS DATE), CONVERT(VARCHAR(10),DATENAME(month, @date))+', '+CONVERT(VARCHAR(4),YEAR(@date))
		SET @date=DATEADD(month, -1, @date)
		SET @counter=@counter-1
	END
	SELECT monthValue, monthLabel FROM @dateTable
END
LIC_ERROR:
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetLicenseDetailsV2')
	delete from GxQscripts where name = 'LicGetLicenseDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetLicenseDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetLicenseDetailsV2'
GO

insert into GXDBVersions values(2, 'LicGetLicenseDetailsV2',  '00010001000400090000', 'LicGetLicenseDetailsV2', '00010001000400090000')
GO

