

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetInstalledClientAgentLicenses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetInstalledClientAgentLicenses.sp,v $ $Id: LicGetInstalledClientAgentLicenses.sp,v 1.18.202.2 2018/03/27 08:52:16 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LicGetInstalledClientAgentLicenses
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--	|
--  |      Output:  Returns licUsage rows by given client/agent type
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        xsui     Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetInstalledClientAgentLicenses <<<'

IF EXISTS (select * from sysobjects where name='LicGetInstalledClientAgentLicenses')
	drop procedure LicGetInstalledClientAgentLicenses
IF EXISTS (select * from GxQscripts where name='LicGetInstalledClientAgentLicenses')
	delete from GxQscripts where name = 'LicGetInstalledClientAgentLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetInstalledClientAgentLicenses')
	delete from GXDBVersions where aliasname = 'LicGetInstalledClientAgentLicenses'
GO
print '... Creating Procedure: LicGetInstalledClientAgentLicenses'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetInstalledClientAgentLicenses
  @i_ClientId integer,
  @i_appTypeId integer,
  @i_platformType integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_licTypeId integer
  DECLARE @o_appTypeId integer
  DECLARE @o_installFlag integer
SET NOCOUNT ON
SET transaction isolation level read uncommitted
DECLARE @consumedLicTbl		TABLE (t_clientId int, t_lictype int, t_apptype int, t_installFlag int)
DECLARE @reservedLicTbl		TABLE (t_lictype int)
--Don't touch library licenses & BASE CS, CC
--INSERT INTO @reservedLicTbl VALUES (SIM_CSL_AT_V2_LCP)
--INSERT INTO @reservedLicTbl VALUES (SIM_CSL_AT_V2_SHARELCP)
INSERT INTO @reservedLicTbl VALUES (71)
INSERT INTO @reservedLicTbl VALUES (50331648)
INSERT INTO @reservedLicTbl VALUES (16777216)
INSERT INTO @reservedLicTbl VALUES (33554432)
IF @i_appTypeId = 0
BEGIN
	-- MA/CC uninstallation
IF @i_platformType in (2, 4)
	BEGIN
		DECLARE @MADependentPackages	TABLE (t_packageId int)
INSERT INTO @MADependentPackages VALUES (51)
INSERT INTO @MADependentPackages VALUES (52)
INSERT INTO @MADependentPackages VALUES (53)
INSERT INTO @MADependentPackages VALUES (1105)
INSERT INTO @MADependentPackages VALUES (1106)
INSERT INTO @MADependentPackages VALUES (1301)
INSERT INTO @MADependentPackages VALUES (1302)
IF @i_platformType = 2
			INSERT INTO @consumedLicTbl
			SELECT	DISTINCT cid, licType, apptype, installFlag
			FROM	LicUsage L
			WHERE	CId = @i_ClientId AND OpType = 'Install' AND LicType NOT in (select t_lictype from @reservedLicTbl) AND
				(	EXISTS (select * from licDependency where platformType = @i_platformType and LicType = dependentlicTypeId and dependentAppTypeId in (0, apptype))
					OR
					EXISTS (select * from @MADependentPackages T JOIN simPackageMap M ON M.simPackageId = T.t_packageId where L.licType = M.licType)	)
					AND (ExpiryDateUTC > GETUTCDATE() OR ExpiryDateUTC = '1970-01-01 00:00:00.000')
		ELSE
			INSERT INTO @consumedLicTbl
			SELECT	DISTINCT cid, licType, apptype, installFlag
			FROM	LicUsage L
			WHERE	CId = @i_ClientId AND OpType = 'Install' AND LicType NOT in (select t_lictype from @reservedLicTbl) AND
(	NOT EXISTS (select * from licDependency where platformType in (2, 0) and LicType = dependentlicTypeId and dependentAppTypeId in (0, apptype))
					AND
					NOT EXISTS (select * from @MADependentPackages T JOIN simPackageMap M ON M.simPackageId = T.t_packageId where L.licType = M.licType)
OR LicType in (-1, -1))
					AND (ExpiryDateUTC > GETUTCDATE() OR ExpiryDateUTC = '1970-01-01 00:00:00.000')
	END
	-- client uninstallation
	ELSE
		INSERT INTO @consumedLicTbl
		SELECT	DISTINCT cid, licType, apptype, installFlag
		FROM	LicUsage
		WHERE	CId = @i_ClientId AND OpType = 'Install' AND LicType NOT in (select t_lictype from @reservedLicTbl) AND NOT EXISTS (select * from licDependency where platformType = 0 and LicType = dependentlicTypeId and dependentAppTypeId in (0, apptype))
				AND (ExpiryDateUTC > GETUTCDATE() OR ExpiryDateUTC = '1970-01-01 00:00:00.000')
END
ELSE
BEGIN
	-- package uninstallation
	INSERT INTO @consumedLicTbl
	SELECT	DISTINCT cid, licType, apptype, installFlag
	FROM	LicUsage
	WHERE	CId = @i_ClientId AND OpType = 'Install' AND LicType NOT in (select t_lictype from @reservedLicTbl) AND
		(appType = @i_appTypeId OR EXISTS (select * from licDependency where apptypeId = @i_appTypeId and LicType = dependentlicTypeId and dependentAppTypeId in (0, apptype) AND platformType > 0))
	--SRM licenses
	DECLARE @SRMLicTbl	TABLE (t_clientId INT, t_bIsPackage INT, t_appTypeId INT, t_licTypeId INT, t_GUIOptAppTypeId INT)
	INSERT INTO @SRMLicTbl
	EXEC LicGetSRMDCLicenseToUpdate	@i_ClientId, @i_appTypeId, 0
	INSERT INTO @consumedLicTbl
	SELECT t_clientId, t_licTypeId, t_appTypeId, (select installFlag from LicUsage where cid=t_clientId and LicType=t_licTypeId and apptype=t_appTypeId)
	FROM	@SRMLicTbl
	--UNIX FSDM licenses
	DECLARE @UNIX_FSDM_LicTbl	TABLE (t_clientId INT, t_bIsPackage INT, t_appTypeId INT, t_licTypeId INT)
	INSERT INTO @UNIX_FSDM_LicTbl
	EXEC LicGetSharedLicenseToUpdate 1, @i_ClientId, @i_appTypeId, 0
	INSERT INTO @consumedLicTbl
	SELECT t_clientId, t_licTypeId, t_appTypeId, (select installFlag from LicUsage where cid=t_clientId and LicType=t_licTypeId and apptype=t_appTypeId)
	FROM	@UNIX_FSDM_LicTbl
END
--keep CC level licenses when CC/MA platform is uninstalled on CS
IF @i_clientId = 2 AND (@i_platformType & 1) = 0
	Delete	@consumedLicTbl
	FROM	simAppTypeLicTypeMap
	WHERE	appTypeId = t_apptype AND simLicAppType = t_lictype AND isCellLevel > 0
-- delete all unlicensed entries
Delete	@consumedLicTbl
WHERE	t_installFlag <> 0
--do not use LicAAL since the base CS, CC already excluded
SELECT DISTINCT * FROM @consumedLicTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetInstalledClientAgentLicenses')
	delete from GxQscripts where name = 'LicGetInstalledClientAgentLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetInstalledClientAgentLicenses')
	delete from GXDBVersions where aliasname = 'LicGetInstalledClientAgentLicenses'
GO

insert into GXDBVersions values(2, 'LicGetInstalledClientAgentLicenses',  '00010018020200020000', 'LicGetInstalledClientAgentLicenses', '00010018020200020000')
GO

