

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetIDADetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetIDADetailsV3.sp,v $ $Id: LicGetIDADetailsV3.sp,v 1.1.2.2 2019/04/17 17:16:17 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetIDADetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetIDADetailsV3 <<<'
	drop procedure LicGetIDADetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetIDADetailsV3')
	delete from GxQscripts where name = 'LicGetIDADetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetIDADetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetIDADetailsV3'
GO
print '... Creating Procedure: LicGetIDADetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetIDADetailsV3
  @nUserId integer = 0
AS
--Calculate 5 licenses, including Protected Client, Archived Client, SRM Client, CI Server, Adv Search Nodes
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetIDADetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'   --0 successful  --1 failed
DECLARE @ProtectedClientType int  = 13
DECLARE @ArchivedClientType  int  = 14
DECLARE @SRMClientType int = 15
DECLARE @CIServerType int = 16
DECLARE @AdvSearchNodesType int  = 17
DECLARE @ProtectedClientLicType int  = 200004
DECLARE @ArchivedClientLicType  int  = 200005
DECLARE @SRMClientLicType int = 200006
DECLARE @CIServerLicType int = 200007
DECLARE @AdvSearchNodesLicType int  = 200008
DECLARE @current_ProtectedClient       int = 0
DECLARE @current_ArchivedClient        int = 0
DECLARE @current_SRMClient             int = 0
DECLARE @current_CIServer              int = 0
DECLARE @current_AdvSearchNodes        int = 0
DECLARE @last_ProtectedClient       int = 0
DECLARE @last_ArchivedClient        int = 0
DECLARE @last_SRMClient             int = 0
DECLARE @last_CIServer              int = 0
DECLARE @last_AdvSearchNodes        int = 0
IF @nUserId > 1 --SECURITY
BEGIN
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC LicGetSecurityObjV3 @nUserId OUTPUT,0
END
IF object_id('tempdb.dbo.#tempAppTypes') IS NOT null DROP TABLE #tempAppTypes
CREATE TABLE #tempAppTypes (t_apptype INT, t_name varchar(1024), fname varchar(50))
INSERT INTO #tempAppTypes (t_apptype, t_name, fname)
SELECT TYPE,name,'ProtectedClient' FROM APP_iDAType WITH (NOLOCK)
WHERE displayName IN ('File System','NAS','OES File System', 'Workstation Backup','ProxyHost','Image Level','Image Level on Unix','Image Level ProxyHost',
                        'Image Level ProxyHost on Unix','NDMP Remote Tape Server','NAS Restore Enabler')  AND TYPE < 1000    --ProtectedClient
UNION ALL
select TYPE,name,'ArchivedClient' from APP_iDAType WITH (NOLOCK)  where name like '%Archiver%' AND name NOT LIKE '%Exchange%' AND name NOT LIKE '%Mailbox%'  AND TYPE <1000    --ArchivedClient
UNION ALL
select TYPE,name,'SRMClient' from APP_iDAType WITH (NOLOCK)  where name LIKE 'SRM %' and type <1000    --SRMClient
UNION ALL
select TYPE,name,'CIServer' from APP_iDAType WITH (NOLOCK)   where name like 'Content Index Server'  --CIServer
UNION ALL
select TYPE,name,'AdvSearchNodes' from APP_iDAType  where name ='Compliance Director'   --AdvSearchNodes
IF object_id('tempdb.dbo.#tblClientIDA') IS NOT null DROP TABLE #tblClientIDA
CREATE TABLE  #tblClientIDA (clientId INT, appTypeId INT, disabled INT)
INSERT INTO #tblClientIDA
SELECT clientId, ida.appTypeId , 0 FROM  APP_IDAName IDA WITH (NOLOCK) WHERE (IDA.status & 6) = 0
IF @nUserId > 1 --SECURITY
   delete #tblClientIDA where ClientId not in (select clientId from #LicCalUserObj where clientId > 0)
DELETE  #tblClientIDA
FROM  #tblClientIDA T, JMJobAction A WITH (NOLOCK)
WHERE A.clientId = T.clientId AND (A.appType = 0 OR A.appType = T.appTypeId)
AND A.opType = 4 AND A.action = 1
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage INT, t_lastUsage INT, t_updateStatus INT DEFAULT 0)
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType IN (@ProtectedClientType,@ArchivedClientType,@SRMClientType,@CIServerType,@AdvSearchNodesType))
DELETE FROM Lic_CurrentUsage WHERE UsageType IN (@ProtectedClientType,@ArchivedClientType,@SRMClientType,@CIServerType,@AdvSearchNodesType)
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,AppTypeId,LicType,CapacityFlag, VMFlag, ObjectName)
SELECT  DISTINCT @ProtectedClientType,clientId, appTypeId, @ProtectedClientLicType,-1,0,t_name
FROM  #tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='ProtectedClient'
UNION ALL  --ArchivedClient
SELECT  DISTINCT @ArchivedClientType,clientId, appTypeId,@ArchivedClientLicType,-1,0,t_name
FROM  #tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='ArchivedClient'
UNION ALL --SRMClient
SELECT  DISTINCT @SRMClientType,clientId,appTypeId,@SRMClientLicType,-1,0,t_name
FROM  #tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='SRMClient'
UNION ALL  --CIServer
SELECT  DISTINCT @CIServerType,clientId,appTypeId,@CIServerLicType,-1,0,t_name
FROM  #tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='CIServer'
UNION ALL   --AdvSearchNodes
SELECT  DISTINCT @AdvSearchNodesType,clientId,appTypeId,@AdvSearchNodesLicType,-1,0,t_name
FROM  #tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='AdvSearchNodes'
SELECT @current_ProtectedClient = [13],@current_ArchivedClient =[14],@current_SRMClient =[15],@current_CIServer =[16],@current_AdvSearchNodes = [17]
FROM (SELECT distinct clientId, UsageType FROM Lic_CurrentUsage WITH (NOLOCK) ) AS S
PIVOT
(COUNT(clientId) FOR UsageType in ([13],[14],[15],[16],[17])) AS P
SELECT @last_ProtectedClient = [13],@last_ArchivedClient =[14],@last_SRMClient =[15],@last_CIServer =[16],@last_AdvSearchNodes = [17]
FROM (SELECT distinct clientId, UsageType FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType) AS S
PIVOT
(COUNT(clientId) FOR UsageType in ([13],[14],[15],[16],[17])) AS P
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage)
VALUES (@ProtectedClientType,@current_ProtectedClient,@last_ProtectedClient),
(@ArchivedClientType,@current_ArchivedClient,@last_ArchivedClient),
(@SRMClientType,@current_SRMClient,@last_SRMClient),
(@CIServerType,@current_CIServer,@last_CIServer),
(@AdvSearchNodesType,@current_AdvSearchNodes,@last_AdvSearchNodes)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,AppTypeId,LicType,CapacityFlag, VMFlag, ObjectName)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,AppTypeId,LicType,CapacityFlag, VMFlag, ObjectName
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING (SELECT UsageType,ClientId,AppTypeId,LicType,CapacityFlag, VMFlag, ObjectName FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@ProtectedClientType,@ArchivedClientType,@SRMClientType,@CIServerType,@AdvSearchNodesType)) AS S
ON T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ClientId = S.ClientId AND T.AppTypeId = S.AppTypeId
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate, UsageType, PeakType,ClientId,AppTypeId,LicType,CapacityFlag, VMFlag, ObjectName)
		VALUES(@monthStart, @currentTime, S.UsageType,@SCLPeakType,S.ClientId,S.AppTypeId,S.LicType,S.CapacityFlag,S.VMFlag,S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
IF @nUserId > 0 --SECURITY
DROP TABLE #LicCalUserObj
DROP TABLE #tempAppTypes
DROP TABLE #tblClientIDA
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetIDADetailsV3')
	delete from GxQscripts where name = 'LicGetIDADetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetIDADetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetIDADetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetIDADetailsV3',  '00010001000200020000', 'LicGetIDADetailsV3', '00010001000200020000')
GO

