

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetHyperScaleUsageV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetHyperScaleUsageV3.sp,v $ $Id: LicGetHyperScaleUsageV3.sp,v 1.1.2.2.26.1 2021/03/28 07:37:17 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicGetHyperScaleUsageV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetHyperScaleUsageV3 <<<'
	drop procedure LicGetHyperScaleUsageV3
END
IF EXISTS (select * from GxQscripts where name='LicGetHyperScaleUsageV3')
	delete from GxQscripts where name = 'LicGetHyperScaleUsageV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetHyperScaleUsageV3')
	delete from GXDBVersions where aliasname = 'LicGetHyperScaleUsageV3'
GO
print '... Creating Procedure: LicGetHyperScaleUsageV3'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicGetHyperScaleUsageV3
AS
--Calculate LiveSync Pairs
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetHyperScaleUsageV3'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @HyperScaleType int = 33
DECLARE @HyperScaleLicType int = 200021
DECLARE @current_HSUsage bigint = 0
DECLARE @last_HSUsage    bigint = 0
IF object_id('tempdb.dbo.#StoragePool') IS NOT NULL DROP TABLE #StoragePool
CREATE TABLE #StoragePool (
    StoragePoolId     integer,
    StoragePoolName   nvarchar(255),
    StoragePoolType   integer,
    SIDBStoreId       integer,
    ClientGroupName   nvarchar(512),
    Libraries         varchar(1024),
    LibraryType       integer,
    NumMediaAgents    integer,
    TotalControllers  integer,
    ActiveControllers integer,
    LibOfflineReason  integer,
    MPOfflineReason   integer,
    MAOfflineReason   integer,
    MountPathType     integer,
    StatusCode        integer,
	DeviceTypeId	  integer,
	LibrarySubType	  integer
)
IF object_id('tempdb.dbo.#StoragePoolMA') IS NOT NULL DROP TABLE #StoragePoolMA
CREATE TABLE #StoragePoolMA (StoragePoolId INT, ApplianceType INT)
INSERT INTO #StoragePool EXEC MMGetStoragePools
INSERT INTO #StoragePoolMA
SELECT DISTINCT SPL.StoragePoolId, AT.ApplianceType
FROM #StoragePool SPL
INNER JOIN MMMasterPool MPL WITH (NOLOCK) ON MPL.LibraryId IN (SELECT _ID FROM dbo.SplitIDs(SPL.Libraries))
INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON MPL.MasterPoolId = DPL.MasterPoolId
INNER JOIN APP_Client CL WITH (NOLOCK) ON DPL.ClientId = CL.id
INNER JOIN (
             SELECT EntityId, intVal AS ApplianceType
             FROM MMEntityProp WITH (NOLOCK)
             WHERE propertyName = 'MediaAgentApplianceType' AND EntityType = 10
           ) AT ON CL.id = AT.EntityId
IF object_id('tempdb.dbo.#MountPathProp') IS NOT NULL DROP TABLE #MountPathProp
CREATE TABLE #MountPathProp (LibraryId INT, TotalSpaceMB BIGINT, FreeBytesMB BIGINT)
INSERT  INTO #MountPathProp
SELECT  L.LibraryId, MS.TotalSpaceMB, MS.FreeBytesMB
FROM    MMS2getMountPathNameGUIView MP WITH (NOLOCK)
INNER JOIN MMLibrary L WITH (NOLOCK) ON MP.LibraryId = L.LibraryId
INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
WHERE   MP.MountPathId > 0 AND MP.MountPathName <> 'CVDiskFolder' AND L.LibraryId > 0 AND L.LibraryTypeId != 8
IF object_id('tempdb.dbo.#HyperScaleUsage') IS NOT null DROP TABLE #HyperScaleUsage
CREATE TABLE #HyperScaleUsage (StoragePoolId INT, StoragePoolName NVARCHAR(255), ApplianceType INT, TotalSpaceMB BIGINT, UsedSpaceMB BIGINT)
INSERT INTO #HyperScaleUsage
SELECT PL.StoragePoolId,PL.StoragePoolName, MA.ApplianceType,SUM(M.TotalSpaceMB), SUM(M.TotalSpaceMB - M.FreeBytesMB)
FROM #StoragePool PL
INNER JOIN #StoragePoolMA MA ON MA.StoragePoolId = PL.StoragePoolId
INNER JOIN #MountPathProp M on M.LibraryId IN (SELECT _ID FROM dbo.SplitIDs(PL.Libraries))
WHERE PL.StoragePoolType = 4
GROUP BY PL.StoragePoolId,PL.StoragePoolName,MA.ApplianceType
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @HyperScaleType)
DELETE FROM Lic_CurrentUsage WHERE UsageType = @HyperScaleType
INSERT INTO Lic_CurrentUsage (UsageType,SPId,LicType,SPName,BackupSetId, AppSizeMB, CapacityFlag, VMFlag, ObjectName)
SELECT DISTINCT @HyperScaleType,StoragePoolId,@HyperScaleLicType,StoragePoolName,TotalSpaceMB, UsedSpaceMB,-1,0,CASE ApplianceType WHEN 1 THEN 'HyperScale Appliance' WHEN 2 THEN 'HyperScale Reference Architecture' ELSE 'N/A' END
FROM  #HyperScaleUsage
SELECT @current_HSUsage = ISNULL(SUM(AppSizeMB),0) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @HyperScaleType
SELECT @last_HSUsage   = ISNULL(SUM(AppSizeMB),0) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @HyperScaleType AND PeakType = @CCLPeakType
IF @current_HSUsage >= @last_HSUsage AND @current_HSUsage > 0
BEGIN
DELETE Lic_PeakUsage WHERE MonthStart = @monthStart AND UsageType = @HyperScaleType AND PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,SPId,LicType,SPName,BackupSetId,AppSizeMB,CapacityFlag,VMFlag,ObjectName)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,SPId,LicType,SPName,BackupSetId,AppSizeMB,CapacityFlag,VMFlag,ObjectName
FROM Lic_CurrentUsage WITH (NOLOCK)
WHERE UsageType = @HyperScaleType
END
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,SPId,LicType,SPName,BackupSetId,AppSizeMB,CapacityFlag, VMFlag, ObjectName FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType  = @HyperScaleType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.SPId = S.SPId
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN UPDATE SET T.CreationDate = @currentTime, T.SPName = S.SPName, T.AppSizeMB = S.AppSizeMB, T.BackupSetId = S.BackupSetId, T.ObjectName = S.ObjectName
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart,CreationDate,UsageType,PeakType,SPId,LicType,SPName,BackupSetId,AppSizeMB,CapacityFlag,VMFlag,ObjectName)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.SPId,S.LicType,S.SPName,S.BackupSetId,S.AppSizeMB,S.CapacityFlag,S.VMFlag,S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #StoragePool
DROP TABLE #StoragePoolMA
DROP TABLE #MountPathProp
DROP TABLE #HyperScaleUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetHyperScaleUsageV3')
	delete from GxQscripts where name = 'LicGetHyperScaleUsageV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetHyperScaleUsageV3')
	delete from GXDBVersions where aliasname = 'LicGetHyperScaleUsageV3'
GO

insert into GXDBVersions values(2, 'LicGetHyperScaleUsageV3',  'v1.1.2.2.26.1', 'LicGetHyperScaleUsageV3', 'v1.1.2.2.26.1')
GO

