

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetDDADetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetDDADetailsV3.sp,v $ $Id: LicGetDDADetailsV3.sp,v 1.1.2.3 2019/04/17 17:16:29 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetDDADetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetDDADetailsV3 <<<'
	drop procedure LicGetDDADetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetDDADetailsV3')
	delete from GxQscripts where name = 'LicGetDDADetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetDDADetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetDDADetailsV3'
GO
print '... Creating Procedure: LicGetDDADetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetDDADetailsV3
AS
--Calculate 6 licenses, including Dedup Data, Dedup Data On Tape, Avail Dedup Space, App Store Capacity, Used Disk Space, Avail Disk Space
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetDDADetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @DedupDataType int = 5
DECLARE @DedupDataOnTapeType int = 6
DECLARE @AvailDedupSpaceType int = 7
DECLARE @AppStoreCapacityType int = 8
DECLARE @UsedDiskSpaceType int = 9
DECLARE @AvailDiskSpaceType int = 10
DECLARE @DedupDataLicType int = 100016
DECLARE @UsedDiskSpaceLicType int = 100015
DECLARE @AppStoreCapacityLicType int = 100031
DECLARE @current_DedupDataSizeMB        bigint = 0
DECLARE @current_DedupDataOnTapeMB      bigint = 0
DECLARE @current_AvailDedupSpaceMB      bigint = 0
DECLARE @current_AppStoreCapacityMB    bigint = 0
DECLARE @current_UsedDiskSpaceMB        bigint = 0
DECLARE @current_AvailDiskSpaceMB       bigint = 0
DECLARE @last_DedupDataSizeMB        bigint = 0
DECLARE @last_DedupDataOnTapeMB      bigint = 0
DECLARE @last_AvailDedupSpaceMB      bigint = 0
DECLARE @last_AppStoreCapacityMB    bigint = 0
DECLARE @last_UsedDiskSpaceMB        bigint = 0
DECLARE @last_AvailDiskSpaceMB       bigint = 0
IF object_id('tempdb.dbo.#tempClientList1') IS NOT null DROP TABLE #tempClientList1
CREATE TABLE #tempClientList1(t_type int, t_lictype INT, t_objectId int, t_objectsizeMB bigint)
INSERT INTO #tempClientList1 (t_type, t_lictype, t_objectId, t_objectsizeMB)
SELECT @DedupDataType,@DedupDataLicType, SIDBStoreId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM MMVolume WITH (NOLOCK)
WHERE SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM archCopySIDBStore CS WITH (NOLOCK) WHERE ((CS.Flags & 4) > 0))
group by SIDBStoreId       --DedupData
UNION ALL
SELECT @DedupDataOnTapeType,0,SIDBStoreId,SUM(CASE WHEN SiloStatus = 3 THEN ISNULL(CAST(PhysicalBytesMB AS BIGINT),0) ELSE 0 END)
FROM MMVolume WITH (NOLOCK)
WHERE SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM archCopySIDBStore CS WITH (NOLOCK) WHERE ((CS.Flags & 4) > 0))
group by SIDBStoreId       --DedupDataOnTape
UNION ALL
SELECT @AvailDedupSpaceType,0, MediaSideId,SUM(ISNULL(CAST(FreeBytesMB AS BIGINT),0))
FROM  MMMediaSide WITH (NOLOCK)
WHERE MediaSideId IN (SELECT DISTINCT MediaSideId FROM MMVolume WITH (NOLOCK) WHERE SIDBStoreId > 0)
group by MediaSideId       --Avail Dedup Space
UNION ALL
SELECT @AppStoreCapacityType,@AppStoreCapacityLicType, MediaSideId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM  MMVolume WITH (NOLOCK)
WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0 and MountPathTypeId <> 7)
group by MediaSideId       --Appliance Store Usage
UNION ALL
SELECT @UsedDiskSpaceType,@UsedDiskSpaceLicType, MediaSideId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM  MMVolume WITH (NOLOCK)
WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0)
group by MediaSideId        --used Disk Space
UNION ALL
SELECT @AvailDiskSpaceType,0, MS.MediaSideId,SUM(ISNULL(CAST(FreeBytesMB AS BIGINT),0))
FROM  MMMediaSide MS WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
WHERE MS.MediaSideId=MP.MediaSideId AND  MP.MediaSideId > 0
group by MS.MediaSideId     --Avail Disk Space
Delete FROM #tempClientList1
Where t_objectsizeMB = 0
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage BIGINT, t_lastUsage BIGINT, t_updateStatus INT DEFAULT 0)
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@DedupDataType,@DedupDataOnTapeType,@AvailDedupSpaceType,@AppStoreCapacityType,@UsedDiskSpaceType,@AvailDiskSpaceType))
DELETE FROM Lic_CurrentUsage WHERE UsageType in (@DedupDataType,@DedupDataOnTapeType,@AvailDedupSpaceType,@AppStoreCapacityType,@UsedDiskSpaceType,@AvailDiskSpaceType)
INSERT INTO Lic_CurrentUsage (UsageType,LicType,AppSizeMB,CapacityFlag,VMFlag,ObjectId)
SELECT DISTINCT t_type,t_lictype,t_objectsizeMB,-1,0,t_objectId
FROM #tempClientList1
SELECT @current_DedupDataSizeMB = ISNULL([5],0),@current_DedupDataOnTapeMB = ISNULL([6],0),@current_AvailDedupSpaceMB = ISNULL([7],0),@current_AppStoreCapacityMB =ISNULL([8],0),@current_UsedDiskSpaceMB =ISNULL([9],0),@current_AvailDiskSpaceMB = ISNULL([10],0)
FROM (select AppSizeMB, UsageType from Lic_CurrentUsage WITH (NOLOCK)) AS S
PIVOT
(sum(AppSizeMB) FOR UsageType in ([5],[6],[7],[8],[9],[10])) AS P
SELECT @last_DedupDataSizeMB = ISNULL([5],0),@last_DedupDataOnTapeMB = ISNULL([6],0),@last_AvailDedupSpaceMB = ISNULL([7],0),@last_AppStoreCapacityMB =ISNULL([8],0),@last_UsedDiskSpaceMB =ISNULL([9],0),@last_AvailDiskSpaceMB = ISNULL([10],0)
FROM (select AppSizeMB, UsageType from Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType) AS S
PIVOT
(sum(AppSizeMB) FOR UsageType in ([5],[6],[7],[8],[9],[10])) AS P
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage)
VALUES (@DedupDataType,@current_DedupDataSizeMB,@last_DedupDataSizeMB),
(@DedupDataOnTapeType,@current_DedupDataOnTapeMB,@last_DedupDataOnTapeMB),
(@AvailDedupSpaceType,@current_AvailDedupSpaceMB,@last_AvailDedupSpaceMB),
(@AppStoreCapacityType,@current_AppStoreCapacityMB,@last_AppStoreCapacityMB),
(@UsedDiskSpaceType,@current_UsedDiskSpaceMB,@last_UsedDiskSpaceMB),
(@AvailDiskSpaceType,@current_AvailDiskSpaceMB,@last_AvailDiskSpaceMB)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,LicType,AppSizeMB,CapacityFlag,VMFlag,ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,LicType,AppSizeMB,CapacityFlag,VMFlag,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING (SELECT UsageType,LicType,AppSizeMB,CapacityFlag,VMFlag, Objectid FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@DedupDataType,@DedupDataOnTapeType,@AvailDedupSpaceType,@AppStoreCapacityType,@UsedDiskSpaceType,@AvailDiskSpaceType)) AS S
ON T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.Objectid = S.Objectid
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN Update
		SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate, UsageType, PeakType,LicType, AppSizeMB, CapacityFlag, VMFlag, ObjectId)
		VALUES(@monthStart, @currentTime, S.UsageType,@SCLPeakType,S.LicType,S.AppSizeMB,S.CapacityFlag, S.VMFlag,S.ObjectId)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #tempClientList1
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetDDADetailsV3')
	delete from GxQscripts where name = 'LicGetDDADetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetDDADetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetDDADetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetDDADetailsV3',  '00010001000200030000', 'LicGetDDADetailsV3', '00010001000200030000')
GO

