

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetDBDatabaseList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Zach Wang
--	Date:   4/3/2019
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicGetDBDatabaseList')
BEGIN
	print '>>> Drop Stored Procedure: LicGetDBDatabaseList <<<'
	drop procedure LicGetDBDatabaseList
END
IF EXISTS (select * from GxQscripts where name='LicGetDBDatabaseList')
	delete from GxQscripts where name = 'LicGetDBDatabaseList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetDBDatabaseList')
	delete from GXDBVersions where aliasname = 'LicGetDBDatabaseList'
GO
print '... Creating Procedure: LicGetDBDatabaseList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicGetDBDatabaseList
AS
SET ANSI_PADDING ON
SET NOCOUNT ON
IF object_id('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
BEGIN
	INSERT	INTO #ClientInstanceDetails (InstanceId, ClientId, IdaType, DbName)
	SELECT	DISTINCT I.id as instanceid, SC.clientId, IP.attrVal,DB.databaseName
	FROM IdaDBExtendedProp DB WITH (NOLOCK)
	INNER JOIN APP_InstanceName I WITH (NOLOCK) ON DB.instanceId = I.id
	INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('22','23','32')
	INNER JOIN APP_Application SC WITH (NOLOCK) ON DB.instanceId = SC.instance
	INNER JOIN APP_IDAName N WITH (NOLOCK) ON N.clientId = SC.clientId and N.appTypeId = 134 and N.status = 0
	WHERE (I.status&4) = 0 AND (I.status&16) = 0 AND (I.status&32) = 0 AND (I.status&2048) = 0
	UNION
	SELECT	DISTINCT I.id, SC.clientId, IP.attrVal,DBMap.dbName + ' [' + CVR.RegionCode + ']'
	FROM	APP_Application SC WITH (NOLOCK)
	INNER JOIN (SELECT subclientId, dbName, CAST(rsdAttributes AS XML) as rdsXml, regionId
				FROM APP_RDSSubclientContentMap WITH (NOLOCK)
				WHERE modified = 0) DBMap ON SC.id = DBMap.subclientId
	INNER JOIN APP_InstanceName I WITH (NOLOCK) ON SC.instance = I.id
	INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('4','26','27')
	INNER JOIN APP_IDAName N WITH (NOLOCK) ON N.clientId = SC.clientId and N.appTypeId = 134 and N.status = 0
	INNER JOIN App_CloudVendorRegion CVR WITH (NOLOCK) ON CVR.Id = DBMap.regionId
	WHERE (I.status&4) = 0 AND (I.status&16) = 0 AND (I.status&32) = 0 AND (I.status&2048) = 0
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetDBDatabaseList')
	delete from GxQscripts where name = 'LicGetDBDatabaseList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetDBDatabaseList')
	delete from GXDBVersions where aliasname = 'LicGetDBDatabaseList'
GO

insert into GXDBVersions values(2, 'LicGetDBDatabaseList',  '00000000000000000000', 'LicGetDBDatabaseList', '00000000000000000000')
GO

