

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetCplSearchPerms.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Zach Wang
--	Date:   4/3/2019
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetCplSearchPerms')
BEGIN
	print '>>> Drop Stored Procedure: LicGetCplSearchPerms <<<'
	drop procedure LicGetCplSearchPerms
END
IF EXISTS (select * from GxQscripts where name='LicGetCplSearchPerms')
	delete from GxQscripts where name = 'LicGetCplSearchPerms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCplSearchPerms')
	delete from GXDBVersions where aliasname = 'LicGetCplSearchPerms'
GO
print '... Creating Procedure: LicGetCplSearchPerms'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetCplSearchPerms
  @in_tmpTbl VARCHAR(MAX)=NULL
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#outputTbl') IS NOT NULL DROP TABLE #outputTbl
CREATE TABLE #outputTbl (isUser INT, userOrGroupId INT,	companyId INT)
IF OBJECT_ID('tempdb.dbo.#entitiesTbl') IS NOT NULL DROP TABLE #entitiesTbl
	CREATE TABLE #entitiesTbl (entityType1 INT,	entityId1 INT, entityType2 INT,	entityId2 INT, UNIQUE CLUSTERED (entityType1, entityId1, entityType2, entityId2))
INSERT INTO #entitiesTbl
SELECT 3, clientId, 4, appTypeId
FROM App_IdaName I WITH (NOLOCK)
WHERE I.appTypeId IN (137, 78, 134)
INSERT INTO #entitiesTbl
SELECT DISTINCT 28, CGA.clientGroupId, 0, 0
FROM App_ClientGroupAssoc CGA WITH (NOLOCK)
INNER JOIN #entitiesTbl E
ON CGA.clientId = E.entityId1
IF OBJECT_ID('tempdb.dbo.#CompSearchRPTbl') IS NOT NULL DROP TABLE #CompSearchRPTbl
CREATE TABLE #CompSearchRPTbl (roleId INT, permissionId INT,UNIQUE CLUSTERED (roleId, permissionId))
INSERT INTO #CompSearchRPTbl
SELECT roleId, 0
FROM UMRolesWithPermissionsExpanded RPE WITH (NOLOCK)
WHERE	RPE.permissionId = 25			-- Compliance Search
INSERT INTO #CompSearchRPTbl VALUES (0, 25)	 -- Compliance Search
-- Classic security associations.
INSERT INTO #outputTbl
SELECT DISTINCT Sec.isUser, Sec.userOrGroupId, Sec.companyId
FROM UMSecurityAssociations Sec WITH (NOLOCK)
INNER JOIN #entitiesTbl E ON Sec.entityType1 = E.entityType1 AND Sec.entityID1 = E.entityID1
				AND (Sec.entityType2 = 0 OR Sec.entityType2 = E.entityType2) AND (Sec.entityID2 = 0 OR Sec.entityId2 = E.entityId2)
-- association can be on client group / client level in which case entity2 = 0. If it is on appType, entity2 should match the specified appTypes.
INNER JOIN #CompSearchRPTbl RP ON Sec.roleId = RP.roleId AND Sec.permissionId = RP.permissionID
DECLARE @systemOwnerRole INT = ISNULL((SELECT roleId FROM UMOwnerRoles WITH (NOLOCK) WHERE entityType = 1 AND entityId = 2), 0)
IF (@systemOwnerRole <> 0) AND EXISTS (SELECT 1 FROM #CompSearchRPTbl WHERE roleId = @systemOwnerRole)
BEGIN
	INSERT INTO #outputTbl
	SELECT DISTINCT SecOwners.isUser, SecOwners.userOrGroupId, SecOwners.companyId
	FROM UMOwners SecOwners WITH (NOLOCK)
	INNER JOIN #entitiesTbl E
	ON E.entityType1 = 3 AND SecOwners.entityId = E.entityID1
END
ELSE
BEGIN
	-- Get list of clients on which owner roles have compliance search permission.
	IF OBJECT_ID('tempdb.dbo.#clientsWithCompSearchTbl') IS NOT NULL DROP TABLE #clientsWithCompSearchTbl
	CREATE TABLE #clientsWithCompSearchTbl (clientId INT PRIMARY KEY)
	INSERT INTO #clientsWithCompSearchTbl
	-- client owner role directly has this permission.
	SELECT E.entityId1
	FROM UMOwnerRoles SecOwnerRoles WITH (NOLOCK)
	INNER JOIN #entitiesTbl E ON E.entityType1 = 3 AND SecOwnerRoles.entityType = 3 AND SecOwnerRoles.entityId = E.entityId1
	INNER JOIN #CompSearchRPTbl RP ON SecOwnerRoles.roleId = RP.roleId AND SecOwnerRoles.permissionId = RP.permissionId
	-- client group owner role has this permission.
	UNION
	SELECT E.entityId1
	FROM UMOwnerRoles SecOwnerRoles WITH (NOLOCK)
	INNER JOIN #entitiesTbl E ON E.entityType1 = 28 AND SecOwnerRoles.entityType = 28 AND SecOwnerRoles.entityId = E.entityId1
	INNER JOIN #CompSearchRPTbl RP ON SecOwnerRoles.roleId = RP.roleId AND SecOwnerRoles.permissionId = RP.permissionId
	-- Get the owners of these clients in the above list.
	INSERT INTO #outputTbl
	SELECT DISTINCT SecOwners.isUser, SecOwners.userOrgroupid, SecOwners.companyId
	FROM UMOwners SecOwners WITH (NOLOCK)
	INNER JOIN #clientsWithCompSearchTbl CP WITH (NOLOCK) ON SecOwners.entityType = 3 AND SecOwners.entityId = CP.clientID
	DROP TABLE #clientsWithCompSearchTbl
END
IF @in_tmpTbl = '#tmpCompanyList'
BEGIN
		INSERT INTO #tmpCompanyList
		SELECT DISTINCT D.GUID
		FROM #outputTbl
		INNER JOIN UMDSProviders D WITH (NOLOCK) ON companyId = D.id
END
DROP TABLE #outputTbl
DROP TABLE #entitiesTbl
DROP TABLE #CompSearchRPTbl
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetCplSearchPerms')
	delete from GxQscripts where name = 'LicGetCplSearchPerms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCplSearchPerms')
	delete from GXDBVersions where aliasname = 'LicGetCplSearchPerms'
GO

insert into GXDBVersions values(2, 'LicGetCplSearchPerms',  '00000000000000000000', 'LicGetCplSearchPerms', '00000000000000000000')
GO

