

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetCapacityDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetCapacityDetailsV3.sp,v $ $Id: LicGetCapacityDetailsV3.sp,v 1.1.2.13 2020/07/01 00:34:34 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetCapacityDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetCapacityDetailsV3 <<<'
	drop procedure LicGetCapacityDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetCapacityDetailsV3')
	delete from GxQscripts where name = 'LicGetCapacityDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCapacityDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetCapacityDetailsV3'
GO
print '... Creating Procedure: LicGetCapacityDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetCapacityDetailsV3
  @userId integer =0,
  @i_bIncludeForeignJobs integer =0
AS
--Calculate 4 capacity licenses
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetCapacityDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @BackupType					INT = 1
DECLARE @ArchiverType				INT = 2
DECLARE @SnapType					INT = 3
DECLARE @ReplicationType			INT = 4
DECLARE @current_BackupEnterPriseUsed BIGINT = 0
DECLARE @current_ArchiverEnterPriseUsed BIGINT = 0
DECLARE @current_SnapUsed BIGINT = 0
DECLARE @current_ReplicationUsed BIGINT = 0
DECLARE @last_BackupEnterPriseUsed BIGINT = 0
DECLARE @last_ArchiverEnterPriseUsed BIGINT = 0
DECLARE @last_SnapUsed BIGINT = 0
DECLARE @last_ReplicationUsed BIGINT = 0
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
create table #tmpCommcellUsageReport ([EnterpriseBackupSize] bigint , [CoreBackupSize] bigint , [EnterpriseArchiveSize] bigint , [CoreArchiveSize] bigint , [SnapshotSize]	bigint , [ReplicationSize]	bigint , [nJobType]	int , [appId] int , [jobID]	int , [ClientName]	nvarchar(255) , [ClientId]	int , [AppTypeId] int , [AppTypeName] nvarchar(255) , [BackupSetName]	nvarchar(128) , [InstanceName]	nvarchar(512) , [SubclientName]	nvarchar(255) , [SPId]	int , [SPName]	nvarchar(144) , [UncompBytes]	bigint , [DedupEnabled]  int , [SecondaryEncryption]   int , [flag]	int	, [Snapshot] int default 0, [ClientGroup] nvarchar(1024) default '',[LicType] int DEFAULT -1, [IsVM] int DEFAULT -1)
EXEC QS_CommCellUsageReport '', @i_bIncludeForeignJobs, 4
-- add new temp usage type ObjectStore_capacity 32
IF object_id('tempdb.dbo.#NFSJobInfo') IS NOT null DROP TABLE #NFSJobInfo
CREATE TABLE #NFSJobInfo (t_clientId INT, t_appId INT, t_appTypeId INT, t_size BIGINT)
INSERT INTO #NFSJobInfo
SELECT AP.ClientId, J.appid, AP.appTypeId, sum(totalUncompBytes)
FROM JMBkpStats J WITH (NOLOCK)
INNER JOIN App_application AP WITH (NOLOCK) ON AP.id = J.appId AND (@i_bIncludeForeignJobs > 0 OR AP.subclientStatus & 6 = 0)
INNER JOIN App_Clientprop CP WITH (NOLOCK) ON CP.componentNameId = AP.ClientId AND CP.attrname = N'System Drive Type' AND CP.modified = 0 AND CP.attrVal = '4'
WHERE J.status in (1,3,14,16) AND J.dataStatus = 0 AND J.totalUncompBytes > 0 and fullCycleNum = (SELECT MAX(fullCycleNum) FROM JMBkpStats WITH (NOLOCK) WHERE appid = J.appid AND status in (1,3,14,16) AND dataStatus = 0 AND totalUncompBytes > 0)
GROUP BY AP.ClientId,J.appid,AP.appTypeId
IF @i_bIncludeForeignJobs <= 0
BEGIN
    DELETE FROM #NFSJobInfo
	WHERE EXISTS (select appId from JMJobAction WITH(NOLOCK) where appId = t_appId and action = 1 and opType = 4)
    DELETE #NFSJobInfo
    FROM APP_ClientProp WITH(NOLOCK)
    where attrName = N'Index Server Type' and attrVal = '6' and modified = 0 and componentNameId = t_clientId
END
IF @i_bIncludeForeignJobs = 0
DELETE #NFSJobInfo
FROM APP_iDAName WITH (NOLOCK)
WHERE clientId = t_clientId AND appTypeId = t_appTypeId AND (Status & 6) > 0
IF EXISTS (SELECT 1 FROM #NFSJobInfo)
BEGIN
	INSERT INTO #tmpCommcellUsageReport (nJobType, appId, jobID, ClientName, ClientId, AppTypeId, AppTypeName, BackupSetName, InstanceName, SubclientName, SPId, SPName, UncompBytes, flag)
	SELECT DISTINCT 31, N.t_appId, 0, C.name, AP.clientId,AP.appTypeId,I.name,B.name,Ins.name,AP.subclientName,AP.dataArchGrpID,AG.name, N.t_size,256
	FROM #NFSJobInfo N
	INNER JOIN App_application AP WITH (NOLOCK) ON AP.id = N.t_appId
	INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = AP.clientId
	INNER JOIN APP_iDAType I WITH (NOLOCK) ON AP.AppTypeId = I.type
	INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON AP.backupSet = B.id
	INNER JOIN APP_InstanceName Ins WITH (NOLOCK) ON AP.instance = Ins.id
	INNER JOIN archGroup AG WITH (NOLOCK) ON AP.dataArchGrpID = AG.id
END
DROP TABLE #NFSJobInfo
IF @userId > 1 --SECURITY
BEGIN
    IF object_id('tempdb.dbo.#tmpObjByUser') IS NOT NULL DROP TABLE #tmpObjByUser
	create table  #tmpObjByUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	DECLARE @capability BIGINT = 1
	EXEC sec_getUserObjects @userId,2013,0,'#tmpObjByUser' --SUB_CLIENT_ITEM->client
		--If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
	IF NOT EXISTS (SELECT * FROM #tmpObjByUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) AND (capabilities & POWER(2, @capability-1)) > 0)
	DELETE FROM #tmpCommcellUsageReport
    WHERE ClientId not in (select clientId from #tmpObjByUser where clientId > 0)
    DROP TABLE #tmpObjByUser
END
IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
CREATE TABLE #NoNeedBackupSet (apptype INT)
INSERT INTO #NoNeedBackupSet VALUES
(6),(32),(15),(9),(24),(25),(27),(31),(40),(2),(22),(23),(5),(48),(51),(47),(59),(67),(68),(65),(76),(75),(77),(80),(104),(4),(16),(70),(81),(61),(79),(53),(600),(601),(602),(604),(605),(606),(607),(128)
UPDATE #tmpCommcellUsageReport
SET BackupSetName = 'N/A'
WHERE apptypeid in (SELECT apptype FROM #NoNeedBackupSet)
IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
CREATE TABLE #NeedInstance (apptype INT)
INSERT INTO #NeedInstance VALUES
(3),(4),(16),(6),(7),(5),(126), (51),(52), (9),(8),(15),(14),(45), (2),(22),(23), (27),(31), (32),(35), (44), (37), (106), (54), (53), (55), (56),(60), (59), (57), (62), (67),(68),(69), (70),(77),(82),(80),(81),(90),(103),(104),(125),(58), (124), (131), (128),(79), (61), (134), (64), (135)
UPDATE #tmpCommcellUsageReport
SET InstanceName = 'N/A'
WHERE apptypeid not in (SELECT apptype FROM #NeedInstance)
UPDATE A
SET LicType = ISNULL(B.LicType,0),
	ClientGroup = LEFT(STUFF((SELECT ',' + name
		FROM APP_ClientGroupAssoc cga WITH(NOLOCK)
		INNER JOIN APP_ClientGroup cg ON cg.id = cga.clientgroupid AND cga.clientId = A.Clientid
		FOR XML PATH('')), 1, 1, ''), 1024),
	IsVM = ISNULL(CAST(C.attrVal AS INT),0)
FROM #tmpCommcellUsageReport A
LEFT JOIN LicUsage B WITH(NOLOCK) ON Cid = ClientId AND B.AppType = A.AppTypeId
LEFT JOIN APP_ClientProp C WITH(NOLOCK) ON C.componentNameId = A.ClientId AND C.attrName ='Virtual Server Discovered Clients' AND C.attrVal = '1' AND C.modIFied = 0
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage BIGINT, t_lastUsage BIGINT, t_updateStatus INT DEFAULT 0)
IF object_id('tempdb.dbo.#VSAParentJobs') IS NOT null DROP TABLE #VSAParentJobs
CREATE TABLE #VSAParentJobs (parentAppid INT,UsageType INT)
INSERT INTO #VSAParentJobs
SELECT DISTINCT parentAppid,UsageType
FROM JMJobDataLink J WITH(NOLOCK)
INNER JOIN #tmpCommcellUsageReport T ON childAppid = T.appId AND childJobId = T.JobId AND T.AppTypeId = 106 AND J.linkType = 7
INNER JOIN Lic_PeakUsage L WITH(NOLOCK) ON L.UsageType = T.nJobType+1 AND L.AppTypeId = T.AppTypeId AND L.SubclientId = parentAppid
WHERE MonthStart = @monthStart AND L.UsageType <= @ReplicationType
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType <= @ReplicationType OR UsageType = 32)
DELETE FROM Lic_CurrentUsage WHERE UsageType <= @ReplicationType OR UsageType = 32
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName, InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName, ObjectId)
SELECT DISTINCT (T.nJobType+1),T.ClientId,T.ClientName,T.appId,T.SubclientName, T.AppTypeId, T.LicType,APP.backupSet,T.BackupSetName,APP.instance,T.InstanceName,T.SPId,T.SPName,T.JobId,(1.0*T.UncompBytes)/1024/1024,T.flag, CASE WHEN T.AppTypeId = 106 THEN ISNULL(J.parentAppid,1) ELSE T.IsVM END, T.ClientGroup,ISNULL(J.parentJobId,0)
FROM #tmpCommcellUsageReport T
INNER JOIN APP_Application APP WITH (NOLOCK) ON T.appId = APP.id and T.clientId = APP.clientId
LEFT JOIN JMJobDataLink J WITH(NOLOCK) ON J.childAppid = T.appId AND J.childJobId = T.JobId AND T.AppTypeId = 106 AND J.linkType = 7
SELECT @current_BackupEnterPriseUsed = ISNULL([1],0), @current_ArchiverEnterPriseUsed = ISNULL([2],0),@current_SnapUsed = ISNULL([3],0), @current_ReplicationUsed = ISNULL([4],0)
FROM (select AppSizeMB, UsageType from Lic_CurrentUsage WITH (NOLOCK) WHERE CapacityFlag = 0) AS S
PIVOT
(sum(AppSizeMB) FOR UsageType in ([1],[2],[3],[4])) AS P
IF EXISTS (SELECT 1 FROM #VSAParentJobs)
BEGIN
	DELETE P
    FROM Lic_PeakUsage P
    INNER JOIN #VSAParentJobs V ON P.UsageType = V.UsageType AND P.SubclientId = V.parentAppid
	WHERE MonthStart = @monthStart AND AppTypeId = 106
END
SELECT @last_BackupEnterPriseUsed = ISNULL([1],0), @last_ArchiverEnterPriseUsed = ISNULL([2],0),@last_SnapUsed = ISNULL([3],0), @last_ReplicationUsed = ISNULL([4],0)
FROM (select AppSizeMB, UsageType from Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType AND CapacityFlag = 0) AS S
PIVOT
(sum(AppSizeMB) FOR UsageType in ([1],[2],[3],[4])) AS P
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage)
VALUES (@BackupType,@current_BackupEnterPriseUsed,@last_BackupEnterPriseUsed),
(@ArchiverType,@current_ArchiverEnterPriseUsed,@last_ArchiverEnterPriseUsed),
(@SnapType,@current_SnapUsed,@last_SnapUsed),
(@ReplicationType,@current_ReplicationUsed,@last_ReplicationUsed)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName,InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag,VMFlag,ObjectName,ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName,InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag,VMFlag,ObjectName,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName,InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName, ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType <= @ReplicationType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.SubclientId = S.SubclientId
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN UPDATE SET T.CreationDate = @currentTime, T.ClientName = S.ClientName, T.SubclientName = S.SubclientName, T.AppTypeId = S.AppTypeId, T.LicType = S.LicType, T.BackupSetId = S.BackupSetId, T.BackupSetName = S.BackupSetName, T.InstanceId = S.InstanceId, T.InstanceName = S.InstanceName, T.SPId = S.SPId, T.SPName = S.SPName, T.AppSizeMB = S.AppSizeMB, T.jobID = S.jobID, T.ObjectName = S.ObjectName, T.CapacityFlag = S.CapacityFlag, T.ObjectId = S.ObjectId, T.VMFlag = S.VMFlag
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate,UsageType,PeakType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName,InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName, ObjectId)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.ClientId,S.ClientName,S.SubclientId,S.SubclientName,S.AppTypeId,S.LicType,S.BackupSetId,S.BackupSetName,S.InstanceId,S.InstanceName,S.SPId,S.SPName,S.JobId,S.AppSizeMB,S.CapacityFlag,S.VMFlag,S.ObjectName,S.ObjectId)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  QS_ERROR
END CATCH
QS_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #NoNeedBackupSet
DROP TABLE #NeedInstance
DROP TABLE #tmpCommcellUsageReport
DROP TABLE #tempUsage
DROP TABLE #VSAParentJobs
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetCapacityDetailsV3')
	delete from GxQscripts where name = 'LicGetCapacityDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCapacityDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetCapacityDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetCapacityDetailsV3',  '00010001000200130000', 'LicGetCapacityDetailsV3', '00010001000200130000')
GO

