

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetCapacityDetailsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetCapacityDetailsV2.sp,v $ $Id: LicGetCapacityDetailsV2.sp,v 1.1.4.3 2018/08/12 03:08:37 leiwang Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LicGetCapacityDetailsV2 <<<'

IF EXISTS (select * from sysobjects where name='LicGetCapacityDetailsV2')
	drop procedure LicGetCapacityDetailsV2
IF EXISTS (select * from GxQscripts where name='LicGetCapacityDetailsV2')
	delete from GxQscripts where name = 'LicGetCapacityDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCapacityDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetCapacityDetailsV2'
GO
print '... Creating Procedure: LicGetCapacityDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetCapacityDetailsV2
  @i_bIncludeForeignJobs integer = 0,
  @userId integer = 0
AS
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @date_s AS NVARCHAR(32) = CAST(DATEPART(year,  @currentTime) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(month, @currentTime) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(day,   @currentTime) AS NVARCHAR(32)) + ' 00:00:00.000'
DECLARE @date_start INTEGER = dbo.GetUnixTime(CONVERT(DATETIME, @date_s, 120))
DECLARE @date_END   INTEGER = @date_start + 86400
DECLARE @lastdate INTEGER = 0
DECLARE @last_CCLPeekBackupEnterPriseUsed BIGINT = 0
DECLARE @last_CCLPeekArchiverEnterPriseUsed BIGINT = 0
DECLARE @last_CCLPeekSnapUsed BIGINT = 0
DECLARE @last_CCLPeekReplicationUsed BIGINT = 0
DECLARE @current_BackupEnterPriseUsed BIGINT = 0
DECLARE @current_ArchiverEnterPriseUsed BIGINT = 0
DECLARE @current_SnapUsed BIGINT = 0
DECLARE @current_ReplicationUsed BIGINT = 0
SET NOCOUNT ON
SET ANSI_PADDING ON
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
create table #tmpCommcellUsageReport ([EnterpriseBackupSize] bigint , [CoreBackupSize] bigint , [EnterpriseArchiveSize] bigint , [CoreArchiveSize] bigint , [SnapshotSize]	bigint , [ReplicationSize]	bigint , [nJobType]	int , [appId] int , [jobID]	int , [ClientName]	nvarchar(255) , [ClientId]	int , [AppTypeId] int , [AppTypeName] nvarchar(255) , [BackupSetName]	nvarchar(128) , [InstanceName]	nvarchar(512) , [SubclientName]	nvarchar(255) , [SPId]	int , [SPName]	nvarchar(144) , [UncompBytes]	bigint , [DedupEnabled]  int , [SecondaryEncryption]   int , [flag]	int	, [Snapshot] int default 0, [ClientGroup] nvarchar(1024) default '',[LicType] int DEFAULT -1, [IsVM] int DEFAULT -1)
EXEC QS_CommCellUsageReportV2 '', @i_bIncludeForeignJobs, 4
IF @userId > 1 --SECURITY
BEGIN
    IF object_id('tempdb.dbo.#tmpObjByUser') IS NOT NULL DROP TABLE #tmpObjByUser
create table  #tmpObjByUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @capability BIGINT = 1
EXEC sec_getUserObjects @userId,2013,0,'#tmpObjByUser' --SUB_CLIENT_ITEM->client
    --If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
IF NOT EXISTS (SELECT * FROM #tmpObjByUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) AND (capabilities & POWER(2, @capability-1)) > 0)
    DELETE FROM #tmpCommcellUsageReport
    WHERE ClientId not in (select clientId from #tmpObjByUser where clientId > 0)
    DROP TABLE #tmpObjByUser
END
DECLARE @NoNeedBackupSet TABLE (apptype INT)
INSERT INTO @NoNeedBackupSet VALUES
(6),(32),(15),(9),(24),(25),(27),(31),(40),(2),(22),(23),(5),(48),(51),(47),(59),(67),(68),(65),(76),(75),(77),(80),(104),(4),(16),(70),(81),(61),(79),(53),(600),(601),(602),(604),(605),(606),(607),(128)
UPDATE #tmpCommcellUsageReport
SET BackupSetName = 'N/A'
WHERE apptypeid in (SELECT apptype FROM @NoNeedBackupSet)
DECLARE @NeedInstance TABLE (apptype INT)
INSERT INTO @NeedInstance VALUES
(3),(4),(16),(6),(7),(5),(126), (51),(52), (9),(8),(15),(14),(45), (2),(22),(23), (27),(31), (32),(35), (44), (37), (106), (54), (53), (55), (56),(60), (59), (57), (62), (67),(68),(69), (70),(77),(82),(80),(81),(90),(103),(104),(125),(58), (124), (131), (128),(79), (61), (134), (64), (135)
UPDATE #tmpCommcellUsageReport
SET InstanceName = 'N/A'
WHERE apptypeid not in (SELECT apptype FROM @NeedInstance)
UPDATE A
SET LicType = ISNULL(B.LicType,0), ClientGroup  = dbo.GetClientGroup(Clientid), IsVM = ISNULL(CAST(C.attrVal AS INT),0)
FROM #tmpCommcellUsageReport A
LEFT JOIN LicUsage B WITH(NOLOCK) ON Cid = ClientId AND B.AppType = A.AppTypeId
LEFT JOIN APP_ClientProp C WITH(NOLOCK) ON C.componentNameId = A.ClientId AND C.attrName ='Virtual Server Discovered Clients' AND C.attrVal = '1' AND C.modIFied = 0
SELECT TOP 1 @lastdate = date, @last_CCLPeekBackupEnterPriseUsed = CCLPeakEnterpriseBackupSize,@last_CCLPeekArchiverEnterPriseUsed = CCLPeakEnterpriseArchiveSize,@last_CCLPeekSnapUsed = CCLPeakSnapSize, @last_CCLPeekReplicationUsed = CCLPeakReplicationSize
FROM    LicPeakUsageHistory WITH(NOLOCK)
WHERE  date>= @monthStart_Uix
Order by date DESC
SELECT TOP 1 @current_BackupEnterPriseUsed = ISNULL(EnterpriseBackupSize,0),@current_ArchiverEnterPriseUsed = ISNULL(EnterpriseArchiveSize,0),
@current_SnapUsed= ISNULL(SnapshotSize,0),@current_ReplicationUsed = ISNULL(ReplicationSize,0) FROM #tmpCommcellUsageReport
--Keep data only for last 3 months and current month
DELETE FROM LicCCLPeakUsageDetails WHERE DATEDIFf(MM, MonthStart,@currentTime) > 3
DELETE FROM LicSCLPeakUsageDetails WHERE DATEDIFf(MM, MonthStart,@currentTime) > 3
DECLARE @updateusage TABLE (type int)
BEGIN TRY
BEGIN TRAN
MERGE LicSCLPeakUsageDetails AS T
USING #tmpCommcellUsageReport AS S
ON T.AppId = S.AppId AND T.nJobtype = S.nJobtype AND T.MonthStart = @monthStart
WHEN MATCHED AND S.UncompBytes > (T.AppSizeMB*1024*1024)
	THEN UPDATE SET T.AppSizeMB = (1.0*S.UncompBytes)/1024/1024, T.PeakDate = @currentTime, T.jobID = S.jobID, T.SPId = S.SPId
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, nJobType, jobID, SPId, SPName, ClientId, ClientName, AppTypeId, AppTypeName, appId, SubclientName,AppSizeMB,BackupSetName, InstanceName,LicType, IsVM, CapacityFlag, Organization, OrgGUID, PlanName)
	VALUES(@monthStart, @currentTime, S.nJobType, S.jobID, S.SPId, S.SPName,S.ClientId, S.ClientName, S.AppTypeId,S.AppTypeName, S.appId,S.SubclientName,(1.0*S.UncompBytes)/1024/1024,S.BackupSetName,S.InstanceName, S.LicType, S.IsVM, S.flag, NULL, NULL, NULL)
;
IF  @current_BackupEnterPriseUsed > 0 AND @current_BackupEnterPriseUsed >= @last_CCLPeekBackupEnterPriseUsed
BEGIN
	SET @last_CCLPeekBackupEnterPriseUsed = @current_BackupEnterPriseUsed
	INSERT INTO  @updateusage VALUES (0)
END
IF  @current_ArchiverEnterPriseUsed >= @last_CCLPeekArchiverEnterPriseUsed
BEGIN
	SET @last_CCLPeekArchiverEnterPriseUsed = @current_ArchiverEnterPriseUsed
	INSERT INTO  @updateusage VALUES (1)
END
IF @current_SnapUsed >= @last_CCLPeekSnapUsed
BEGIN
	SET @last_CCLPeekSnapUsed = @current_SnapUsed
	INSERT INTO  @updateusage VALUES (2)
END
IF @current_ReplicationUsed >= @last_CCLPeekReplicationUsed
BEGIN
	SET @last_CCLPeekReplicationUsed = @current_ReplicationUsed
	INSERT INTO  @updateusage VALUES (3)
END
SELECT @current_BackupEnterPriseUsed = ISNULL(SUM(AppSizeMB)*1024*1024,0) From LicSCLPeakUsageDetails WITH(NOLOCK) WHERE MonthStart = @monthStart AND nJobtype = 0 AND CapacityFlag = 0
SELECT @current_ArchiverEnterPriseUsed = ISNULL(SUM(AppSizeMB)*1024*1024,0) From LicSCLPeakUsageDetails WITH(NOLOCK) WHERE MonthStart = @monthStart AND nJobtype = 1 AND CapacityFlag = 0
SELECT @current_SnapUsed = ISNULL(SUM(AppSizeMB)*1024*1024,0) From LicSCLPeakUsageDetails WITH(NOLOCK) WHERE MonthStart = @monthStart AND nJobtype = 2 AND CapacityFlag = 0
SELECT @current_ReplicationUsed = ISNULL(SUM(AppSizeMB)*1024*1024,0) From LicSCLPeakUsageDetails WITH(NOLOCK) WHERE MonthStart = @monthStart AND nJobtype = 3 AND CapacityFlag = 0
IF EXISTS (SELECT TOP 1 1 FROM @updateusage)
BEGIN
	DELETE ccl
	FROM LicCCLPeakUsageDetails ccl
	INNER JOIN @updateusage u ON ccl.nJobType = u.type and MonthStart = @monthStart
	INSERT INTO  LicCCLPeakUsageDetails (MonthStart, PeakDate, nJobType, jobID, SPId, SPName, ClientId, ClientName, AppTypeId, AppTypeName, appId, SubclientName,AppSizeMB,BackupSetName, InstanceName,LicType, IsVM, CapacityFlag, Organization, OrgGUID, PlanName)
	SELECT @monthStart, @currentTime, nJobType, jobID, SPId, SPName,ClientId, ClientName, AppTypeId,AppTypeName,appId,SubclientName,(1.0*UncompBytes)/1024/1024,BackupSetName,InstanceName, LicType, IsVM, flag, NULL, NULL, NULL
	FROM #tmpCommcellUsageReport t INNER JOIN @updateusage u ON t.njobtype = u.type
END
IF @lastdate >= @date_start AND @lastdate < @date_END
DELETE FROM LicPeakUsageHistory WHERE date = @lastdate
INSERT INTO LicPeakUsageHistory (date,CCLPeakEnterpriseBackupSize,CCLPeakEnterpriseArchiveSize,CCLPeakSnapSize,CCLPeakReplicationSize,SCLPeakEnterpriseBackupSize,SCLPeakEnterpriseArchiveSize,SCLPeakSnapSize,SCLPeakReplicationSize)
VALUES(@currentTime_Unix, @last_CCLPeekBackupEnterPriseUsed,@last_CCLPeekArchiverEnterPriseUsed,@last_CCLPeekSnapUsed,@last_CCLPeekReplicationUsed,@current_BackupEnterPriseUsed, @current_ArchiverEnterPriseUsed, @current_SnapUsed, @current_ReplicationUsed)
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
GOTO  QS_ERROR
END CATCH
UPDATE LicSCLPeakUsageDetails SET LicType = ISNULL(A.LicType,0)
FROM LicSCLPeakUsageDetails B LEFT JOIN LicUsage A WITH(NOLOCK) ON Cid = ClientId AND A.AppType = B.AppTypeId
WHERE B.LicType < 0
UPDATE LicSCLPeakUsageDetails SET IsVM = ISNULL(CAST(attrVal AS INT),0)
FROM LicSCLPeakUsageDetails B LEFT JOIN APP_ClientProp A WITH(NOLOCK)
ON componentNameId = ClientId AND attrName ='Virtual Server Discovered Clients' AND attrVal = '1' AND modIFied = 0
WHERE B.IsVM < 0
UPDATE LicCCLPeakUsageDetails SET LicType = ISNULL(A.LicType,0)
FROM LicCCLPeakUsageDetails B LEFT JOIN LicUsage A WITH(NOLOCK) ON Cid = ClientId AND A.AppType = B.AppTypeId
WHERE B.LicType < 0
UPDATE LicCCLPeakUsageDetails SET IsVM = ISNULL(CAST(attrVal AS INT),0)
FROM LicCCLPeakUsageDetails B LEFT JOIN APP_ClientProp A WITH(NOLOCK)
ON componentNameId = ClientId AND attrName ='Virtual Server Discovered Clients' AND attrVal = '1' AND modIFied = 0
WHERE B.IsVM < 0
IF object_id('tempdb.dbo.#tempAssocIdMap') IS NOT null DROP TABLE #tempAssocIdMap
CREATE TABLE #tempAssocIdMap (t_cid INT, t_appid INT, t_org NVARCHAR(1024), t_orgGUID uniqueidentifier, t_planid INT)
INSERT INTO #tempAssocIdMap
SELECT DISTINCT ClientId, AppId, NULL,NULL,0 FROM #tmpCommcellUsageReport
UPDATE Map
SET t_org = domainName, t_orgGUID = D.GUID
FROM #tempAssocIdMap Map JOIN APP_ClientGroupAssoc A WITH(NOLOCK) ON Map.t_cid = A.ClientId
JOIN APP_ClientGroup B WITH(NOLOCK) ON A.clientGroupId = B.id
JOIN App_CompanyProp C WITH(NOLOCK) ON C.attrName = 'Associated Smart Client Group' AND CAST(A.clientGroupId AS nvarchar(MAX)) = C.attrVal AND C.modIFied = 0
JOIN UMDSProviders D WITH(NOLOCK) ON C.componentNameId = D.id
WHERE B.flag&0x1000 > 0
UPDATE Map
SET t_planid = CASE  WHEN AC.status & 4096 = 0 THEN CAST(ISNULL(ASCP.attrVal, 0) AS int)
                     ELSE CAST(ISNULL(ACP.attrVal, 0) AS INT)
               END
FROM #tempAssocIdMap Map
INNER JOIN APP_Application AAP WITH(NOLOCK) ON Map.t_appid = AAP.id AND Map.t_cid = AAP.clientId
INNER JOIN APP_Client AC WITH(NOLOCK) ON AC.id = AAP.clientId
LEFT JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.modified = 0
LEFT JOIN APP_ClientProp ACP WITH(NOLOCK) ON ACP.componentNameId = AC.id AND ACP.attrName = 'Associated Plan' AND ACP.modified = 0
UPDATE LicSCLPeakUsageDetails
SET Organization = t_org, OrgGUID = t_orgGUID, PlanName = P.Name
FROM #tempAssocIdMap
LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
WHERE ClientId = t_cid AND AppId = t_appid AND PeakDate = @currentTime
UPDATE LicCCLPeakUsageDetails
SET Organization = t_org, OrgGUID = t_orgGUID, PlanName = P.Name
FROM #tempAssocIdMap
LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
WHERE ClientId = t_cid AND AppId = t_appid AND PeakDate = @currentTime
SELECT DISTINCT T.EnterpriseBackupSize, T.CoreBackupSize, T.EnterpriseArchiveSize, T.CoreArchiveSize,T.SnapshotSize,T.ReplicationSize,T.nJobType,T.appId,T.jobID,T.ClientName,T.ClientId,T.AppTypeId,T.AppTypeName,T.BackupSetName,T.InstanceName,T.SubclientName,T.SPId,T.SPName,T.UncompBytes,T.DedupEnabled,T.SecondaryEncryption,T.flag,T.Snapshot,T.LicType,T.IsVM,T.ClientGroup,t_org AS Organization, t_orgGUID AS OrgGUID, P.Name AS PlanName
FROM #tmpCommcellUsageReport T
LEFT JOIN #tempAssocIdMap on T.ClientId = t_cid AND T.AppId = t_appid
LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
DROP TABLE #tempAssocIdMap
QS_ERROR:
DROP TABLE #tmpCommcellUsageReport
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetCapacityDetailsV2')
	delete from GxQscripts where name = 'LicGetCapacityDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCapacityDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetCapacityDetailsV2'
GO

insert into GXDBVersions values(2, 'LicGetCapacityDetailsV2',  '00010001000400030000', 'LicGetCapacityDetailsV2', '00010001000400030000')
GO

