

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetCIDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetCIDetailsV3.sp,v $ $Id: LicGetCIDetailsV3.sp,v 1.1.2.2 2019/04/17 17:16:38 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetCIDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetCIDetailsV3 <<<'
	drop procedure LicGetCIDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetCIDetailsV3')
	delete from GxQscripts where name = 'LicGetCIDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCIDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetCIDetailsV3'
GO
print '... Creating Procedure: LicGetCIDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetCIDetailsV3
  @nUserId integer = 0
AS
--Calculate Content Indexed Object license
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetCIDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0' --0 successful  --1 failed
DECLARE @ContentIndexedObjectType int = 25
DECLARE @ContentIndexedObjectLicType  int = 100017
DECLARE @current_ContentIndexedObject  bigint = 0
DECLARE @last_ContentIndexedObject  bigint = 0
IF object_id('tempdb.dbo.#tblAppGetFastServerList') IS NOT null DROP TABLE #tblAppGetFastServerList
CREATE TABLE #tblAppGetFastServerList
            (
              ServerName        VARCHAR(1024),
              ClientId          VARCHAR(1024),
              ClientName        VARCHAR(1024),
              CloudId           VARCHAR(1024),
              HostName          VARCHAR(1024),
              BasePort          VARCHAR(1024),
              Version           VARCHAR(1024),
              EngineName        VARCHAR(1024),
              serverType        INT
            )
INSERT INTO #tblAppGetFastServerList
EXEC AppGetFastServerList
DELETE #tblAppGetFastServerList
WHERE CloudId in (SELECT longVal FROM app_componentprop WITH (NOLOCK) WHERE propertyTypeId = 1039 and componentType = 2)
IF @nUserId > 1 --SECURITY
BEGIN
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC LicGetSecurityObjV3 @nUserId OUTPUT,0
END
IF @nUserId > 1 --SECURITY
BEGIN
	DELETE #tblAppGetFastServerList
    WHERE ClientId not in (SELECT clientId FROM #LicCalUserObj  WHERE clientId > 0)
END
IF object_id('tempdb.dbo.#SearchEngineList') IS NOT null DROP TABLE #SearchEngineList
CREATE TABLE #SearchEngineList
       (
         EngineName        VARCHAR(1024),
         CICount           bigint,
         CloudId           VARCHAR(1024)
        )
INSERT INTO #SearchEngineList
SELECT '',SUM(longlongVal),componentId FROM APP_ComponentProp WITH (NOLOCK)
WHERE (componentId in (SELECT distinct cloudId FROM #tblAppGetFastServerList WHERE Version not like '%Solr%') OR componentId in (2039))
AND propertyTypeId = 1002 and modified =0
GROUP BY componentId
--Updating Search engine name
UPDATE  #SearchEngineList
SET  EngineName = ISNULL((SELECT DISTINCT EngineName FROM  #tblAppGetFastServerList mainlist WHERE list.CloudId = mainlist.CloudId),'')
FROM #SearchEngineList list
--10.0 count...
INSERT INTO #SearchEngineList(EngineName,CICount)
SELECT ISNULL(StringVal, ''), SUM(ISNULL(CollectionSize,0)) + SUM(ISNULL(failedItems,0)) as Total
FROM DM2SearchServerCoreInfo A WITH (NOLOCK)
INNER JOIN APP_ComponentProp B WITH (NOLOCK) on B.id = A.CloudId
WHERE ((A.CoreRoles & 8 = 8) OR (A.CoreRoles & 16 = 16)) AND CloudId NOT IN (SELECT CloudId FROM DM2CloudCoreRole WITH (NOLOCK)) AND CLOUDID IN (select distinct cloudId from #tblAppGetFastServerList where Version like '%Solr%')
GROUP BY ISNULL(StringVal, '')
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ContentIndexedObjectType)
DELETE FROM Lic_CurrentUsage WHERE UsageType = @ContentIndexedObjectType
INSERT INTO Lic_CurrentUsage (UsageType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName)
SELECT  DISTINCT @ContentIndexedObjectType,@ContentIndexedObjectLicType,sum(CICount),-1,0,EngineName
From #SearchEngineList
WHERE CICount > 0
Group BY EngineName
SELECT @current_ContentIndexedObject = ISNULL(SUM(AppSizeMB),0) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ContentIndexedObjectType
SELECT @last_ContentIndexedObject  = ISNULL(SUM(AppSizeMB),0) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND UsageType = @ContentIndexedObjectType AND PeakType = @CCLPeakType
IF @current_ContentIndexedObject >= @last_ContentIndexedObject AND @current_ContentIndexedObject > 0
BEGIN
DELETE Lic_PeakUsage WHERE MonthStart = @monthStart AND UsageType = @ContentIndexedObjectType AND PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName
FROM Lic_CurrentUsage WITH (NOLOCK)
WHERE UsageType = @ContentIndexedObjectType
END
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType  = @ContentIndexedObjectType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ObjectName = S.ObjectName
WHEN MATCHED AND T.AppSizeMB < S.AppSizeMB
	THEN Update
		SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, CreationDate,UsageType,PeakType,LicType,AppSizeMB,CapacityFlag, VMFlag, ObjectName)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.LicType,S.AppSizeMB,S.CapacityFlag,S.VMFlag, S.ObjectName)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
IF @nUserId > 0 --SECURITY
DROP TABLE #LicCalUserObj
DROP TABLE #tblAppGetFastServerList
DROP TABLE #SearchEngineList
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetCIDetailsV3')
	delete from GxQscripts where name = 'LicGetCIDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCIDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetCIDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetCIDetailsV3',  '00010001000200020000', 'LicGetCIDetailsV3', '00010001000200020000')
GO

