

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetCALDetailsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetCALDetailsV2.sp,v $ $Id: LicGetCALDetailsV2.sp,v 1.1.4.8 2018/10/25 02:24:48 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetCALDetailsV2')
BEGIN
	print '>>> Drop Stored Procedure: LicGetCALDetailsV2 <<<'
	drop procedure LicGetCALDetailsV2
END
IF EXISTS (select * from GxQscripts where name='LicGetCALDetailsV2')
	delete from GxQscripts where name = 'LicGetCALDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCALDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetCALDetailsV2'
GO
print '... Creating Procedure: LicGetCALDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetCALDetailsV2
  @nUserId integer =0,
  @nOrganizationDetails integer =0
AS
SET NOCOUNT ON
SET ANSI_PADDING ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @date_s AS NVARCHAR(32) = CAST(DATEPART(year,  @currentTime) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(month, @currentTime) AS NVARCHAR(32)) + '-' +
                                      CAST(DATEPART(day,   @currentTime) AS NVARCHAR(32)) + ' 00:00:00.000'
DECLARE @date_start INTEGER = dbo.GetUnixTime(CONVERT(DATETIME, @date_s, 120))
DECLARE @date_END   INTEGER = @date_start + 86400
DECLARE @lastdate INTEGER = 0
--Keep data only for last 3 months and current month
DELETE FROM LicCCLPeakCALDetails WHERE DATEDIFf(MM, MonthStart,@currentTime) > 3
DELETE FROM LicSCLPeakCALDetails WHERE DATEDIFf(MM, MonthStart,@currentTime) > 3
IF object_id('tempdb.dbo.#updateusage') IS NOT null DROP TABLE #updateusage
CREATE TABLE #updateusage (type int primary key)
--1. Calculation for usage based license
DECLARE @nProtectedClient       integer = 0
DECLARE @nArchivedClient        integer = 0
DECLARE @nArchivedVM            integer = 0
DECLARE @nACV			        integer = 0
DECLARE @nVMOnly			    integer = 0
DECLARE @nVMWithApp				integer = 0
DECLARE @nVMSocket              integer = 0
DECLARE @nArchivedMailBox       integer = 0
DECLARE @nMSimUsers             integer = 0
DECLARE @nSearchMailBox         integer = 0
DECLARE @nSRMClient             integer = 0
DECLARE @nCIServer              integer = 0
DECLARE @nAdvSearchNodes        integer = 0
DECLARE @nEpUsers               integer = 0
DECLARE @nEpSharingUsers        integer = 0
DECLARE @nEpEdiscoveryUsers     integer = 0
DECLARE @nFSOnlyServer          integer = 0
DECLARE @nDOL					integer = 0
DECLARE @nApplicationServer     integer = 0
DECLARE @nAppStoreCapacityMB    bigint = 0
DECLARE @nUsedDiskSpaceMB        bigint = 0
DECLARE @nAvailDiskSpaceMB       bigint = 0
DECLARE @nDedupDataSizeMB        bigint = 0
DECLARE @nDedupDataOnTapeMB      bigint = 0
DECLARE @nAvailDedupSpaceMB      bigint = 0
DECLARE @nContentIndexedObject  bigint = 0
DECLARE @last_nProtectedClient       integer = 0
DECLARE @last_nArchivedClient        integer = 0
DECLARE @last_nArchivedVM            integer = 0
DECLARE @last_nACV					 integer = 0
DECLARE @last_nVMOnly			     integer = 0
DECLARE @last_nVMWithApp			 integer = 0
DECLARE @last_nVMSocket              integer = 0
DECLARE @last_nArchivedMailBox       integer = 0
DECLARE @last_nMSimUsers             integer = 0
DECLARE @last_nSearchMailBox         integer = 0
DECLARE @last_nSRMClient             integer = 0
DECLARE @last_nCIServer              integer = 0
DECLARE @last_nAdvSearchNodes        integer = 0
DECLARE @last_nEpUsers               integer = 0
DECLARE @last_nEpSharingUsers        integer = 0
DECLARE @last_nEpEdiscoveryUsers     integer = 0
DECLARE @last_nFSOnlyServer          integer = 0
DECLARE @last_nDOL					 integer = 0
DECLARE @last_nApplicationServer     integer = 0
DECLARE @last_nAppStoreCapacityMB    bigint = 0
DECLARE @last_nUsedDiskSpaceMB        bigint = 0
DECLARE @last_nAvailDiskSpaceMB       bigint = 0
DECLARE @last_nDedupDataSizeMB        bigint = 0
DECLARE @last_nDedupDataOnTapeMB      bigint = 0
DECLARE @last_nAvailDedupSpaceMB      bigint = 0
DECLARE @last_nContentIndexedObject  bigint = 0
DECLARE @AppServerType INT = 1
DECLARE @LapDesktopType INT = 2
DECLARE @FsOnlyType INT = 3
DECLARE @DedupDataType int = 4
DECLARE @DedupDataOnTapeType int = 5
DECLARE @AvailDedupSpaceType int = 6
DECLARE @AppStoreCapacityType int = 7
DECLARE @UsedDiskSpaceType int = 8
DECLARE @AvailDiskSpaceType int = 9
DECLARE @ArchivedMailBoxType int = 10
DECLARE @ProtectedClientType int  = 11
DECLARE @ArchivedClientType  int  = 12
DECLARE @SRMClientType int = 13
DECLARE @CIServerType int = 14
DECLARE @AdvSearchNodesType int  = 15
DECLARE @SearchMailBoxType int = 16
DECLARE @MSimUserType int = 17
DECLARE @ACVType int = 18
DECLARE @VMSocketType int = 19
DECLARE @VMOnlyType int = 20
DECLARE @ArchivedVMType int = 21
DECLARE @EpUsersType int  = 22
DECLARE @EpSharingUsersType int = 23
DECLARE @EpEdiscoveryUsersType int  = 24
DECLARE @ContentIndexedObjectType int = 25
DECLARE @VMWithAppType int  = 26
DECLARE @FsOnlyLicType INT = 100029
DECLARE @AppServerLicType INT = 100030
DECLARE @LapDesktopLicType INT = 200002
DECLARE @FSOnlyName VARCHAR(64) = 'File System Only Server'
DECLARE @AppServerName VARCHAR(64) = 'Application Server'
DECLARE @LapDeskTopName VARCHAR(64) = 'DLO Only'
DECLARE @DedupData VARCHAR(64) = 'Dedup Data'
DECLARE @DedupDataLicType int = 100016
DECLARE @DedupDataOnTape VARCHAR(64) = 'Dedup Data On Tape'
DECLARE @AvailDedupSpace VARCHAR(64) = 'Avail Dedup Space'
DECLARE @AppStoreCapacity VARCHAR(64) = 'Appliance Store Usage'
DECLARE @UsedDiskSpace VARCHAR(64) = 'Used Disk Space'
DECLARE @UsedDiskSpaceLicType int = 100015
DECLARE @AvailDiskSpace VARCHAR(64) = 'Avail Disk Space'
DECLARE @AppStoreCapacityLicType int =  100031
DECLARE @ArchivedMailBox VARCHAR(64) = 'Archived Mail Box'
DECLARE @ArchivedMailBoxLicType int = 100013
DECLARE @ProtectedClient VARCHAR(64) = 'Protected Client '
DECLARE @ArchivedClient  VARCHAR(64)  = 'Archived Client'
DECLARE @SRMClient VARCHAR(64) = 'SRM Client'
DECLARE @CIServer VARCHAR(64) = 'CI Server'
DECLARE @AdvSearchNodes VARCHAR(64)  = 'Adv Search Nodes'
DECLARE @SearchMailBox VARCHAR(64) = 'Search Mail Box'
DECLARE @ProtectedClientLicType int  = 200004
DECLARE @ArchivedClientLicType  int  = 200005
DECLARE @SRMClientLicType int = 200006
DECLARE @CIServerLicType int = 200007
DECLARE @AdvSearchNodesLicType int  = 200008
DECLARE @SearchMailBoxLicType int = 200009
DECLARE @MSimUsers VARCHAR(64) = 'MSim Users'
DECLARE @MSimLicType int = 100028
DECLARE @ACV  VARCHAR(64) = 'ACV'
DECLARE @ACVLicType  int = 100027
DECLARE @VMWithApp  VARCHAR(64) = 'VM With App'
--DECLARE @ProtectedVM     VARCHAR(64) = 'Protected VM'
DECLARE @VMOnly     VARCHAR(64) = 'VM Only'
DECLARE @VMSocket   VARCHAR(64) = 'VM Socket'
DECLARE @ArchivedVM VARCHAR(64) = 'Archived VM'
DECLARE @VMWithAppLicType  int = 200003
DECLARE @VMOnlyLicType  int = 200001
DECLARE @VMSocketLicType  int = 100018
DECLARE @ArchivedVMLicType  int = 100021
DECLARE @EpUsers  VARCHAR(64) = 'EndPoint Users'
DECLARE @EpSharingUsers     VARCHAR(64) = 'EndPoint Sharing Users'
DECLARE @EpEdiscoveryUsers   VARCHAR(64) = 'EndPoint Ediscovery Users'
DECLARE @EpUsersLicType  int = 100024
DECLARE @EpSharingUsersLicType  int = 100025
DECLARE @EpEdiscoveryUsersLicType  int = 100026
DECLARE @ContentIndexedObject   VARCHAR(64) = 'Content Indexed Object'
DECLARE @ContentIndexedObjectLicType  int = 100017
DECLARE @bIsArchiveLicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsArchiveLicValid = @licAppliedStatus&0x4
END
ELSE
	SELECT @bIsArchiveLicValid = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = 100021),0)--SIM_CSL_AT_V2_VM_ARCHIVING
SELECT TOP 1 @lastdate = date, @last_nProtectedClient = CCLProtectedClient,@last_nArchivedClient = CCLArchivedClient,@last_nVMWithApp = CCLVMWithApp,@last_nArchivedVM = CCLArchivedVM,@last_nACV = CCLACV,@last_nVMOnly = CCLVMOnly,@last_nVMSocket = CCLVMSocket,@last_nArchivedMailBox = CCLArchivedMailBox,@last_nMSimUsers = CCLMSimUsers,@last_nSearchMailBox = CCLSearchMailBox,@last_nSRMClient = CCLSRMClient,@last_nCIServer = CCLCIServer,@last_nContentIndexedObject = CCLContentIndexedObject,@last_nAdvSearchNodes = CCLAdvSearchNodes,@last_nEpUsers = CCLEpUsers,@last_nEpSharingUsers = CCLEpSharingUsers,@last_nEpEdiscoveryUsers = CCLEpEdiscoveryUsers,@last_nFSOnlyServer = CCLFSOnlyServer,@last_nDOL = CCLDLO,@last_nApplicationServer = CCLApplicationServer,@last_nAppStoreCapacityMB = CCLAppStoreCapacityMB,@last_nUsedDiskSpaceMB = CCLUsedDiskSpaceMB,@last_nAvailDiskSpaceMB = CCLAvailDiskSpaceMB,@last_nDedupDataSizeMB = CCLDedupDataSizeMB,@last_nDedupDataOnTapeMB = CCLDedupDataOnTapeMB,@last_nAvailDedupSpaceMB = CCLAvailDedupSpaceMB
FROM    LicPeakCALClientCountHistory WITH (NOLOCK)
WHERE  date>= @monthStart_Uix
Order by date desc
IF object_id('tempdb.dbo.#tempClientList') IS NOT null DROP TABLE #tempClientList
CREATE TABLE #tempClientList(t_type int, t_typename VARCHAR(64),t_clientId INT, t_subclientid int, t_appName NVARCHAR(MAX), t_appTypeId INT, t_lictype INT, t_jobid INT, t_objectName NVARCHAR(MAX),t_objectId int, t_objectsizeMB bigint)
---1.1 Dedup, Appliance Store Usage and Disk library space
INSERT INTO #tempClientList (t_clientId, t_type, t_typename,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectId, t_objectsizeMB)
SELECT 0,@DedupDataType,@DedupData, 0,NULL, 0,@DedupDataLicType, 0, NULL,SIDBStoreId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM MMVolume WITH (NOLOCK)
WHERE SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM archCopySIDBStore CS WITH (NOLOCK) WHERE ((CS.Flags & 4) > 0))
group by SIDBStoreId       --DedupData
UNION ALL
SELECT 0,@DedupDataOnTapeType,@DedupDataOnTape, 0,NULL, 0,0, 0, NULL,SIDBStoreId,SUM(CASE WHEN SiloStatus = 3 THEN ISNULL(CAST(PhysicalBytesMB AS BIGINT),0) ELSE 0 END)
FROM MMVolume WITH (NOLOCK)
WHERE SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM archCopySIDBStore CS WITH (NOLOCK) WHERE ((CS.Flags & 4) > 0))
group by SIDBStoreId       --DedupDataOnTape
UNION ALL
SELECT 0,@AvailDedupSpaceType,@AvailDedupSpace, 0,NULL, 0,0, 0, NULL,MediaSideId,SUM(ISNULL(CAST(FreeBytesMB AS BIGINT),0))
FROM  MMMediaSide WITH (NOLOCK)
WHERE MediaSideId IN (SELECT DISTINCT MediaSideId FROM MMVolume WITH (NOLOCK) WHERE SIDBStoreId > 0)
group by MediaSideId       --Avail Dedup Space
UNION ALL
SELECT 0,@AppStoreCapacityType,@AppStoreCapacity, 0,NULL, 0,@AppStoreCapacityLicType, 0, NULL,MediaSideId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM  MMVolume WITH (NOLOCK)
WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0 and MountPathTypeId <> 7)
group by MediaSideId       --Appliance Store Usage
UNION ALL
SELECT 0,@UsedDiskSpaceType,@UsedDiskSpace, 0,NULL, 0,@UsedDiskSpaceLicType, 0, NULL,MediaSideId,SUM(ISNULL(CAST(PhysicalBytesMB AS BIGINT),0))
FROM  MMVolume WITH (NOLOCK)
WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0)
group by MediaSideId        --used Disk Space
UNION ALL
SELECT 0,@AvailDiskSpaceType,@AvailDiskSpace, 0,NULL, 0,0, 0, NULL,MS.MediaSideId,SUM(ISNULL(CAST(FreeBytesMB AS BIGINT),0))
FROM  MMMediaSide MS WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
WHERE MS.MediaSideId=MP.MediaSideId AND  MP.MediaSideId > 0
group by MS.MediaSideId     --Avail Disk Space
Delete FROM #tempClientList
Where t_objectsizeMB = 0 and t_type in (@DedupDataType,@DedupDataOnTapeType,@AvailDedupSpaceType,@AppStoreCapacityType,@UsedDiskSpaceType,@AvailDiskSpaceType)
SELECT @nDedupDataSizeMB = ISNULL([4],0),@nDedupDataOnTapeMB = ISNULL([5],0),@nAvailDedupSpaceMB = ISNULL([6],0),@nAppStoreCapacityMB =ISNULL([7],0),@nUsedDiskSpaceMB =ISNULL([8],0),@nAvailDiskSpaceMB = ISNULL([9],0)
FROM (select t_objectsizeMB, t_type from #tempClientList) AS S
PIVOT
(sum(t_objectsizeMB) FOR t_type in ([4],[5],[6],[7],[8],[9])) AS P
IF @nUserId > 1 --SECURITY
BEGIN
DECLARE @capability BIGINT = 1
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	--If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
EXEC sec_getUserObjects @nUserId,2013,0,'#LicCalUserObj' --SUB_CLIENT_ITEM->client
IF EXISTS(SELECT 1 FROM #LicCalUserObj sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) AND (capabilities & POWER(2, @capability-1)) > 0)
		SET @nUserId = 1
END
IF @nOrganizationDetails > 0
BEGIN
	-- #Companies table should be created by the caller
	--IF object_id('tempdb.dbo.#Companies') IS NOT NULL DROP TABLE #Companies
	--CREATE TABLE #Companies(id INT PRIMARY KEY, domainName VARCHAR(1024), vmcount INT DEFAULT 0, socketcount INT DEFAULT 0, epUsers INT DEFAULT 0, epSharingUsers INT DEFAULT 0, epDiscoveryUsers INT DEFAULT 0 )
	INSERT INTO #Companies(id,domainName)
	SELECT id,domainName FROM UMDSProviders p WITH(NOLOCK)
	WHERE p.serviceType = 5	-- UMDS_PROVIDER_ORGANIZATIONS
	IF object_id('tempdb.dbo.#CompanyClientMap') IS NOT NULL DROP TABLE #CompanyClientMap
	CREATE TABLE #CompanyClientMap(t_companyId INT , t_clientId INT)
	CREATE UNIQUE CLUSTERED INDEX CompanyClientMap_Idx ON #CompanyClientMap (t_companyId, t_clientId)
	;WITH Providers(companyId) AS
	(
		SELECT
			c.id
		FROM  #Companies c
		UNION
		SELECT
			p.id
		FROM UMDSProviders p WITH(NOLOCK)
			INNER JOIN #Companies c ON
				c.id = p.ownerCompany
				AND p.serviceType = 2		-- UMDS_PROVIDER_ACTIVE_DIR
	)
	,Users(userId, companyId) AS (
		SELECT DISTINCT
			u.id, c.companyId
		FROM Providers c
			INNER JOIN UMUsers u WITH(NOLOCK) ON
				u.umDSproviderId = c.companyId
				AND (u.flags & 1) <> 0
	)
	,Groups(groupId, companyId) AS (
		SELECT DISTINCT
			g.id groupId, c.companyId
		FROM Providers c
			INNER JOIN UMGroups g WITH(NOLOCK) ON
				g.umdsProviderId = c.companyId
	)
	INSERT INTO #CompanyClientMap
		SELECT
			u.companyId, a.entityId1 AS clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				a.entityType1 = 3
				AND a.isUser = 1
				AND a.userOrGroupId = u.userId
		WHERE
			a.entityId1 NOT IN (0, 1)
		UNION
		SELECT
			g.companyId, a.entityId1 AS clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				a.entityType1 = 3
				AND a.isUser = 0
				AND g.groupId = a.userOrGroupId
		WHERE
			a.entityId1 NOT IN (0, 1)
		UNION
		SELECT
			u.companyId, o.entityId AS clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				o.entityType = 3
				AND o.isUser = 1
				AND o.userOrGroupId = u.userId
		UNION
		SELECT
			g.companyId, o.entityId AS clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				o.entityType = 3
				AND o.isUser = 0
				AND o.userOrGroupId = g.groupId
		UNION
		SELECT
			u.companyId, cga.clientId clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND a.isUser = 1
				AND a.userOrGroupId = u.userId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = a.entityId1
		UNION
		SELECT
			g.companyId, cga.clientId clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND a.isUser = 0
				AND g.groupId = a.userOrGroupId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = a.entityId1
		UNION
		SELECT
			u.companyId, cga.clientId clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				o.entityType = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND o.isUser = 1
				AND o.userOrGroupId = u.userId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = o.entityId
		UNION
		SELECT
			g.companyId, cga.clientId clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				o.entityType = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND o.isUser = 0
				AND o.userOrGroupId = g.groupId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = o.entityId
		-- Security Association check at user level is needed from Aaron
END
--1.2 Archive Mailbox
IF object_id('tempdb.dbo.#tempAppTypes') IS NOT null DROP TABLE #tempAppTypes
CREATE TABLE #tempAppTypes (t_apptype INT, t_name varchar(1024), fname varchar(50))
----ProtectedMailbox
INSERT INTO #tempAppTypes
SELECT type, name, (CASE WHEN name like '%Archiv%' THEN 'ArchivedMailbox' ELSE 'ProtectedMailbox' END)
FROM   APP_iDAType WITH (NOLOCK)  where type < 1000
AND (name like '%Compliance Archiver'  or name like '%mail%box%'  or name LIKE '%Notes%')
AND name not like '%Database' AND name NOT LIKE 'SRM%'
--If mSIM is present remove counting of apptype 54,56,67,137 from archive mailbox
DECLARE @o_isValidApptype INT
DECLARE @o_appTypeList NVARCHAR(1024) = ''
EXEC LicGetMSimAppType -1,0,@o_isValidApptype OUTPUT, @o_appTypeList OUTPUT
IF @o_appTypeList <> ''
   DELETE #tempAppTypes  WHERE t_apptype in (select _ID from dbo.SplitIDs(@o_appTypeList))
-- Backup activity disabled Client.
DECLARE     @tblClientIDA TABLE (clientId INT, appTypeId INT, disabled INT)
INSERT      INTO @tblClientIDA
SELECT      clientId, ida.appTypeId , 0 FROM  APP_IDAName IDA WITH (NOLOCK) WHERE (IDA.status & 6) =0
IF @nUserId > 1 --SECURITY
   delete @tblClientIDA where ClientId not in (select clientId from #LicCalUserObj where clientId > 0)
DELETE  @tblClientIDA
FROM  @tblClientIDA T, JMJobAction A WITH (NOLOCK)
WHERE A.clientId = T.clientId AND (A.appType = 0 OR A.appType = T.appTypeId)
AND A.opType = 4 AND A.action = 1
-- Backup activity disabled Subclient client.
DECLARE @ArchiveSubclients TABLE (SubclientId INT,clientId INT, subclientName VARCHAR(1024), appTypeId INT, bIsArchive INT)
INSERT INTO @ArchiveSubclients
SELECT ID,clientId,subclientName,appTypeId, (case fname WHEN 'ProtectedMailbox' THEN 0 ELSE 1 END)
FROM APP_Application App WITH (NOLOCK), (select distinct t_apptype, fname from #tempAppTypes where fname IN ('ProtectedMailbox', 'ArchivedMailbox')) T
WHERE appTypeId = t_apptype
AND (dataArchGrpID > 1 OR logArchGrpID > 1) AND (subclientStatus & 65538) = 0
AND clientId in (Select distinct clientId from @tblClientIDA )
AND App.id not in (SELECT appId FROM  JMJobAction WITH (NOLOCK) WHERE appId > 1 AND action = 1)
DELETE @ArchiveSubclients
WHERE bIsArchive = 0 AND NOT EXISTS (select 1 from APP_SubclientProp  a WITH (NOLOCK) where attrName = 'Is Turbo Subclient' and a.componentNameId=SubclientId and attrval='1' and a.modified = 0)
-- Temp table for the Archive Mailbox list.
INSERT INTO #tempClientList (t_clientId, t_type, t_typename,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectId, t_objectsizeMB)
SELECT  DISTINCT T.clientId, @ArchivedMailBoxType,@ArchivedMailBox,SCP.componentNameId,IDT.name, T.appTypeId,@ArchivedMailBoxLicType,0,CP.stringVal,0,0
FROM  @tblClientIDA T, @ArchiveSubclients APP, APP_SubClientProp SCP WITH (NOLOCK), APP_ComponentProp CP WITH (NOLOCK), APP_iDAType IDT WITH (NOLOCK)
WHERE APP.clientId = T.clientId AND APP.appTypeId = T.appTypeId
AND SCP.componentNameId = APP.SubclientId AND SCP.modified = 0 AND SCP.attrType > 100
AND IDT.type =T.appTypeId
AND CP.componentId = SCP.id AND CP.modified = 0
AND CP.propertyTypeId IN (1100, 1400)
SELECT @nArchivedMailBox = COUNT(DISTINCT t_objectName) From #tempClientList WHERE t_type = @ArchivedMailBoxType
--1.3 client, CTServer, AdvSearchNodes & SearchMailBox
INSERT INTO #tempAppTypes (t_apptype, t_name, fname)
SELECT TYPE,name,'ProtectedClient' FROM APP_iDAType WITH (NOLOCK)
WHERE displayName IN ('File System','NAS','OES File System', 'Workstation Backup','ProxyHost','Image Level','Image Level on Unix','Image Level ProxyHost',
                        'Image Level ProxyHost on Unix','NDMP Remote Tape Server','NAS Restore Enabler')  AND TYPE < 1000    --ProtectedClient
UNION ALL
select TYPE,name,'ArchivedClient' from APP_iDAType WITH (NOLOCK)  where name like '%Archiver%' AND name NOT LIKE '%Exchange%' AND name NOT LIKE '%Mailbox%'  AND TYPE <1000    --ArchivedClient
UNION ALL
select TYPE,name,'SRMClient' from APP_iDAType WITH (NOLOCK)  where name LIKE 'SRM %' and type <1000    --SRMClient
UNION ALL
select TYPE,name,'CIServer' from APP_iDAType WITH (NOLOCK)   where name like 'Content Index Server'  --CIServer
UNION ALL
select TYPE,name,'AdvSearchNodes' from APP_iDAType  where name ='Compliance Director'   --AdvSearchNodes
IF object_id('tempdb.dbo.#tblCI') IS NOT null DROP TABLE #tblCI
CREATE TABLE #tblCI (clientId INT, appTypeId INT, appId INT)
INSERT INTO #tblCI
SELECT DISTINCT APP.clientId, APP.appTypeId, APP.id
FROM APP_Application APP WITH (NOLOCK), APP_ClientProp CP WITH (NOLOCK)
WHERE APP.dataArchGrpID IN (SELECT archGroupId FROM archContentIndexingRules WITH (NOLOCK) WHERE enabled = 1)
      AND CP.componentNameId = APP.clientId AND CP.attrName = 'Content Indexing Enabled' AND CP.attrVal = '1' AND CP.modified = 0
INSERT INTO #tempClientList (t_clientId, t_type, t_typename,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectId, t_objectsizeMB)
SELECT  DISTINCT clientId, @ProtectedClientType,@ProtectedClient,0,t_name, appTypeId,@ProtectedClientLicType,0,NULL,0,0
FROM  @tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='ProtectedClient'
UNION ALL  --ArchivedClient
SELECT  DISTINCT clientId, @ArchivedClientType,@ArchivedClient,0,t_name, appTypeId,@ArchivedClientLicType,0,NULL,0,0
FROM  @tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='ArchivedClient'
UNION ALL --SRMClient
SELECT  DISTINCT clientId, @SRMClientType,@SRMClient,0,t_name, appTypeId,@SRMClientLicType,0,NULL,0,0
FROM  @tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='SRMClient'
UNION ALL  --CIServer
SELECT  DISTINCT clientId, @CIServerType,@CIServer,0,t_name, appTypeId,@CIServerLicType,0,NULL,0,0
FROM  @tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='CIServer'
UNION ALL   --AdvSearchNodes
SELECT  DISTINCT clientId, @AdvSearchNodesType,@AdvSearchNodes,0,t_name, appTypeId,@AdvSearchNodesLicType,0,NULL,0,0
FROM  @tblClientIDA
INNER JOIN #tempAppTypes on appTypeId = t_apptype and fname='AdvSearchNodes'
SELECT @nProtectedClient = [11],@nArchivedClient =[12],@nSRMClient =[13],@nCIServer =[14],@nAdvSearchNodes = [15]
FROM (SELECT distinct t_clientId, t_type FROM #tempClientList) AS S
PIVOT
(COUNT(t_clientId) FOR t_type in ([11],[12],[13],[14],[15])) AS P
--SearchMailBox
IF @nUserId > 1 --SECURITY
BEGIN
DELETE #tblCI
WHERE ClientId not in (SELECT clientId FROM #LicCalUserObj WHERE clientId > 0)
END
INSERT INTO #tempClientList (t_objectName,t_type, t_typename,t_clientId, t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectId, t_objectsizeMB)
SELECT  DISTINCT CP.stringVal, @SearchMailBoxType,@SearchMailBox,CI.clientId,CI.appId, NULL,CI.appTypeId,@SearchMailBoxLicType,0,0,0
FROM #tblCI CI, APP_SubClientProp SCP WITH (NOLOCK), APP_ComponentProp CP WITH (NOLOCK)
WHERE SCP.componentNameId = CI.appId AND SCP.modified = 0
AND CP.componentId = SCP.id AND CP.modified = 0
AND CP.propertyTypeId IN (1100, 1400)
SELECT @nSearchMailBox = COUNT(DISTINCT t_objectName) From #tempClientList WHERE t_type = @SearchMailBoxType
DROP TABLE #tblCI
DROP TABLE #tempAppTypes
--1.4 MSim
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#msimCountTable'))
DROP TABLE #msimCountTable
CREATE TABLE #msimCountTable (clientId INT, appTypeId INT, mailbox NVARCHAR(448), mailboxGUID VARCHAR(512), apptypename NVARCHAR(1024), subclientname NVARCHAR(1024), clientname NVARCHAR(1024), subClientId  int)
EXEC LicGetMSimUserCountV2 1,@nUserId,@nMSimUsers OUTPUT
INSERT INTO #tempClientList (t_objectName,t_type, t_typename,t_clientId, t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectId, t_objectsizeMB)
SELECT distinct mailbox, @MSimUserType,@MSimUsers,clientId,SubClientId,apptypename,appTypeId,@MSimLicType,0,0,0
From #msimCountTable
drop table #msimCountTable
--1.5 VM
DECLARE @tblVM TABLE (VMName VARCHAR(1024),VMSizeGB bigint, LastBackupTime datetime, IsVMArchived INT)
IF object_id('tempdb.dbo.#tempVMDPJobs') IS NOT null DROP TABLE #tempVMDPJobs
CREATE TABLE #tempVMDPJobs( VMName              nvarchar(1024),
                    BackupStatus                    VARCHAR(256), -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded,
                    InstanceName                    nvarchar(1024),
                    BackupSetName                   nvarchar(1024),
                    SubClientName                   nvarchar(1024),
                    VMSizeGB                        BIGINT,
                    VMBackedupSizeGB                BIGINT,
                    EstimatedVMDataWrittenSizeGB    BIGINT,
                    LastSuccessfulBackupJobId       BIGINT,
                    LastBackupTime                  datetime,
                    LastBackupType                  VARCHAR(256),
                    TotalTimeForLastBackup          BIGINT,
                    clientId                        INT,
                    CommCellId                      INT,
                    CommCellName                    varchar(256),
                    IsVMArchived                    INT)
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpSocketDetails'))
DROP TABLE #tmpSocketDetails
CREATE TABLE #tmpSocketDetails(t_host VARCHAR(256), t_sockets INT, t_clientId INT)
INSERT INTO #tempVMDPJobs EXEC VMProtectionCoverageProc -2, 0, @nUserId
---ACV
DECLARE @t_id INT
DECLARE @t_name VARCHAR(MAX)
DECLARE @appClassPkgInfo TABLE(t_pkgId INT, t_appTypeId INT, t_licTypeId INT)
INSERT INTO @appClassPkgInfo SELECT id, 0, 0 FROM SimPackage WITH (NOLOCK) WHERE DisplayName IN ('Exchange', 'SQL Server', 'Active Directory', 'SharePoint', 'MySQL', 'PostgreSQL','Oracle')
UPDATE @appClassPkgInfo
SET t_appTypeId = appType, t_licTypeId = LicType
FROM    simPackageMap M WITH (NOLOCK)
WHERE   t_pkgId = simPackageId
IF object_id('tempdb.dbo.#VMsWithAppClass1Pkg') IS NOT null DROP TABLE #VMsWithAppClass1Pkg
CREATE TABLE #VMsWithAppClass1Pkg(t_Id INT, t_Name NVARCHAR(255), t_bRDM INT, t_pkgId INT, t_appType INT, t_licType INT, t_agentStatus INT, t_pkgName VARCHAR(255))
INSERT INTO #VMsWithAppClass1Pkg
SELECT	C.id, C.name, 0, t_pkgId, t_appTypeId, t_licTypeId, A.status, (select displayname from simPackage P WITH (NOLOCK) where id = t_pkgId)
FROM	APP_Client C WITH (NOLOCK), APP_iDAName A WITH (NOLOCK), @appClassPkgInfo T
WHERE	C.id IN (SELECT clientId FROM simInstalledPackages WHERE simPackageId = t_pkgId) AND
		C.id IN (select componentNameId from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Server Discovered Clients' and attrval = '1' and modified = 0) AND
		A.clientId = C.id AND A.appTypeId = t_appTypeId
--exclude VM that has been deleted
DELETE VM
From #VMsWithAppClass1Pkg VM INNER JOIN APP_ClientProp WITH (NOLOCK) ON t_Id = componentNameId AND attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
UPDATE #VMsWithAppClass1Pkg
SET t_bRDM = 1
WHERE   EXISTS (SELECT 1
        FROM APP_Application A WITH (NOLOCK) JOIN APP_SubclientProp P WITH (NOLOCK) ON A.id = P.componentNameID and P.attrName = 'Snap Engine' and LEN(P.attrVal) > 0 and P.attrVal <> '48' and P.modified = 0
        WHERE   clientId = t_Id AND t_appType = appTypeId AND (subClientStatus & 2) = 0)
DELETE FROM #VMsWithAppClass1Pkg WHERE t_id IN (select T.t_id from #VMsWithAppClass1Pkg T where T.t_bRDM = 1)
DELETE FROM #VMsWithAppClass1Pkg WHERE t_agentStatus&(2+4) > 0
IF @nUserId > 1 --SECURITY
BEGIN
   delete #VMsWithAppClass1Pkg
   where t_Id not in (select clientId from #LicCalUserObj where clientId > 0)
END
INSERT INTO #tempClientList (t_objectId,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectsizeMB)
SELECT distinct t_Id, @ACVType,@ACV,t_Id, 0,t_pkgName,t_appType,@ACVLicType,0,NULL,0
From #VMsWithAppClass1Pkg
UPDATE #tempClientList
SET t_objectName = c.name
From App_Client c WITH(NOLOCK)
WHERE t_type = @ACVType and c.id=t_objectId
SELECT @nACV = count(DISTINCT t_Id) FROM #VMsWithAppClass1Pkg
IF @nOrganizationDetails > 0
BEGIN
 --VM calculation
	DELETE FROM #tempVMDPJobs WHERE BackupStatus <> 'Currently protected'
	UPDATE T SET T.vmcount = B.vmcount
	FROM #Companies T JOIN
	(SELECT t_companyId,COUNT(DISTINCT VMName) vmcount FROM #tempVMDPJobs A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId AND IsVMArchived = 0 GROUP BY t_companyId ) B
	ON T.id = B.t_companyId
--Socket calculation
	UPDATE T SET T.socketcount = C.sockets
	FROM #Companies T JOIN
	(SELECT B.t_companyId,SUM(socket) AS sockets FROM
	(SELECT t_companyId,t_host,MAX(t_sockets) socket FROM #tmpSocketDetails A JOIN #CompanyClientMap B ON A.t_clientId = B.t_clientId GROUP BY t_companyId, t_host ) B
	GROUP BY t_companyId) C ON T.id = C.t_companyId
END
ELSE
BEGIN
	--VM Socket
	INSERT INTO #tempClientList (t_objectName,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectId,t_objectsizeMB)
	SELECT distinct t_host, @VMSocketType,@VMSocket,0,0,NULL,0,@VMSocketLicType,0,0,MAX(t_sockets)
	From #tmpSocketDetails
	GROUP BY t_host
	SELECT @nVMSocket = ISNULL(SUM(t_objectsizeMB),0) FROM #tempClientList where t_type = @VMSocketType
	----VM only & Archived VM
	 IF @bIsArchiveLicValid > 0
     BEGIN
		INSERT INTO #tempClientList (t_objectName,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectId,t_objectsizeMB)
		SELECT distinct vmname,
		(case IsVMArchived when 0 then @VMOnlyType
					  when 1 then @ArchivedVMType
					  end),
		(case IsVMArchived when 0 then @VMOnly
					  when 1 then @ArchivedVM
					  end),
		0, 0,
		(case IsVMArchived when 0 then @VMOnly
					  when 1 then 'Virtual Server'
					  end),
		106,
		(case IsVMArchived when 0 then @VMOnlyLicType
					  when 1 then @ArchivedVMLicType
					  end),
		LastSuccessfulBackupJobId,clientId,VMSizeGB*1024
		From #tempVMDPJobs
		Where BackupStatus = 'Currently protected'
		SELECT  @nArchivedVM = count(distinct t_objectName) FROM #tempClientList where t_type = @ArchivedVMType	    --ARCHIVED VM:
     END
     ELSE
	 BEGIN
		INSERT INTO #tempClientList (t_objectName,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectId,t_objectsizeMB)
		SELECT distinct vmname,@VMOnlyType,@VMOnly,0, 0,@VMOnly,106,@VMOnlyLicType,LastSuccessfulBackupJobId,clientId,VMSizeGB*1024
		From #tempVMDPJobs
		Where BackupStatus = 'Currently protected'
		SET  @nArchivedVM = 0
     END
	 UPDATE A
	 SET A.t_type = @VMWithAppType,A.t_typename = @VMWithApp, A.t_clientId = V.t_Id,A.t_appTypeId = V.t_appType,A.t_appName = V.t_pkgName,A.t_lictype = @VMWithAppLicType
	 FROM #tempClientList A INNER JOIN #VMsWithAppClass1Pkg V ON A.t_objectId = V.t_Id
	 WHERE A.t_type = @VMOnlyType
	 UPDATE A
	 SET A.t_jobid = B.t_jobid,A.t_objectsizeMB = B.t_objectsizeMB
	 From #tempClientList A	 INNER JOIN #tempClientList B
	 On A.t_type = @ACVType AND B.t_type = @VMWithAppType AND A.t_objectId = B.t_objectId
	 UPDATE A
	 SET A.t_clientId = C.clientId, A.t_subclientid = C.id
	 FROM #tempClientList A join JMBkpStats B WITH(NOLOCK) ON A.t_jobid = B.jobId
	 JOIN APP_Application C WITH(NOLOCK) ON B.appId = C.id
	 WHERE t_type = @VMOnlyType or t_type = @ArchivedVMType
	 UPDATE A
	 SET A.t_jobId = B.jobId
	 FROM #tempClientList A JOIN LicSCLPeakUsageDetails B WITH(NOLOCK) ON A.t_clientId = B.clientId AND A.t_AppTypeId = B.AppTypeId
	 WHERE (t_type = @VMOnlyType or t_type = @ArchivedVMType) AND B.MonthStart = @monthStart
	 SELECT @nVMOnly = count(distinct t_objectName) FROM #tempClientList WHERE t_type = @VMOnlyType
	 SELECT @nVMWithApp = count(DISTINCT t_clientId) FROM #tempClientList WHERE t_type =@VMWithAppType
END
drop table #tmpSocketDetails
drop table #VMsWithAppClass1Pkg
drop table #tempVMDPJobs
---1.6 Server type usage (FSOnly, DLO, Application)
IF object_id('tempdb.dbo.#temp_lic1') IS NOT null DROP TABLE #temp_lic1
    CREATE TABLE #temp_lic1(t_cid int, t_lictype int)
INSERT INTO #updateusage
select distinct t_clientId from #tempClientList where t_type in (@VMOnlyType,@VMWithAppType,@ArchivedVMType)
INSERT INTO #temp_lic1
SELECT cid, LicType FROM LicUsage WITH (NOLOCK) WHERE OpType = 'Install' AND LicType < 1000 AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE())
DELETE #temp_lic1
WHERE t_cid IN (select type from #updateusage)
DELETE #updateusage
INSERT INTO #tempClientList (t_clientId, t_type, t_typename,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName, t_objectId, t_objectsizeMB)
SELECT DISTINCT t_cid,@AppServerType,@AppServerName, 0,@AppServerName, 0,@AppServerLicType, 0, NULL,0,0  FROM #temp_lic1 WHERE t_lictype IN (3,16,17)
SELECT @nApplicationServer = count(distinct t_clientid) FROM #tempClientList WHERE t_type = @AppServerType
--Remove all clients which are already counted towards application server
DELETE #temp_lic1
WHERE t_cid IN (SELECT DISTINCT t_cid FROM #temp_lic1 WHERE t_lictype IN (3,16,17))
DELETE #temp_lic1 WHERE t_lictype IN (SELECT id FROM simLicAppTypeV2 WHERE groupId IN (1,7,14,15))
INSERT INTO #tempClientList (t_clientId, t_type, t_typename,t_subclientid, t_appName,t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectID,t_objectsizeMB)
SELECT DISTINCT t_cid,@LapDesktopType,@LapDeskTopName, 0,@LapDeskTopName, 0,@LapDesktopLicType, 0, NULL,0,0 FROM #temp_lic1 WHERE t_lictype = 2
SELECT @nDOL = count(distinct t_clientid) FROM #tempClientList WHERE t_type = @LapDesktopType
--Remove all clients which are already counted towards LaptopDesktop
DELETE #temp_lic1
WHERE t_cid IN (SELECT DISTINCT t_cid FROM #temp_lic1 WHERE t_lictype = 2)
INSERT INTO #tempClientList(t_clientId, t_type, t_typename,t_subclientid, t_appName,t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectID,t_objectsizeMB)
SELECT DISTINCT t_cid,@FsOnlyType,@FSOnlyName, 0,@FSOnlyName, 0,@FsOnlyLicType, 0, NULL,0,0 FROM #temp_lic1 WHERE t_lictype in (1,25) -- count NAS under FSOnly
SELECT @nFSOnlyServer = count(distinct t_clientid) FROM #tempClientList WHERE t_type = @FsOnlyType
DROP TABLE #temp_lic1
--1.7 end users
IF object_id('tempdb.dbo.#tempEndPointUsers') IS NOT null DROP TABLE #tempEndPointUsers
CREATE TABLE #tempEndPointUsers(userId INT,userName NVARCHAR(1024),userLogin NVARCHAR(1024),userEmail NVARCHAR(1024),userType INT,reportName NVARCHAR(1024),associationType NVARCHAR(MAX),clientId INT)
--EpUsers
INSERT INTO #tempEndPointUsers
EXEC RptEndPointUserDetails 2,@nUserId,@nOrganizationDetails
IF @nOrganizationDetails > 0
BEGIN
	UPDATE T SET T.epUsers = B.usercount
    FROM #Companies T JOIN
   (SELECT t_companyId,COUNT(distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
    ON T.id = B.t_companyId
END
ELSE
BEGIN
	INSERT INTO #tempClientList (t_objectId,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid,t_objectName, t_objectsizeMB)
	SELECT distinct userId,@EpUsersType,@EpUsers,0,0,associationType,0,@EpUsersLicType,0,userName,0
	From #tempEndPointUsers
	select @nEpUsers = count(distinct userId) FROM #tempEndPointUsers
END
DELETE #tempEndPointUsers
--EpSharingUsers
INSERT INTO #tempEndPointUsers
EXEC RptEndPointUserDetails 1,@nUserId,@nOrganizationDetails
IF @nOrganizationDetails > 0
BEGIN
	UPDATE T SET T.epSharingUsers = B.usercount
    FROM #Companies T JOIN
    (SELECT t_companyId,COUNT( distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
     ON T.id = B.t_companyId
END
ELSE
BEGIN
	INSERT INTO #tempClientList (t_objectId,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid,t_objectName, t_objectsizeMB)
	SELECT distinct userId,@EpSharingUsersType,@EpSharingUsers,0,0,associationType,0,@EpSharingUsersLicType,0,userName,0
	From #tempEndPointUsers
	select @nEpSharingUsers = count(distinct userId) FROM #tempEndPointUsers
END
DELETE #tempEndPointUsers
--EpEdiscoveryUsers
INSERT INTO #tempEndPointUsers
EXEC RptEndPointUserDetails 3,@nUserId,@nOrganizationDetails
IF @nOrganizationDetails > 0
BEGIN
	UPDATE T SET T.epDiscoveryUsers = B.usercount
    FROM #Companies T JOIN
    (SELECT t_companyId,COUNT(distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
    ON T.id = B.t_companyId
END
ELSE
BEGIN
	INSERT INTO #tempClientList (t_objectId,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid,t_objectName, t_objectsizeMB)
	SELECT distinct userId,@EpEdiscoveryUsersType,@EpEdiscoveryUsers,0,0,associationType,0,@EpEdiscoveryUsersLicType,0,userName,0
	From #tempEndPointUsers
	select @nEpEdiscoveryUsers = count(distinct userId) FROM #tempEndPointUsers
END
DROP TABLE #tempEndPointUsers
--1.8 CONTENT INDEXED OBJECT
IF object_id('tempdb.dbo.#tblAppGetFastServerList') IS NOT null DROP TABLE #tblAppGetFastServerList
CREATE TABLE #tblAppGetFastServerList
            (
              ServerName        VARCHAR(1024),
              ClientId          VARCHAR(1024),
              ClientName        VARCHAR(1024),
              CloudId           VARCHAR(1024),
              HostName          VARCHAR(1024),
              BasePort          VARCHAR(1024),
              Version           VARCHAR(1024),
              EngineName        VARCHAR(1024),
              serverType        INT
            )
INSERT INTO #tblAppGetFastServerList exec AppGetFastServerList
DELETE #tblAppGetFastServerList
WHERE CloudId in (SELECT longVal FROM app_componentprop WITH (NOLOCK) WHERE propertyTypeId = 1039 and componentType = 2)
IF @nUserId > 1 --SECURITY
BEGIN
	DELETE #tblAppGetFastServerList
    WHERE ClientId not in (SELECT clientId FROM #LicCalUserObj WHERE clientId > 0)
END
SELECT @nContentIndexedObject = ISNULL(SUM(longlongVal),0) FROM APP_ComponentProp WITH (NOLOCK)
WHERE (componentId in (SELECT distinct cloudId FROM #tblAppGetFastServerList WHERE Version not like '%Solr%') OR componentId in (2039))
AND propertyTypeId = 1002 and modified = 0
IF EXISTS (SELECT cloudId FROM #tblAppGetFastServerList WHERE Version like '%Solr%' )
BEGIN
   SELECT  @nContentIndexedObject = ISNULL(@nContentIndexedObject,0) + ISNULL(SUM(CollectionSize),0) + ISNULL(SUM(failedItems),0)
   FROM DM2SearchServerCoreInfo WITH (NOLOCK)
WHERE  ((CoreRoles & 8 = 8) OR (CoreRoles & 16 = 16))
          AND CloudId NOT IN (SELECT CloudId FROM DM2CloudCoreRole WITH (NOLOCK))
          AND CLOUDID IN (SELECT distinct cloudId FROM #tblAppGetFastServerList WHERE Version like '%Solr%')
END
DECLARE @SearchEngineList TABLE
       (
         EngineName        VARCHAR(1024),
         CICount           bigint,
         CloudId           VARCHAR(1024)
        )
INSERT INTO @SearchEngineList
SELECT '',SUM(longlongVal),componentId FROM APP_ComponentProp WITH (NOLOCK)
WHERE (componentId in (SELECT distinct cloudId FROM #tblAppGetFastServerList WHERE Version not like '%Solr%') OR componentId in (2039))
AND propertyTypeId = 1002 and modified =0
GROUP BY componentId
--Updating Search engine name
UPDATE  @SearchEngineList
SET  EngineName = ISNULL((SELECT DISTINCT EngineName FROM  #tblAppGetFastServerList mainlist WHERE list.CloudId = mainlist.CloudId),'')
FROM @SearchEngineList list
--10.0 count...
INSERT INTO @SearchEngineList(EngineName,CICount)
SELECT ISNULL(StringVal, ''), SUM(ISNULL(CollectionSize,0)) + SUM(ISNULL(failedItems,0)) as Total
FROM DM2SearchServerCoreInfo A WITH (NOLOCK)
INNER JOIN APP_ComponentProp B WITH (NOLOCK) on B.id = A.CloudId
WHERE ((A.CoreRoles & 8 = 8) OR (A.CoreRoles & 16 = 16)) AND CloudId NOT IN (SELECT CloudId FROM DM2CloudCoreRole WITH (NOLOCK))
GROUP BY ISNULL(StringVal, '')
INSERT INTO #tempClientList (t_objectName,t_type, t_typename, t_clientId,t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid,t_objectId, t_objectsizeMB)
SELECT distinct EngineName,@ContentIndexedObjectType,@ContentIndexedObject,0,0,NULL,0,@ContentIndexedObjectLicType,0,0,sum(CICount)
From @SearchEngineList
WHERE CICount > 0
Group BY EngineName
DROP TABLE #tblAppGetFastServerList
IF @nApplicationServer > 0 AND @nApplicationServer >= @last_nApplicationServer
BEGIN
	SET @last_nApplicationServer = @nApplicationServer
	INSERT INTO  #updateusage VALUES (@AppServerType)
END
IF @nDOL > 0 AND @nDOL >= @last_nDOL
BEGIN
	SET @last_nDOL = @nDOL
	INSERT INTO  #updateusage VALUES (@LapDesktopType)
END
IF @nFSOnlyServer > 0 AND @nFSOnlyServer >= @last_nFSOnlyServer
BEGIN
	SET @last_nFSOnlyServer = @nFSOnlyServer
	INSERT INTO  #updateusage VALUES (@FsOnlyType)
END
IF @nDedupDataSizeMB > 0 AND @nDedupDataSizeMB >= @last_nDedupDataSizeMB
BEGIN
	SET @last_nDedupDataSizeMB = @nDedupDataSizeMB
	INSERT INTO  #updateusage VALUES (@DedupDataType)
END
IF @nDedupDataOnTapeMB > 0 AND @nDedupDataOnTapeMB >= @last_nDedupDataOnTapeMB
BEGIN
	SET @last_nDedupDataOnTapeMB = @nDedupDataOnTapeMB
	INSERT INTO  #updateusage VALUES (@DedupDataOnTapeType)
END
IF @nAvailDedupSpaceMB > 0 AND @nAvailDedupSpaceMB >= @last_nAvailDedupSpaceMB
BEGIN
	SET @last_nAvailDedupSpaceMB = @nAvailDedupSpaceMB
	INSERT INTO  #updateusage VALUES (@AvailDedupSpaceType)
END
IF @nAppStoreCapacityMB > 0 AND @nAppStoreCapacityMB >= @last_nAppStoreCapacityMB
BEGIN
	SET  @last_nAppStoreCapacityMB = @nAppStoreCapacityMB
	INSERT INTO  #updateusage VALUES (@AppStoreCapacityType)
END
IF @nUsedDiskSpaceMB > 0 AND @nUsedDiskSpaceMB >= @last_nUsedDiskSpaceMB
BEGIN
	SET @last_nUsedDiskSpaceMB = @nUsedDiskSpaceMB
	INSERT INTO  #updateusage VALUES (@UsedDiskSpaceType)
END
IF @nAvailDiskSpaceMB > 0 AND @nAvailDiskSpaceMB >= @last_nAvailDiskSpaceMB
BEGIN
	SET  @last_nAvailDiskSpaceMB = @nAvailDiskSpaceMB
	INSERT INTO  #updateusage VALUES (@AvailDiskSpaceType)
END
IF @nArchivedMailBox > 0 AND @nArchivedMailBox >= @last_nArchivedMailBox
BEGIN
	SET @last_nArchivedMailBox = @nArchivedMailBox
	INSERT INTO  #updateusage VALUES (@ArchivedMailBoxType)
END
IF @nProtectedClient > 0 AND @nProtectedClient >= @last_nProtectedClient
BEGIN
	SET @last_nProtectedClient = @nProtectedClient
	INSERT INTO  #updateusage VALUES (@ProtectedClientType)
END
IF @nArchivedClient > 0 AND @nArchivedClient >= @last_nArchivedClient
BEGIN
	SET @last_nArchivedClient = @nArchivedClient
	INSERT INTO  #updateusage VALUES (@ArchivedClientType)
END
IF @nSRMClient > 0 AND @nSRMClient >= @last_nSRMClient
BEGIN
	SET @last_nSRMClient = @nSRMClient
	INSERT INTO  #updateusage VALUES (@SRMClientType)
END
IF @nCIServer > 0 AND @nCIServer >= @last_nCIServer
BEGIN
	SET @last_nCIServer = @nCIServer
	INSERT INTO  #updateusage VALUES (@CIServerType)
END
IF @nAdvSearchNodes > 0 AND @nAdvSearchNodes >= @last_nAdvSearchNodes
BEGIN
	SET @last_nAdvSearchNodes = @nAdvSearchNodes
	INSERT INTO  #updateusage VALUES (@AdvSearchNodesType)
END
IF @nSearchMailBox  > 0 AND @nSearchMailBox  >= @last_nSearchMailBox
BEGIN
	SET @last_nSearchMailBox  = @nSearchMailBox
	INSERT INTO  #updateusage VALUES (@SearchMailBoxType)
END
IF @nMSimUsers > 0 AND @nMSimUsers >= @last_nMSimUsers
BEGIN
	SET @last_nMSimUsers = @nMSimUsers
	INSERT INTO  #updateusage VALUES (@MSimUserType)
END
IF @nACV > 0 AND @nACV >= @last_nACV
BEGIN
	SET @last_nACV = @nACV
	INSERT INTO  #updateusage VALUES (@ACVType)
END
IF @nVMSocket > 0 AND @nVMSocket >= @last_nVMSocket
BEGIN
	SET @last_nVMSocket = @nVMSocket
	INSERT INTO  #updateusage VALUES (@VMSocketType)
END
IF @nVMOnly > 0 AND @nVMOnly >= @last_nVMOnly
BEGIN
	SET @last_nVMOnly = @nVMOnly
	INSERT INTO  #updateusage VALUES (@VMOnlyType)
END
IF @nVMWithApp > 0 AND @nVMWithApp >= @last_nVMWithApp
BEGIN
	SET @last_nVMWithApp = @nVMWithApp
	INSERT INTO  #updateusage VALUES (@VMWithAppType)
END
IF @nArchivedVM > 0 AND @nArchivedVM >= @last_nArchivedVM
BEGIN
	SET @last_nArchivedVM = @nArchivedVM
	INSERT INTO  #updateusage VALUES (@ArchivedVMType)
END
IF @nEpUsers > 0 AND @nEpUsers >= @last_nEpUsers
BEGIN
	SET @last_nEpUsers = @nEpUsers
	INSERT INTO  #updateusage VALUES (@EpUsersType)
END
IF @nEpSharingUsers > 0 AND @nEpSharingUsers >= @last_nEpSharingUsers
BEGIN
	SET @last_nEpSharingUsers = @nEpSharingUsers
	INSERT INTO  #updateusage VALUES (@EpSharingUsersType)
END
IF @nEpEdiscoveryUsers > 0 AND @nEpEdiscoveryUsers >= @last_nEpEdiscoveryUsers
BEGIN
	SET @last_nEpEdiscoveryUsers = @nEpEdiscoveryUsers
	INSERT INTO  #updateusage VALUES (@EpEdiscoveryUsersType)
END
IF @nContentIndexedObject > 0 AND @nContentIndexedObject >= @last_nContentIndexedObject
BEGIN
	SET @last_nContentIndexedObject = @nContentIndexedObject
	INSERT INTO  #updateusage VALUES (@ContentIndexedObjectType)
END
--2. populate data into LicCCLPeakCALDetails & LicSCLPeakCALDetails
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT TOP 1 1 FROM #updateusage)
BEGIN
	DELETE ccl
	FROM LicCCLPeakCALDetails ccl
    INNER JOIN #updateusage u ON ccl.ObjectType = u.type and ccl.MonthStart = @monthStart
	INSERT INTO LicCCLPeakCALDetails
	SELECT @monthStart,@currentTime,t_type,t_typename,NULL,t_clientId,NULL, t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID,NULL,NULL,NULL
	FROM #tempClientList t
    INNER JOIN #updateusage u ON t.t_type = u.type
END
DROP TABLE #updateusage
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@AppServerType,@LapDesktopType,@FsOnlyType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.clientid = S.t_clientid
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@DedupDataType,@DedupDataOnTapeType,@AvailDedupSpaceType,@AppStoreCapacityType,@UsedDiskSpaceType,@AvailDiskSpaceType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.Objectid = S.t_objectid
WHEN MATCHED AND T.AppSizeMB < S.t_objectsizeMB
	THEN Update
		SET T.AppSizeMB = S.t_objectsizeMB, T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@ArchivedMailBoxType,@SearchMailBoxType,@MSimUserType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.ObjectName = S.t_objectname AND T.ClientId = S.t_ClientId AND T.SubclientId = S.t_subclientid
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@ProtectedClientType,@ArchivedClientType,@SRMClientType,@CIServerType,@AdvSearchNodesType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.ClientId = S.t_ClientId AND T.AppTypeId = S.t_appTypeId
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@ACVType,@VMWithAppType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.Objectid = S.t_objectid AND T.AppTypeId = S.t_appTypeId
WHEN MATCHED
	THEN Update
		SET T.Subclientid = S.t_subclientid,T.ObjectName = S.t_objectName, T.JobId = S.t_jobId, T.AppSizeMB = S.t_objectsizeMB, T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@VMOnlyType,@ArchivedVMType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.Objectid = S.t_objectid
WHEN MATCHED AND S.t_jobId <> T.JobId
	THEN Update
		SET T.Subclientid = S.t_subclientid,T.ClientId = S.t_clientId, T.JobId = S.t_jobId, T.ObjectName = S.t_objectName,T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type in (@EpUsersType,@EpSharingUsersType,@EpEdiscoveryUsersType)) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.Objectid = S.t_objectid AND T.ObjectName = S.t_objectName
WHEN MATCHED
	THEN Update
		SET T.AppTypeName = S.t_appName, T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type = @VMSocketType) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.Objectid = S.t_objectid AND T.ObjectName = S.t_objectName
WHEN MATCHED AND T.AppSizeMB < S.t_objectsizeMB
	THEN Update
		SET T.AppSizeMB = S.t_objectsizeMB, T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
MERGE LicSCLPeakCALDetails AS T
USING (SELECT t_type,t_typename, t_ClientId,t_subclientid,t_appTypeId,t_appName,t_lictype,t_jobid,t_objectsizeMB,t_objectName,t_objectID FROM #tempClientList WHERE t_type = @ContentIndexedObjectType) AS S
ON T.ObjectType = S.t_type and T.MonthStart = @monthStart AND T.ObjectName = S.t_objectName
WHEN MATCHED AND T.AppSizeMB < S.t_objectsizeMB
	THEN Update
		SET T.AppSizeMB = S.t_objectsizeMB, T.PeakDate = @currentTime
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart, PeakDate, ObjectType, TypeName, ClientName, ClientId, SubclientName,SubclientId,AppTypeId,AppTypeName,LicType, JobId,AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName)
		VALUES(@monthStart, @currentTime, S.t_type, S.t_typename, NULL, S.t_ClientId, NULL,S.t_subclientid,S.t_appTypeId,S.t_appName,S.t_lictype,S.t_jobid,S.t_objectsizeMB,S.t_objectName,S.t_objectID,NULL,NULL,NULL)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
GOTO  QS_ERROR
END CATCH
--4. Update ClientName, SubclientName, Organization and OrgGUID
Update T
Set T.ClientName = C.name
From LicSCLPeakCALDetails T
inner join APP_Client C WITH (NOLOCK) on T.clientid = C.id
Where T.clientid > 0 and T.ClientName is null
Update T
Set	T.SubclientName = A.subclientName
From LicSCLPeakCALDetails T
inner join APP_Application A  WITH (NOLOCK) on T.SubclientId = A.id and T.ClientId = A.clientId
Where T.clientid > 0 and T.subclientid > 0 AND T.SubclientName is null
Update T
Set T.ClientName = C.name
From LicCCLPeakCALDetails T
inner join APP_Client C WITH (NOLOCK) on T.clientid = C.id
Where T.clientid > 0 and T.ClientName is null
Update T
Set	T.SubclientName = A.subclientName
From LicCCLPeakCALDetails T
inner join APP_Application A WITH (NOLOCK) on T.SubclientId = A.id and T.ClientId = A.clientId
Where T.clientid > 0 and T.subclientid > 0 AND T.SubclientName is null
IF object_id('tempdb.dbo.#tempAssocIdMap') IS NOT null DROP TABLE #tempAssocIdMap
CREATE TABLE #tempAssocIdMap (t_cid INT, t_appid INT, t_VMClientid INT, t_org NVARCHAR(1024), t_orgGUID uniqueidentifier, t_planid INT)
INSERT INTO #tempAssocIdMap
SELECT DISTINCT t_clientId, t_subclientid, CASE WHEN t_type IN (@VMOnlyType, @ArchivedVMType) THEN t_objectId ELSE 0 END, NULL,NULL,0
FROM #tempClientList
UPDATE Map
SET t_org = domainName, t_orgGUID = D.GUID
FROM #tempAssocIdMap Map JOIN APP_ClientGroupAssoc A WITH(NOLOCK) ON  A.ClientId = CASE t_VMClientid WHEN 0 THEN Map.t_cid ELSE Map.t_VMClientid END
JOIN APP_ClientGroup B WITH(NOLOCK) ON A.clientGroupId = B.id
JOIN App_CompanyProp C WITH(NOLOCK) ON C.attrName = 'Associated Smart Client Group' AND CAST(A.clientGroupId AS nvarchar(MAX)) = C.attrVal AND C.modIFied = 0
JOIN UMDSProviders D WITH(NOLOCK) ON C.componentNameId = D.id
WHERE B.flag&0x1000 > 0
UPDATE Map
SET t_planid = CASE  WHEN AC.status & 4096 = 0 THEN CAST(ISNULL(ASCP.attrVal, 0) AS INT)
                     ELSE CAST(ISNULL(ACP.attrVal, 0) AS INT)
               END
FROM #tempAssocIdMap Map
INNER JOIN APP_Application AAP WITH(NOLOCK) ON Map.t_appid = AAP.id AND Map.t_cid = AAP.clientId
INNER JOIN APP_Client AC WITH(NOLOCK) ON AC.id = AAP.clientId
LEFT JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.modified = 0
LEFT JOIN APP_ClientProp ACP WITH(NOLOCK) ON ACP.componentNameId = AC.id AND ACP.attrName = 'Associated Plan' AND ACP.modified = 0
UPDATE LicCCLPeakCALDetails
SET Organization = t_org, OrgGUID = t_orgGUID, PlanName = P.Name
FROM #tempAssocIdMap
LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
WHERE ClientId = t_cid AND SubclientId = t_appid AND t_VMClientid = CASE WHEN ObjectType IN (@VMOnlyType, @ArchivedVMType) THEN ObjectId ELSE 0 END AND PeakDate = @currentTime
UPDATE LicSCLPeakCALDetails
SET Organization = t_org, OrgGUID = t_orgGUID, PlanName = P.Name
FROM #tempAssocIdMap
LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
WHERE ClientId = t_cid AND SubclientId = t_appid AND t_VMClientid = CASE WHEN ObjectType IN (@VMOnlyType, @ArchivedVMType) THEN ObjectId ELSE 0 END AND PeakDate = @currentTime
IF object_id('tempdb.dbo.#LicCurrentCALDetails') IS NOT NULL
BEGIN
    TRUNCATE TABLE #LicCurrentCALDetails
    INSERT INTO #LicCurrentCALDetails(ObjectType, TypeName, ClientId, AppId, AppTypeName, AppTypeId, LicType, JobId, ObjectName, ObjectId, AppSizeMB, Organization, OrgGUID, PlanName)
	SELECT DISTINCT t_type, t_typename,t_clientId, t_subclientid, t_appName, t_appTypeId, t_lictype, t_jobid, t_objectName,t_objectId,t_objectsizeMB, t_org,t_orgGUID, P.Name
	FROM #tempClientList
	LEFT JOIN #tempAssocIdMap on t_clientId = t_cid AND t_subclientid = t_appid AND t_VMClientid = CASE WHEN t_type IN (@VMOnlyType, @ArchivedVMType) THEN t_objectId ELSE 0 END
	LEFT JOIN App_Plan P WITH(NOLOCK) ON t_planid > 0 AND t_planid = P.id AND P.modified = 0
	ORDER BY t_type
END
ELSE
SELECT @nProtectedClient AS ProtectedClient,@nArchivedClient AS ArchivedClient,@nArchivedVM AS ArchivedVM,@nACV AS ACV,@nVMOnly AS VMOnly,@nVMWithApp AS nVMWithApp,@nVMSocket AS VMSocket,
	@nArchivedMailBox AS ArchivedMailBox,@nMSimUsers AS MSimUsers,@nSearchMailBox AS SearchMailBox,@nSRMClient AS SRMClient,@nCIServer AS CIServer,
	@nContentIndexedObject AS ContentIndexedObject,@nAdvSearchNodes AS AdvSearchNodes,@nEpUsers AS EpUsers,@nEpSharingUsers AS EpSharingUsers,@nEpEdiscoveryUsers AS EpEdiscoveryUsers,
	@nFSOnlyServer AS FSOnlyServer,@nDOL AS DOL,@nApplicationServer AS ApplicationServer,@nAppStoreCapacityMB AS AppStoreCapacityMB,@nUsedDiskSpaceMB AS UsedDiskSpaceMB,@nAvailDiskSpaceMB AS AvailDiskSpaceMB,
	@nDedupDataSizeMB AS DedupDataSizeMB,@nDedupDataOnTapeMB AS DedupDataOnTapeMB,@nAvailDedupSpaceMB AS AvailDedupSpaceMB
SELECT @nProtectedClient = COUNT(DISTINCT ClientId) From LicSCLPeakCALDetails WHERE MonthStart = @monthStart AND ObjectType = @ProtectedClientType
SELECT @nArchivedClient = COUNT(DISTINCT ClientId) From LicSCLPeakCALDetails WHERE MonthStart = @monthStart AND ObjectType = @ArchivedClientType
SELECT @nArchivedVM = COUNT(DISTINCT ObjectName) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @ArchivedVMType
SELECT @nACV = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @ACVType
SELECT @nVMOnly = COUNT(DISTINCT ObjectName) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @VMOnlyType
SELECT @nVMWithApp = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @VMWithAppType
SELECT @nVMSocket = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @VMSocketType
SELECT @nArchivedMailBox = COUNT(DISTINCT ObjectName) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @ArchivedMailBoxType
SELECT @nMSimUsers = COUNT(DISTINCT ObjectName) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @MSimUserType
SELECT @nSearchMailBox = COUNT(DISTINCT ObjectName) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @SearchMailBoxType
SELECT @nSRMClient = COUNT(DISTINCT ClientId) From LicSCLPeakCALDetails WHERE MonthStart = @monthStart AND ObjectType = @SRMClientType
SELECT @nCIServer = COUNT(DISTINCT ClientId) From LicSCLPeakCALDetails WHERE MonthStart = @monthStart AND ObjectType = @CIServerType
SELECT @nContentIndexedObject = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @ContentIndexedObjectType
SELECT @nAdvSearchNodes = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @AdvSearchNodesType
SELECT @nEpUsers = COUNT(DISTINCT ObjectId) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @EpUsersType
SELECT @nEpSharingUsers = COUNT(DISTINCT ObjectId) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @EpSharingUsersType
SELECT @nEpEdiscoveryUsers = COUNT(DISTINCT ObjectId) From LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @EpEdiscoveryUsersType
SELECT @nFSOnlyServer = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @FsOnlyType
SELECT @nDOL = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @LapDesktopType
SELECT @nApplicationServer = COUNT(DISTINCT ClientId) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @AppServerType
SELECT @nAppStoreCapacityMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @AppStoreCapacityType
SELECT @nUsedDiskSpaceMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @UsedDiskSpaceType
SELECT @nAvailDiskSpaceMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @AvailDiskSpaceType
SELECT @nDedupDataSizeMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @DedupDataType
SELECT @nDedupDataOnTapeMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @DedupDataOnTapeType
SELECT @nAvailDedupSpaceMB = ISNULL(SUM(AppSizeMB),0) FROM LicSCLPeakCALDetails where MonthStart = @monthStart AND ObjectType = @AvailDedupSpaceType
IF @lastdate >= @date_start AND @lastdate < @date_END
DELETE FROM LicPeakCALClientCountHistory WHERE date = @lastdate
INSERT INTO LicPeakCALClientCountHistory (date,CCLProtectedClient,CCLArchivedClient,CCLArchivedVM,CCLACV,CCLVMOnly,CCLVMWithApp,CCLVMSocket,CCLArchivedMailBox,CCLMSimUsers,CCLSearchMailBox,CCLSRMClient,CCLCIServer,CCLContentIndexedObject,CCLAdvSearchNodes,CCLEpUsers,CCLEpSharingUsers,CCLEpEdiscoveryUsers,CCLFSOnlyServer,CCLDLO,CCLApplicationServer,CCLAppStoreCapacityMB,CCLUsedDiskSpaceMB,CCLAvailDiskSpaceMB,CCLDedupDataSizeMB,CCLDedupDataOnTapeMB,CCLAvailDedupSpaceMB,SCLProtectedClient,SCLArchivedClient,SCLArchivedVM,SCLACV,SCLVMOnly,SCLVMWithApp,SCLVMSocket,SCLArchivedMailBox,SCLMSimUsers,SCLSearchMailBox,SCLSRMClient,SCLCIServer,SCLContentIndexedObject,SCLAdvSearchNodes,SCLEpUsers,SCLEpSharingUsers,SCLEpEdiscoveryUsers,SCLFSOnlyServer,SCLDLO,SCLApplicationServer,SCLAppStoreCapacityMB,SCLUsedDiskSpaceMB,SCLAvailDiskSpaceMB,SCLDedupDataSizeMB,SCLDedupDataOnTapeMB,SCLAvailDedupSpaceMB)
VALUES(@currentTime_Unix,@last_nProtectedClient,@last_nArchivedClient,@last_nArchivedVM,@last_nACV,@last_nVMOnly,@last_nVMWithApp,@last_nVMSocket,@last_nArchivedMailBox,@last_nMSimUsers,@last_nSearchMailBox,@last_nSRMClient,@last_nCIServer,@last_nContentIndexedObject,@last_nAdvSearchNodes,@last_nEpUsers,@last_nEpSharingUsers,@last_nEpEdiscoveryUsers,@last_nFSOnlyServer,@last_nDOL,@last_nApplicationServer,@last_nAppStoreCapacityMB,@last_nUsedDiskSpaceMB,@last_nAvailDiskSpaceMB,@last_nDedupDataSizeMB,@last_nDedupDataOnTapeMB,@last_nAvailDedupSpaceMB,@nProtectedClient,@nArchivedClient,@nArchivedVM,@nACV,@nVMOnly,@nVMWithApp,@nVMSocket,@nArchivedMailBox,@nMSimUsers,@nSearchMailBox,@nSRMClient,@nCIServer,@nContentIndexedObject,@nAdvSearchNodes,@nEpUsers,@nEpSharingUsers,@nEpEdiscoveryUsers,@nFSOnlyServer,@nDOL,@nApplicationServer,@nAppStoreCapacityMB,@nUsedDiskSpaceMB,@nAvailDiskSpaceMB,@nDedupDataSizeMB,@nDedupDataOnTapeMB,@nAvailDedupSpaceMB)
DROP TABLE #tempAssocIdMap
QS_ERROR:
DROP TABLE #tempClientList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LicGetCALDetailsV2')
	delete from GxQscripts where name = 'LicGetCALDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetCALDetailsV2')
	delete from GXDBVersions where aliasname = 'LicGetCALDetailsV2'
GO

insert into GXDBVersions values(2, 'LicGetCALDetailsV2',  '00010001000400080000', 'LicGetCALDetailsV2', '00010001000400080000')
GO

