

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetAllLicFeatures.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetAllLicFeatures.sp,v $ $Id: LicGetAllLicFeatures.sp,v 1.18.2.6 2019/01/30 19:19:46 miyengar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetAllLicFeatures')
BEGIN
	print '>>> Drop Stored Procedure: LicGetAllLicFeatures <<<'
	drop procedure LicGetAllLicFeatures
END
IF EXISTS (select * from GxQscripts where name='LicGetAllLicFeatures')
	delete from GxQscripts where name = 'LicGetAllLicFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetAllLicFeatures')
	delete from GXDBVersions where aliasname = 'LicGetAllLicFeatures'
GO
print '... Creating Procedure: LicGetAllLicFeatures'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicGetAllLicFeatures
AS
  DECLARE @o_licFlags BIGINT
-- t_checkType: 0 - license consumed; 1 - license available; 2 - license present; 3 - others
DECLARE @commcellId	INT
DECLARE @clientId	INT
DECLARE @licType	INT
DECLARE @licToCheck	TABLE (t_licType INT, t_flagBit BIGINT, t_licName VARCHAR(1024), t_checkType INT, t_bEnabled INT)
SET @commcellId = 2
SET @clientId = 2
INSERT INTO @licToCheck VALUES (85,			0x1,			'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,		0x8,			'', 0, 0)
INSERT INTO @licToCheck VALUES (82,			0x10,			'', 0, 0)
INSERT INTO @licToCheck VALUES (91,			0x40,			'', 0, 0)
INSERT INTO @licToCheck VALUES (90,			0x80,			'', 0, 0)
INSERT INTO @licToCheck VALUES (105,				0x00100,				'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,				0x00200,				'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,				0x00400,				'', 0, 0)
INSERT INTO @licToCheck VALUES (110,	0x02000,	'', 0, 0)
INSERT INTO @licToCheck VALUES (111,		0x04000,		'', 0, 0)
INSERT INTO @licToCheck VALUES (102,	0x20000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,		0x200000,		'', 0, 0)
INSERT INTO @licToCheck VALUES (25,				0x800000,				'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,		0x1000000,		'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,			0x2000000,		'', 3, 0)
INSERT INTO @licToCheck VALUES (141,		0x8000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,			0x20000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (142,			0x40000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,			0x400000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (132,				0x800000000,				'', 0, 0)
INSERT INTO @licToCheck VALUES (171,			0x2000000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (110,	0x10000000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (102,	0x20000000000,			'', 0, 0)
INSERT INTO @licToCheck VALUES (-1,			0x10000,			'', 1, 0)
INSERT INTO @licToCheck VALUES (190,			0x40000000000,			'', 2, 0)
INSERT INTO @licToCheck VALUES (196,		0x100000000000,		'', 2, 0)
INSERT INTO @licToCheck VALUES (200,		0x1000000000000,		'', 2, 0)
INSERT INTO @licToCheck VALUES (163,			0x200000000000,			'', 2, 0)
INSERT INTO @licToCheck VALUES (168,	0x400000000000,		'', 2, 0)
INSERT INTO @licToCheck VALUES (100002,			0x2000000000000,				'', 1, 0)
UPDATE @licToCheck
SET t_licName = dbo.GetLicensePropName(appTypeId)
FROM	simAppTypeLicTypeMap
WHERE	t_licType = simLicAppType
UPDATE @licToCheck
SET t_bEnabled = 1
WHERE	EXISTS (select * from LicUsage WITH (NOLOCK) where cid = @clientId and lictype = t_licType and opType = 'Install' and (Eval = 0 or ExpiryDateUTC > getUTCDate ())) AND
	EXISTS (select * from App_Clientprop WITH (NOLOCK) where componentNameId = @clientId and AttrName = t_licName and attrVal = '1' and modified = 0)
UPDATE @licToCheck
SET	t_bEnabled = 1
WHERE	t_checkType = 2 AND EXISTS (select * from LicAAL WITH (NOLOCK) where simLicAppTypeId = t_licType AND commcellId = @commcellId)
UPDATE @licToCheck
SET t_bEnabled = 1
WHERE	t_licType = -1 AND t_bEnabled = 0 AND EXISTS ( SELECT * FROM simInstalledPackages WITH (NOLOCK) where simPackageID IN ( 251, 257, 260) )
DECLARE @bIsBackupLicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsBackupLicValid = @licAppliedStatus&0x100
END
--t_checkType = 1: isFeatureLicensed --SET @licType = SIM_CSL_AT_V2_SNMP_ENABLER
DECLARE CheckAALSP CURSOR STATIC FOR SELECT t_licType FROM @licToCheck WHERE t_checkType = 1 AND t_bEnabled = 0
OPEN CheckAALSP FETCH NEXT FROM CheckAALSP INTO @licType
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @evalFld	varchar(1024) = ''
	DECLARE @permFld	varchar(1024) = ''
	DECLARE @licTotal	integer = 0
	DECLARE @licUsed	integer = 0
	DECLARE @bEnabled	INT = 0
IF (@licType = 100002 AND @bIsBackupLicValid > 0)
		SET @bEnabled = 1
	ELSE
	BEGIN
		SELECT @evalFld = RTRIM(eval_fld1), @permFld = RTRIM(perm_fld1) FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = @licType AND commcellId = @commcellId
		IF len(@permFld) > 0
			EXEC dbo.xp_getAALInfo @permFld, @licTotal OUTPUT, @licUsed OUTPUT
IF (@licType = 100002 AND @licTotal > 0 OR @bIsBackupLicValid > 0) OR @licType = -1 AND @licTotal > @licUsed
			SET @bEnabled = 1
		IF @bEnabled = 0 AND len(@evalFld) > 0
		BEGIN
			EXEC dbo.xp_getAALInfo @evalFld, @licTotal OUTPUT, @licUsed OUTPUT
IF (@licType = 100002 AND @licTotal > 0 OR @bIsBackupLicValid > 0) OR @licType = -1 AND @licTotal > @licUsed
				SET @bEnabled = 1
		END
	END
	IF @bEnabled = 1
		UPDATE @licToCheck
		SET t_bEnabled = 1
		WHERE t_licType = @licType
	FETCH NEXT FROM CheckAALSP INTO @licType
END
CLOSE CheckAALSP
DEALLOCATE CheckAALSP
SELECT SUM(t_flagBit) FROM @licToCheck WHERE t_bEnabled > 0
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetAllLicFeatures')
	delete from GxQscripts where name = 'LicGetAllLicFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetAllLicFeatures')
	delete from GXDBVersions where aliasname = 'LicGetAllLicFeatures'
GO

insert into GXDBVersions values(2, 'LicGetAllLicFeatures',  '00010018000200060000', 'LicGetAllLicFeatures', '00010018000200060000')
GO

