

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetActivates.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetActivates.sp,v $ $Id: LicGetActivates.sp,v 1.1.2.5 2020/10/13 16:38:12 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetActivates')
BEGIN
	print '>>> Drop Stored Procedure: LicGetActivates <<<'
	drop procedure LicGetActivates
END
IF EXISTS (select * from GxQscripts where name='LicGetActivates')
	delete from GxQscripts where name = 'LicGetActivates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetActivates')
	delete from GXDBVersions where aliasname = 'LicGetActivates'
GO
print '... Creating Procedure: LicGetActivates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetActivates
AS
--Calculate Activate licenses
/*
-- fso backed up data
1. individual core
2. multinode where each datasource pointing to single client
3. multinode where datasourceId pointing to client group.
How to retrieve in license?
    -        once we find list of dsIds, then split backedup datasourceId belong to client group (possible to find clientgroup mapping)
    -        then join with SEIndexServerNodeStatsProp for those datasourceId and clientId
    -        merge the results for FSO.
*/
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @CS_SPVERSION  INT = 0
SELECT Top 1 @CS_SPVERSION = ISNULL(SIM.HighestSP,0)
FROM simInstalledPackages SIM WITH (NOLOCK)
WHERE sim.ClientId = 2 AND Sim.simPackageID = 20 /*commserve package*/
IF(@CS_SPVERSION < 11) RETURN -- This report is for V11 SP11 and above
DECLARE @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_FILES				 INT =100034        -- Compliance search/Ediscovery Files (old and new CI for fs)
DECLARE @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_EMAIL_CLOUD_APPS      INT =100035			-- Compliance search/Ediscovery Users
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_FILES             INT =100036			-- SDG Files
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS  INT =100037			-- SDG Emails
DECLARE @SIM_CSL_AT_V2_FILE_STORAGE_OPTIMIZATION                     INT =100038			 -- FSO Files
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SUITE                                INT =100039
DECLARE @CLIENT_PROPERTY_ID INT = (SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyGuid = '9D174CA5-95AB-4EF6-A15B-5E190F87317F')
IF OBJECT_ID('tempdb.dbo.#tempgGlobalDSInfos') IS NOT NULL
	DROP TABLE #tempgGlobalDSInfos
CREATE TABLE #tempgGlobalDSInfos
	(	DatasourceId int,
		DatasourceName NVARCHAR(1024),
		TotalCount BIGINT,
		FSSizeAnalyzed BIGINT,
		DataSourceType VARCHAR(100),
		EmailMailboxCount INT,
		AppName VARCHAR(20),
		ClientId INT,
		IgnoreDSStatus INT DEFAULT 0
	);
--retrieve all datasources
INSERT INTO #tempgGlobalDSInfos(DatasourceId, DatasourceName, DataSourceType, AppName, ClientId)
SELECT SE.DataSourceId, SE.DataSourceName, UPPER(DST.TypeDisplayName), 'DataCube', DSP.PropertyValue
FROM SEDataSource SE (NOLOCK)
JOIN SECollectionInfo CI (NOLOCK) ON SE.CoreId = CI.CoreId
JOIN DM2Cloud DC (NOLOCK) ON CI.CloudID = DC.cloudId AND DC.CloudType IN (1, 5)
JOIN SEDataSourceType DST WITH (NOLOCK) ON SE.DataSourceType = DST.TypeId AND SE.Attribute & 4 != 4
			AND DST.TypeGUID IN ('A32C5C37-FEDE-4849-BF3E-6FCEFD46D769','0BC3CD9F-5B02-4A47-97FE-125A83BA13FC')
LEFT JOIN SEDataSourceProperty DSP WITH(NOLOCK) ON DSP.PropertyId = @CLIENT_PROPERTY_ID AND DSP.DataSourceId = SE.DataSourceId
--delete all the route table shards
DELETE T
FROM #tempgGlobalDSInfos T JOIN SEDataSourceRoute DSR
ON T.DatasourceId = DSR.DataSourceId
--use datasource size from stats table, if exists
IF OBJECT_ID('tempdb.dbo.#tDSFromStats') IS NOT NULL 	DROP TABLE #tDSFromStats
CREATE TABLE #tDSFromStats
(
	t_dsId int,
	t_dsSize BIGINT,
	t_clientId INT,
	t_datasourceType VARCHAR(100)
);
INSERT INTO #tDSFromStats
SELECT P.DataSourceId, P.PropertyLongValue, P.EntityId, T.DataSourceType
FROM SEIndexServerNodeStatsProp P
JOIN #tempgGlobalDSInfos T ON T.DatasourceId = P.DataSourceId
WHERE P.PropertyName = 'Total File Size'
DELETE T
FROM #tempgGlobalDSInfos T
JOIN #tDSFromStats D ON T.DatasourceId = D.t_dsId
INSERT INTO #tempgGlobalDSInfos(DatasourceId,  AppName, FSSizeAnalyzed, ClientId, IgnoreDSStatus, DataSourceType)
SELECT D.t_dsId, 'DataCube', D.t_dsSize, D.t_clientId, 1, D.t_datasourceType
FROM #tDSFromStats D
DROP TABLE #tDSFromStats
---
--fetch the total docs, index directory size,
IF OBJECT_ID('tempdb.dbo.#tempDSStatus') IS NOT NULL
	DROP TABLE #tempDSStatus
CREATE TABLE #tempDSStatus (
    DataSourceId INT,
	statusInfo	XML
)
INSERT INTO #tempDSStatus
SELECT T.datasourceId, CONVERT(XML,T.PropertyValue)
FROM SEDataSourceProperty T WITH (NOLOCK)
INNER JOIN SEProperty P WITH (NOLOCK) ON T.PropertyId = P.PropertyId AND P.PropertyName = 'statusinfo'
WHERE T.PropertyValue is not null AND T.PropertyValue != ''
UPDATE tGDS
SET	TotalCount = ISNULL(m.c.value('@TotalDocs','BIGINT'),0),
FSSizeAnalyzed = ISNULL(m.c.value('(TypeStatusInfo/FileInfo/@SizeAnalyzed)[1]','BIGINT'),0)
FROM #tempgGlobalDSInfos tGDS
INNER JOIN #tempDSStatus cte ON CTE.datasourceId = tGDS.DatasourceId
OUTER APPLY CTE.statusInfo.nodes('/StatusInfo') as m(c)
WHERE tGDS.IgnoreDSStatus = 0
DROP TABLE #tempDSStatus
 ---
/*
SET GDPR flag that are part of project
*/
IF OBJECT_ID('tempdb.dbo.#tempGDPRDSId') IS NOT NULL
	DROP TABLE #tempGDPRDSId
CREATE TABLE #tempGDPRDSId (
    DataSourceId INT
)
;with CTEGPRoj(id) AS
(
	SELECT c.id
	FROM APP_Client c WITH (NOLOCK)
	INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON cp.componentNameId = c.id
					AND (c.status & 0x10000000 ) <> 0
					AND cp.attrName = N'System Drive Type'
					AND cp.attrVal = N'6'	--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
)
INSERT INTO #tempGDPRDSId
SELECT CONVERT(INT, attrVal)
FROM APP_ClientProp cp WITH (NOLOCK)
JOIN CTEGPRoj TP ON TP.id = cp.componentNameId
WHERE cp.attrName = 'Datasource Id'
UPDATE tGDS
SET	AppName = 'GDPR'
FROM #tempgGlobalDSInfos tGDS
INNER JOIN #tempGDPRDSId ds ON tGDS.DatasourceId = ds.DataSourceId
--delete clients with FSO backup data. its needs to be handle seperately
DELETE #tempgGlobalDSInfos WHERE ClientId is null
/*---------------Temp table holding UserMailbox for Email Activate/SDG license type-------------------*/
IF OBJECT_ID('tempdb.dbo.#tempTenantUsers') IS NOT NULL
	DROP TABLE #tempTenantUsers
CREATE TABLE #tempTenantUsers (LicenseType INT, clientId INT, smtp NVARCHAR(512))
/**-------------------------------------------------------------SDG EMAIL License-------------------------------------------------------------**/
-- filter to get only email datasoures
DELETE T
FROM #tempGDPRDSId T
JOIN SEDataSource S WITH (NOLOCK) ON S.DataSourceId = T.DataSourceId
JOIN SEDataSourceType ST WITH (NOLOCK) ON S.DataSourceType = ST.TypeId
WHERE ST.TypeName <> 'email' AND ST.TypeName <> 'exchange'
-- get property info: backed up subclient, crawl type, additional info
IF OBJECT_ID('tempdb.dbo.#tempEDatasourceCrawlDetail') IS NOT NULL
	DROP TABLE #tempEDatasourceCrawlDetail
CREATE TABLE #tempEDatasourceCrawlDetail (DatasourceId INT, CrawlType INT, SubClientId INT, MailBoxLst NVARCHAR(MAX), ClientId INT)
-- fill data from property - crawl type
INSERT INTO #tempEDatasourceCrawlDetail
SELECT T.DatasourceId, CAST(ISNULL(DSP.PropertyValue, '1') AS INT), 0, '', 0
FROM #tempGDPRDSId T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'crawltype')
DELETE FROM #tempEDatasourceCrawlDetail
WHERE CrawlType <> 2 AND CrawlType <> 3
-- update subclient id from property
UPDATE T
SET SubClientId = CAST(ISNULL(DSP.PropertyValue, '0') AS INT)
FROM #tempEDatasourceCrawlDetail T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'backedupsubclientids')
-- update mailbox list from property
UPDATE T
SET MailBoxLst = ISNULL(DSP.PropertyValue, '')
FROM #tempEDatasourceCrawlDetail T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'additionalinfo')
UPDATE T
SET ClientID = App.clientId
FROM #tempEDatasourceCrawlDetail T
INNER JOIN APP_Application APP WITH (NOLOCK) ON App.id = T.SubClientId
INSERT INTO #tempTenantUsers  (LicenseType, clientId, smtp)
SELECT DISTINCT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS, T.ClientId, smtpAdrress
FROM #tempEDatasourceCrawlDetail T
JOIN APP_EmailConfigPolicyAssoc E WITH (NOLOCK) ON T.SubClientId = E.subClientId AND T.CrawlType = 3
JOIN APP_EmailConfigPolicies EP WITH (NOLOCK) ON Ep.componentNameId = E.assocId
JOIN APP_ConfigurationPolicyDetails CD WITH (NOLOCK) on CD.componentNameId = EP.policyId
WHERE E.mailBoxType = 1 AND E.modified = 0 AND EP.policyType = 1 /* Ida::EmailPolicyType_ARCHIVE=1 */ AND EP.modified = 0
		AND CD.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
		AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0
UNION
SELECT DISTINCT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS, T.ClientId, smtpAdrress
FROM #tempEDatasourceCrawlDetail T
JOIN APP_EmailConfigPolicyAssoc E (nolock) ON E.subClientId = T.SubClientId AND T.CrawlType = 2 AND T.MailBoxLst = ''
WHERE E.mailBoxType = 1 AND E.modified = 0 AND E.status = 0 AND E.deleted = 0 AND E.modified = 0
UNION	--Parse MailBoxLst json
SELECT DISTINCT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS, T.ClientId, REPLACE(Data, 'smtpAdrress":"','')
FROM #tempEDatasourceCrawlDetail T
CROSS APPLY dbo.split(REPLACE(MailBoxLst,'","',';'),';')
WHERE Data like 'smtpAdrress":"%'
DROP TABLE #tempGDPRDSId
/**-------------------------------------------------------------End SDG EMAIL License-------------------------------------------------------------**/
/**-------------------------------------------------------------Activate EMAIL License-------------------------------------------------------------**/
INSERT INTO #tempTenantUsers  (LicenseType, clientId, smtp)
SELECT DISTINCT @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_EMAIL_CLOUD_APPS, client, smtp
FROM
(
       --Total v2 CI mailboxes (content indexing enabled in archive policy)
       SELECT DISTINCT clientId as client, smtpAdrress as smtp
	   FROM APP_EmailConfigPolicyAssoc E WITH (NOLOCK)
       JOIN APP_EmailConfigPolicies EP WITH (NOLOCK) ON Ep.componentNameId = E.assocId
       JOIN APP_ConfigurationPolicyDetails CD WITH (NOLOCK) on CD.componentNameId = EP.policyId
       WHERE E.mailBoxType = 1 AND E.modified = 0 AND EP.policyType = 1 /* Ida::EmailPolicyType_ARCHIVE=1 */ AND EP.modified = 0
       AND CD.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
       AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0
       AND E.subClientId IN (SELECT id FROM APP_Application WITH (NOLOCK) WHERE appTypeId = 137 AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/)
	   UNION
       --- Total v2 Users that are being journaled to JRN MB's where CI is enabled
       SELECT DISTINCT clientId as client, smtpAdrress as smtp
       FROM App_EmailConfigPolicyAssoc WITH (NOLOCK) WHERE modified = 0  and discoverByType = 13
       AND subClientId IN (SELECT id FROM APP_Application WITH (NOLOCK) WHERE appTypeId = 137  AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/)
       AND subclientId IN (SELECT DISTINCT subclientId FROM APP_EmailConfigPolicyAssoc E WITH (NOLOCK)
       JOIN APP_EmailConfigPolicies EP WITH (NOLOCK) ON Ep.componentNameId = E.assocId
       JOIN APP_ConfigurationPolicyDetails CD WITH (NOLOCK) on CD.componentNameId = EP.policyId
       WHERE E.mailBoxType IN (2,3) AND E.modified = 0 AND EP.policyType = 4 /* Ida::EmailPolicyType_JOURNAL=4 */ AND EP.modified = 0
             AND CD.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
             AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0)
) Exch
/**-------------------------------------------------------------End Activate EMAIL License-------------------------------------------------------------**/
DELETE #tempTenantUsers WHERE ISNULL(smtp,'') = ''
DECLARE @isMSP int = 0
SELECT TOP 1 @isMSP = CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'IsMSPCommcell' AND modified = 0
IF object_id('tempdb.dbo.#tempAssocIdMap') IS NOT null DROP TABLE #tempAssocIdMap
CREATE TABLE #tempAssocIdMap (t_cid INT, t_org NVARCHAR(1024), t_orgGUID uniqueidentifier)
INSERT INTO #tempAssocIdMap
SELECT DISTINCT clientId, NULL, NULL
FROM #tempTenantUsers
IF object_id('tempdb.dbo.#tempCompanyMap') IS NOT null DROP TABLE #tempCompanyMap
CREATE TABLE #tempCompanyMap (t_did INT, t_cid INT)
IF @isMSP = 1
BEGIN
	INSERT INTO #tempCompanyMap
	SELECT DISTINCT id,id FROM UMDSProviders WITH (NOLOCK) WHERE serviceType = 5
	UNION
	SELECT DISTINCT id,ownerCompany FROM UMDSProviders WITH (NOLOCK) WHERE serviceType <> 5
	DELETE T
	FROM #tempCompanyMap T
	INNER JOIN UMDSProviders D WITH (NOLOCK) ON T.t_cid = D.id
	WHERE D.serviceType <> 5
	UPDATE Map
	SET t_org = domainName, t_orgGUID = D.GUID
	FROM #tempAssocIdMap Map
	JOIN APP_ClientGroupAssoc A WITH(NOLOCK) ON A.ClientId = Map.t_cid
	JOIN APP_ClientGroup B WITH (NOLOCK) ON A.clientGroupId = B.id
JOIN App_CompanyProp C WITH (NOLOCK) ON C.attrName = 'Associated Smart Client Group' AND A.clientGroupId=C.attrValInt AND C.modIFied = 0 AND C.cs_attrName = checksum('Associated Smart Client Group')
	JOIN #tempCompanyMap M ON C.componentNameId = M.t_did
	JOIN UMDSProviders D WITH (NOLOCK) ON M.t_cid = D.id
WHERE B.flag&0x1000 > 0
END
ELSE
BEGIN
	UPDATE Map
	SET t_org = B.name, t_orgGUID = B.GUID
	FROM #tempAssocIdMap Map
	INNER JOIN APP_ClientGroupAssoc A WITH(NOLOCK) ON  A.ClientId = Map.t_cid
	INNER JOIN APP_ClientGroup B WITH (NOLOCK) ON A.clientGroupId = B.id
WHERE B.flag&1073741824 > 0
END
--OUTPUT
IF object_id('tempdb.dbo.#tmpActivateUsage') IS NOT NULL
BEGIN
	INSERT INTO #tmpActivateUsage (Lictype,ClientId,TotalCounts)
	SELECT @SIM_CSL_AT_V2_FILE_STORAGE_OPTIMIZATION  'LicenseType', ClientId, 1.0*ISNULL(SUM(FSSizeAnalyzed),0)/1024/1024 'TotalCounts'
	FROM #tempgGlobalDSInfos
	WHERE AppName ='DataCube' AND DataSourceType = 'FILE' AND FSSizeAnalyzed >0
	GROUP BY ClientId
	UNION
	SELECT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_FILES, ClientId, 1.0*ISNULL(SUM(FSSizeAnalyzed),0)/1024/1024
	FROM #tempgGlobalDSInfos
	WHERE AppName ='GDPR' AND DataSourceType = 'FILE' AND FSSizeAnalyzed >0
	GROUP BY ClientId
	/*
		--for activate File CI :
		1. Search engine (join with dm2searchservercoreindo of SearchEngine type) and fetch the shardid
		2. Find indexserver configured to File system CI,
			Fetch the multinodedsId, fsindex
	*/
	;WITH CTE AS(
			SELECT DISTINCT ShardPropId FROM SEIndexServerNodeStatsProp NSPROP WITH (NOLOCK)
			JOIN SEIndexServerNodeStats NS (NOLOCK) ON NSPROP.ShardId = NS.ShardId
			JOIN DM2SearchServerCoreInfo S (NOLOCK) ON NS.SearchServerCoreId = S.CoreId AND S.CloudType = 3
			WHERE NSPROP.Attribute & 4 = 0
			UNION
			SELECT DISTINCT ShardPropId
			FROM SEIndexServerNodeStatsProp P (NOLOCK)
			JOIN SEDataSource SED (NOLOCK) ON P.DataSourceId = SED.DataSourceId
			JOIN SEDataSourceType SEDT (NOLOCK) ON SED.DataSourceType = SEDT.TypeId
			JOIN SEDataSourceProperty SEDP (NOLOCK) ON SED.DataSourceId = SEDP.DataSourceId
			JOIN SEProperty SEP (NOLOCK) ON SEP.PropertyId  = SEDP.PropertyId
			WHERE SEP.PropertyGuid = '617BB3EF-65A9-49C1-BC60-8F3820149236'
				  AND SEDT.TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6'
				  AND SEDP.PropertyValue = 'fsindex'
				AND P.Attribute & 4 = 0
		)
	    INSERT INTO #tmpActivateUsage (Lictype,ClientId,TotalCounts)
		SELECT DISTINCT @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_FILES, NSPROP.EntityId, SUM(1.0*CONVERT(BIGINT,ISNULL(NSPROP.PropertyLongValue,0))/1024/1024)
		FROM SEIndexServerNodeStatsProp NSPROP WITH (NOLOCK)
		INNER JOIN CTE ON CTE.ShardPropId = NSPROP.ShardPropId
		WHERE NSPROP.PropertyName= 'Total File Size'
		GROUP BY NSPROP.EntityId
END
IF object_id('tempdb.dbo.#tmpActivateEmailUsage') IS NOT NULL
BEGIN
	INSERT INTO #tmpActivateEmailUsage (lictype,ClientId,SMTP,Org,OrgGUID)
	SELECT DISTINCT T.LicenseType, T.ClientId, T.smtp, Map.t_org, Map.t_orgGUID
	FROM #tempTenantUsers T
	INNER JOIN #tempAssocIdMap Map ON Map.t_cid = T.ClientId
END
DROP TABLE #tempgGlobalDSInfos
DROP TABLE #tempTenantUsers
DROP TABLE #tempEDatasourceCrawlDetail
DROP TABLE #tempAssocIdMap
DROP TABLE #tempCompanyMap
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetActivates')
	delete from GxQscripts where name = 'LicGetActivates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetActivates')
	delete from GXDBVersions where aliasname = 'LicGetActivates'
GO

insert into GXDBVersions values(2, 'LicGetActivates',  '00010001000200050000', 'LicGetActivates', '00010001000200050000')
GO

