

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetActivateDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetActivateDetailsV3.sp,v $ $Id: LicGetActivateDetailsV3.sp,v 1.1.2.3 2020/10/13 16:51:39 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicGetActivateDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetActivateDetailsV3 <<<'
	drop procedure LicGetActivateDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetActivateDetailsV3')
	delete from GxQscripts where name = 'LicGetActivateDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetActivateDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetActivateDetailsV3'
GO
print '... Creating Procedure: LicGetActivateDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicGetActivateDetailsV3
AS
--Calculate Content Indexed Object license
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetActivateDetailsV3'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0' --0 successful  --1 failed
DECLARE @ActEDisFilesType int = 34
DECLARE @ActEDisECAppsType int = 35
DECLARE @ActSensDataFilesType int = 36
DECLARE @ActSensDataECAppsType int = 37
DECLARE @FileStoreOptType int = 38
DECLARE @ActEDisFilesLicType  int = 100034
DECLARE @ActEDisECAppsLicType  int = 100035
DECLARE @ActSensDataFilesLicType  int = 100036
DECLARE @ActSensDataECAppsLicType  int = 100037
DECLARE @FileStoreOptLicType  int = 100038
DECLARE @current_ActEDisFiles  bigint = 0
DECLARE @current_ActEDisECApps  int = 0
DECLARE @current_ActSensDataFiles  bigint = 0
DECLARE @current_ActSensDataECApps  int = 0
DECLARE @current_FileStoreOpt  bigint = 0
DECLARE @last_ActEDisFiles bigint = 0
DECLARE @last_ActEDisECApps int = 0
DECLARE @last_ActSensDataFiles bigint = 0
DECLARE @last_ActSensDataECApps int = 0
DECLARE @last_FileStoreOpt bigint = 0
IF object_id('tempdb.dbo.#tmpActivateUsage') IS NOT NULL
	DROP TABLE #tmpActivateUsage
IF object_id('tempdb.dbo.#tmpActivateEmailUsage') IS NOT NULL
	DROP TABLE #tmpActivateEmailUsage
CREATE TABLE #tmpActivateUsage (LicType INT, ClientId INT, TotalCounts BIGINT, UsageType INT)
CREATE TABLE #tmpActivateEmailUsage (LicType INT, ClientId INT, SMTP NVARCHAR(512), Org NVARCHAR(1024), OrgGUID uniqueidentifier, UsageType INT)
EXEC LicGetActivates
UPDATE #tmpActivateUsage
SET UsageType = CASE LicType WHEN @ActEDisFilesLicType THEN @ActEDisFilesType
							 WHEN @ActSensDataFilesLicType THEN @ActSensDataFilesType
							 WHEN @FileStoreOptLicType THEN @FileStoreOptType
				END
UPDATE #tmpActivateEmailUsage
SET UsageType = CASE LicType WHEN @ActEDisECAppsLicType  THEN @ActEDisECAppsType
							 WHEN @ActSensDataECAppsLicType THEN @ActSensDataECAppsType
				END
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_usageType INT,t_currentUsage BIGINT, t_lastUsage BIGINT, t_updateStatus INT DEFAULT 0)
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType >= @ActEDisFilesType AND UsageType <= @FileStoreOptType)
DELETE FROM Lic_CurrentUsage WHERE UsageType >= @ActEDisFilesType AND UsageType <= @FileStoreOptType
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,LicType,AppSizeMB,CapacityFlag,VMFlag)
SELECT DISTINCT UsageType,ClientId,LicType,TotalCounts,-1,0
From #tmpActivateUsage
INSERT INTO Lic_CurrentUsage (UsageType,LicType,AppSizeMB,CapacityFlag,VMFlag,Organization,OrgGUID)
SELECT DISTINCT UsageType,LicType, COUNT(DISTINCT SMTP),-1,0,Org,OrgGUID
FROM #tmpActivateEmailUsage
GROUP BY UsageType,LicType,OrgGUID,Org
SELECT @current_ActEDisFiles = ISNULL([34],0),@current_ActEDisECApps = ISNULL([35],0),@current_ActSensDataFiles = ISNULL([36],0), @current_ActSensDataECApps = ISNULL([37],0), @current_FileStoreOpt = ISNULL([38],0)
FROM (SELECT AppSizeMB, UsageType FROM Lic_CurrentUsage WITH (NOLOCK) ) AS S
PIVOT
(SUM(AppSizeMB) FOR UsageType in ([34],[35],[36],[37],[38])) AS P
SELECT @last_ActEDisFiles = ISNULL([34],0),@last_ActEDisECApps = ISNULL([35],0),@last_ActSensDataFiles = ISNULL([36],0), @last_ActSensDataECApps = ISNULL([37],0), @last_FileStoreOpt = ISNULL([38],0)
FROM (SELECT AppSizeMB, UsageType FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType) AS S
PIVOT
(SUM(AppSizeMB) FOR UsageType in ([34],[35],[36],[37],[38])) AS P
INSERT INTO #tempUsage (t_usageType,t_currentUsage,t_lastUsage)
VALUES (@ActEDisFilesType,@current_ActEDisFiles,@last_ActEDisFiles),
(@ActEDisECAppsType,@current_ActEDisECApps,@last_ActEDisECApps),
(@ActSensDataFilesType,@current_ActSensDataFiles,@last_ActSensDataFiles),
(@ActSensDataECAppsType,@current_ActSensDataECApps,@last_ActSensDataECApps),
(@FileStoreOptType,@current_FileStoreOpt,@last_FileStoreOpt)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.UsageType = t_usageType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,LicType,AppSizeMB,CapacityFlag,VMFlag,Organization,OrgGUID)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,LicType,AppSizeMB,CapacityFlag,VMFlag,Organization,OrgGUID
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON UsageType = t_usageType AND t_updateStatus = 1
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,ClientId,LicType,AppSizeMB,CapacityFlag,VMFlag FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ActEDisFilesType OR UsageType = @ActSensDataFilesType OR UsageType = @FileStoreOptType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND T.ClientId = S.ClientId
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN UPDATE SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart,CreationDate,UsageType,PeakType,ClientId,LicType,AppSizeMB,CapacityFlag,VMFlag)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.ClientId,S.LicType,S.AppSizeMB,S.CapacityFlag,S.VMFlag)
;
MERGE Lic_PeakUsage AS T
USING  (SELECT UsageType,LicType,AppSizeMB,CapacityFlag,VMFlag,Organization,OrgGUID FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ActEDisECAppsType OR UsageType = @ActSensDataECAppsType) AS S
ON  T.MonthStart = @monthStart AND T.UsageType = S.UsageType AND T.PeakType = @SCLPeakType AND (T.OrgGUID = S.OrgGUID OR S.OrgGUID IS NULL AND T.OrgGUID IS NULL)
WHEN MATCHED AND T.AppSizeMB <= S.AppSizeMB
	THEN UPDATE SET T.CreationDate = @currentTime, T.AppSizeMB = S.AppSizeMB, T.Organization = S.Organization
WHEN NOT MATCHED BY TARGET
	THEN INSERT (MonthStart,CreationDate,UsageType,PeakType,LicType,AppSizeMB,CapacityFlag,VMFlag,Organization,OrgGUID)
	VALUES(@monthStart,@currentTime,S.UsageType,@SCLPeakType,S.LicType,S.AppSizeMB,S.CapacityFlag,S.VMFlag,S.Organization,S.OrgGUID)
;
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #tmpActivateUsage
DROP TABLE #tmpActivateEmailUsage
DROP TABLE #tempUsage
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetActivateDetailsV3')
	delete from GxQscripts where name = 'LicGetActivateDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetActivateDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetActivateDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetActivateDetailsV3',  '00010001000200030000', 'LicGetActivateDetailsV3', '00010001000200030000')
GO

