

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicGetADFDetailsV3.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicGetADFDetailsV3.sp,v $ $Id: LicGetADFDetailsV3.sp,v 1.1.2.13.8.1 2021/02/19 22:11:11 leiwang Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicGetADFDetailsV3')
BEGIN
	print '>>> Drop Stored Procedure: LicGetADFDetailsV3 <<<'
	drop procedure LicGetADFDetailsV3
END
IF EXISTS (select * from GxQscripts where name='LicGetADFDetailsV3')
	delete from GxQscripts where name = 'LicGetADFDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetADFDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetADFDetailsV3'
GO
print '... Creating Procedure: LicGetADFDetailsV3'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicGetADFDetailsV3
AS
--Calculate 5 licenses, including App Server, DLO, FS Only, OI AND VOI
SET ANSI_PADDING ON
SET NOCOUNT ON
DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @currentTime DATETIME = dbo.getdatetime(@currentTime_Unix)
DECLARE @monthStart DATETIME = DATEADD(MM, DATEDIFF(MM, 0, GETUTCDATE()), 0)
DECLARE @monthStart_Uix int  = dbo.GetUnixTime(@monthStart)
DECLARE @CCLPeakType INT = 0
DECLARE @SCLPeakType INT = 1
DECLARE @attrName varchar (256) ='LicGetADFDetailsV3Status'
DECLARE @attrType int = 1
DECLARE @attrVal varchar(1) = '0'    --0 successful  --1 failed
DECLARE @AppServerType INT = 27
DECLARE @DLOType INT = 28
DECLARE @FSOnlyType INT = 29
DECLARE @ArchivedVMType INT = 21
DECLARE @AdvancedVMType INT = 19
DECLARE @OIType INT = 30
DECLARE @VOIType INT = 31
DECLARE @FSOnlyLicType INT = 100029
DECLARE @AppServerLicType INT = 100030
DECLARE @DLOLicType INT = 200002
DECLARE @FSOnlyVMLicType INT = 200017
DECLARE @OILicType INT = 100032
DECLARE @VOILicType INT = 100033
DECLARE @ArchivedVMLicType  int = 100021
DECLARE @VMOnlyLicType  int = 200001
DECLARE @VMWithAppLicType  int = 200003
DECLARE @ACVLicType  int = 100027
DECLARE @EPLicType  int = 200020
DECLARE @OPENSTACKLicType  int = 200022
DECLARE	@MsimLicType int = 100028
DECLARE @current_ApplicationServer     int = 0
DECLARE @current_DLO					int = 0
DECLARE @current_FSOnlyServer          int = 0
DECLARE @current_FSOnlyVM		    int = 0
DECLARE @current_OI				    int = 0
DECLARE @current_VOI			    int = 0
DECLARE @last_ApplicationServer     int = 0
DECLARE @last_DLO					int = 0
DECLARE @last_FSOnlyServer          int = 0
DECLARE @last_FSOnlyVM		        int = 0
DECLARE @last_OI			        int = 0
DECLARE @last_VOI			        int = 0
DECLARE @current_DbInstance			int = 0
DECLARE @last_DbInstance			int = 0
DECLARE @currentupdatelevel         int = 0
DECLARE @ADFUpdateLevel nvarchar(64)  = 'LicGetADFDetailsUpdateLevel'
IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH (NOLOCK) WHERE name = @ADFUpdateLevel)
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES (@ADFUpdateLevel, 0, dbo.GetUnixTime(getdate()), 0)
END
ELSE
BEGIN
	SELECT @currentupdatelevel = CONVERT(INT, value) FROM GXGlobalParam WITH (NOLOCK) WHERE name = @ADFUpdateLevel
END
IF object_id('tempdb.dbo.#temp_lic') IS NOT null DROP TABLE #temp_lic
    CREATE TABLE #temp_lic(t_cid int, t_lictype int)
IF object_id('tempdb.dbo.#VMList') IS NOT null DROP TABLE #VMList
    CREATE TABLE #VMList(t_VMid int)
IF object_id('tempdb.dbo.#tempClientList3') IS NOT null DROP TABLE #tempClientList3
	CREATE TABLE #tempClientList3(t_type int, t_clientId INT, t_lictype INT, t_flag INT default -1, t_isVM INT default 0, t_clusterid INT default 0)
IF object_id('tempdb.dbo.#tempCluster') IS NOT null DROP TABLE #tempCluster
	CREATE TABLE #tempCluster(t_VMClientId int, t_PMClientId int, t_Lictype int)
IF object_id('tempdb.dbo.#tempVMToPMList') IS NOT null DROP TABLE #tempVMToPMList
	CREATE TABLE #tempVMToPMList(appTypeId INT,pseudoClientId INT,physClientId INT)
EXEC LicGetVMToPMList
INSERT INTO #VMList
SELECT DISTINCT ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @ArchivedVMType OR (UsageType = @AdvancedVMType AND VMFlag in (2,3))
INSERT INTO #temp_lic
SELECT cid, LicType FROM LicUsage WITH (NOLOCK) WHERE OpType = 'Install' AND LicType in (1,2,3,16,17,25,127) AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE())
UNION
SELECT DISTINCT ObjectId, 3 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @AdvancedVMType AND VMFlag = 4
UNION --include Openstack pseudo client
SELECT DISTINCT C.id, @OPENSTACKLicType
FROM APP_Client C WITH (NOLOCK)
INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.clientId = C.id AND (APP.subclientStatus & 6) = 0
INNER JOIN APP_iDAName IDA WITH (NOLOCK) ON IDA.clientId = APP.clientId AND (iDA.Status & 6) = 0
INNER JOIN APP_InstanceProp Prop WITH (NOLOCK) ON APP.instance = Prop.componentNameId AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0 AND attrVal ='15'
INSERT INTO #tempCluster
SELECT DISTINCT pseudoClientId, physClientId, U.LicType
FROM #tempVMToPMList V
INNER JOIN #temp_lic T ON V.pseudoClientId = T.t_cid
INNER JOIN LicUsage U WITH (NOLOCK) ON U.cid = V.physClientId AND LicType in (1,2,3,16,17,25,127)
UNION --add physical nodes which do not consume app class agent licenses due to ACV
SELECT DISTINCT pseudoClientId, physClientId, T.t_Lictype
FROM #tempVMToPMList V
INNER JOIN #temp_lic T ON V.pseudoClientId = T.t_cid
INNER JOIN APP_IDAName Ida WITH (NOLOCK) ON Ida.clientId = V.physClientId
INNER JOIN simAppTypeLicTypeMap Map WITH (NOLOCK) ON Map.appTypeId = Ida.appTypeId AND Map.simLicAppType = T.t_Lictype
WHERE T.t_Lictype in (3,16,17)
DELETE T
FROM #temp_lic T
INNER JOIN #tempCluster C ON T.t_cid = C.t_PMClientId OR T.t_cid = C.t_VMClientId
INSERT INTO #temp_lic
SELECT DISTINCT t_PMClientId, t_Lictype
FROM #tempCluster
IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
DROP TABLE #ClientInstanceDetails
CREATE TABLE #ClientInstanceDetails
(
	[InstanceId] INT,
	[ClientId] INT,
	[IdaType] INT,
	[DbName] NVARCHAR(255)
	PRIMARY KEY([InstanceId],[ClientId],[DbName])
)
--EXEC LicGetDBDatabaseList
--Exclude commserve DR nodes
DELETE T
FROM #temp_lic T
INNER JOIN SimInstalledPackages P WITH (NOLOCK) ON T.t_cid = P.clientid AND P.simpackageid = 24
INNER JOIN App_application APP WITH (NOLOCK) ON APP.clientId = T.t_cid AND APP.appTypeId = 81
DELETE #temp_lic
WHERE t_cid IN (select t_VMid from #VMList)
INSERT INTO #tempClientList3 (t_clientId, t_type, t_lictype)
SELECT DISTINCT t_cid,@AppServerType, @AppServerLicType FROM #temp_lic WHERE t_lictype IN (3,16,17)
--Remove all clients which are already counted towards application server
DELETE #temp_lic
WHERE t_cid IN (SELECT DISTINCT t_cid FROM #temp_lic WHERE t_lictype IN (3,16,17))
DELETE #temp_lic WHERE t_lictype IN (SELECT id FROM simLicAppTypeV2 WITH (NOLOCK) WHERE groupId IN (1,7,14,15))
INSERT INTO #tempClientList3 (t_clientId, t_type, t_lictype)
SELECT DISTINCT t_cid,@DLOType,@DLOLicType FROM #temp_lic
INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = t_cid
WHERE t_lictype = 2 OR C.status & 4096 = 4096 AND C.status & 2 <> 2
--Remove all clients which are already counted towards LaptopDesktop
DELETE #temp_lic
WHERE t_cid IN (SELECT DISTINCT t_cid FROM #temp_lic
				INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = t_cid
				WHERE t_lictype = 2 OR C.status & 4096 = 4096 AND C.status & 2 <> 2)
INSERT INTO #tempClientList3(t_clientId, t_type, t_lictype)
SELECT DISTINCT t_cid,@FSOnlyType,@FSOnlyLicType FROM #temp_lic WHERE t_lictype in (1,25,127) -- count NAS, Cluster Group under FSOnly
UPDATE T
SET t_isVM = 1
FROM #tempClientList3 T
INNER JOIN (SELECT DISTINCT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Machine GUID' and modified = 0) C ON t_clientId = C.componentNameId
UPDATE T
SET t_lictype = @FSOnlyVMLicType
FROM #tempClientList3 T
WHERE t_type = @FSOnlyType AND t_isVM = 1
IF OBJECT_ID('tempdb.dbo.#tempClientOwners') IS NOT NULL DROP TABLE #tempClientOwners
CREATE TABLE #tempClientOwners (clientId INT, userId INT, PRIMARY KEY(clientId, userId))
INSERT INTO #tempClientOwners(clientId, userId)
SELECT DISTINCT clientId, userId FROM dbo.sec_getClientOwners(1)
IF object_id('tempdb.dbo.#tmpValidLictypes') IS NOT null DROP TABLE #tmpValidLictypes
CREATE TABLE #tmpValidLictypes (LicType INT)
EXEC LicCheckOIStatus '#tmpValidLictypes'
INSERT INTO #tempClientList3 (t_clientId, t_type, t_lictype, t_flag, t_isVM, t_clusterid)
SELECT DISTINCT ObjectId,@VOIType,@VOILicType,
CASE WHEN UsageType = @AdvancedVMType AND VMFLAG = 2 THEN @VMOnlyLicType
	 WHEN UsageType = @AdvancedVMType AND VMFLAG = 3 THEN @VMWithAppLicType
	 WHEN UsageType = @AdvancedVMType AND VMFLAG = 4 THEN @ACVLicType
	 ELSE @ArchivedVMLicType END, 1, ISNULL(S.t_VMClientId,0)
FROM Lic_CurrentUsage C WITH (NOLOCK)
INNER JOIN #tmpValidLictypes T ON C.LicType = T.LicType
LEFT JOIN #tempCluster S ON C.ObjectId = S.t_PMClientId
WHERE UsageType = @ArchivedVMType OR UsageType = @AdvancedVMType
UNION
SELECT DISTINCT t_clientId, CASE t_isVM WHEN 1 THEN @VOIType ELSE @OIType END, CASE t_isVM WHEN 1 THEN @VOILicType ELSE @OILicType END, CASE WHEN t_type = @FSOnlyType THEN @FSOnlyLicType ELSE @AppServerLicType END, t_isVM, ISNULL(S.t_VMClientId,0)
FROM #tempClientList3
LEFT JOIN #tempCluster S ON t_clientId = S.t_PMClientId
WHERE t_type = @FSOnlyType OR t_type = @AppServerType AND t_clientId NOT IN (SELECT DISTINCT ObjectId FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @AdvancedVMType AND VMFLAG = 4)
UNION
SELECT DISTINCT t_clientId, CASE t_isVM WHEN 1 THEN @VOIType ELSE @OIType END, CASE t_isVM WHEN 1 THEN @VOILicType ELSE @OILicType END, CASE WHEN userId > 0 THEN @EPLicType ELSE @DLOLicType END, t_isVM, ISNULL(S.t_VMClientId,0)
FROM #tempClientList3
LEFT JOIN #tempClientOwners O ON t_clientId = O.clientId
LEFT JOIN #tempCluster S ON t_clientId = S.t_PMClientId
WHERE t_type = @DLOType
UNION
SELECT DISTINCT t_cid, @OIType, @OILicType, @OPENSTACKLicType, 0, 0
FROM #temp_lic
WHERE t_lictype = @OPENSTACKLicType
IF NOT EXISTS (SELECT 1 FROM #tmpValidLictypes WHERE LicType = @EPLicType)
DELETE #tempClientList3 WHERE t_flag = @EPLicType
IF NOT EXISTS (SELECT 1 FROM #tmpValidLictypes WHERE LicType = @MsimLicType)
DELETE T
FROM #tempClientList3 T
INNER JOIN Lic_CurrentUsage C WITH (NOLOCK) ON C.usageType = 18 AND C.clientid = T.t_clientId
WHERE T.t_type = @OIType OR T.t_type = @VOIType
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
CREATE TABLE #tempUsage (t_licType INT,t_currentUsage INT, t_lastUsage INT, t_updateStatus INT DEFAULT 0)
BEGIN TRY
BEGIN TRAN
IF EXISTS (SELECT 1 FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType in (@AppServerType,@DLOType,@FSOnlyType,@OIType,@VOIType))
DELETE FROM Lic_CurrentUsage WHERE UsageType in (@AppServerType,@DLOType,@FSOnlyType,@OIType,@VOIType)
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,LicType,CapacityFlag,VMFlag,ObjectId)
SELECT  DISTINCT t_type,t_clientId,t_lictype,t_flag,t_isVM,t_clusterid
FROM #tempClientList3
INSERT INTO Lic_CurrentUsage (UsageType,ClientId,SubclientName,LicType,CapacityFlag,VMFlag,ObjectId)
SELECT DISTINCT @OIType,ClientId,DbName,@OILicType,IdaType,0,0
FROM #ClientInstanceDetails
IF @currentupdatelevel = 0
BEGIN
	DELETE P
	FROM Lic_PeakUsage P
	INNER JOIN Lic_CurrentUsage C WITH (NOLOCK) ON C.UsageType = @AdvancedVMType AND C.VMFlag = 4 AND C.ObjectId = P.ClientId
	WHERE MonthStart = @monthStart AND P.UsageType = @FSOnlyType AND P.LicType = @FSOnlyVMLicType
	UPDATE GXGlobalParam SET value = @currentupdatelevel + 1 WHERE name = @ADFUpdateLevel
	SET @currentupdatelevel = @currentupdatelevel + 1
END
IF @currentupdatelevel = 1 OR @currentupdatelevel = 2
BEGIN
	DELETE P
	FROM Lic_PeakUsage P
	INNER JOIN #tempCluster C ON P.ClientId = C.t_VMClientId OR P.ClientId = C.t_PMClientId
	WHERE MonthStart = @monthStart AND P.UsageType IN (@OIType,@VOIType)
	UPDATE GXGlobalParam SET value = 3 WHERE name = @ADFUpdateLevel
	SET @currentupdatelevel = 3
END
UPDATE T
SET T.UsageType = S.UsageType, T.LicType = S.LicType, T.CapacityFlag = S.CapacityFlag
FROM Lic_PeakUsage T
INNER JOIN Lic_CurrentUsage S WITH (NOLOCK) ON S.UsageType <> T.UsageType AND S.ClientId = T.ClientId
WHERE MonthStart = @monthStart AND T.UsageType IN (@VOIType, @OIType) AND S.UsageType IN (@VOIType, @OIType)
SELECT @current_ApplicationServer = [100030],@current_DLO = [200002],@current_FSOnlyServer = [100029], @current_FSOnlyVM = [200017], @current_VOI = [100033]
FROM (SELECT distinct clientId, LicType FROM Lic_CurrentUsage WITH (NOLOCK) ) AS S
PIVOT
(COUNT(clientId) FOR LicType in ([100030],[200002],[100029],[200017],[100033])) AS P
SELECT @current_OI = COUNT(distinct clientId) FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @OIType AND SubclientName IS NULL
SELECT @current_DbInstance = ISNULL(sum(S.counts),0)
	FROM (SELECT ClientId, count(distinct SubclientName) AS counts FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = @OIType AND SubclientName IS NOT NULL GROUP BY ClientId) S
SET @current_OI = @current_OI + @current_DbInstance
SELECT @last_ApplicationServer = [100030],@last_DLO = [200002],@last_FSOnlyServer = [100029], @last_FSOnlyVM = [200017], @last_VOI = [100033]
FROM (SELECT distinct clientId, LicType FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType) AS S
PIVOT
(COUNT(clientId) FOR LicType in ([100030],[200002],[100029],[200017],[100033])) AS P
SELECT @last_OI = COUNT(distinct clientId) FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType AND UsageType = @OIType AND SubclientName IS NULL
SELECT @last_DbInstance = ISNULL(sum(S.counts),0)
	FROM (SELECT ClientId, count(distinct SubclientName) AS counts FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @CCLPeakType AND UsageType = @OIType AND SubclientName IS NOT NULL GROUP BY ClientId) S
SET @last_OI = @last_OI + @last_DbInstance
INSERT INTO #tempUsage (t_licType,t_currentUsage,t_lastUsage)
VALUES (@AppServerLicType,@current_ApplicationServer,@last_ApplicationServer),
(@DLOLicType,@current_DLO,@last_DLO),
(@FSOnlyLicType,@current_FSOnlyServer,@last_FSOnlyServer),
(@FSOnlyVMLicType,@current_FSOnlyVM,@last_FSOnlyVM),
(@OILicType,@current_OI,@last_OI),
(@VOILicType,@current_VOI,@last_VOI)
UPDATE #tempUsage
SET t_updateStatus = 1
WHERE t_currentUsage >= t_lastUsage AND t_currentUsage > 0
DELETE T
FROM Lic_PeakUsage T
INNER JOIN #tempUsage ON T.LicType = t_licType AND t_updateStatus = 1
WHERE T.MonthStart = @monthStart AND T.PeakType = @CCLPeakType
INSERT INTO Lic_PeakUsage (MonthStart,CreationDate,UsageType,PeakType,ClientId,SubclientName,LicType,CapacityFlag,VMFlag,ObjectId)
SELECT @monthStart,@currentTime,UsageType,@CCLPeakType,ClientId,SubclientName,LicType,CapacityFlag,VMFlag,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK)
INNER JOIN #tempUsage ON LicType = t_licType AND t_updateStatus = 1
UPDATE T
SET T.CapacityFlag = S.CapacityFlag
FROM Lic_PeakUsage T
INNER JOIN Lic_CurrentUsage S WITH (NOLOCK) ON T.UsageType = S.UsageType AND T.clientid = S.clientid AND T.LicType = S.LicType AND T.ObjectId = S.ObjectId AND S.SubclientName IS NULL AND T.SubclientName IS NULL
WHERE T.MonthStart = @monthStart AND T.PeakType = @SCLPeakType AND T.UsageType in (@OIType,@VOIType)
INSERT INTO Lic_PeakUsage(MonthStart, CreationDate, UsageType, PeakType,ClientId, SubclientName, LicType, CapacityFlag, VMFlag, ObjectId)
SELECT @monthStart, @currentTime, UsageType,@SCLPeakType,ClientId,SubclientName,LicType,CapacityFlag,VMFlag,ObjectId
FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType IN (@AppServerType,@DLOType,@FSOnlyType,@OIType,@VOIType)
EXCEPT
SELECT @monthStart, @currentTime,UsageType,@SCLPeakType,ClientId,SubclientName,LicType,CapacityFlag,VMFlag,ObjectId
FROM Lic_PeakUsage WITH (NOLOCK) WHERE MonthStart = @monthStart AND PeakType = @SCLPeakType AND UsageType IN (@AppServerType,@DLOType,@FSOnlyType,@OIType,@VOIType)
UPDATE T
SET T.ObjectName = C.name
FROM Lic_CurrentUsage T
INNER JOIN APP_Client C WITH (NOLOCK) ON T.ObjectId = C.id
WHERE T.ObjectId > 0 and T.UsageType IN (@VOIType, @OIType) AND T.ObjectName is null
Update T
Set T.ObjectName = C.name
FROM Lic_PeakUsage T
INNER JOIN APP_Client C WITH (NOLOCK) ON T.ObjectId = C.id
WHERE T.ObjectId > 0 and T.UsageType IN (@VOIType, @OIType) AND T.ObjectName is null
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @attrVal = '1'
GOTO  CAL_ERROR
END CATCH
CAL_ERROR:
IF EXISTS(select 1 from LicUsageBasedConfig WITH (nolock) where attrname = @attrname)
	Update LicUsageBasedConfig
	SET attrVal = @attrVal
	WHERE attrname = @attrname AND attrVal <> @attrVal
ELSE
	INSERT INTO LicUsageBasedConfig (attrname,attrType,attrVal)
	VALUES (@attrname, @attrType, @attrVal)
DROP TABLE #VMList
DROP TABLE #temp_lic
DROP TABLE #tempClientList3
DROP TABLE #tempUsage
DROP TABLE #tmpValidLictypes
DROP TABLE #tempClientOwners
DROP TABLE #tempCluster
DROP TABLE #tempVMToPMList
DROP TABLE #ClientInstanceDetails
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicGetADFDetailsV3')
	delete from GxQscripts where name = 'LicGetADFDetailsV3'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicGetADFDetailsV3')
	delete from GXDBVersions where aliasname = 'LicGetADFDetailsV3'
GO

insert into GXDBVersions values(2, 'LicGetADFDetailsV3',  'v1.1.2.13.8.1', 'LicGetADFDetailsV3', 'v1.1.2.13.8.1')
GO

