

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicCheckOIStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Zach Wang
--	Date:   4/3/2019
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
-- @i_clientId can be client ID or Library ID
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicCheckOIStatus')
BEGIN
	print '>>> Drop Stored Procedure: LicCheckOIStatus <<<'
	drop procedure LicCheckOIStatus
END
IF EXISTS (select * from GxQscripts where name='LicCheckOIStatus')
	delete from GxQscripts where name = 'LicCheckOIStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCheckOIStatus')
	delete from GXDBVersions where aliasname = 'LicCheckOIStatus'
GO
print '... Creating Procedure: LicCheckOIStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicCheckOIStatus
  @in_tmpTbl VARCHAR(MAX)=NULL,
  @in_appType INTEGER = 0,	
  @in_clientId INTEGER = 0,	
  @isOIValid INTEGER = 0 OUTPUT,
  @isVOIValid INTEGER = 0 OUTPUT,
  @isAppTypeValid INTEGER = 0 OUTPUT
AS
DECLARE @ArchivedVMLicType  int = 100021
DECLARE @VMOnlyLicType  int = 200001
DECLARE @VMWithAppLicType  int = 200003
DECLARE @ACVLicType  int = 100027
DECLARE @EPLicType  int = 200020
DECLARE @MsimLicType  int = 100028
DECLARE @isVSAValid INT = 0
DECLARE @isArchivedVMValid INT = 0
DECLARE @isEPValid INT = 0
DECLARE @isVMAppClass1Valid INT = 0
DECLARE @isMsimValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
DECLARE @isCvCpltUsageBasedEnabled INT = 0
SELECT @isCvCpltUsageBasedEnabled = 1 FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = 205 AND commcellId = 2
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @isVSAValid = @licAppliedStatus&0x2
SELECT @isArchivedVMValid = @licAppliedStatus&0x4
SELECT @isVMAppClass1Valid = @licAppliedStatus&0x40
SELECT @isEPValid = CASE WHEN @licAppliedStatus&0x8 > 0
OR @licAppliedStatus&0x10 > 0
OR @licAppliedStatus&0x20 > 0
									THEN 1 ELSE 0 END
SELECT @isMsimValid = @licAppliedStatus&0x80
	IF @isCvCpltUsageBasedEnabled > 0
	BEGIN
SELECT @isOIValid =  @licAppliedStatus&0x200
SELECT @isVOIValid =  @licAppliedStatus&0x400
	END
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100019, @isVSAValid OUTPUT
	EXEC LicIsLicenseValid 100021, @isArchivedVMValid OUTPUT
	EXEC LicIsLicenseValid 100027, @isVMAppClass1Valid OUTPUT
	EXEC LicIsLicenseValid 100024, @isEPValid OUTPUT
	EXEC LicIsLicenseValid 100028, @isMsimValid OUTPUT
	IF @isEPValid = 0
		EXEC LicIsLicenseValid 100025, @isEPValid OUTPUT
	IF @isEPValid = 0
		EXEC LicIsLicenseValid 100026, @isEPValid OUTPUT
	IF @isCvCpltUsageBasedEnabled > 0
	BEGIN
		EXEC LicIsLicenseValid 100032, @isOIValid OUTPUT
		EXEC LicIsLicenseValid 100033, @isVOIValid OUTPUT
	END
END
IF object_id('tempdb.dbo.#ValidLictypes') IS NOT null DROP TABLE #ValidLictypes
	CREATE TABLE #ValidLictypes (LicType INT)
IF @isVOIValid > 0 OR @isOIValid > 0
BEGIN
	IF @isVSAValid = 0
	INSERT INTO #ValidLictypes VALUES (@VMOnlyLicType)
	IF @isArchivedVMValid = 0
	INSERT INTO #ValidLictypes VALUES (@ArchivedVMLicType)
	IF @isVMAppClass1Valid = 0
	INSERT INTO #ValidLictypes VALUES (@VMWithAppLicType),(@ACVLicType)
	IF @isMsimValid = 0
	INSERT INTO #ValidLictypes VALUES (@MsimLicType)
END
IF @isOIValid > 0 AND @isEPValid = 0
INSERT INTO #ValidLictypes VALUES (@EPLicType)
IF @in_tmpTbl = '#tmpValidLictypes'
BEGIN
	INSERT INTO #tmpValidLictypes
	SELECT DISTINCT LicType FROM #ValidLictypes
END
IF @in_appType > 0 AND @in_appType <> 134
BEGIN
IF @in_ClientId > 0 AND EXISTS (SELECT 1 from LicUsage WITH (NOLOCK) WHERE cid = @in_clientId AND AppType = @in_appType AND OpType = 'Install' AND LicType in (1,2,3,16,17,25,127,143) AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE()))
SET @isAppTypeValid = 1
ELSE IF @in_ClientId = 0 AND EXISTS (SELECT 1 from simAppTypeLicTypeMap WITH (NOLOCK) WHERE appTypeId = @in_appType AND simLicAppType IN (1,2,3,16,17,25,127,143))
SET @isAppTypeValid = 1
END
--IF @in_appType = 134 AND @in_ClientId > 0 AND EXISTS (SELECT TOP 1 1 FROM APP_Application app WITH (NOLOCK) INNER JOIN APP_InstanceName I WITH (NOLOCK) ON app.instance = I.id INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('4','22','23','26','27','32') WHERE app.appTypeId = 134 AND app.clientId = @in_ClientId AND (I.status&4) = 0 AND (I.status&16) = 0 AND (I.status&32) = 0 AND (I.status&2048) = 0)
--SET @isAppTypeValid = 1
DROP TABLE #ValidLictypes
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicCheckOIStatus')
	delete from GxQscripts where name = 'LicCheckOIStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCheckOIStatus')
	delete from GXDBVersions where aliasname = 'LicCheckOIStatus'
GO

insert into GXDBVersions values(2, 'LicCheckOIStatus',  '00000000000000000000', 'LicCheckOIStatus', '00000000000000000000')
GO

