

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicCalcUsageMaster.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Abhinaw Kumar
--	Date:   09/17/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LicCalcUsageMaster.sp,v $ $Id: LicCalcUsageMaster.sp,v 1.1.2.6 2020/09/17 18:29:57 leiwang Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicCalcUsageMaster')
BEGIN
	print '>>> Drop Stored Procedure: LicCalcUsageMaster <<<'
	drop procedure LicCalcUsageMaster
END
IF EXISTS (select * from GxQscripts where name='LicCalcUsageMaster')
	delete from GxQscripts where name = 'LicCalcUsageMaster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCalcUsageMaster')
	delete from GXDBVersions where aliasname = 'LicCalcUsageMaster'
GO
print '... Creating Procedure: LicCalcUsageMaster'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LicCalcUsageMaster
  @bIsParamRequired INTEGER = 0,
  @i_bIncludeForeignJobs INTEGER = 0,
  @nUserId INTEGER = 0,
  @nOrganizationDetails INTEGER = 0,
  @nCallerType INTEGER = 0   --0 for SQL Job, 1 for Lic App, 2 for 
AS
BEGIN
	DECLARE @useNewLicCal INT = 0
	IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'nUseNewLicCal')
		SELECT @useNewLicCal = value FROM GXGlobalParam WITH (NOLOCK) WHERE name ='nUseNewLicCal'
	ELSE
		SELECT @useNewLicCal = 1
	DECLARE @turnoffLicCal INT = 0
	SELECT @turnoffLicCal = value FROM GXGlobalParam WITH (NOLOCK) WHERE name ='LicTurnOffCalcUsage'
	IF @useNewLicCal = 0 OR @turnoffLicCal = 1
		RETURN
	SET NOCOUNT ON
	DECLARE @isMasterSPRunning INT
	DECLARE @LastCollUnixTime INT = 0
	BEGIN TRANSACTION
		DECLARE @LastResetUnixTime INT = 0
		SELECT @isMasterSPRunning = CONVERT(INT, value), @LastResetUnixTime = ISNULL(created, -1) FROM GXGlobalParam WITH (ROWLOCK, UPDLOCK) WHERE name = 'LicCalcUsageMasterSPRunning'
		IF @isMasterSPRunning = 0
		BEGIN
			UPDATE GXGlobalParam SET value = '1', created = dbo.GetUnixTime(GETUTCDATE()) WHERE name = 'LicCalcUsageMasterSPRunning'
		END
		ELSE
		BEGIN
			 DECLARE @minElapsedFromLastReset INT  = 0
			 SET @minElapsedFromLastReset = DATEDIFF(MINUTE, DATEADD(SECOND, @LastResetUnixTime, '1970-01-01'), GETUTCDATE())
			 IF @minElapsedFromLastReset > 60
			 BEGIN
				UPDATE GXGlobalParam SET created = dbo.GetUnixTime(GETUTCDATE()) WHERE name = 'LicCalcUsageMasterSPRunning'
				SET @isMasterSPRunning = 0
			 END
		END
	COMMIT TRANSACTION
	BEGIN TRANSACTION
		SELECT @LastCollUnixTime = ISNULL(CONVERT(BIGINT,value), -1)  FROM GXGlobalParam WITH (ROWLOCK, UPDLOCK) WHERE name = 'LicCurrentUsageCollectionTime'
		DECLARE @currentTime_Unix  INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @currentCollectionTime varchar(16) = CONVERT(varchar(16),@currentTime_Unix)
		DECLARE @minElapsedFromLastUsageColl INT  = 0
		SET @minElapsedFromLastUsageColl = DATEDIFF(MINUTE, DATEADD(SECOND, @LastCollUnixTime, '1970-01-01'), GETUTCDATE())
	COMMIT TRANSACTION
	IF ((@minElapsedFromLastUsageColl > 60 AND @nCallerType = 0) OR (@nCallerType = 1 OR @nCallerType = 2)) AND  @isMasterSPRunning = 0
	BEGIN
		DECLARE @params TABLE(paramName NVARCHAR(1024), paramValue NVARCHAR(1024))
		--this is start of Insert statement for each type of parameters expected for the SPs
		INSERT INTO @params VALUES ('@nUserId,@i_bIncludeForeignJobs', CONVERT(VARCHAR,@nUserId) + ',' + CONVERT(VARCHAR,@i_bIncludeForeignJobs))
		INSERT INTO @params VALUES ('@nUserId,@nOrganizationDetails', CONVERT(VARCHAR,@nUserId) + ',' + CONVERT(VARCHAR,@nOrganizationDetails))
		INSERT INTO @params VALUES ('@nUserId', @nUserId)
		--End
		CREATE TABLE #SPToExec (nID INT IDENTITY(1,1), sSPName NVARCHAR(1024), sParamNames NVARCHAR(1024) NULL, nPriority INT)
		INSERT INTO #SPToExec SELECT sSPName, sParamNames, nPriority FROM LicCalcUsageSPList WITH (NOLOCK) ORDER BY nPriority
		DECLARE @LoopCounter INT = 1, @MaxSPId INT = 0, @SPName NVARCHAR(512) = NULL,
				@SPParam NVARCHAR(1024) = NULL, @sqlString NVARCHAR(MAX) = NULL
		SET @MaxSPID = (SELECT MAX(nID) FROM #SPToExec)
		DECLARE @returnCode INT = 0
		WHILE(@LoopCounter <= @MaxSPId)
		BEGIN TRY
			SET @returnCode = -1
			SET @SPParam = NULL
			SELECT @SPName = sSPName, @SPParam = sParamNames FROM #SPToExec WHERE nID = @LoopCounter
			IF @bIsParamRequired = 0 OR @SPParam IS NULL OR @SPParam = ''
			BEGIN
				SET @sqlString = N'EXECUTE ' + @SPName
			END
			ELSE
			BEGIN
				SELECT @SPParam = paramValue FROM @params WHERE paramName = @SPParam
				SET @sqlString = N'EXECUTE ' + @SPName + ' ' + @SPParam
			END
			EXECUTE @returnCode = sp_executesql @sqlString
			UPDATE LicCalcUsageSPList SET dLastRun = GETUTCDATE(), nLastRunStatusCode = @returnCode WHERE sSPName = @SPName
			SET @LoopCounter = @LoopCounter  + 1
		END TRY
		BEGIN CATCH
			DECLARE @ErrorMessage NVARCHAR(2048)
			DECLARE @ErrorSeverity INT;
			DECLARE @ErrorState INT
			SELECT
				@ErrorMessage = ERROR_MESSAGE(),
				@ErrorSeverity = ERROR_SEVERITY(),
				@ErrorState = ERROR_STATE();
			RAISERROR( @ErrorMessage, @ErrorSeverity , @ErrorState)
			DROP TABLE #SPToExec
			UPDATE GXGlobalParam WITH(ROWLOCK) SET value = '0', created = dbo.GetUnixTime(GETUTCDATE()) WHERE name = 'LicCalcUsageMasterSPRunning'
			RETURN
		END CATCH
		DROP TABLE #SPToExec
		UPDATE GXGlobalParam WITH(ROWLOCK) SET value = '0', created = dbo.GetUnixTime(GETUTCDATE()) WHERE name = 'LicCalcUsageMasterSPRunning'
		IF (@LastCollUnixTime <> -1)
		BEGIN
			UPDATE GXGlobalParam WITH(ROWLOCK) SET value = @currentCollectionTime WHERE name = 'LicCurrentUsageCollectionTime'
		END
	END
	ELSE
	BEGIN
		IF @isMasterSPRunning = 0
		BEGIN
			UPDATE GXGlobalParam WITH(ROWLOCK) SET value = '0', created = dbo.GetUnixTime(GETUTCDATE()) WHERE name = 'LicCalcUsageMasterSPRunning'
		END
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LicCalcUsageMaster')
	delete from GxQscripts where name = 'LicCalcUsageMaster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCalcUsageMaster')
	delete from GXDBVersions where aliasname = 'LicCalcUsageMaster'
GO

insert into GXDBVersions values(2, 'LicCalcUsageMaster',  '00010001000200060000', 'LicCalcUsageMaster', '00010001000200060000')
GO

