

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicCIUsageBasedValid.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : LicCIUsageBasedValid.sp
--
--  Description : This Stored Procedure used to check ths Content Index Object
--                                                                            usage status for the Usage based licenses
--
--  Author      : Ravi Kumarasamy
--
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  LicCIUsageBasedValid()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LicCIUsageBasedValid')
BEGIN
	print '>>> Drop Stored Procedure: LicCIUsageBasedValid <<<'
	drop procedure LicCIUsageBasedValid
END
IF EXISTS (select * from GxQscripts where name='LicCIUsageBasedValid')
	delete from GxQscripts where name = 'LicCIUsageBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCIUsageBasedValid')
	delete from GXDBVersions where aliasname = 'LicCIUsageBasedValid'
GO
print '... Creating Procedure: LicCIUsageBasedValid'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LicCIUsageBasedValid
  @in_jobId INTEGER=0
AS
  DECLARE @o_error INTEGER
SET NOCOUNT ON
--local vars
DECLARE @nLicenceTypeToCheck INT
DECLARE @nUsageStatus BIGINT
DECLARE @nDetailedStatus BIGINT
DECLARE @isValid INT = 0
DECLARE @isContentJob INT
SET @isContentJob = 0
set @nLicenceTypeToCheck=0
SET @o_error = 0 --success
SET @isValid = 0
--get the capacity usage status
SET @nUsageStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'LicUsageBasedStatus'), 1)
SET @nDetailedStatus = ISNULL( (SELECT attrVal FROM LicUsageBasedConfig with (readuncommitted) WHERE attrName = 'LicUsageBasedDetailedStatus'), 1)
--if we are not using usage based licensing, or if the status is valid, simply return
IF (@nUsageStatus = 1 AND @nDetailedStatus = 1)
BEGIN
    GOTO SP_EXIT
END
IF (@in_jobId = 0) OR (@in_jobId = NULL)
	BEGIN
		GOTO SP_EXIT
	END
ELSE
	BEGIN
		--Optype for the Content Indexed Objec Job is 53
		IF NOT EXISTS (SELECT * FROM JMJobInfo WHERE JobId = @in_jobId and opType=53)
		BEGIN
						set @nLicenceTypeToCheck=0
						GOTO SP_EXIT
		END
		--When the Job is running.
SET @nLicenceTypeToCheck = 100017  -- Content Indexed Object LicType
	END
--get the license type against which we should check for license validity
--All the variables are defined in the header files
IF (@nUsageStatus & 0x80) = 0
	BEGIN
					IF @nDetailedStatus >0
						BEGIN
							---license not applied or expired
							SET @o_error =
								CASE @nLicenceTypeToCheck
WHEN 100017 THEN
										(CASE
WHEN ((@nDetailedStatus & 0x20 ) > 0) 	THEN 20101  --20101
WHEN ((@nDetailedStatus & 0x10) > 0) 		THEN 20104  --20104
											ELSE 0
										END)
									ELSE 0
										END
						END
					IF @o_error IS NULL OR @o_error = 0
						BEGIN
							SET @o_error =
								CASE @nLicenceTypeToCheck
WHEN 100017                   THEN 20107 --20107
								ELSE 0
								END
						END
	END
	SP_EXIT:
    RETURN @o_error
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'LicCIUsageBasedValid')
	delete from GxQscripts where name = 'LicCIUsageBasedValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCIUsageBasedValid')
	delete from GXDBVersions where aliasname = 'LicCIUsageBasedValid'
GO

insert into GXDBVersions values(2, 'LicCIUsageBasedValid',  '00000000000000000000', 'LicCIUsageBasedValid', '00000000000000000000')
GO

