

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LicCALUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : LicCALUsage.sp
--
--  Description : Will return usage based license details.
--
--
--  Author      : Jun Lu Created.
--				  Ravi Kumarasamy Added the Content Indexing Object
--				  and Renamed to LicCALUsage from RptSubscriptionUsage.
--				  nCallFromReport - It used to filter the execution.
--				  If the SP is called from License Usage GUI this SP will
--				  return onlu Proctected, Archived and Content Indexed object
--				  used count
--
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE : "LicCALUsage"									|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION		|
--	| AND RETURNING RESULTS													|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LicCALUsage')
BEGIN
	print '>>> Drop Stored Procedure: LicCALUsage <<<'
	drop procedure LicCALUsage
END
IF EXISTS (select * from GxQscripts where name='LicCALUsage')
	delete from GxQscripts where name = 'LicCALUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCALUsage')
	delete from GXDBVersions where aliasname = 'LicCALUsage'
GO
print '... Creating Procedure: LicCALUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LicCALUsage
  @nCallFromReport BIGINT =0,
  @nDetailedReportFor BIGINT =0,
  @nUserId integer =0,
  @nOrganizationDetails integer =0
-- nCallFromReport		: 0 will execute the entire stored procedure.
-- nDetailedReportFor	: for Protected, Archived mailboxes and VM Detailed Report.
AS
  DECLARE @nProtectedClient integer;
  DECLARE @nProtectedVM integer;
  DECLARE @nArchivedVM integer;
  DECLARE @nArchivedClient integer;
  DECLARE @nArchivedMailBox integer;
  DECLARE @nSRMClient integer;
  DECLARE @nCIServer integer;
  DECLARE @nAdvSearchNodes integer;
  DECLARE @nSearchMailBox integer;
  DECLARE @nVMSocket integer;
  DECLARE @nEpUsers integer;
  DECLARE @nEpSharingUsers integer;
  DECLARE @nEpEdiscoveryUsers integer;
  DECLARE @nVMWithAppClass1Pkg integer;
  DECLARE @nMSimUsers integer;
  DECLARE @nAppStoreCapacityMB bigint;
  DECLARE @FSOnlyServer integer;
  DECLARE @ApplicationServer integer;
  DECLARE @UsedDiskSpaceMB bigint;
  DECLARE @AvailDiskSpaceMB bigint;
  DECLARE @DedupDataSizeMB bigint;
  DECLARE @DedupDataOnTapeMB bigint;
  DECLARE @AvailDedupSpaceMB bigint;
  DECLARE @nContentIndexedObject bigint;
  DECLARE @nOIUsers integer;
  DECLARE @nVOIUsers integer;
  DECLARE @nActEDisFilesMB bigint;
  DECLARE @nActEDisECApps integer;
  DECLARE @nActSensDataFilesMB bigint;
  DECLARE @nActSensDataECApps integer;
  DECLARE @nFileStoreOptMB bigint;
  DECLARE @nActSuite integer;
  DECLARE @nDRVM integer;
  DECLARE @MailBoxXML NVARCHAR(MAX);
  DECLARE @VMXML NVARCHAR(MAX);
  DECLARE @ArchivedVMXML NVARCHAR(MAX);
  DECLARE @CIEngineXML NVARCHAR(MAX);
  DECLARE @socketXML NVARCHAR(MAX);
  DECLARE @epUserXML NVARCHAR(MAX);
  DECLARE @epSharingUserXML NVARCHAR(MAX);
  DECLARE @epEdiscoveryUserXML NVARCHAR(MAX);
  DECLARE @VMWithAppClass1PkgXML NVARCHAR(MAX);
  DECLARE @MSimUsersXML NVARCHAR(MAX);
  DECLARE @OIUsersXML NVARCHAR(MAX);
  DECLARE @VOIUsersXML NVARCHAR(MAX);
  DECLARE @DRVMXML NVARCHAR(MAX);
  DECLARE @nMetallicStoreMB bigint;
  DECLARE @ActEDisFilesMBXML NVARCHAR(MAX);
  DECLARE @ActEDisECAppsXML NVARCHAR(MAX);
  DECLARE @ActSensDataFilesMBXML NVARCHAR(MAX);
  DECLARE @ActSensDataECAppsXML NVARCHAR(MAX);
  DECLARE @FileStoreOptMBXML NVARCHAR(MAX);
  DECLARE @nMetallicStoreT2MB bigint;
  DECLARE @nMetallicStoreT3MB bigint;
  DECLARE @nMetallicStoreT4MB bigint;
  DECLARE @nMetallicStoreT5MB bigint;
  DECLARE @nMetallicStoreT6MB bigint;
  DECLARE @nMetallicStoreT7MB bigint;
  DECLARE @nMetallicStoreT8MB bigint;
  DECLARE @nMetallicStoreT9MB bigint;
  DECLARE @nMetallicStoreT10MB bigint;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @bIsArchiveLicValid INT = 0
DECLARE @bIsDRVMLicValid INT = 0
DECLARE @bIsVMProtectedLicValid INT = 0
DECLARE @bIsOILicValid INT = 0
DECLARE @bIsVOILicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsArchiveLicValid = @licAppliedStatus&0x4
SELECT @bIsDRVMLicValid = @licAppliedStatus&0x20000
SELECT @bIsVMProtectedLicValid = @licAppliedStatus&0x2
SELECT @bIsOILicValid =  @licAppliedStatus&0x200
SELECT @bIsVOILicValid =  @licAppliedStatus&0x400
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100021, @bIsArchiveLicValid OUTPUT
	EXEC LicIsLicenseValid 100040, @bIsDRVMLicValid OUTPUT
	EXEC LicIsLicenseValid 100019, @bIsVMProtectedLicValid OUTPUT
	EXEC LicIsLicenseValid 100032, @bIsOILicValid OUTPUT
	EXEC LicIsLicenseValid 100033, @bIsVOILicValid OUTPUT
END
IF object_id('tempdb.dbo.#VMList') IS NOT null DROP TABLE #VMList
CREATE TABLE #VMList(t_VMid int, t_type int)
IF ((@nCallFromReport & 0x100 >0 ) OR (@nCallFromReport =0 ))
BEGIN
	SELECT      @DedupDataSizeMB  = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)), 0),
                @DedupDataOnTapeMB= ISNULL(SUM(CASE WHEN SiloStatus = 3 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END), 0)
      FROM  MMVolume WITH (NOLOCK)
WHERE SIDBStoreId IN (SELECT DISTINCT CS.SIDBStoreId FROM archCopySIDBStore CS WITH (NOLOCK) WHERE ((CS.Flags & 4) > 0))
END
IF ((@nCallFromReport & 0x2000 >0 ) OR (@nCallFromReport =0 ))
BEGIN
	  -- Appliance Store Usage and Disk library space will be mutually exclusive on license generator.
	  SELECT      @nAppStoreCapacityMB  = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)), 0)
      FROM  MMVolume WITH (NOLOCK)
      WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0 and MountPathTypeId <> 7)
END
if (@nCallFromReport =0 )
BEGIN
      SELECT      @AvailDiskSpaceMB = SUM(CAST(FreeBytesMB AS BIGINT))
      FROM  MMMediaSide MS WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
      WHERE MS.MediaSideId=MP.MediaSideId AND  MP.MediaSideId > 0
      SELECT      @UsedDiskSpaceMB  = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)), 0)
      FROM  MMVolume WITH (NOLOCK)
      WHERE MediaSideId IN (SELECT MediaSideId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId > 0)
      SELECT      @AvailDedupSpaceMB= SUM(CAST(FreeBytesMB AS BIGINT))
      FROM  MMMediaSide WITH (NOLOCK)
      WHERE MediaSideId IN (SELECT DISTINCT MediaSideId FROM MMVolume WITH (NOLOCK) WHERE SIDBStoreId > 0)
END
IF @nUserId > 1 --SECURITY
BEGIN
DECLARE @capability BIGINT = 1
	IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
create table  #LicCalUserObj ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	--If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
EXEC sec_getUserObjects @nUserId,2013,0,'#LicCalUserObj' --SUB_CLIENT_ITEM->client
IF EXISTS(SELECT * FROM #LicCalUserObj sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) AND (capabilities & POWER(2, @capability-1)) > 0)
		SET @nUserId = 1
END
IF @nOrganizationDetails > 0
BEGIN
	-- #Companies table should be created by the caller
	--IF object_id('tempdb.dbo.#Companies') IS NOT NULL DROP TABLE #Companies
	--CREATE TABLE #Companies(id INT PRIMARY KEY, domainName VARCHAR(1024), vmcount INT DEFAULT 0, socketcount INT DEFAULT 0, epUsers INT DEFAULT 0, epSharingUsers INT DEFAULT 0, epDiscoveryUsers INT DEFAULT 0 )
	INSERT INTO #Companies(id,domainName)
	SELECT id,domainName FROM UMDSProviders p WITH(NOLOCK)
	WHERE p.serviceType = 5	-- UMDS_PROVIDER_ORGANIZATIONS
	IF object_id('tempdb.dbo.#CompanyClientMap') IS NOT NULL DROP TABLE #CompanyClientMap
	CREATE TABLE #CompanyClientMap(t_companyId INT , t_clientId INT)
	CREATE UNIQUE CLUSTERED INDEX CompanyClientMap_Idx ON #CompanyClientMap (t_companyId, t_clientId)
	;WITH Providers(companyId) AS
	(
		SELECT
			c.id
		FROM  #Companies c
		UNION
		SELECT
			p.id
		FROM UMDSProviders p WITH(NOLOCK)
			INNER JOIN #Companies c ON
				c.id = p.ownerCompany
				AND p.serviceType = 2		-- UMDS_PROVIDER_ACTIVE_DIR
	)
	,Users(userId, companyId) AS (
		SELECT DISTINCT
			u.id, c.companyId
		FROM Providers c
			INNER JOIN UMUsers u WITH(NOLOCK) ON
				u.umDSproviderId = c.companyId
				AND (u.flags & 1) <> 0
	)
	,Groups(groupId, companyId) AS (
		SELECT DISTINCT
			g.id groupId, c.companyId
		FROM Providers c
			INNER JOIN UMGroups g WITH(NOLOCK) ON
				g.umdsProviderId = c.companyId
	)
	INSERT INTO #CompanyClientMap
		SELECT
			u.companyId, a.entityId1 AS clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				a.entityType1 = 3
				AND a.isUser = 1
				AND a.userOrGroupId = u.userId
		WHERE
			a.entityId1 NOT IN (0, 1)
		UNION
		SELECT
			g.companyId, a.entityId1 AS clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				a.entityType1 = 3
				AND a.isUser = 0
				AND g.groupId = a.userOrGroupId
		WHERE
			a.entityId1 NOT IN (0, 1)
		UNION
		SELECT
			u.companyId, o.entityId AS clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				o.entityType = 3
				AND o.isUser = 1
				AND o.userOrGroupId = u.userId
		UNION
		SELECT
			g.companyId, o.entityId AS clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				o.entityType = 3
				AND o.isUser = 0
				AND o.userOrGroupId = g.groupId
		UNION
		SELECT
			u.companyId, cga.clientId clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND a.isUser = 1
				AND a.userOrGroupId = u.userId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = a.entityId1
		UNION
		SELECT
			g.companyId, cga.clientId clientId
		FROM UMSecurityAssociations a WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND a.isUser = 0
				AND g.groupId = a.userOrGroupId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = a.entityId1
		UNION
		SELECT
			u.companyId, cga.clientId clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Users u WITH(NOLOCK) ON
				o.entityType = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND o.isUser = 1
				AND o.userOrGroupId = u.userId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = o.entityId
		UNION
		SELECT
			g.companyId, cga.clientId clientId
		FROM UMOwners o WITH(NOLOCK)
			INNER JOIN Groups g WITH(NOLOCK) ON
				o.entityType = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
				AND o.isUser = 0
				AND o.userOrGroupId = g.groupId
			INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
				cga.clientGroupId = o.entityId
		-- Security Association check at user level is needed from Aaron
END
if ((@nCallFromReport & 0x40 >0 ) OR (@nCallFromReport =0 ))
BEGIN
		--******************************************************************************
		--Table which holds all the Apptype
		--******************************************************************************
		DECLARE @TempAppTypes TABLE (t_apptype INT, t_name varchar(1024), fname varchar(50))
		--ProtectedMailbox
		INSERT INTO @TempAppTypes
        select type, name, (CASE WHEN name like '%Archiv%' THEN 'ArchivedMailbox' ELSE 'ProtectedMailbox' END)
              from   APP_iDAType WITH (NOLOCK)  where type < 1000
			   AND (name like '%Compliance Archiver'  or name like '%mail%box%'  or name LIKE '%Notes%')
			   AND name not like '%Database' AND name NOT LIKE 'SRM%'
		--If mSIM is present remove counting of apptype 54,56,67,137 from archive mailbox
		DECLARE @o_isValidApptype INT
		DECLARE @o_appTypeList NVARCHAR(1024) = ''
		EXEC LicGetMSimAppType -1,0,@o_isValidApptype OUTPUT, @o_appTypeList OUTPUT
		IF @o_appTypeList <> ''
			DELETE @TempAppTypes  WHERE t_apptype in (select _ID from dbo.SplitIDs(@o_appTypeList))
		-- Backup activity disabled Client.
		DECLARE     @tblClientIDA TABLE (clientId INT, appTypeId INT, disabled INT)
		INSERT      INTO @tblClientIDA
        SELECT      clientId, ida.appTypeId , 0 FROM  APP_IDAName IDA WITH (NOLOCK) WHERE (IDA.status & 6) =0
		IF @nUserId > 1 --SECURITY
		BEGIN
			delete @tblClientIDA
			where ClientId not in (select clientId from #LicCalUserObj where clientId > 0)
		END
        DELETE      @tblClientIDA
		FROM  @tblClientIDA T, JMJobAction A WITH (NOLOCK)
		WHERE A.clientId = T.clientId AND (A.appType = 0 OR A.appType = T.appTypeId)
		AND A.opType = 4 AND A.action = 1
		-- Backup activity disabled Subclient client.
        DECLARE @ArchiveSubclients TABLE (SubclientId INT,clientId INT, subclientName VARCHAR(1024), appTypeId INT, bIsArchive INT)
		INSERT INTO @ArchiveSubclients
        SELECT ID,clientId,subclientName,appTypeId, (case fname WHEN 'ProtectedMailbox' THEN 0 ELSE 1 END)
        FROM APP_Application App WITH (NOLOCK),
                      (select distinct t_apptype, fname from @TempAppTypes where fname IN ( 'ProtectedMailbox', 'ArchivedMailbox')) T
        WHERE appTypeId = t_apptype
		AND (dataArchGrpID > 1 OR logArchGrpID > 1) AND (subclientStatus & 65538) = 0
		AND clientId in (Select distinct clientId from @tblClientIDA )
        and App.id not in (SELECT  appId FROM  JMJobAction WITH (NOLOCK) WHERE appId > 1 AND action = 1)
        DELETE @ArchiveSubclients
        WHERE bIsArchive = 0 AND NOT EXISTS (select * from APP_SubclientProp  a WITH (NOLOCK) where attrName = 'Is Turbo Subclient' and a.componentNameId=SubclientId and a.cs_attrName = CHECKSUM(N'Is Turbo Subclient') and attrval='1' and a.modified = 0)
		-- Temp table for the Archive Mailbox list.
		DECLARE  @tblMB TABLE (clientId INT, appTypeId INT, mailbox VARCHAR(1024),apptypename varchar(1024),
		subclientname varchar(1024),clientname varchar(1024), SubClientId  int)
		INSERT  INTO @tblMB
		SELECT  DISTINCT T.clientId, T.appTypeId, CP.stringVal,IDT.name,
		APP.subclientName,dbo.GetClientName(T.clientId) , SCP.componentNameId
		FROM  @tblClientIDA T, @ArchiveSubclients APP , APP_SubClientProp SCP WITH (NOLOCK), APP_ComponentProp CP WITH (NOLOCK),
		APP_iDAType IDT WITH (NOLOCK)
		WHERE APP.clientId = T.clientId AND APP.appTypeId = T.appTypeId
        AND SCP.componentNameId = APP.SubclientId AND SCP.modified = 0 AND SCP.attrType > 100
		AND IDT.type =T.appTypeId
		AND CP.componentId = SCP.id AND CP.modified = 0
		AND CP.propertyTypeId IN (1100, 1400)
		-- ********************************************************************************
		-- ArchivedMailBox
		-- ********************************************************************************
IF ((@nCallFromReport & 0x40 >0) OR (@nCallFromReport =0 ))
			SELECT @nArchivedMailBox = COUNT(DISTINCT mailbox) From @tblMB
END
DECLARE     @tblVM TABLE (VMName VARCHAR(1024),VMSizeGB bigint, LastBackupTime datetime, IsVMArchived INT)
if (@nCallFromReport & 0x20 > 0 ) OR (@nCallFromReport & 0x400 >0 ) OR (@nCallFromReport = 0 ) OR (@nCallFromReport & 0x4000) > 0 OR (@nCallFromReport & 0x8000) > 0 OR (@nCallFromReport & 0x400000) > 0
BEGIN
	IF object_id('tempdb.dbo.#tempVMDPJobs') IS NOT null DROP TABLE #tempVMDPJobs
	CREATE TABLE #tempVMDPJobs(	VMName				nvarchar(1024),
					BackupStatus					VARCHAR(256), -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded,
					InstanceName					nvarchar(1024),
					BackupSetName					nvarchar(1024),
					SubClientName					nvarchar(1024),
					VMSizeGB						BIGINT,
					VMBackedupSizeGB				BIGINT,
					EstimatedVMDataWrittenSizeGB	BIGINT,
					LastSuccessfulBackupJobId		BIGINT,
					LastBackupTime					datetime,
					LastBackupType					VARCHAR(256),
					TotalTimeForLastBackup			BIGINT,
					clientId						INT,
					CommCellId						INT,
        			CommCellName					varchar(256),
					IsVMArchived					INT)
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpSocketDetails'))
	DROP TABLE #tmpSocketDetails
	CREATE TABLE #tmpSocketDetails(t_host VARCHAR(256), t_sockets INT, t_clientId INT)
	INSERT INTO #tempVMDPJobs EXEC VMProtectionCoverageProc -2, 0, @nUserId
	IF object_id('tempdb.dbo.#VSAVMList')  IS NOT null DROP TABLE #VSAVMList
	CREATE TABLE #VSAVMList (t2_ccId INT, t2_jobId INT, t2_VMId INT, t2_vmSize BIGINT, t2_vmUsedSpace BIGINT, t2_vmStatus INT)
	INSERT INTO #VSAVMList
	SELECT  commCellId, jobId, VMClientId, ISNULL([vmGuestSize], 0), ISNULL([vmUsedSpace], 0), CAST(ISNULL([vmStatus],-1) AS INT)
	FROM    ( SELECT clientJobId AS jobId, commcellId, VmClientId, attrName, attrVal
      FROM    APP_VMProp P WITH (NOLOCK)
      WHERE   EXISTS (select 1 from #tempVMDPJobs J INNER JOIN JMBkpStats JMB WITH (NOLOCK) ON J.LastSuccessfulBackupJobId = JMB.jobid where J.LastSuccessfulBackupJobId = P.clientJobId AND P.commCellId = JMB.commCellId AND J.clientId = P.VMClientId AND J.BackupStatus = 'Currently protected' ) ) AS VMs
	PIVOT   ( MAX(attrVal) FOR attrName IN (  [vmUsedSpace], [vmGuestSize], [vmStatus]) ) AS P
	DELETE #VSAVMList WHERE t2_vmStatus NOT IN (0,3)
	UPDATE #VSAVMList
	SET t2_vmSize   = (CASE WHEN t2_vmSize = 0 THEN t2_vmUsedSpace ELSE t2_vmSize END)
	UPDATE J
	SET VMSizeGB = CAST(ISNULL(t2_vmSize,0)/1024.0/1024.0/1024.0 as decimal(10,2))
	FROM #tempVMDPJobs J
	LEFT JOIN #VSAVMList L ON t2_jobId = J.LastSuccessfulBackupJobId AND t2_VMId = J.clientId
	MERGE #VMList AS T
	USING (SELECT DISTINCT clientId FROM #tempVMDPJobs WHERE BackupStatus = 'Currently protected') AS S
	ON T.t_VMid = S.clientId
	WHEN NOT MATCHED BY TARGET
		THEN INSERT (t_VMid, t_type) VALUES (S.clientId,200001)
	;
	IF object_id('tempdb.dbo.#tempDRVM') IS NOT null DROP TABLE #tempDRVM
	CREATE TABLE #tempDRVM (VMName nvarchar(1024),clientId INT, Jobid BIGINT)
	INSERT INTO #tempDRVM
	SELECT DISTINCT J.VMName,J.clientId,J.LastSuccessfulBackupJobId
	FROM #tempVMDPJobs J
	INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = J.clientId AND attrname ='Virtual Machine Instance UUID' AND modified = 0
	INNER JOIN APP_VSAReplication R WITH(NOLOCK) ON R.sourceGuid = CP.attrVal AND ISNULL(R.status,0) <> 6
	INNER JOIN TM_Task T WITH (NOLOCK) ON R.taskId = T.taskId AND ISNULL(T.disabled,0) <> 1
	WHERE BackupStatus = 'Currently protected'
	IF @bIsArchiveLicValid > 0
	BEGIN
		UPDATE V
		SET t_type = 100021
		FROM #VMList V
		INNER JOIN #tempVMDPJobs J ON V.t_VMid = J.clientId
		WHERE J.BackupStatus = 'Currently protected' AND J.IsVMArchived = 1
	END
	IF @bIsDRVMLicValid > 0 OR @bIsOILicValid = 0 AND @bIsVOILicValid = 0
	BEGIN
		DELETE V
		FROM #VMList V
		INNER JOIN (
					SELECT T.clientId FROM #tempDRVM T
					INNER JOIN JMBkpStats JMB WITH(NOLOCK) ON JMB.jobId = T.JobId
					INNER JOIN archGroupCopy AG WITH(NOLOCK) ON AG.archGroupId = JMB.dataArchGrpId
					INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
					GROUP BY T.clientId
HAVING max(AGR.retentionDays)<=14
					) DR ON V.t_VMid = DR.clientId
	END
	IF @bIsDRVMLicValid > 0 OR @bIsVMProtectedLicValid = 0
	BEGIN
		DELETE V
		FROM #tempVMDPJobs V
		INNER JOIN (
					SELECT T.clientid,T.JobId FROM #tempDRVM T
					INNER JOIN JMBkpStats JMB WITH(NOLOCK) ON JMB.jobId = T.JobId
					INNER JOIN archGroupCopy AG WITH(NOLOCK) ON AG.archGroupId = JMB.dataArchGrpId
					INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
					GROUP BY T.clientid,T.JobId
HAVING max(AGR.retentionDays)<=14
				   ) D ON D.clientid = V.clientid AND V.LastSuccessfulBackupJobId = D.JobId
	END
IF ((@nCallFromReport & 0x400000) > 0 OR @nCallFromReport = 0)
	BEGIN
		SELECT @nDRVM = count(distinct vmname) from #tempDRVM
		SET @DRVMXML = (SELECT vmname as DRVMName FROM #tempDRVM
								FOR XML PATH('DRVMList'), ROOT('DRVM') )
	END
	IF @nOrganizationDetails > 0
	BEGIN
		--VM calculation
		DELETE FROM #tempVMDPJobs WHERE BackupStatus <> 'Currently protected'
		UPDATE T SET T.vmcount = B.vmcount
		FROM #Companies T JOIN
		(SELECT t_companyId,COUNT(DISTINCT VMName) vmcount FROM #tempVMDPJobs A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId AND IsVMArchived = 0 GROUP BY t_companyId ) B
		ON T.id = B.t_companyId
		--Socket calculation
		UPDATE T SET T.socketcount = C.sockets
		FROM #Companies T JOIN
		(SELECT B.t_companyId,SUM(socket) AS sockets FROM
		(SELECT t_companyId,t_host,MAX(t_sockets) socket FROM #tmpSocketDetails A JOIN #CompanyClientMap B ON A.t_clientId = B.t_clientId GROUP BY t_companyId, t_host ) B
		GROUP BY t_companyId) C ON T.id = C.t_companyId
	END
	ELSE
	BEGIN
if ((@nCallFromReport & 0x20 >0 ) OR @nCallFromReport = 0 )
			BEGIN
			INSERT INTO @tblVM select VMName,VMSizeGB,dbo.utctocelllocaltime(LastBackupTime, 2), IsVMArchived from #tempVMDPJobs WHERE BackupStatus = 'Currently protected'
			DECLARE @NormalVMCount INT = 0
			DECLARE @ArchivedVMCount INT = 0
			SELECT  @NormalVMCount = count(distinct vmname) from @tblVM WHERE IsVMArchived = 0   --PROTECTED VM:
			SELECT  @ArchivedVMCount = count(distinct vmname) from @tblVM WHERE IsVMArchived = 1   	--ARCHIVED VM:
			IF @bIsArchiveLicValid > 0
			BEGIN
				SET  @nProtectedVM = @NormalVMCount   --PROTECTED VM:
				SET  @nArchivedVM = @ArchivedVMCount   	--ARCHIVED VM:
			END
			ELSE
				SET  @nProtectedVM = @NormalVMCount + @ArchivedVMCount
		END
if ((@nCallFromReport & 0x400 >0 ) OR @nCallFromReport = 0)
		BEGIN
			SELECT @nVMSocket = SUM(t_sockets) FROM
			(SELECT MAX(t_sockets) AS t_sockets FROM #tmpSocketDetails GROUP BY t_host) A
			SET @socketXML = (SELECT t_host as VMName , MAX(t_sockets) as SocketCount FROM #tmpSocketDetails GROUP BY t_host
								FOR XML PATH('VMList'), ROOT('VMSockets') )
		END
	END
	DROP TABLE #tmpSocketDetails
	DROP TABLE #VSAVMList
	DROP TABLE #tempVMDPJobs
	DROP TABLE #tempDRVM
END
if (@nCallFromReport =0)
BEGIN
      --ProtectedClient
      INSERT INTO @TempAppTypes
      SELECT TYPE,name,'ProtectedClient' FROM APP_iDAType WITH (NOLOCK) WHERE displayName IN
                        ('File System','NAS','OES File System',
                        'Workstation Backup','ProxyHost','Image Level','Image Level on Unix','Image Level ProxyHost',
                        'Image Level ProxyHost on Unix','NDMP Remote Tape Server','NAS Restore Enabler')       AND TYPE <1000
      --ArchivedClient
      INSERT INTO @TempAppTypes
      select TYPE,name,'ArchivedClient' from APP_iDAType WITH (NOLOCK)  where name like '%Archiver%' AND name NOT LIKE '%Exchange%' AND name NOT LIKE '%Mailbox%'  AND TYPE <1000
      --SRMClient
      INSERT INTO @TempAppTypes
      select TYPE,name,'SRMClient' from APP_iDAType WITH (NOLOCK)  where name LIKE 'SRM %' and type <1000
      --CIServer
      INSERT INTO @TempAppTypes
      select TYPE,name,'CIServer' from APP_iDAType WITH (NOLOCK)   where name like 'Content Index Server'
      --AdvSearchNodes
      INSERT INTO @TempAppTypes
      select TYPE,name,'AdvSearchNodes' from APP_iDAType  where name ='Compliance Director'
      --******************************************************************************
      DECLARE     @tblCI TABLE (clientId INT, appTypeId INT, appId INT)
      INSERT      INTO @tblCI
                                SELECT      DISTINCT APP.clientId, APP.appTypeId, APP.id
                                FROM
                                APP_Application APP WITH (NOLOCK), APP_ClientProp CP WITH (NOLOCK)
                                                  WHERE
                                                            APP.dataArchGrpID IN (SELECT archGroupId FROM archContentIndexingRules WITH (NOLOCK) WHERE enabled = 1)
                                                            AND CP.componentNameId = APP.clientId AND CP.attrName = 'Content Indexing Enabled' AND CP.attrVal = '1' AND CP.modified = 0
      SELECT
                        @nProtectedClient = COUNT(DISTINCT clientId)
                                FROM  @tblClientIDA
                                WHERE
                                appTypeId IN ( SELECT t_apptype from @TempAppTypes where fname='ProtectedClient')
      --ArchivedClient
      SELECT
              @nArchivedClient = COUNT(DISTINCT clientId)
                        FROM  @tblClientIDA
                        WHERE appTypeId IN( SELECT t_apptype from @TempAppTypes where fname='ArchivedClient')
      --SRMClient
      SELECT
                        @nSRMClient = COUNT(DISTINCT clientId)
                        FROM  @tblClientIDA
                        WHERE appTypeId IN (SELECT t_apptype from @TempAppTypes where fname='SRMClient'      )
      --CIServer
      SELECT
                        @nCIServer = COUNT(*)
                        FROM  @tblClientIDA
                        WHERE appTypeId IN (SELECT t_apptype from @TempAppTypes where fname='CIServer' )
      --AdvSearchNodes
      SELECT
                        @nAdvSearchNodes = COUNT(*)
                        FROM  @tblClientIDA
                        WHERE appTypeId IN (SELECT t_apptype from @TempAppTypes where fname='AdvSearchNodes')
      --SearchMailBox
		IF @nUserId > 1 --SECURITY
		BEGIN
			delete @tblCI
			where ClientId not in (select clientId from #LicCalUserObj where clientId > 0)
		END
      SELECT
                        @nSearchMailBox = COUNT(DISTINCT CP.stringVal)
                        FROM  @tblCI CI, APP_SubClientProp SCP WITH (NOLOCK), APP_ComponentProp CP WITH (NOLOCK)
                        WHERE SCP.componentNameId = CI.appId AND SCP.modified = 0
                        AND CP.componentId = SCP.id AND CP.modified = 0
                        AND CP.propertyTypeId IN (1100, 1400)
      -- Detailed report for the mailvbox, VM
if (((@nDetailedReportFor & 0x40 >0 )  OR (@nDetailedReportFor & 0x80 >0 ) )  AND (@nCallFromReport =0 ))
		BEGIN
IF (@nDetailedReportFor & 0x40 >0)
			   SELECT @MailBoxXML =(
				SELECT distinct
				dbo.NormalizeForXML(mailbox) as '@SMTP', apptypename as '@Apptype', subclientname  as '@SubClientName',
				clientname  as '@ClientName'
				FROM @tblMB FOR XML PATH('mailBoxList'), ROOT('MailBoxes'))
IF ((@nDetailedReportFor & 0x80 >0))
				BEGIN
					IF @bIsArchiveLicValid > 0
					BEGIN
						SELECT @VMXML =(
						SELECT distinct VMNAME as '@VMName',
						isnull(VMSizeGB,0)  as '@VMSize',
						--'@LastBackupTime'  = CONVERT(VARCHAR, convert(datetime, LastBackupTime, 120),20)
						'@LastBackupTime'  =  CASE DBO.GetUNIXTime(LastBackupTime) WHEN 0 THEN NULL ELSE CONVERT(VARCHAR, LastBackupTime, 20) END
						FROM @tblVM  WHERE IsVMArchived = 0 ORDER BY VMNAME FOR XML PATH('VMList'), ROOT('VMs'))
						SELECT @ArchivedVMXML =(
						SELECT distinct VMNAME as '@VMName',
						isnull(VMSizeGB,0)  as '@VMSize',
						--'@LastBackupTime'  = CONVERT(VARCHAR, convert(datetime, LastBackupTime, 120),20)
						'@LastBackupTime'  =  CASE DBO.GetUNIXTime(LastBackupTime) WHEN 0 THEN NULL ELSE CONVERT(VARCHAR, LastBackupTime, 20) END
						FROM @tblVM  WHERE IsVMArchived = 1 ORDER BY VMNAME FOR XML PATH('VMList'), ROOT('VMs'))
					END
					ELSE
						SELECT @VMXML =(
						SELECT distinct VMNAME as '@VMName',
						isnull(VMSizeGB,0)  as '@VMSize',
						--'@LastBackupTime'  = CONVERT(VARCHAR, convert(datetime, LastBackupTime, 120),20)
						'@LastBackupTime'  =  CASE DBO.GetUNIXTime(LastBackupTime) WHEN 0 THEN NULL ELSE CONVERT(VARCHAR, LastBackupTime, 20) END
						FROM @tblVM  ORDER BY VMNAME FOR XML PATH('VMList'), ROOT('VMs'))
				END
		END
END
IF ((@nCallFromReport & 0x80 >0) OR (@nCallFromReport =0 ) OR (@nDetailedReportFor & 0x200 >0))
		-- ********************************************************************************
		-- CONTEXT INDEXED OBJECT USAGE CHECK -----
		-- ********************************************************************************
	BEGIN
		DECLARE @TblAppGetFastServerList TABLE
			(
			  ServerName        VARCHAR(1024),
			  ClientId          VARCHAR(1024),
			  ClientName        VARCHAR(1024),
			  CloudId           VARCHAR(1024),
			  HostName          VARCHAR(1024),
			  BasePort          VARCHAR(1024),
			  Version           VARCHAR(1024),
			  EngineName        VARCHAR(1024),
			  serverType		INT
			)
			insert into @TblAppGetFastServerList exec AppGetFastServerList
			--filter out replicated search enigne
			delete @TblAppGetFastServerList
where CloudId in (select longVal from app_componentprop (nolock) where propertyTypeId = 1039 and componentType = 2 )
			IF @nUserId > 1 --SECURITY
			BEGIN
				delete @TblAppGetFastServerList
				where ClientId not in (select clientId from #LicCalUserObj where clientId > 0)
			END
			select @nContentIndexedObject = SUM(longlongVal) from APP_ComponentProp WITH (NOLOCK) where
			(componentId in( select distinct cloudId from @TblAppGetFastServerList where Version not like '%Solr%') OR componentId in (2039))
AND propertyTypeId = 1002 and modified =0
			if EXISTS ( select distinct cloudId from @TblAppGetFastServerList where Version like '%Solr%' )
			begin
				select
					@nContentIndexedObject = ISNULL(@nContentIndexedObject,0) + SUM(CollectionSize) + SUM(failedItems)
				from
					DM2SearchServerCoreInfo WITH (NOLOCK)
				where
((CoreRoles & 8 = 8) OR (CoreRoles & 16 = 16))
					AND CLOUDID IN (select distinct cloudId from @TblAppGetFastServerList where Version like '%Solr%')
AND cloudType =3
			end
			--9.0 Count into a temp table.
IF (@nDetailedReportFor & 0x200 >0) --CI Engine
			BEGIN
				DECLARE @SearchEngineList TABLE
				(
				  EngineName        VARCHAR(MAX),
				  CICount          	bigint,
				  CloudId			VARCHAR(1024)
				)
				--9.0 count...
				--Updating CICount, CloudId
				insert into @SearchEngineList
				select '',SUM(longlongVal),componentId from APP_ComponentProp WITH (NOLOCK) where
				(componentId in( select distinct cloudId from @TblAppGetFastServerList where Version not like '%Solr%') OR componentId in (2039))
AND propertyTypeId = 1002 and modified =0 group by componentId
				 --Updating Search engine name
				UPDATE	@SearchEngineList
				set	 EngineName     = ISNULL((SELECT DISTINCT EngineName FROM  @TblAppGetFastServerList mainlist where list.CloudId = mainlist.CloudId),0)
				FROM	@SearchEngineList list
				--10.0 count...
				insert into @SearchEngineList(EngineName,  CICount)
				select
					ISNULL(StringVal, ''), SUM(ISNULL(CollectionSize,0)) + SUM(ISNULL(failedItems,0)) as Total
				from
					DM2SearchServerCoreInfo A WITH (NOLOCK)
				inner join
					APP_ComponentProp B WITH (NOLOCK)
				on
					B.id = A.CloudId
				where
((A.CoreRoles & 8 = 8) OR (A.CoreRoles & 16 = 16))
AND cloudType =3
				group by
					ISNULL(StringVal, '')
				SELECT @CIEngineXML =(
				SELECT EngineName AS '@CIEngineName', CICount as '@CICount' FROM @SearchEngineList FOR XML PATH('CIEngineList'), ROOT('CIEngine')
				)
			END
	END
IF @nCallFromReport = 0 OR (@nDetailedReportFor & 0x800) >0
BEGIN
	IF object_id('tempdb.dbo.#tempEndPointUsers') IS NOT null DROP TABLE #tempEndPointUsers
	CREATE TABLE #tempEndPointUsers(userId INT,
					userName NVARCHAR(1024),
					userLogin NVARCHAR(1024),
					userEmail NVARCHAR(1024),
					userType INT,
					reportName NVARCHAR(1024),
					associationType NVARCHAR(MAX),
					clientId INT)
	INSERT INTO #tempEndPointUsers
	EXEC RptEndPointUserDetails 2,@nUserId,@nOrganizationDetails
	IF @nOrganizationDetails > 0
	BEGIN
		UPDATE T SET T.epUsers = B.usercount
		FROM #Companies T JOIN
		(SELECT t_companyId,COUNT(distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
		ON T.id = B.t_companyId
	END
	ELSE
	BEGIN
		SET @nEpUsers = (SELECT count(*) FROM #tempEndPointUsers)
		SET @epUserXML = (SELECT userName, userLogin, userEmail, associationType FROM #tempEndPointUsers FOR XML PATH('userList'), ROOT('EndPointUserInfo'))
	END
	DELETE #tempEndPointUsers
	INSERT INTO #tempEndPointUsers
	EXEC RptEndPointUserDetails 1,@nUserId,@nOrganizationDetails
	IF @nOrganizationDetails > 0
	BEGIN
		UPDATE T SET T.epSharingUsers = B.usercount
		FROM #Companies T JOIN
		(SELECT t_companyId,COUNT( distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
		ON T.id = B.t_companyId
	END
	ELSE
	BEGIN
		SET @nEpSharingUsers = (SELECT count(*) FROM #tempEndPointUsers)
		SET @epSharingUserXML = (SELECT userName, userLogin, userEmail, associationType FROM #tempEndPointUsers FOR XML PATH('userList'), ROOT('EndPointUserInfo'))
	END
	DELETE #tempEndPointUsers
	INSERT INTO #tempEndPointUsers
	EXEC RptEndPointUserDetails 3,@nUserId,@nOrganizationDetails
	IF @nOrganizationDetails > 0
	BEGIN
		UPDATE T SET T.epDiscoveryUsers = B.usercount
		FROM #Companies T JOIN
		(SELECT t_companyId,COUNT(distinct userId) usercount FROM #tempEndPointUsers A JOIN #CompanyClientMap B ON A.clientId = B.t_clientId GROUP BY t_companyId ) B
		ON T.id = B.t_companyId
	END
	ELSE
	BEGIN
		SET @nEpEdiscoveryUsers = (SELECT count(*) FROM #tempEndPointUsers)
		SET @epEdiscoveryUserXML = (SELECT userName, userLogin, userEmail, associationType FROM #tempEndPointUsers FOR XML PATH('userList'), ROOT('EndPointUserInfo'))
	END
	DROP TABLE #tempEndPointUsers
END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x800) >0 OR (@nDetailedReportFor & 0x2000) >0 OR (@nCallFromReport & 0x4000) > 0 OR (@nCallFromReport & 0x8000) > 0
BEGIN
	DECLARE @t_id INT
	DECLARE @t_name VARCHAR(MAX)
	IF object_id('tempdb.dbo.#tempVMsWithIdNamePkgName') IS NOT null DROP TABLE #tempVMsWithIdNamePkgName
CREATE TABLE #tempVMsWithIdNamePkgName(t_Id INT, t_Name NVARCHAR(255), t_pkgName VARCHAR(MAX))
	EXEC LicGetVMAppcalss1 '#tempVMsWithIdNamePkgName'
	DECLARE @bIsMsimValid INT = 0
	IF @isLicInherited > 0
	BEGIN
SELECT @bIsMsimValid = @licAppliedStatus&0x80
	END
	ELSE
		EXEC LicIsLicenseValid 100028, @bIsMsimValid OUTPUT
	IF @bIsMsimValid > 0
	BEGIN
		IF object_id('tempdb.dbo.#tmpO365SharePointClients') IS NOT null DROP TABLE #tmpO365SharePointClients
		CREATE TABLE #tmpO365SharePointClients (clientid INT)
		EXEC LicGetO365Sharepoint '#tmpO365SharePointClients'
		DELETE #tempVMsWithIdNamePkgName FROM #tmpO365SharePointClients WHERE  t_Id = clientid
		DROP TABLE #tmpO365SharePointClients
	END
	IF @nUserId > 1 --SECURITY
	BEGIN
		delete #tempVMsWithIdNamePkgName
		where t_Id not in (select clientId from #LicCalUserObj where clientId > 0)
	END
	MERGE #VMList AS T
	USING (SELECT DISTINCT t_Id FROM #tempVMsWithIdNamePkgName) AS S
	ON T.t_VMid = S.t_Id
	WHEN MATCHED
		THEN Update	SET T.t_type = 200003
	WHEN NOT MATCHED BY TARGET
		THEN INSERT (t_VMid,t_type) VALUES (S.t_Id,100027)
	;
	DECLARE ClientsWithMultiplePkgs CURSOR FOR SELECT t_Id FROM #tempVMsWithIdNamePkgName GROUP BY t_id HAVING count(*) > 1
	OPEN ClientsWithMultiplePkgs FETCH FROM ClientsWithMultiplePkgs INTO @t_id
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @t_name = ''
		SELECT @t_name = @t_name + (CASE LEN(@t_name) WHEN 0 THEN '' ELSE ',' END) + t_pkgName FROM #tempVMsWithIdNamePkgName WHERE t_id = @t_id
		UPDATE #tempVMsWithIdNamePkgName SET t_pkgName = @t_name WHERE t_id = @t_id
		FETCH FROM ClientsWithMultiplePkgs INTO @t_id
	END
	CLOSE ClientsWithMultiplePkgs
	DEALLOCATE ClientsWithMultiplePkgs
	SET @nVMWithAppClass1Pkg =	(SELECT count(DISTINCT t_Id) FROM #tempVMsWithIdNamePkgName)
	SET @VMWithAppClass1PkgXML =	(SELECT name=t_Name, packages=MAX(t_pkgName)
					 FROM #tempVMsWithIdNamePkgName T1 GROUP BY t_id, t_Name FOR XML PATH('vmInfo'), ROOT('VMWithAppClass1Packages'))
	DROP TABLE #tempVMsWithIdNamePkgName
END
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#msimCountTable'))
DROP TABLE #msimCountTable
CREATE TABLE #msimCountTable (clientId INT, appTypeId INT, mailbox NVARCHAR(448), mailboxGUID VARCHAR(512), apptypename NVARCHAR(1024), subclientname NVARCHAR(1024), clientname NVARCHAR(1024), subClientId int, instance int,isCIEnabled int)
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x1000) >0 OR (@nDetailedReportFor & 0x4000) >0 OR (@nCallFromReport & 0x4000) > 0 OR (@nCallFromReport & 0x8000) > 0
BEGIN
	--declare @mSimDetailReport integer = (@nDetailedReportFor & 0x4000)
	EXEC LicGetMSimUserCountV2 1,@nUserId, @nMSimUsers OUTPUT, @MSimUsersXML OUTPUT
END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x4000) > 0 OR (@nCallFromReport & 0x8000) > 0
BEGIN
	DECLARE @isOIValid					INT = 0
	DECLARE @isVOIValid					INT = 0
	IF object_id('tempdb.dbo.#templic') IS NOT null DROP TABLE #templic
	CREATE TABLE #templic(t_cid int, t_lictype int, t_isVM int default 0)
	INSERT INTO #templic
	SELECT cid, LicType,0 FROM LicUsage WITH (NOLOCK) WHERE OpType = 'Install' AND LicType in (1,2,3,16,17,25,127) AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE())
	UNION --include Openstack pseudo client
	SELECT DISTINCT C.id, 100032, 0
	FROM APP_Client C WITH (NOLOCK)
	INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.clientId = C.id AND (APP.subclientStatus & 6) = 0
	INNER JOIN APP_iDAName IDA WITH (NOLOCK) ON IDA.clientId = APP.clientId AND (iDA.Status & 6) = 0
	INNER JOIN APP_InstanceProp Prop WITH (NOLOCK) ON APP.instance = Prop.componentNameId AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0 AND attrVal ='15'
	IF object_id('tempdb.dbo.#tempVMToPMList') IS NOT null DROP TABLE #tempVMToPMList
	CREATE TABLE #tempVMToPMList(appTypeId INT,pseudoClientId INT,physClientId INT)
	EXEC LicGetVMToPMList
	IF object_id('tempdb.dbo.#tempCluster') IS NOT null DROP TABLE #tempCluster
	CREATE TABLE #tempCluster(t_VMClientId int, t_PMClientId int, t_Lictype int)
	INSERT INTO #tempCluster
	SELECT DISTINCT pseudoClientId, physClientId, U.LicType
	FROM #tempVMToPMList V
	INNER JOIN #templic T ON V.pseudoClientId = T.t_cid
	INNER JOIN LicUsage U WITH (NOLOCK) ON U.cid = V.physClientId AND LicType in (1,2,3,16,17,25,127)
	UNION --add physical nodes which do not consume app class agent licenses due to ACV
	SELECT DISTINCT pseudoClientId, physClientId, T.t_Lictype
	FROM #tempVMToPMList V
	INNER JOIN #templic T ON V.pseudoClientId = T.t_cid
	INNER JOIN APP_IDAName Ida WITH (NOLOCK) ON Ida.clientId = V.physClientId
	INNER JOIN simAppTypeLicTypeMap Map WITH (NOLOCK) ON Map.appTypeId = Ida.appTypeId AND Map.simLicAppType = T.t_Lictype
	WHERE T.t_Lictype in (3,16,17)
	DELETE T
	FROM #templic T
	INNER JOIN #tempCluster C ON T.t_cid = C.t_PMClientId OR T.t_cid = C.t_VMClientId
	INSERT INTO #templic
	SELECT DISTINCT t_PMClientId, t_Lictype, 0
	FROM #tempCluster
	--Exclude commserve DR nodes
	DELETE T
	FROM #templic T
	INNER JOIN SimInstalledPackages P WITH (NOLOCK) ON T.t_cid = P.clientid AND P.simpackageid = 24
	INNER JOIN App_application APP WITH (NOLOCK) ON APP.clientId = T.t_cid AND APP.appTypeId = 81
	IF object_id('tempdb.dbo.#tmpValidLictypes') IS NOT null DROP TABLE #tmpValidLictypes
	CREATE TABLE #tmpValidLictypes (LicType INT)
	EXEC LicCheckOIStatus '#tmpValidLictypes', 0, 0, @isOIValid OUTPUT, @isVOIValid OUTPUT
	IF NOT EXISTS (SELECT 1 FROM #tmpValidLictypes WHERE LicType = 100028)
	BEGIN
		DELETE #templic
		FROM #msimCountTable
		WHERE t_cid = clientId
	END
	UPDATE T
	SET t_isVM = 1
	FROM #templic T
	INNER JOIN (SELECT DISTINCT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Machine GUID' and modified = 0) C ON T.t_cid = C.componentNameId
	MERGE #VMList AS T
	USING (SELECT DISTINCT t_cid FROM #templic WHERE t_isVM = 1) AS S
	ON T.t_VMid = S.t_cid
	WHEN NOT MATCHED BY TARGET
	THEN INSERT (t_VMid,t_type) VALUES (S.t_cid, 100033)
	;
	DELETE #VMList WHERE t_type <> 100033 AND t_type NOT IN (SELECT LicType From #tmpValidLictypes)
	SELECT @nVOIUsers = count(DISTINCT t_VMid) FROM #VMList
	SELECT @VOIUsersXML =(
						SELECT distinct name as '@VOIUserName'
						FROM #VMList
						INNER JOIN APP_Client C WITH (NOLOCK) ON t_VMid = C.id
						ORDER BY name FOR XML PATH('VOIUserList'), ROOT('VOIUsers'))
	IF OBJECT_ID('tempdb.dbo.#tempClientOwners') IS NOT NULL DROP TABLE #tempClientOwners
	CREATE TABLE #tempClientOwners (clientId INT, userId INT, PRIMARY KEY(clientId, userId))
	INSERT INTO #tempClientOwners(clientId, userId)
	SELECT DISTINCT clientId, userId FROM dbo.sec_getClientOwners(1) WHERE userId <> 0
	IF NOT EXISTS (SELECT 1 FROM #tmpValidLictypes WHERE LicType = 200020)
	BEGIN
		DELETE #templic
		FROM (	SELECT DISTINCT t_cid AS cid FROM #templic
				INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = t_cid
				WHERE t_lictype = 2 OR C.status & 4096 = 4096 AND C.status & 2 <> 2) L
		INNER JOIN #tempClientOwners O ON L.cid = O.clientId
		WHERE t_cid = cid
	END
	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails
	(
		[InstanceId] INT,
		[ClientId] INT,
		[IdaType] INT,
		[DbName] NVARCHAR(255)
		PRIMARY KEY([InstanceId],[ClientId],[DbName])
	)
	--	EXEC LicGetDBDatabaseList
	DECLARE @nDbInstance    INT = 0
	SELECT @nDbInstance = ISNULL(sum(S.counts),0)
	FROM (SELECT ClientId, count(distinct DbName) AS counts FROM #ClientInstanceDetails GROUP BY ClientId) S
	SELECT @nOIUsers = count(DISTINCT t_cid) FROM #templic WHERE t_isVM = 0
	SET @nOIUsers = @nOIUsers + @nDbInstance
	SELECT @OIUsersXML = (SELECT sub.name as '@OIUserName', sum(sub.counts) as '@OICount' FROM
							(
								SELECT distinct name, 1 as counts
								FROM #templic
								INNER JOIN APP_Client C WITH (NOLOCK) ON t_cid = C.id
								WHERE t_isVM = 0
								UNION ALL
								SELECT name, count(distinct DbName) as counts
								FROM #ClientInstanceDetails I
								INNER JOIN APP_Client C WITH (NOLOCK) ON I.clientid = C.id
								GROUP BY name
							)sub
						 GROUP BY sub.name
						 ORDER BY sub.name
						 FOR XML PATH('OIUserList'), ROOT('OIUsers'))
	IF @isOIValid > 0 AND @isVOIValid = 0
	BEGIN
		DELETE #templic WHERE t_isVM = 1
		INSERT INTO #templic SELECT DISTINCT t_VMid,100033,1 FROM #VMList
		SET @nOIUsers = @nOIUsers + @nVOIUsers
		SET @nVOIUsers = 0
		SELECT @OIUsersXML = (SELECT sub.name as '@OIUserName', sum(sub.counts) as '@OICount' FROM
								(
									SELECT distinct name, 1 as counts
									FROM #templic
									INNER JOIN APP_Client C WITH (NOLOCK) ON t_cid = C.id
									UNION ALL
									SELECT name, count(distinct DbName) as counts
									FROM #ClientInstanceDetails I
									INNER JOIN APP_Client C WITH (NOLOCK) ON I.clientid = C.id
									GROUP BY name
								)sub
							 GROUP BY sub.name
							 ORDER BY sub.name
							 FOR XML PATH('OIUserList'), ROOT('OIUsers'))
	END
	ELSE IF @isOIValid > 0 AND @isVOIValid > 0 AND @nVOIUsers > 0
	BEGIN
		DECLARE @nVOIToOI INT = 0
		EXEC LicVOIToOI @nVOIUsers, @nOIUsers, @nVOIToOI OUTPUT
		IF @nVOIToOI > 0
		BEGIN
			SET @nVOIUsers = @nVOIUsers - @nVOIToOI
			SET @nOIUsers = @nOIUsers + @nVOIToOI
		END
	END
	DROP TABLE #tmpValidLictypes
	DROP TABLE #templic
	DROP TABLE #tempClientOwners
	DROP TABLE #tempCluster
	DROP TABLE #tempVMToPMList
	DROP TABLE #ClientInstanceDetails
END
--Activate Licenses
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x10000) > 0 OR (@nCallFromReport & 0x20000) > 0 OR (@nCallFromReport & 0x40000) > 0
OR (@nCallFromReport & 0x80000) > 0 OR (@nCallFromReport & 0x100000) > 0 OR (@nCallFromReport & 0x200000) > 0
BEGIN
	SET @nActEDisFilesMB = 0
	SET @nActEDisECApps = 0
	SET @nActSensDataFilesMB = 0
	SET @nActSensDataECApps = 0
	SET @nFileStoreOptMB =  0
	SET @nActSuite = 0
	IF object_id('tempdb.dbo.#tmpActivateUsage') IS NOT NULL
	DROP TABLE #tmpActivateUsage
	IF object_id('tempdb.dbo.#tmpActivateEmailUsage') IS NOT NULL
	DROP TABLE #tmpActivateEmailUsage
	CREATE TABLE #tmpActivateUsage (LicType INT, ClientId INT, TotalCounts BIGINT)
	CREATE TABLE #tmpActivateEmailUsage (LicType INT, ClientId INT, SMTP NVARCHAR(512), Org NVARCHAR(1024), OrgGUID uniqueidentifier)
	EXEC LicGetActivates
	SELECT @nActEDisFilesMB = ISNULL(SUM(TotalCounts),0) FROM #tmpActivateUsage WHERE LicType = 100034
	SELECT @ActEDisFilesMBXML = (
						SELECT C.name AS '@ActEDisFilesName', ISNULL(TotalCounts,0) AS '@ActEDisFilesCounts'
						FROM #tmpActivateUsage A
						INNER JOIN APP_Client C WITH (NOLOCK) ON A.ClientId = C.id
						WHERE A.LicType = 100034
						ORDER BY name FOR XML PATH('ActEDisFilesList'), ROOT('ActEDisFiles'))
	SELECT @nActEDisECApps =  ISNULL(SUM(TotalCounts),0)
							  FROM (SELECT COUNT(DISTINCT SMTP) AS TotalCounts
									FROM #tmpActivateEmailUsage
									WHERE LicType = 100035
									GROUP BY OrgGUID, Org) S
	SELECT @ActEDisECAppsXML = (
						SELECT ISNULL(Org,'N/A') AS '@ActEDisECAppsName', COUNT(DISTINCT SMTP) AS '@ActEDisECAppsCounts'
						FROM #tmpActivateEmailUsage
						WHERE LicType = 100035
						GROUP BY OrgGUID, Org
						ORDER BY Org FOR XML PATH('ActEDisECAppsList'), ROOT('ActEDisECApps'))
	SELECT @nActSensDataFilesMB = ISNULL(SUM(TotalCounts),0) FROM #tmpActivateUsage WHERE LicType = 100036
	SELECT @ActSensDataFilesMBXML = (
						SELECT C.name AS '@ActSensDataFilesName', ISNULL(TotalCounts,0) AS '@ActSensDataFilesCounts'
						FROM #tmpActivateUsage A
						INNER JOIN APP_Client C WITH (NOLOCK) ON A.ClientId = C.id
						WHERE A.LicType = 100036
						ORDER BY name FOR XML PATH('ActSensDataFilesList'), ROOT('ActSensDataFiles'))
	SELECT @nActSensDataECApps = ISNULL(SUM(TotalCounts),0)
							     FROM (SELECT COUNT(DISTINCT SMTP) AS TotalCounts
									   FROM #tmpActivateEmailUsage
									   WHERE LicType = 100037
									   GROUP BY OrgGUID, Org) S
	SELECT @ActSensDataECAppsXML = (
						SELECT ISNULL(Org,'N/A') AS '@ActSensDataECAppsName', COUNT(DISTINCT SMTP) AS '@ActSensDataECAppsCounts'
						FROM #tmpActivateEmailUsage
						WHERE LicType = 100037
						GROUP BY OrgGUID, Org
						ORDER BY Org FOR XML PATH('ActSensDataECAppsList'), ROOT('ActSensDataECApps'))
	SELECT @nFileStoreOptMB = ISNULL(SUM(TotalCounts),0) FROM #tmpActivateUsage WHERE LicType = 100038
	SELECT @FileStoreOptMBXML = (
						SELECT C.name AS '@FileStoreOptName', ISNULL(TotalCounts,0) AS '@FileStoreOptCounts'
						FROM #tmpActivateUsage A
						INNER JOIN APP_Client C WITH (NOLOCK) ON A.ClientId = C.id
						WHERE A.LicType = 100038
						ORDER BY name FOR XML PATH('FileStoreOptList'), ROOT('FileStoreOpt'))
	DROP TABLE #tmpActivateUsage
	DROP TABLE #tmpActivateEmailUsage
END
--Metallic storage license
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x800000) > 0
OR (@nCallFromReport & 0x1000000) > 0
OR (@nCallFromReport & 0x2000000) > 0
OR (@nCallFromReport & 0x4000000) > 0
OR (@nCallFromReport & 0x8000000) > 0
OR (@nCallFromReport & 0x10000000) > 0
OR (@nCallFromReport & 0x20000000) > 0
OR (@nCallFromReport & 0x40000000) > 0
OR (@nCallFromReport & 0x80000000) > 0
OR (@nCallFromReport & 0x100000000) > 0
BEGIN
	SET @nMetallicStoreMB = 0
	SET @nMetallicStoreT2MB		= 0
	SET @nMetallicStoreT3MB		= 0
	SET @nMetallicStoreT4MB		= 0
	SET @nMetallicStoreT5MB		= 0
	SET @nMetallicStoreT6MB		= 0
	SET @nMetallicStoreT7MB		= 0
	SET @nMetallicStoreT8MB		= 0
	SET @nMetallicStoreT9MB		= 0
	SET @nMetallicStoreT10MB	= 0
	IF OBJECT_ID('tempdb.dbo.#tempMetallicStorageUsageByContainer') IS NOT NULL DROP TABLE #tempMetallicStorageUsageByContainer
	CREATE TABLE #tempMetallicStorageUsageByContainer
	(
	   licenseType		  INT,
	   usageType		  INT,
	   deviceId           INT,
	   storagepoolId      INT,
	   storagePoolName    NVARCHAR(144),
	   container	      VARCHAR(64),
	   usedSpace	      BIGINT
	 )
	exec Lic_GetMetallicStorageUsageByContainer 0
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x800000) > 0
	BEGIN
		SELECT @nMetallicStoreMB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100041
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x1000000) > 0
	BEGIN
		SELECT @nMetallicStoreT2MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100042
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x2000000) > 0
	BEGIN
		SELECT @nMetallicStoreT3MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100043
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x4000000) > 0
	BEGIN
		SELECT @nMetallicStoreT4MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100044
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x8000000) > 0
	BEGIN
		SELECT @nMetallicStoreT5MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100045
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x10000000) > 0
	BEGIN
		SELECT @nMetallicStoreT6MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100046
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x20000000) > 0
	BEGIN
		SELECT @nMetallicStoreT7MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100047
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x40000000) > 0
	BEGIN
		SELECT @nMetallicStoreT8MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100048
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x80000000) > 0
	BEGIN
		SELECT @nMetallicStoreT9MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100049
	END
IF @nCallFromReport = 0 OR (@nCallFromReport & 0x100000000) > 0
	BEGIN
		SELECT @nMetallicStoreT10MB = ISNULL(SUM(usedSpace),0) FROM #tempMetallicStorageUsageByContainer WHERE licenseType = 100050
	END
	drop table #tempMetallicStorageUsageByContainer
END
--
DECLARE @temp_lic1 table(t_cid int, t_lictype int)
INSERT INTO @temp_lic1
SELECT cid, LicType FROM LicUsage WHERE OpType = 'Install' AND LicType < 1000 AND (Eval = 0 OR ExpiryDateUTC > GETUTCDATE())
SELECT @ApplicationServer = count(DISTINCT t_cid) FROM @temp_lic1 where t_lictype IN (3,16,17)
DELETE @temp_lic1 WHERE t_lictype IN (SELECT id FROM simLicAppTypeV2 WHERE groupId IN (1,7,14,15))
DELETE A
FROM @temp_lic1 A join
	(SELECT t_cid as cid FROM @temp_lic1 GROUP BY t_cid HAVING count(t_lictype) > 1) B
	ON A.t_cid = b.cid
DELETE @temp_lic1 WHERE t_lictype NOT IN (1,2)
SELECT @FSOnlyServer = count(DISTINCT t_cid) FROM @temp_lic1
IF object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL DROP TABLE #LicCalUserObj
IF object_id('tempdb.dbo.#CompanyClientMap') IS NOT NULL DROP TABLE #CompanyClientMap
IF object_id('tempdb.dbo.#VMList') IS NOT NULL DROP TABLE #VMList
IF object_id('tempdb.dbo.#msimCountTable') IS NOT NULL DROP TABLE #msimCountTable
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpSubscrptnUsg10'))
BEGIN
INSERT INTO #tmpSubscrptnUsg10
SELECT      @nProtectedClient AS ProtectedClient, @nProtectedVM AS ProtectedVM,
            @nArchivedClient AS ArchivedClient, @nArchivedMailBox AS ArchivedMailBox, @nSRMClient AS SRMClient,
            @nCIServer AS CIServer, @nAdvSearchNodes AS AdvSearchNodes, @nSearchMailBox AS SearchMailBox, ISNULL(@nVMSocket, 0) AS VMSocket,
            ISNULL(@nEpUsers, 0) AS nEpUsers, ISNULL(@nEpSharingUsers, 0) AS EpSharingUsers, ISNULL(@nEpEdiscoveryUsers, 0) AS EpEdiscoveryUsers,
            ISNULL(@UsedDiskSpaceMB, 0) AS UsedDiskSpace_MB, ISNULL(@AvailDiskSpaceMB, 0) AS AvailDiskSpace_MB,
            ISNULL(@DedupDataSizeMB, 0) AS DedupDataSize_MB, ISNULL(@DedupDataOnTapeMB, 0) AS DedupDataOnTape_MB,
            ISNULL(@AvailDedupSpaceMB, 0) AS AvailDedupSpace_MB, ISNULL(@nContentIndexedObject,0) as ContentIndexedObject,
			@MailBoxXML as MailBoxXML, @VMXML as VMxml, @CIEngineXML as CIEngineXML, @socketXML as socketXML,
            @epUserXML as EndPointUserXML, @epSharingUserXML as EndPointSharingUser, @epEdiscoveryUserXML as EndPointEDiscoveryUser
END
ELSE
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpLicUsage11'))
BEGIN
	INSERT INTO #tmpLicUsage11
	          SELECT 100013, ISNULL(@nArchivedMailBox, 0)
	UNION ALL SELECT 100014, ISNULL(@nSearchMailBox, 0)
	UNION ALL SELECT 100015, ISNULL(@UsedDiskSpaceMB, 0)/1024
	UNION ALL SELECT 100016, ISNULL(@DedupDataSizeMB, 0)/1024
	UNION ALL SELECT 100017, ISNULL(@nContentIndexedObject,0)
	UNION ALL SELECT 100018, ISNULL(@nVMSocket, 0)
	UNION ALL SELECT 100019, ISNULL(@nProtectedVM, 0)
	UNION ALL SELECT 100021, ISNULL(@nArchivedVM, 0)
	UNION ALL SELECT 100024, ISNULL(@nEpUsers, 0)
	UNION ALL SELECT 100025, ISNULL(@nEpSharingUsers, 0)
	UNION ALL SELECT 100026, ISNULL(@nEpEdiscoveryUsers, 0)
	UNION ALL SELECT 100027, ISNULL(@nVMWithAppClass1Pkg, 0)
	UNION ALL SELECT 100028, ISNULL(@nMSimUsers,0)
	UNION ALL SELECT 100031, ISNULL(@nAppStoreCapacityMB, 0)/1024
	UNION ALL SELECT 100032, ISNULL(@nOIUsers, 0)
	UNION ALL SELECT 100033, ISNULL(@nVOIUsers, 0)
	UNION ALL SELECT 100034, ISNULL(@nActEDisFilesMB, 0)/1024
	UNION ALL SELECT 100035, ISNULL(@nActEDisECApps, 0)
	UNION ALL SELECT 100036, ISNULL(@nActSensDataFilesMB, 0)/1024
	UNION ALL SELECT 100037, ISNULL(@nActSensDataECApps, 0)
	UNION ALL SELECT 100038, ISNULL(@nFileStoreOptMB, 0)/1024
	UNION ALL SELECT 100039, ISNULL(@nActSuite, 0)
	UNION ALL SELECT 100040, ISNULL(@nDRVM, 0)
	UNION ALL SELECT 100041, ISNULL(@nMetallicStoreMB, 0)/1024
	UNION ALL SELECT 100042, ISNULL(@nMetallicStoreT2MB, 0)/1024
	UNION ALL SELECT 100043, ISNULL(@nMetallicStoreT3MB, 0)/1024
	UNION ALL SELECT 100044, ISNULL(@nMetallicStoreT4MB, 0)/1024
	UNION ALL SELECT 100045, ISNULL(@nMetallicStoreT5MB, 0)/1024
	UNION ALL SELECT 100046, ISNULL(@nMetallicStoreT6MB, 0)/1024
	UNION ALL SELECT 100047, ISNULL(@nMetallicStoreT7MB, 0)/1024
	UNION ALL SELECT 100048, ISNULL(@nMetallicStoreT8MB, 0)/1024
	UNION ALL SELECT 100049, ISNULL(@nMetallicStoreT9MB, 0)/1024
	UNION ALL SELECT 100050, ISNULL(@nMetallicStoreT10MB, 0)/1024
END
ELSE
BEGIN
SELECT      @nProtectedClient AS ProtectedClient, @nProtectedVM AS ProtectedVM, @nArchivedVM AS nArchivedVM,
            @nArchivedClient AS ArchivedClient, @nArchivedMailBox AS ArchivedMailBox, @nSRMClient AS SRMClient,
            @nCIServer AS CIServer, @nAdvSearchNodes AS AdvSearchNodes, @nSearchMailBox AS SearchMailBox, ISNULL(@nVMSocket, 0) AS VMSocket,
            ISNULL(@nEpUsers, 0) AS nEpUsers, ISNULL(@nEpSharingUsers, 0) AS EpSharingUsers, ISNULL(@nEpEdiscoveryUsers, 0) AS EpEdiscoveryUsers, ISNULL(@nVMWithAppClass1Pkg, 0) AS VMWithAppClass1Pkg,
			ISNULL(@nMSimUsers,0) AS MSimUsers, ISNULL(@nAppStoreCapacityMB, 0) AS ApplianceStoreCapacity_MB, ISNULL(@FSOnlyServer,0) as FSOnlyServer, ISNULL(@ApplicationServer,0) as ApplicationServer,
			ISNULL(@UsedDiskSpaceMB, 0) AS UsedDiskSpace_MB, ISNULL(@AvailDiskSpaceMB, 0) AS AvailDiskSpace_MB,
            ISNULL(@DedupDataSizeMB, 0) AS DedupDataSize_MB, ISNULL(@DedupDataOnTapeMB, 0) AS DedupDataOnTape_MB,
            ISNULL(@AvailDedupSpaceMB, 0) AS AvailDedupSpace_MB, ISNULL(@nContentIndexedObject,0) as ContentIndexedObject,ISNULL(@nOIUsers,0) as OIUsers, ISNULL(@nVOIUsers,0) as VOIUsers,
			ISNULL(@nActEDisFilesMB, 0) as ActEDisFiles_MB, ISNULL(@nActEDisECApps, 0) as ActEDisECApps, ISNULL(@nActSensDataFilesMB, 0) as ActSensDataFiles_MB,
			ISNULL(@nActSensDataECApps, 0) as ActSensDataECApps, ISNULL(@nFileStoreOptMB, 0) as FileStoreOpt_MB, ISNULL(@nActSuite, 0) as ActSuite, ISNULL(@nDRVM, 0) as DRVM,
			@MailBoxXML as MailBoxXML, @VMXML as VMxml, @ArchivedVMXML as ArchivedVMXML, @CIEngineXML as CIEngineXML, @socketXML as socketXML,
            @epUserXML as EndPointUserXML, @epSharingUserXML as EndPointSharingUser, @epEdiscoveryUserXML as EndPointEDiscoveryUser, @VMWithAppClass1PkgXML as VMWithAppClass1PkgXML,
			@MSimUsersXML as MSimUsersXML, @OIUsersXML as OIUsersXML, @VOIUsersXML as VOIUsersXML, @DRVMXML as DRVMXML,ISNULL(@nMetallicStoreMB, 0) as MetallicStore_MB, @ActEDisFilesMBXML as ActEDisFilesMBXML, @ActEDisECAppsXML as ActEDisECAppsXML,
			@ActSensDataFilesMBXML as ActSensDataFilesMBXML, @ActSensDataECAppsXML as ActSensDataECAppsXML, @FileStoreOptMBXML as FileStoreOptMBXML, ISNULL(@nMetallicStoreT2MB, 0) as MetallicStoreT2_MB,ISNULL(@nMetallicStoreT3MB, 0) as MetallicStoreT3_MB, ISNULL(@nMetallicStoreT4MB, 0) as MetallicStoreT4_MB, ISNULL(@nMetallicStoreT5MB, 0) as MetallicStoreT5_MB, ISNULL(@nMetallicStoreT6MB, 0) as MetallicStoreT6_MB, ISNULL(@nMetallicStoreT7MB, 0) as MetallicStoreT7_MB, ISNULL(@nMetallicStoreT8MB, 0) as MetallicStoreT8_MB, ISNULL(@nMetallicStoreT9MB, 0) as MetallicStoreT9_MB, ISNULL(@nMetallicStoreT10MB, 0) as MetallicStoreT10_MB
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LicCALUsage')
	delete from GxQscripts where name = 'LicCALUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LicCALUsage')
	delete from GXDBVersions where aliasname = 'LicCALUsage'
GO

insert into GXDBVersions values(2, 'LicCALUsage',  '00000000000000000000', 'LicCALUsage', '00000000000000000000')
GO

