

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LibraryStatsPopulate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LibraryStatsPopulate.sp,v $ $Id: LibraryStatsPopulate.sp,v 1.1.46.2 2018/03/20 00:04:04 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "LibraryStatsPopulate"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LibraryStatsPopulate <<<'

IF EXISTS (select * from sysobjects where name='LibraryStatsPopulate')
	drop procedure LibraryStatsPopulate
IF EXISTS (select * from GxQscripts where name='LibraryStatsPopulate')
	delete from GxQscripts where name = 'LibraryStatsPopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LibraryStatsPopulate')
	delete from GXDBVersions where aliasname = 'LibraryStatsPopulate'
GO
print '... Creating Procedure: LibraryStatsPopulate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LibraryStatsPopulate
AS
  DECLARE @ErrVal INT
  DECLARE @ErrString VARCHAR(1024)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--DECLARE @ERRVAL INT
--DECLARE @ErrString VARCHAR(1024)
DECLARE	@RunIfQNetAgentRegistered	INT
SET NOCOUNT ON
SET	@ERRVAL = 0
SET	@ErrString = ' '
SET @RunIfQNetAgentRegistered = 0
SET @RunIfQNetAgentRegistered = ISNULL(
				(SELECT CAST(CAST(ISNULL(value,'') as varchar(10)) AS INT)
				 FROM GXGlobalParam
				 WHERE name = 'GatherLibraryStatsInfoForCommNet'), 0)
DECLARE	@CurrentTime DateTime
SET	@CurrentTime = GetUTCDate()
DECLARE	@MaxModified DateTime
SELECT @MaxModified = MAX(Modified) FROM	MMLibraryStatsHistory
-- -----------------------------------------------------------------------
--  Check for the conditions and do the insert
-- -----------------------------------------------------------------------
IF (@RunIfQNetAgentRegistered = 0  AND
	( @MaxModified IS NULL OR @MaxModified < dbo.GetDayStart(GetUTCDate(),0))
   )
BEGIN
	DECLARE @idoc			int
	DECLARE @XMLDoc			XML
	declare @tblLibraryXML table (xmlDoc XML)
	INSERT INTO @tblLibraryXML
	EXEC	MMSummPageGetTapeLibraries 2, 0, 0
	SELECT	@XMLDoc = xmlDoc
	FROM	@tblLibraryXML
	EXEC sp_xml_preparedocument @idoc OUTPUT, @XMLDoc
	INSERT INTO MMLibraryStatsHistory
	SELECT	*,
			@CurrentTime,
	-- QNet 5.9 - Version 3,  QNet 6.1 - Version 4, QNet 7.1 - Version 5, QNet 8.0 - Version 6, QNet 9.0 - Version 7, QNet 10.0 - Version 15
			15
	FROM	OPENXML(@idoc, '//EVGui_SummPageGetTapeLibraries/libraries', 0)
		WITH(	LibraryID				int		'@libraryID',
				NumOfDrives				int		'@numOfDrives',
				NumOfDrivesOffline		int		'@numOfDrivesOffline',
				NumOfMedia				int		'@numOfMedia',
				NumOfActiveMedia		int		'@numOfActiveMedia',
				NumOfFullMedia			int		'@numOfFullMedia',
				NumOfAppendableMedia	int		'@numOfAppendableMedia',
				NumOfIdleMedia			int		'@numOfIdleMedia',
				NumOfReadOnlyMedia		int		'@numOfReadOnlyMedia',
				NumOfBadMedia			int		'@numOfBadMedia',
				NumOfSpareMedia			int		'@numOfSpareMedia',
				NumOfCleaningMedia		int		'@numOfCleaningMedia',
				NumOfExpiredMedia		int		'@numOfExpiredMedia',
				NumOfForeignMedia		int		'@numOfForeignMedia',
				NumOfSavedMedia			int		'@numOfSavedMedia',
				NumOfRegSlots			int		'@numOfRegSlots',
				NumOfRegSlotOccupied	int		'@numOfRegSlotOccupied',
				NumOfIESlots			int		'@numOfIESlots',
				NumOfIESlotOccupied		int		'@numOfIESlotOccupied'
		)
	SET @ERRVAL = @@ERROR
	IF (@ERRVAL <> 0)
	BEGIN
		SET @ERRSTRING = 'Failed to INSERT library stats information into MMLibraryStatsHistory table'
		EXEC sp_xml_removedocument @idoc
		GOTO ERROR_EXIT
	END
	ELSE
		EXEC sp_xml_removedocument @idoc
END
-- -----------------------------------------------------------------------
--  EXIT
-- -----------------------------------------------------------------------
ERROR_EXIT:
-- -----------------------------------------------------------------------
--  RETURN
-- -----------------------------------------------------------------------
SELECT  @ERRVAL, @ERRSTRING
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LibraryStatsPopulate')
	delete from GxQscripts where name = 'LibraryStatsPopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LibraryStatsPopulate')
	delete from GXDBVersions where aliasname = 'LibraryStatsPopulate'
GO

insert into GXDBVersions values(2, 'LibraryStatsPopulate',  '00010001004600020000', 'LibraryStatsPopulate', '00010001004600020000')
GO

