

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LaptopDelegatedMailboxExists.sp] ---------- 

--WARNING! ERRORS ENCOUNTERED DURING SQL PARSING!
	-- ----------------------------------------------------------------------
	--
	--           Copyright (c) 1998  CommVault Systems, Inc.
	--                  All rights reserved.
	--
	--
	--        This is unpublished proprietary source code of CommVault
	--        Systems, Inc. The copyright notice above does not evidence
	--        any actual or intended publication of such source code.
	-- ----------------------------------------------------------------------*/
	-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LaptopDelegatedMailboxExists.sp,v $ $Id: LaptopDelegatedMailboxExists.sp,v 1.1.2.6 2018/07/02 03:57:42 nlakade Exp $";
	--	+===================================================================+
	--	| LaptopDelegatedMailboxExists - check if user has delegated mailbox
	--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LaptopDelegatedMailboxExists <<<'

IF EXISTS (select * from sysobjects where name='LaptopDelegatedMailboxExists')
	drop procedure LaptopDelegatedMailboxExists
IF EXISTS (select * from GxQscripts where name='LaptopDelegatedMailboxExists')
	delete from GxQscripts where name = 'LaptopDelegatedMailboxExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LaptopDelegatedMailboxExists')
	delete from GXDBVersions where aliasname = 'LaptopDelegatedMailboxExists'
GO
print '... Creating Procedure: LaptopDelegatedMailboxExists'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LaptopDelegatedMailboxExists
	-----------------------------------------------------------
	---    PARAMETERS   &   OUTPUTS							---
  @mailboxGuid NVARCHAR(255) = '',
  @userId INT = 0,
  @mailBoxExists INT = 0 OUTPUT
	-----------------------------------------------------------
AS
DECLARE @excludeStatusMask int = (cast(0x00004  as int) | cast(0x00020 as int) |  cast(0x00002 as int))
IF OBJECT_ID('tempdb.dbo.#GroupMailboxUserGUIDS') IS NOT Null DROP TABLE #GroupMailboxUserGUIDS
create table #GroupMailboxUserGUIDS
(
MailboxUserGUID VARCHAR(40),
	PRIMARY KEY(MailboxUserGUID)
)
INSERT INTO #GroupMailboxUserGUIDS SELECT DISTINCT '{' + data + '}' from dbo.SplitString(@mailboxGuid,';')
IF OBJECT_ID('tempdb.dbo.#AccessibleSubclients') IS NOT Null DROP TABLE #AccessibleSubclients
create table #AccessibleSubclients
(
	subclientId INTEGER,
	appTypeId INTEGER,
	PRIMARY KEY(appTypeId, subclientId)
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	DECLARE @sqlStr AS NVARCHAR(4000)
	DECLARE @out TABLE
	(
		out INT
	)
	DECLARE @showCurrentContent INT = 0
	SET @showCurrentContent = ISNULL((SELECT VALUE FROM Gxglobalparam WHERE NAME = 'ShowMBFromCurrentSubclient'), 0)
	INSERT INTO #AccessibleSubclients
	SELECT DISTINCT A.id, A.appTypeId FROM APP_Application A
INNER JOIN #tempAppGetApplicationSecurityObjects SEC ON ((capabilities & CONVERT(bigint, (POWER(2.0,  24  -1))) <> 0 )  OR (capabilities & CONVERT(bigint, (POWER(2.0, 13 -1))) <> 0 ))
		AND(
( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
			OR
			(sec.clientId=A.clientId AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0)
			OR
			(sec.clientId=A.clientId AND sec.appTypeId=A.appTypeId AND sec.instanceId=0 AND sec.backupsetId=0)
			OR
			(sec.clientId=A.clientId AND sec.appTypeId=A.appTypeId AND sec.instanceId=A.instance AND sec.backupsetId=0)
			OR
			(sec.clientId=A.clientId AND sec.appTypeId=A.appTypeId AND sec.instanceId=A.instance AND sec.backupsetId=A.backupSet)
			)
	--Exchange classic agent
	IF EXISTS(	SELECT  TOP 1 1
		FROM APP_Application a
		INNER JOIN APP_Client c ON c.id = a.clientId
		INNER JOIN APP_SubClientProp sp ON a.id = sp.componentNameId
		INNER JOIN APP_ComponentProp e ON e.componentId = sp.id
		INNER JOIN APP_MailBoxDelegates md ON mailboxUserGUID IN ( SELECT MailboxUserGUID FROM  #GroupMailboxUserGUIDS  )
		INNER JOIN APP_Client c2 ON c2.id = md.exchangeclientId and c2.releaseid > 14
		WHERE
		a.id IN ( SELECT subclientId FROM #AccessibleSubclients)
		AND ( @showCurrentContent =0 or sp.modified=0 )
 		AND ( e.stringVal =  REPLACE(md.delegateUserGUID,'-','X') )
		AND e.modified = 0 )
	BEGIN
		SET @mailBoxExists = 1
	END
	--Exchange Agent
	IF (@mailBoxExists = 0) AND EXISTS( SELECT TOP 1 1
				FROM APP_MailBoxDelegates md
				INNER JOIN APP_EmailConfigPolicyAssoc ec ON ('{'+ec.userGuid +'}'=  REPLACE(md.delegateUserGUID,'-','X'))
				WHERE md.mailboxUserGUID IN ( SELECT MailboxUserGUID FROM  #GroupMailboxUserGUIDS )
AND ec.subclientId IN (SELECT subclientId FROM #AccessibleSubclients WHERE appTypeId = 137)	)
	BEGIN
		SET @mailBoxExists = 1
	END
	DROP TABLE #GroupMailboxUserGUIDS
	DROP TABLE #AccessibleSubclients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LaptopDelegatedMailboxExists')
	delete from GxQscripts where name = 'LaptopDelegatedMailboxExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LaptopDelegatedMailboxExists')
	delete from GXDBVersions where aliasname = 'LaptopDelegatedMailboxExists'
GO

insert into GXDBVersions values(2, 'LaptopDelegatedMailboxExists',  '00010001000200060000', 'LaptopDelegatedMailboxExists', '00010001000200060000')
GO

