

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMupdateCoreStatusInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMupdateCoreStatusInfo.sp,v $ $Id: LMupdateCoreStatusInfo.sp,v 1.1.2.8 2018/09/26 17:25:38 logeshg Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMupdateCoreStatusInfo()
--  |
--  |   Revisions   Author          Description
--  |   ---------   ----------      ----------------------------------------
--  |   1.0			logesh G	LMupdateCoreStatusInfo is to update core status
--  |							Optype = 1 , Before space check runs , Core info is updated in App_LMCoreInfo.i.e.,docCount ...etc
--  |							Optype = 2 , After space check runs , unloaded cores are marked.i.e., isLoaded = 0 and requested dates of that cores are also delted from APP_LMCoreReqInfo table.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMupdateCoreStatusInfo <<<'

IF EXISTS (select * from sysobjects where name='LMupdateCoreStatusInfo')
	drop procedure LMupdateCoreStatusInfo
IF EXISTS (select * from GxQscripts where name='LMupdateCoreStatusInfo')
	delete from GxQscripts where name = 'LMupdateCoreStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMupdateCoreStatusInfo')
	delete from GXDBVersions where aliasname = 'LMupdateCoreStatusInfo'
GO
print '... Creating Procedure: LMupdateCoreStatusInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMupdateCoreStatusInfo
  @inputxml xml	OUTPUT
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @outputXml XML = ''
	BEGIN TRY
	-- Fetching operation type
	DECLARE @opType INT
	DECLARE @clientId INT
	SET @opType = ISNULL((SELECT	ref.value('@operationType' , 'INT') FROM @inputxml.nodes('LogMonitoring_LMupdateCoreInfo') as R(ref) ) , 1 ) -- 1--> DEFAULT OPTYPE
	SET @clientId = ISNULL((SELECT	ref.value('@clientId' , 'INT') FROM @inputxml.nodes('LogMonitoring_LMupdateCoreInfo/clientEntity') as R(ref) ) , 0 )
	DECLARE @coresListTbl TABLE (CoreName NVARCHAR(100) , DocCount INT , policyId INT,factor INT)
	IF @opType = 1 --optype 1 is , Before space check , we get status of cores are update in App_LMCoreInfo
	BEGIN
		DECLARE @coreStatusXml XML
		SET @coreStatusXml = CONVERT(XML,ISNULL((SELECT	ref.value('@coreStatusXml' , 'NVARCHAR(MAX)') FROM @inputxml.nodes('LogMonitoring_LMupdateCoreInfo') as R(ref) ) , '' ) )
		DECLARE @createdDate BIGINT = dbo.GetUnixTime(GETUTCDATE())
		-- Fetch info from xml(core name & docCount)
		INSERT INTO @coresListTbl(CoreName , DocCount)
		SELECT	ref.value('@name' , 'nvarchar(100)') as CoreName ,
				ISNULL(ref.value('(lst/int[@name="numDocs"])[1]','INT'),0) as DocCount
		FROM @coreStatusXml.nodes('response/lst/lst') as R(ref)
		WHERE  CHARINDEX('cvcorelm_', ref.value('@name' , 'nvarchar(max)') ) = 1 -- Only lmscale cores are filtered here
		--UPDATING OLD CORES AREA
			-- Now update the existing cores in app_LMCoreInfo table
			UPDATE coreTbl
			SET coreTbl.DocCount = tempCoreTbl.DocCount,
				coreTbl.isLoaded = 1
			FROM APP_LMCoreInfo coreTbl
			INNER JOIN @coresListTbl tempCoreTbl
			ON coreTbl.CoreName = tempCoreTbl.CoreName
			WHERE coreTbl.ClientId = @clientId --> If policy is associated to another cloud, we should move on.
		--UPDATING OLD CORES AREA END
		-- INSERTING NEW CORES AREA
			-- from core names we need to find policyId and factor.
			UPDATE tempCoreTbl
			SET tempCoreTbl.policyId	= SUBSTRING(	tempCoreTbl.CoreName,
														CHARINDEX('_' , tempCoreTbl.CoreName) + 1, -- This will give starting index of '_'
														CHARINDEX('_' , tempCoreTbl.CoreName, CHARINDEX('_' , tempCoreTbl.CoreName) + 1) - CHARINDEX('_' , tempCoreTbl.CoreName) - 1 --This will give end index of '_'
													),
				tempCoreTbl.factor =	CASE WHEN CHARINDEX('W',tempCoreTbl.CoreName,CHARINDEX('_' , tempCoreTbl.CoreName)) > 0 THEN 2 -- weekly core
												WHEN CHARINDEX('M',tempCoreTbl.CoreName,CHARINDEX('_' , tempCoreTbl.CoreName)) > 0 THEN 3 -- monthly core
												ELSE 1 -- daily core
										END
			FROM APP_LMCoreInfo coreTbl
			RIGHT JOIN @coresListTbl tempCoreTbl
			ON coreTbl.CoreName = tempCoreTbl.CoreName AND coreTbl.ClientId = @clientId
			where coreTbl.CoreName IS NULL -- this will filter only new cores.
			--If cloud is deconfigured,then cores of policies will not updated if innner join is done with dm2searchserverCOreInfo table.So making left join
			--So,if clientId is 0 in app_lmcoreINfo table , then those policies not belog to particular cloud.It will be unloaded in next space check
			INSERT INTO APP_LMCoreInfo
			select coreTbl.CoreName  , @clientId , policyTbl.monitorPolicyId , 2 /*Default commcellId*/ , coreTbl.DocCount , 1 /*isLoaded column*/ , coreTbl.factor,@createdDate
			from APP_MonitoringPolicy policyTbl WITH(NOLOCK)
			INNER JOIN APP_MonitoringPolicyProp policyPropTbl WITH(NOLOCK) ON policyPropTbl.monitorPolicyId = policyTbl.monitorPolicyId
			INNER join @coresListTbl coreTbl ON policyPropTbl.monitorPolicyId = coreTbl.policyId
			WHERE policyPropTbl.attrName = 'Cloud Id' AND coreTbl.policyId IS NOT NULL --this will filter only new cores.
		-- INSERTING NEW CORES AREA END
		DECLARE @deletedPolicies TABLE(policyId INT)
		INSERT INTO @deletedPolicies
		SELECT DISTINCT coreTbl.policyId
		from @coresListTbl coreTbl
		LEFT JOIN app_monitoringpolicy policyTbl WITH(NOLOCK)
		on coreTbl.policyId = policyTbl.monitorpolicyId
		where policyTbl.monitorpolicyId IS NULL
		SET @outputXml = (
			SELECT delPolicies.policyId AS '@policyId',
			1 AS '@retentionDays',
			3 AS '@status',
			(
				SELECT A.CoreName AS '@coreName'
				FROM @coresListTbl A
				WHERE A.policyId = delPolicies.policyId
				FOR XML PATH ('coreInfo') , TYPE
			)
			FROM @deletedPolicies delPolicies
		FOR XML PATH('retention'),ROOT('LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientResp'))
	END
		ELSE IF @opType = 2
		BEGIN
			DECLARE @oneDayInSec BIGINT
			SET @oneDayInSec = (24 * 60 * 60)
			--Below query to find the midNight Epoch
			DECLARE @midNightDate DATETIME
			SET @midNightDate = ( SELECT Convert(DATETIME, DATEDIFF(DAY, 0,GETUTCDATE())))
			DECLARE @midNightEpochDate BIGINT
			SET @midNightEpochDate = DBO.GetUnixTime(@midNightDate)
			-- UPDATING ULOAD INFORATION
			INSERT INTO @coresListTbl(CoreName,DocCount)
			SELECT	ref.value('@coreName' , 'nvarchar(max)') , 0
			FROM @inputxml.nodes('LogMonitoring_LMupdateCoreInfo/coreInfo') as R(ref)
			-- set isLoaded = 0
			UPDATE coreInfo
			SET coreInfo.isLoaded = 0
			FROM app_lmcoreinfo coreInfo WITH(NOLOCK) INNER JOIN @coresListTbl temp
			ON coreInfo.CoreName = temp.CoreName AND coreInfo.ClientId =  @clientId
			--Also delete requested dates from App_lmcoreReqInfo table , When requested date becomes older
			DELETE reqTbl
			FROM APP_LMCoreReqInfo reqTbl
			INNER JOIN APP_MonitoringPolicyProp propTbl
			ON reqTbl.PolicyId = propTbl.monitorPolicyId
			WHERE  propTbl.attrName = 'enable ci data ageing' AND propTbl.attrVal = 1 AND ( (RequestedDate + (noOfDays* @oneDayInSec))  <  @midNightEpochDate)
			--pruning other cores
			DELETE FROM APP_LMCoreInfo
			WHERE isLoaded = 0
			DELETE coreReqTbl
			FROM APP_MonitoringPolicy policyTbl
			INNER JOIN APP_LMCoreReqInfo coreReqTbl
			ON policyTbl.monitorPolicyId = coreReqTbl.PolicyId
			WHERE policyTbl.status = 3 --deleted ones
		END
	ERROR_EXIT:
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outputXml = (	SELECT	1 AS '@errorcode',
							ERROR_MESSAGE() AS '@errorMessage'
					FOR XML PATH('LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientResp')
					)
	END CATCH
	SET @outputXml = ISNULL(@outputXml ,'<LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientResp />')
	SET @inputxml =  @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMupdateCoreStatusInfo')
	delete from GxQscripts where name = 'LMupdateCoreStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMupdateCoreStatusInfo')
	delete from GXDBVersions where aliasname = 'LMupdateCoreStatusInfo'
GO

insert into GXDBVersions values(2, 'LMupdateCoreStatusInfo',  '00010001000200080000', 'LMupdateCoreStatusInfo', '00010001000200080000')
GO

