

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LM_isUserHasSharedEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LM_isUserHasSharedEntity.sp,v $ $Id: LM_isUserHasSharedEntity.sp,v 1.1.2.1 2018/04/06 19:46:38 logeshg Exp $";
--
--  +========================================================================+
--  |   Procedure:  LM_isUserHasSharedEntity()
--  |
--  | Description:
--  |
--  |       Input:  userId , lmAppType
--  |
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |    sp12      Logesh 	Checks whether user has shared search or not
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LM_isUserHasSharedEntity <<<'

IF EXISTS (select * from sysobjects where name='LM_isUserHasSharedEntity')
	drop procedure LM_isUserHasSharedEntity
IF EXISTS (select * from GxQscripts where name='LM_isUserHasSharedEntity')
	delete from GxQscripts where name = 'LM_isUserHasSharedEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_isUserHasSharedEntity')
	delete from GXDBVersions where aliasname = 'LM_isUserHasSharedEntity'
GO
print '... Creating Procedure: LM_isUserHasSharedEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LM_isUserHasSharedEntity
  @i_userId integer,
  @i_appType integer,
  @o_isUserHasSharedSearch integer OUTPUT
AS
SET NOCOUNT ON
	SET @o_isUserHasSharedSearch = 0
	IF object_id('tempdb.dbo.#userCreds') is not null
	BEGIN
		drop table #userCreds
	END
	CREATE TABLE #userCreds (entityId int)
exec sec_getNonIdaObjectsForThisUser @i_userId, 9674, 0, '#userCreds'
	IF exists (SELECT 1 FROM #userCreds)
	BEGIN
		-- Check if there is any shared search with appType
		IF EXISTS(  SELECT 1
					FROM App_SharedEntityInfo appShared
						INNER JOIN #userCreds shareIds ON appShared.SharedEntityId = shareIds.entityId
						INNER JOIN LMUserSearch userSearch ON appShared.OriginalEntityId = userSearch.searchId
WHERE appShared.SharedEntityType = 134 AND userSearch.monitoringAppType = @i_appType)
		BEGIN
			SET @o_isUserHasSharedSearch = 1
		END
		-- Check if there is any shared dashboard with appType
		IF @o_isUserHasSharedSearch = 0 AND EXISTS(   SELECT 1
										FROM App_SharedEntityInfo appShared
											INNER JOIN #userCreds shareIds ON appShared.SharedEntityId = shareIds.entityId
											INNER JOIN LMDashBoard lmDashBoard  ON  appShared.OriginalEntityId = lmDashBoard.dashBoardId
WHERE appShared.SharedEntityType = 137 AND lmDashBoard.monitoringAppType = @i_appType)
		BEGIN
			SET @o_isUserHasSharedSearch = 1
		END
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LM_isUserHasSharedEntity')
	delete from GxQscripts where name = 'LM_isUserHasSharedEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_isUserHasSharedEntity')
	delete from GXDBVersions where aliasname = 'LM_isUserHasSharedEntity'
GO

insert into GXDBVersions values(2, 'LM_isUserHasSharedEntity',  '00010001000200010000', 'LM_isUserHasSharedEntity', '00010001000200010000')
GO

