

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LM_HyperScaleMonitoring.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LM_HyperScaleMonitoring.sp,v $ $Id: LM_HyperScaleMonitoring.sp,v 1.1.2.5 2020/06/10 14:56:37 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LM_HyperScaleMonitoring')
BEGIN
	print '>>> Drop Stored Procedure: LM_HyperScaleMonitoring <<<'
	drop procedure LM_HyperScaleMonitoring
END
IF EXISTS (select * from GxQscripts where name='LM_HyperScaleMonitoring')
	delete from GxQscripts where name = 'LM_HyperScaleMonitoring'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_HyperScaleMonitoring')
	delete from GXDBVersions where aliasname = 'LM_HyperScaleMonitoring'
GO
print '... Creating Procedure: LM_HyperScaleMonitoring'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LM_HyperScaleMonitoring
AS
	--Below steps gonna happen in this stored proc.
	--1.Get list of hyperscale clients.
	--2.Check out whether there is hyperscale clients and if default monitoring policy is not created,create it for first time.
	--3.Now check difference between already associated clients & hyperscale clients & find new client list
	--4.Now Associate these new clients with policy and send work queue request for those clients.
	DECLARE @hyperscaleClientList TABLE(clientId INT)
	DECLARE @clientAssoc TABLE(clientId INT)
	DECLARE @newClientList TABLE(clientId INT)
	DECLARE @errorCode INT = 0
	DECLARE @errorStr NVARCHAR(MAX) = ''
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
	DECLARE @guid uniqueidentifier = '4E1E8152-0831-49CF-BB74-C8E91EC76EBC'
	DECLARE @criteriaGuid uniqueidentifier = 'B86DAA18-598B-43FA-AA63-2A3F154AE6B9'
	DECLARE @templateId INT
	DECLARE @clientId INT
	DECLARE @disablePolicy INT = 1
	BEGIN TRY
	BEGIN TRAN HYPERSCALE_POLICY
		INSERT INTO @hyperscaleClientList
		SELECT DISTINCT(HW.hostId)
		FROM MMSDSStoragePool SDS(nolock),
			MMDiskHwInfo HW(nolock),
			MMScaleOutMAInfo MA(nolock),
			MMEntityProp ME(nolock),
			MMMountPath MP (NOLOCK),
			MMMountPathToStorageDevice MSD (NOLOCK)
		WHERE sds.LibraryId = MP.LibraryId AND MSD.MountPathId = MP.MountPathId AND MSD.DeviceId = HW.deviceId
AND HW.hostId = MA.ClientId AND Hw.flags & 1 = 1
AND HW.hostId = ME.EntityId AND ME.EntityType = 10 AND ME.CommCellId = 2 AND ME.propertyName = 'MediaAgentApplianceType'
AND ME.intVal IN (1 , 2)
		IF EXISTS(SELECT 1 FROM @hyperscaleClientList)
		BEGIN
			DECLARE @isHyperScalePolicyExists INT = 0
			SELECT @isHyperScalePolicyExists = 1
			FROM
				GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
			WHERE
				gp.SqlScriptGUID = @guid
			DECLARE @oldPolicyName NVARCHAR(MAX) = 'Hyperscale Statistics - System Created Policy'
			DECLARE @policyName NVARCHAR(MAX) = 'Hyperscale OS Log'
			DECLARE @monitoringPolicyId INT
			SET @templateId = (SELECT TOP 1 templateId FROM APP_Template
									WHERE templateName = 'Simple Text Template' AND status = 0 -- system defined.
									)
			IF(@isHyperScalePolicyExists = 0)
			BEGIN
				-- 1.Policy
				INSERT INTO APP_MonitoringPolicy
				VALUES(2,@policyName,@nowTime,@nowTime,'system created default monitoring policy',@disablePolicy)
				SET @monitoringPolicyId =  ISNULL((SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)
                                    WHERE MonitorPolicyName = @policyName AND status <> 3
                                    ORDER BY monitorPolicyId DESC),0)
				IF(@monitoringPolicyId = 0)
				BEGIN
					SET @errorCode = 1
					SET @errorStr = 'Failed to create system created Hyperscale monitoring policy'
					GOTO ERROR_EXIT
				END
				-- 2.Template
				INSERT INTO App_MonitorTemplateAssoc
				VALUES(@monitoringPolicyId,2,@templateId)
				-- 3.Client
				-- As of now,we dont want to associate client to policy. It is added below.
				-- 4.Criteria
				INSERT INTO APP_Criteria
				VALUES
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains Buffer I/O error on)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Buffer I/O error on" isInclusive="0" isregex="0" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains Input/output error)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Input/output error" isInclusive="0" isregex="0" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains Insufficient available children for this request)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Insufficient available children for this request" isInclusive="0" isregex="0" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains Failed to update version and size)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Failed to update version and size" isInclusive="0" isregex="0" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .*\b:? disconnected from .*\b.? Client process will keep trying to connect to glusterd until brick''s port is available.?)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".*\b:? disconnected from .*\b.? Client process will keep trying to connect to glusterd until brick''s port is available.?" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .*\b:? Connected to .*\b,? attached to remote volume .*\b)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".*\b:? Connected to .*\b,? attached to remote volume .*\b" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .*\b has not responded in the last \d*\.?\d* seconds, disconnecting.)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".*\b has not responded in the last \d*\.?\d* seconds, disconnecting." isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime)
				--5.Content,Alert
				DECLARE @content NVARCHAR(MAX) = '/var/log/glusterfs/bricks/ws-disk*/var/log/glusterfs/glusterd.log/var/log/messages'
				DECLARE @alertOut TABLE(alertId INT,errorCode INT,errorStr NVARCHAR(MAX))
				INSERT INTO @alertOut
				EXEC LM_CreateEventRaiserAlert @policyName
				IF(ISNULL((SELECT TOP 1 errorCode FROM @alertOut),0) <> 0)
				BEGIN
					SET @errorCode = (SELECT TOP 1 errorCode FROM @alertOut)
					SET @errorStr = (SELECT TOP 1 errorStr FROM @alertOut)
					GOTO ERROR_EXIT
				END
				DECLARE @alertId INT = (SELECT TOP 1 alertId FROM @alertOut)
				INSERT INTO APP_MonitoringPolicyProp
				VALUES
				(@monitoringPolicyId,2,'Content',1,@content,@nowTime,@nowTime)
				INSERT INTO APP_MonitoringPolicyProp
				VALUES
				(@monitoringPolicyId,2,'Data capturing type',7,1,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'EventRaiser alert id',7,@alertId,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Continuous monitoring',2,1,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Creater User Id',7,1,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'index all lines',2,0,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Monitoring Type',7,0,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Search in subfolders',2,0,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@nowTime,@nowTime),
				(@monitoringPolicyId,2,'Do not monitor old data',2,0,@nowTime,@nowTime)
				INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES(@guid, 'LM_HyperScaleMonitoring', 'Creating default monitoring policy for hyperscale', @nowTime, 16, 0 , (16 + 2))
			END -- default policy creation done.
			--policy and alert Name change area start
			DECLARE @nameChangeGuid uniqueidentifier = '02CD9A04-BED9-4166-BE48-6C7551B0EF97'
			DECLARE @nameChangeOccured INT = 0
			SELECT @nameChangeOccured = 1
			FROM
				GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
			WHERE
				gp.SqlScriptGUID = @nameChangeGuid
			IF @isHyperScalePolicyExists = 1 and @nameChangeOccured = 0
			BEGIN
				SET @monitoringPolicyId =  ISNULL((SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)
                                    WHERE MonitorPolicyName = @oldPolicyName AND status <> 3
                                    ORDER BY monitorPolicyId DESC),0)
				--update policy name
				UPDATE APP_MonitoringPolicy
				SET MonitorPolicyName = @policyName
				WHERE monitorPolicyId = @monitoringPolicyId
				--update alert name
				DECLARE @erAlertId INT = ISNULL((
										SELECT TOP 1 attrVal from APP_MonitoringPolicyProp WITH(NOLOCK)
										WHERE monitorPolicyId = @monitoringPolicyId and attrname ='EventRaiser alert id'),0)
				IF @erAlertId <> 0
				BEGIN
					UPDATE NTNotificationRule
					SET notificationName = @policyName + ' Alert'
					WHERE id = @erAlertId
					DECLARE @eventCriteriaXmlOrig NVARCHAR(MAX)
					DECLARE @eventCriteriaXml NVARCHAR(MAX)
					SET @eventCriteriaXmlOrig = '<LogMonitoring_ConditionsList criteriaName="(Event Code equals to 35:4402) AND (Description contains Criteria matched for monitoring policy [$MONITORING_POLICY_NAME$])" opBetweenConditions="0">
						  <conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="35:4402" isInclusive="0" isregex="0" operation="2">
							<column _type_="87" columnId="6" columnName="Event Code" />
						  </conditions>
						  <conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Criteria matched for monitoring policy [$MONITORING_POLICY_NAME$]" isInclusive="0" isregex="0" operation="2">
							<column _type_="87" columnId="7" columnName="Description" />
						  </conditions>
						</LogMonitoring_ConditionsList>'
					SET @eventCriteriaXml = REPLACE(@eventCriteriaXmlOrig, '$MONITORING_POLICY_NAME$',@policyName)
					UPDATE NTSimpanaEventCriteria
					SET criteriaXML = @eventCriteriaXml
					WHERE notifRuleId = @erAlertId
				END
			END
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES(@nameChangeGuid, 'LM_HyperScaleMonitoring_NameChange', 'NameChange changes for default monitoring policy for hyperscale', @nowTime, 16, 0 , (16 + 2))
			--policy and alert Name change area end
			SET @monitoringPolicyId =  ISNULL((SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)
                                    WHERE MonitorPolicyName = @policyName AND status <> 3
                                    ORDER BY monitorPolicyId DESC),0)
			IF(@monitoringPolicyId = 0)
			BEGIN
				SET @errorCode = 1
				SET @errorStr = 'System created Hyperscale monitoring policy does not exists.May be deleted'
				GOTO ERROR_EXIT
			END
			DECLARE @isNewCriteriasExists INT = 0
			SELECT @isNewCriteriasExists = 1
			FROM
				GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
			WHERE
				gp.SqlScriptGUID = @criteriaGuid
			IF @isNewCriteriasExists = 0
			BEGIN
				INSERT INTO APP_Criteria
				VALUES
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .+?[ ]?connection.+?failed(.+)disconnecting socket)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".+?[ ]?connection.+?failed(.+)disconnecting socket" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .+?[ ]?connection.+?failed(.*)(Network is unreachable))" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".+?[ ]?connection.+?failed(.*)(Network is unreachable)" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .+Reply submission failed)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".+Reply submission failed" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime),
				(2,@monitoringPolicyId,@templateId,'<LogMonitoring_ConditionsList criteriaName="(Description contains .+disconnecting connection from.+)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1=".+disconnecting connection from.+" isInclusive="0" isregex="1" operation="2"><column _type_="87" columnId="17" columnName="Description" /></conditions></LogMonitoring_ConditionsList>',0,@nowTime)
				INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES(@criteriaGuid, 'LM_HyperScaleMonitoring_criterias', 'Creating criterias for default monitoring policy for hyperscale', @nowTime, 16, 0 , (16 + 2))
			END
			--Check for client association difference.
			INSERT INTO @clientAssoc
			SELECT DISTINCT clientId FROM APP_MonitorAssocEntity WITH(NOLOCK)
			WHERE monitorPolicyId = @monitoringPolicyId AND clientId <> 0
			INSERT INTO @clientAssoc
			SELECT DISTINCT(clientAssoc.clientId)
			FROM APP_ClientGroupAssoc clientAssoc
			INNER JOIN APP_MonitorAssocEntity monitorAssoc
			ON monitorAssoc.monitorPolicyId = @monitoringPolicyId AND monitorAssoc.clientGroupId <> 0 AND monitorAssoc.clientGroupId = clientAssoc.clientGroupId
			WHERE clientAssoc.clientId NOT IN (SELECT clientId FROM @clientAssoc)
			INSERT INTO @newClientList
			SELECT hyperScaleTbl.clientId
			FROM @hyperscaleClientList hyperScaleTbl
			LEFT JOIN @clientAssoc clientTbl
			ON hyperScaleTbl.clientId = clientTbl.clientId
			WHERE clientTbl.clientId IS NULL
			IF EXISTS(SELECT 1 FROM @newClientList)
			BEGIN
				INSERT INTO APP_MonitorAssocEntity
				SELECT @monitoringPolicyId,2,3,@nowTime,0,clientId,0
				FROM @newClientList
				--If policy is enabled, then send workqueue.
				IF(@disablePolicy = 0)
				BEGIN
					INSERT INTO APP_WorkQueueRequest (clientId, remoteClient,workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
					SELECT hyperScaleTbl.clientId, -1, 8/*WORK_TOKEN_LOGMONITORING*/,'<TMMsg_MonitoringPolicyChangeReq clientId="'+ CONVERT(NVARCHAR(MAX),hyperScaleTbl.clientId) + '" monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monitoringPolicyId) + '" operationType="0"/>',@nowTime,@nowTime,0,0
					FROM @newClientList hyperScaleTbl
					INNER JOIN APP_Client clientTbl WITH(NOLOCK)
					ON hyperScaleTbl.clientId = clientTbl.id
				END
			END -- New clients exists
		END -- hyperscale clients exists
	ERROR_EXIT:
	END TRY
	BEGIN CATCH
		SET @errorCode = ERROR_NUMBER()
		SET @errorStr = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')
	END CATCH
	IF @errorCode = 0
		COMMIT TRAN HYPERSCALE_POLICY
	ELSE
	BEGIN
		ROLLBACK TRAN HYPERSCALE_POLICY
	END
	SELECT @errorCode,@errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'LM_HyperScaleMonitoring')
	delete from GxQscripts where name = 'LM_HyperScaleMonitoring'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_HyperScaleMonitoring')
	delete from GXDBVersions where aliasname = 'LM_HyperScaleMonitoring'
GO

insert into GXDBVersions values(2, 'LM_HyperScaleMonitoring',  '00010001000200050000', 'LM_HyperScaleMonitoring', '00010001000200050000')
GO

