

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LM_CreateEventRaiserAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LM_CreateEventRaiserAlert.sp,v $ $Id: LM_CreateEventRaiserAlert.sp,v 1.1.2.4 2020/02/24 07:44:11 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LM_CreateEventRaiserAlert')
BEGIN
	print '>>> Drop Stored Procedure: LM_CreateEventRaiserAlert <<<'
	drop procedure LM_CreateEventRaiserAlert
END
IF EXISTS (select * from GxQscripts where name='LM_CreateEventRaiserAlert')
	delete from GxQscripts where name = 'LM_CreateEventRaiserAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_CreateEventRaiserAlert')
	delete from GXDBVersions where aliasname = 'LM_CreateEventRaiserAlert'
GO
print '... Creating Procedure: LM_CreateEventRaiserAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LM_CreateEventRaiserAlert
  @monitoringPolicyName NVARCHAR(MAX),
  @userid INT = 1,
  @localeId INT = 0
AS
  DECLARE @alertId INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
	SET @errorCode = 0
  	SET @errorMsg = ''
	-- old alert template --> 'Event Raiser Alert for Monitoring Policy [' + @monitoringPolicyName + ']'
	DECLARE @notificationName NVARCHAR(MAX) = @monitoringPolicyName + ' Alert'
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
	DECLARE @emptyDateTime              DATETIME = '1900-01-01 00:00:00.000'
	DECLARE @allClientXmlEntities xml = '<CVGui_CommCellTreeNode>
	  <clients includeAll="0" />
	  <clientGroups includeAll="0" />
	  <libraries includeAll="0" />
	  <mediaAgents includeAll="0" />
	  <storagePolcies includeAll="0" />
	  <trackingPolicies includeAll="0" />
	  <trackingSchedules />
	  <trackingJobs />
	  <criterias includeAll="0" />
	  <workflows includeAll="0" />
	  <associations _type_="2" />
	  <commcells includeAll="0" />
	</CVGui_CommCellTreeNode>'
	DECLARE @thisAlertId INT = 0
	DECLARE @textdefaultTemplateForDefaultAlert NVARCHAR(MAX) = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_'
	DECLARE @htmldefaultTemplateForDefaultAlert NVARCHAR(MAX)
DECLARE @masterGroupId INT = ISNULL((SELECT TOP 1 ID FROM UMGroups WITH(NOLOCK) WHERE groupFlags & 0x0008=0x0008 ), 1)    --_US_ADMIN_GROUP__
	DECLARE @eventCriteriaXmlOrig NVARCHAR(MAX)
	DECLARE @eventCriteriaXml NVARCHAR(MAX)
	SET @eventCriteriaXmlOrig = '<LogMonitoring_ConditionsList criteriaName="(Event Code equals to 35:4402) AND (Description contains Criteria matched for monitoring policy [$MONITORING_POLICY_NAME$])" opBetweenConditions="0">
		  <conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="35:4402" isInclusive="0" isregex="0" operation="2">
			<column _type_="87" columnId="6" columnName="Event Code" />
		  </conditions>
		  <conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="Criteria matched for monitoring policy [$MONITORING_POLICY_NAME$]" isInclusive="0" isregex="0" operation="2">
			<column _type_="87" columnId="7" columnName="Description" />
		  </conditions>
		</LogMonitoring_ConditionsList>'
IF EXISTS(SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name='UseNewAlertTemplate' AND value=1)
		SET @htmldefaultTemplateForDefaultAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Program</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT DISPLAY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Description</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		SET @htmldefaultTemplateForDefaultAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellspacing="0" style="border-bottom-color: #dedede; border-left-width: 0px; border-right-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-style: solid; border-right-width: 0px; border-bottom-width: 0px; border-bottom-style: solid; border-top-color: #dedede; border-left-color: #dedede; border-top-width: 0px" width="600" align="center" border="1" cellpadding="0">  <tr>  <td>  <center>  <table cellspacing="0" id="contentTbl" width="600" align="center" border="0" cellpadding="0">  <tr style="background-color: #666666">  <td valign="middle" align="left">  <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px">  <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font>  </div>  </td>  </tr>  <tr>  <td valign="middle" align="left" bgcolor="#DCDEDE" colspan="1">  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">CommCell: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Type: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Detected Criteria: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Detected Time: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong>  </ul>  </td>  </tr>  <tr>  <td width="100%" align="left" colspan="1">  <ul>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Event ID: &lt;EVENT ID&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Severity: &lt;EVENT SEVERITY&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Job ID: &lt;JOB ID&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Event Date: &lt;EVENT DATE&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Program: &lt;EVENT PROGRAM&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Client: &lt;CLIENT DISPLAY NAME&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Description: &lt;DESCRIPTION&gt; </font> </li>  </ul>  </td>  </tr>  <tr style="background-color: #666666">  <td align="left" colspan="1">     </td>  </tr>  </table>  </center>  </td>  </tr>  </table>'
	DECLARE @templateId int
	-- Only one template for Simpana events. Hence retrieve the template id and store it here.
	SET @templateId = (SELECT TOP 1 templateId
						FROM APP_Template WITH(NOLOCK)
						WHERE templateForMonitoringType = 3)
	--Declaration ends
	BEGIN TRY
		DECLARE @disabled                   INT  = 1
		INSERT INTO NTNotificationRule (categoryId,             alertTypeId,
										notificationName,       revision,
										lastModified,           description,
										notifType,              notifOwner,
										locale,                 status,
										ruleState,              ruleState2,
										lastTimeTriggered,      lastTimeTriggered2,
										lastTimeChecked,        hasAttachments,
										hasAttachments2,        xmlEntityList,
										origCCId,               GUID            )
SELECT                          8,58,
										@notificationName,      1,
										@nowTime,               '',
1|131072 ,             @userid ,
@localeId,              2048|@disabled,
										-- Status 2049 ( Default alert, disabled ). Creating this alert in disabled state
										0,             0,
										@emptyDateTime,         @emptyDateTime,
										@emptyDateTime,         0,
										0,                      @allClientXmlEntities ,
										2,                      newid()
		SET @thisAlertId = @@Identity
		INSERT INTO NTSelCriteria (availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
SELECT 62,1, @thisAlertId, 1|2, 0, 3600
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
				VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
				VALUES (@thisAlertId, 2, null, null, 0)
		-- ADD DEFAULT (EMAIL) MESSAGE:                     --
		INSERT INTO NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
										SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
										baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
				VALUES(@thisAlertId, 1, 1, @textdefaultTemplateForDefaultAlert, N'', 0, 0, 0, 0, 0,null, null, null, null, 1, @htmldefaultTemplateForDefaultAlert),
					  (@thisAlertId, 131072, 1, @textdefaultTemplateForDefaultAlert, N'', 0, 0, 0, 0, 0,null, null, null, null, 0, '')
		INSERT INTO NTnotificationGroups(NTNotificationId,groupId,escalationLevel)
		SELECT @thisAlertId, @masterGroupId, 1
		SET @eventCriteriaXml = REPLACE(@eventCriteriaXmlOrig, '$MONITORING_POLICY_NAME$',@monitoringPolicyName)
		-- Add an entry into for "Simpana Event Log Monitoring" AlertType if criteria is present
		INSERT INTO NTSimpanaEventCriteria(commcellId, notifRuleId, templateId, criteriaXML, severity)
		SELECT 2, @thisAlertId, @templateId, @eventCriteriaXml, 0
		INSERT INTO NTnotificationProp
		VALUES(@thisAlertId,'Match Event Params',7,1,@nowTime,0)
	END TRY
	BEGIN CATCH
		SET @errorCode = ERROR_NUMBER()
		SET @errorMsg = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')
	END CATCH
	SELECT @thisAlertId,@errorCode,@errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'LM_CreateEventRaiserAlert')
	delete from GxQscripts where name = 'LM_CreateEventRaiserAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LM_CreateEventRaiserAlert')
	delete from GXDBVersions where aliasname = 'LM_CreateEventRaiserAlert'
GO

insert into GXDBVersions values(2, 'LM_CreateEventRaiserAlert',  '00010001000200040000', 'LM_CreateEventRaiserAlert', '00010001000200040000')
GO

