

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMUpdateReIndexedTimeRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Logesh G
--	Date:   02/12/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMUpdateReIndexedTimeRange.sp,v $ $Id: LMUpdateReIndexedTimeRange.sp,v 1.1.2.4 2018/03/27 08:54:00 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMUpdateReIndexedTimeRange()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Logesh G LMUpdateReIndexedTimeRange to insert reIndexing time range to db.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMUpdateReIndexedTimeRange <<<'

IF EXISTS (select * from sysobjects where name='LMUpdateReIndexedTimeRange')
	drop procedure LMUpdateReIndexedTimeRange
IF EXISTS (select * from GxQscripts where name='LMUpdateReIndexedTimeRange')
	delete from GxQscripts where name = 'LMUpdateReIndexedTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdateReIndexedTimeRange')
	delete from GXDBVersions where aliasname = 'LMUpdateReIndexedTimeRange'
GO
print '... Creating Procedure: LMUpdateReIndexedTimeRange'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMUpdateReIndexedTimeRange
  @inputXml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @mpId INT
	DECLARE @userId INT
	DECLARE @duration INT
	declare @reIndexTimeRangeTbl TABLE(startDate bigint , endDate bigint)
	declare @createdDate bigint = dbo.GetUnixTime(GETUTCDATE())
	SELECT @mpId = ref.value('@mpId','INT') ,
			@userId = ref.value('@userId','INT') ,
			@duration = isnull(ref.value('@duration','INT') , 7 )
	FROM @inputXml.nodes('LogMonitoring_reIndexTimeRangeInfo') AS R(ref)
	INSERT INTO @reIndexTimeRangeTbl
	SELECT ref.value('@startPeriod','bigint'),ref.value('@endPeriod','bigint')
	FROM @inputXml.nodes('LogMonitoring_reIndexTimeRangeInfo/requestedTimeInterval') AS R(ref)
	INSERT INTO App_LmCoreReqInfo
	SELECT @mpId , 2 ,@userId , startDate , endDate , @createdDate , @duration -- 2 = COMMCELLID
	FROM @reIndexTimeRangeTbl
GO

IF EXISTS (select * from GxQscripts where name = 'LMUpdateReIndexedTimeRange')
	delete from GxQscripts where name = 'LMUpdateReIndexedTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdateReIndexedTimeRange')
	delete from GXDBVersions where aliasname = 'LMUpdateReIndexedTimeRange'
GO

insert into GXDBVersions values(2, 'LMUpdateReIndexedTimeRange',  '00010001000200040000', 'LMUpdateReIndexedTimeRange', '00010001000200040000')
GO

