

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMUpdatePolicyProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMUpdatePolicyProp.sp,v $ $Id: LMUpdatePolicyProp.sp,v 1.4.66.5 2020/01/23 11:29:15 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMUpdatePolicyProp')
BEGIN
	print '>>> Drop Stored Procedure: LMUpdatePolicyProp <<<'
	drop procedure LMUpdatePolicyProp
END
IF EXISTS (select * from GxQscripts where name='LMUpdatePolicyProp')
	delete from GxQscripts where name = 'LMUpdatePolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdatePolicyProp')
	delete from GXDBVersions where aliasname = 'LMUpdatePolicyProp'
GO
print '... Creating Procedure: LMUpdatePolicyProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMUpdatePolicyProp
  @i_xml XML 
AS
  DECLARE @xmlStr xml
SET NOCOUNT ON
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @monitoringpolicyId INTEGER = ISNULL(( SELECT ref.value('@monitoringPolicyid','INTEGER') AS data  FROM @i_xml.nodes('LogMonitoring_UpdateMonitoringPolicyProps/monitoringPolicy') R(ref)),0)
DECLARE @fileSizeTbl TABLE(fileSize BIGINT)
DECLARE @totalFileSize BIGINT
--Check if its a on demand policy, if so update the DB
DECLARE @isOnDemand INTEGER = CONVERT(INTEGER,(SELECT TOP 1 attrVal FROM APP_MonitoringPolicyProp WHERE attrName like 'Monitoring Type' AND monitorPolicyId =@monitoringpolicyId ))
IF @isOnDemand = 4
BEGIN
DECLARE @uploadTag NVARCHAR(MAX)
DECLARE @uploadIds TABLE(id INTEGER, flag INTEGER, error INTEGER)
INSERT INTO @uploadIds
SELECT ISNULL(ref.value('@id','INTEGER'),0) AS data,ISNULL(ref.value('@flag','INTEGER'),3) AS flag, ISNULL(ref.value('@errorCode','INTEGER'),0) AS error
FROM @i_xml.nodes('LogMonitoring_UpdateMonitoringPolicyProps/lmODPFileUploadInfo') R(ref)
SET @uploadTag = ISNULL((SELECT TOP 1 upload.uploadTag FROM LMUploadInfo upload WITH(NOLOCK) INNER JOIN @uploadIds uploadTemp ON upload.id = uploadTemp.id),'')
-- upload ids present in this request are successfully indexed data
IF EXISTS (SELECT 1 FROM LMUPloadInfo Upload INNER JOIN @uploadIds successIds ON upload.id = successIds.id WHERE upload.id = successIds.id AND upload.flag != 3) -- if its already marked success ignore
BEGIN
	UPDATE Upload
	SET Upload.flag = successIds.flag, Upload.modified = @now, Upload.failureReason = successIds.error
	FROM LMUPloadInfo Upload INNER JOIN @uploadIds successIds
	ON upload.id = successIds.id
END
--SET @xmlStr = (SELECT  0 AS '@errorCode', '' AS '@errorMessage' FOR XML PATH ('CVGui_GenericResp'))
INSERT into @fileSizeTbl
SELECT ref.value('@fileSize','BIGINT')
FROM @i_xml.nodes('LogMonitoring_UpdateMonitoringPolicyProps/lmODPFileUploadInfo') R(ref)
SET @totalFileSize = (SELECT sum(fileSize) FROM @fileSizeTbl)
EXEC LMPopulateSizeOfIndexedData @totalFileSize , @monitoringpolicyId,1/*skip output*/
-- Now if all uploads under particular tag is completed, send a commit request to search immediately.
-- for that we need cloud info. so sending this as response.
IF NOT EXISTS (SELECT 1 FROM LMUploadInfo WITH(NOLOCK) WHERE monitoringPolicyId = @monitoringpolicyId AND uploadTag = @uploadTag AND flag <> 3)
BEGIN
	DECLARE @cloudReqXml xml = '<LogMonitoring_GetCloudClientInfoListReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monitoringpolicyId) + '"> <userEntity userId="1"> </userEntity> </LogMonitoring_GetCloudClientInfoListReq>'
	EXEC GetLMCloudClientList @cloudReqXml ,@xmlStr OUTPUT
END
ELSE
BEGIN
	SET @xmlStr = '<LogMonitoring_GetCloudClientInfoListResp errorcode="0"> </LogMonitoring_GetCloudClientInfoListResp>'
END
SELECT @xmlStr
END
ELSE
BEGIN
	--Update if data set into is present
	INSERT into @fileSizeTbl
	SELECT ref.value('@size','BIGINT')
	FROM @i_xml.nodes('LogMonitoring_UpdateMonitoringPolicyProps/dataSetInfo') R(ref)
	SET @totalFileSize = (SELECT sum(fileSize) FROM @fileSizeTbl)
	EXEC LMPopulateSizeOfIndexedData @totalFileSize , @monitoringpolicyId,1/*skip output*/
	exec [LMUpdateDataSetInfoForCI] @i_xml
END
GO

IF EXISTS (select * from GxQscripts where name = 'LMUpdatePolicyProp')
	delete from GxQscripts where name = 'LMUpdatePolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdatePolicyProp')
	delete from GXDBVersions where aliasname = 'LMUpdatePolicyProp'
GO

insert into GXDBVersions values(2, 'LMUpdatePolicyProp',  '00010004006600050000', 'LMUpdatePolicyProp', '00010004006600050000')
GO

