

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMUpdateCreatedCores.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Logesh G
--	Date:   02/12/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMUpdateCreatedCores.sp,v $ $Id: LMUpdateCreatedCores.sp,v 1.1.2.3 2018/03/27 09:15:26 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMUpdateCreatedCores()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Logesh G LMUpdateCreatedCores to give update App_LMCoreInfo table with the newly created cores.
--  |				Created cores are updated immediately because , while lm app loading , need to provide cores .Untill space check runs , core information will not be available
--  |				so coreName and default value will be updated in this proc && doc count will be updated when space check run.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMUpdateCreatedCores <<<'

IF EXISTS (select * from sysobjects where name='LMUpdateCreatedCores')
	drop procedure LMUpdateCreatedCores
IF EXISTS (select * from GxQscripts where name='LMUpdateCreatedCores')
	delete from GxQscripts where name = 'LMUpdateCreatedCores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdateCreatedCores')
	delete from GXDBVersions where aliasname = 'LMUpdateCreatedCores'
GO
print '... Creating Procedure: LMUpdateCreatedCores'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMUpdateCreatedCores
  @inputXml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @mpId INT
	DECLARE @clientId INT
	DECLARE @createdCores TABLE(coreName NVARCHAR(MAX))
	DECLARE @createdDate BIGINT = dbo.GetUnixTime(GETUTCDATE())
	SELECT @mpId = ref.value('@policyId','INT')
	FROM @inputXml.nodes('LogMonitoring_updateCreatedCoresReq') AS R(ref)
	INSERT INTO @createdCores
	SELECT ref.value('@val','NVARCHAR(MAX)')
	FROM @inputXml.nodes('LogMonitoring_updateCreatedCoresReq/createdCores') AS R(ref)
	SET @clientId = (SELECT ClientId
					FROM DM2SearchServerCoreInfo dm2 WITH(NOLOCK)
					WHERE CloudId = (SELECT attrVal FROM APP_MonitoringPolicyProp WITH(NOLOCK) WHERE monitorPolicyId = @mpId and attrName = 'Cloud Id')
					)
	UPDATE coreInfo
	SET coreInfo.IsLoaded = 1
	FROM App_LmCoreInfo coreInfo WITH(NOLOCK)
	INNER JOIN @createdCores createdCores
	ON coreInfo.CoreName = createdCores.coreName
	 --	Default values inserting to App_LMcoreReqInfo
	 -- 2 = commcellId , 0 = docCount(will updated at spacecheck)
	 -- 1 = isLoaded , 2 = default factor(week)
	INSERT INTO App_LmCoreInfo
	SELECT createdCores.coreName ,@clientId , @mpId , 2, 0 , 1 , 2 , @createdDate
	FROM @createdCores createdCores
	WHERE createdCores.coreName not in
	(
		select App_LmCoreInfo.CoreName
		from App_LmCoreInfo WITH(NOLOCK)
		where  PolicyId = @mpId
	)
GO

IF EXISTS (select * from GxQscripts where name = 'LMUpdateCreatedCores')
	delete from GxQscripts where name = 'LMUpdateCreatedCores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMUpdateCreatedCores')
	delete from GXDBVersions where aliasname = 'LMUpdateCreatedCores'
GO

insert into GXDBVersions values(2, 'LMUpdateCreatedCores',  '00010001000200030000', 'LMUpdateCreatedCores', '00010001000200030000')
GO

