

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMSetEnityAssocForMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMSetEnityAssocForMonitoringPolicy.sp,v $ $Id: LMSetEnityAssocForMonitoringPolicy.sp,v 1.2.88.3 2019/01/14 08:17:09 syadav Exp $";
--  +==================================================================================+
--  |Description : Does security check and save monitoring policy client/client group associations
--  |
--	|
--  | Input		 : LM Assoc  XML string
--	| Output	 : errorCode, errorMessage.  If success, errorCode = 0.
--  +==================================================================================+
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMSetEnityAssocForMonitoringPolicy')
BEGIN
	print '>>> Drop Stored Procedure: LMSetEnityAssocForMonitoringPolicy <<<'
	drop procedure LMSetEnityAssocForMonitoringPolicy
END
IF EXISTS (select * from GxQscripts where name='LMSetEnityAssocForMonitoringPolicy')
	delete from GxQscripts where name = 'LMSetEnityAssocForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSetEnityAssocForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMSetEnityAssocForMonitoringPolicy'
GO
print '... Creating Procedure: LMSetEnityAssocForMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMSetEnityAssocForMonitoringPolicy
  @userId integer,
  @monitoringPolicyId integer,
  @commcellId integer,
  @localeId integer,
  @xmlText XML  
AS
  DECLARE @errorCode int = 0
  DECLARE @errorMessage varchar(max) = 'Success'
DECLARE @clientGroupId integer=-1
DECLARE @clientId integer=-1
DECLARE @providerId integer=-1
DECLARE @isUserAdmin integer
DECLARE @time bigint
DECLARE @capabilityString nvarchar(max)
SET @capabilityString =(SELECT (dbo.fn_EvFormatEventMsgText(0,@localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 2), 0,2))+'/'+dbo.fn_EvFormatEventMsgText(0,@localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 1), 0,2))
SET @time =(select dbo.GetUnixTime(GETDATE()))
DECLARE @capability bigint=POWER(2,1-1)|POWER(2,2-1)
EXEC sec_isUserAdmin @userId,@isUserAdmin OUTPUT
IF(@isUserAdmin<>1)
BEGIN
  --CHECK FOR Admin/Agent management cap at commcell Level
	DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
	INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @userId , @commcellId, 2018, @commCellId
	IF (ISNULL((SELECT nodeCap & @capability FROM @t_userCaps), 0) <> 0)
    SET @isUserAdmin = 1;
END
IF(@isUserAdmin=1)
BEGIN
		DELETE FROM APP_MonitorAssocEntity where monitorPolicyId=@monitoringPolicyId
		INSERT INTO APP_MonitorAssocEntity
		SELECT @monitoringPolicyId,@commcellId,ref.value('@_type_','integer'),@time,ISNULL(ref.value('@clientGroupId','integer'),0),
		CASE
			WHEN ref.value('@clientId','integer') IS NOT NULL
				THEN ref.value('@clientId','integer')
			WHEN ref.value('@providerId', 'integer') IS NOT NULL
			   THEN ref.value('@providerId', 'integer')
		   ELSE 0
		END
		,ISNULL(ref.value('flags[1]/@exclude','integer'),0)
		FROM @xmlText.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
END
ELSE
BEGIN
	DECLARE @newclientGroupList   table ( clientGroupId int, exclude int)
	DECLARE @newclientList table ( clientId int, exclude int)
	DECLARE @newproviderList table ( providerId int, exclude int)
	DECLARE @deletedClientList Table (clientId int)
	DECLARE @deletedClientGroupList Table (clientGroupId int)
	DECLARE @deletedProviderList Table (providerId int)
	INSERT INTO @newclientGroupList
	SELECT DISTINCT ref.value('@clientGroupId','integer')  ,ISNULL(ref.value('flags[1]/@exclude','integer'),0) AS exclude
	FROM @xmlText.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 28
	INSERT INTO @newclientList
	SELECT DISTINCT ref.value('@clientId','integer')  ,ISNULL(ref.value('flags[1]/@exclude','integer'),0) AS exclude
	FROM @xmlText.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 3
	INSERT INTO @newproviderList
	SELECT DISTINCT ref.value('@providerId','integer') , ISNULL(ref.value('flags[1]/@exclude','integer'),0) AS exclude
	FROM @xmlText.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 61
	INSERT INTO @deletedClientGroupList
	SELECT  clientGroupId
	FROM APP_MonitorAssocEntity
WHERE   monitorPolicyId =@monitoringPolicyId AND flags=28 AND clientGroupId not in (select clientGroupId from @newclientGroupList)
	INSERT INTO @deletedClientList
	SELECT clientId
	FROM APP_MonitorAssocEntity
WHERE   monitorPolicyId =@monitoringPolicyId AND flags=3 AND clientId not in (select clientId from @newclientList)
	INSERT INTO @deletedClientList
	SELECT clientId
	FROM APP_MonitorAssocEntity
WHERE   monitorPolicyId =@monitoringPolicyId AND flags=61 AND clientId not in (select clientId from @newproviderList)
	--GEt only added/changed client/clientgroupList
	DELETE CLIENTTBL
	from @newclientList CLIENTTBL inner join APP_MonitorAssocEntity MAE on  MAE.clientId=CLIENTTBL.clientId and MAE.exclude=CLIENTTBL.exclude and MAE.monitorPolicyID=@monitoringPolicyId
where flags=3
	DELETE CLIENTGRPTBL
	from @newclientGroupList CLIENTGRPTBL inner join APP_MonitorAssocEntity MAE on  MAE.clientGroupId=CLIENTGRPTBL.clientGroupId and MAE.exclude=CLIENTGRPTBL.exclude and  MAE.monitorPolicyID=@monitoringPolicyId
where flags=28
	DELETE PROVIDERTBL
	from @newproviderList PROVIDERTBL inner join APP_MonitorAssocEntity MAE on  MAE.clientId=PROVIDERTBL.providerId and MAE.monitorPolicyID=@monitoringPolicyId
where flags=61
	--GetAccessible client and client group list
	IF object_id('tempdb.dbo.#ClientGroupObjects') is not null
        DROP TABLE #ClientGroupObjects
create table  #ClientGroupObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,2572,0,'#ClientGroupObjects'
	DELETE FROM #ClientGroupObjects
	WHERE  capabilities&@capability=0
	--NOW CHECK IF ANY User group is added/changed without the rights on...throw the error.
	SET  @clientGroupId 	= ISNULL((SELECT TOP 1 clientGroupId FROM @newclientGroupList where clientGroupId not in (select clientGroupId from #ClientGroupObjects)),0)
	IF @clientGroupId <>0
	BEGIN
SET @errorCode=(462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
		SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 name FROM APP_ClientGroup with (NOLOCK) WHERE id =@clientGroupId ))
		GOTO EXITPROC
	END
	SET  @clientGroupId 	=ISNULL((SELECT TOP 1 clientGroupId FROM @deletedClientGroupList where clientGroupId not in (select clientGroupId from #ClientGroupObjects)),0)
	IF @clientGroupId <>0
	BEGIN
	   --JUST SET ERROR STRING FOR LOGS
		SET @errorCode=1
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
		SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 name FROM APP_ClientGroup with (NOLOCK) WHERE id =@clientGroupId ))
		DELETE FROM @deletedClientGroupList
		WHERE clientGroupId not in (select clientGroupId from #ClientGroupObjects)
	END
	DROP TABLE #ClientGroupObjects
	IF object_id('tempdb.dbo.#ClientObjects') is not null
        DROP TABLE #ClientObjects
create table  #ClientObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,2009,0,'#ClientObjects'
	DELETE FROM #ClientObjects
	WHERE  capabilities&@capability=0
	--NOW CHECK IF ANY User group is added/changed without the rights on...throw the error.
	SET @clientId = ISNULL((SELECT TOP 1 clientId FROM @newclientList where clientId not in (select clientId from #ClientObjects)),0)
	IF @clientId<>0
	BEGIN
SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
      SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
	  SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
      SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 name FROM APP_CLIENT WITH (NOLOCK)WHERE id =@clientId))
		GOTO EXITPROC
	END
	SET @clientId = ISNULL((SELECT TOP 1 clientId FROM @deletedClientList where clientId not in (select clientId from #ClientObjects)),0)
	IF @clientId<>0
	BEGIN
	   --JUST SET ERROR STRING FOR LOGS
		SET @errorCode=1
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		 SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
		 SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 name FROM APP_CLIENT WITH (NOLOCK)WHERE id =@clientId))
		DELETE FROM @deletedClientList
		WHERE clientId not in (select clientId from #ClientObjects)
	END
	DROP TABLE #ClientObjects
	-- Provider security check
	IF OBJECT_ID('tempdb.dbo.#GetPlanAssociationsV2_VisibleNonIDAEntities') IS NOT NULL DROP TABLE #VisibleNonIDAEntities
	CREATE TABLE #VisibleNonIDAEntities (entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 61, 0, '#VisibleNonIDAEntities'
	--NOW CHECK IF ANY User group is added/changed without the rights on...throw the error.
	SET @providerId = ISNULL((SELECT TOP 1 providerId FROM @newproviderList where providerId not in (select entityId from #VisibleNonIDAEntities)),0)
	IF @providerId<>0
	BEGIN
SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
      SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
	  SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
      SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 domainname FROM UMDSProviders WITH (NOLOCK)WHERE id =@providerId))
		GOTO EXITPROC
	END
	SET @providerId = ISNULL((SELECT TOP 1 providerId FROM @deletedproviderlist where providerId not in (select entityId from #VisibleNonIDAEntities)),0)
	IF @clientId<>0
	BEGIN
	   --JUST SET ERROR STRING FOR LOGS
		SET @errorCode=1
SET @errorMessage = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		 SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
		 SET @errorMessage = REPLACE(@errorMessage, '^2%s', @capabilityString )
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', (SELECT top 1 domainname FROM UMDSProviders WITH (NOLOCK)WHERE id =@providerId))
		DELETE FROM @deletedproviderlist
		WHERE providerId not in (select entityId from #VisibleNonIDAEntities)
	END
	DROP TABLE #VisibleNonIDAEntities
	--NOW All secuirty done, delete rows and update/insert new rows
	DELETE MAssocTBL
FROM APP_MonitorAssocEntity MAssocTBL JOIN @deletedClientList del on MAssocTBL.ClientId=del.clientId and flags=3
	WHERE monitorPolicyId=@monitoringPolicyId
	DELETE MAssocTBL
FROM APP_MonitorAssocEntity MAssocTBL JOIN @deletedClientGroupList del on MAssocTBL.clientGroupId=del.clientGroupId and flags=28
	WHERE monitorPolicyId=@monitoringPolicyId
	DELETE MAssocTBL
FROM APP_MonitorAssocEntity MAssocTBL JOIN @deletedProviderList del on MAssocTBL.ClientId=del.ProviderId and flags=61
	WHERE monitorPolicyId=@monitoringPolicyId
	MERGE APP_MonitorAssocEntity as MAE
	USING (SELECT clientId,exclude from @newClientList) newList
ON MAE.clientId=newList.clientId and monitorPolicyId=@monitoringPolicyId and flags=3
	WHEN MATCHED THEN
	      UPDATE SET MAE.exclude=newList.exclude
	WHEN NOT MATCHED THEN
INSERT VALUES(@monitoringPolicyId,@commcellId,3,@time,0,newList.clientId,newList.exclude);
   MERGE APP_MonitorAssocEntity as MAE
   USING (SELECT clientGroupId,exclude from @newClientGroupList) newList
ON MAE.clientGroupId=newList.clientGroupId and monitorPolicyId=@monitoringPolicyId and flags=28
	WHEN MATCHED THEN
	      UPDATE SET MAE.exclude=newList.exclude
	WHEN NOT MATCHED THEN
INSERT VALUES(@monitoringPolicyId,@commcellId,28,@time,newList.clientGroupId,0,newList.exclude);
	MERGE APP_MonitorAssocEntity as MAE
	USING (SELECT providerId, exclude from @newProviderList) newList
ON MAE.clientId=newList.providerId and monitorPolicyId=@monitoringPolicyId and flags=61
	WHEN MATCHED THEN
	      UPDATE SET MAE.exclude=newList.exclude
	WHEN NOT MATCHED THEN
INSERT VALUES(@monitoringPolicyId,@commcellId,61,@time,0,newList.providerId,newList.exclude);
END
EXITPROC:
     SELECT @errorCode,@errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'LMSetEnityAssocForMonitoringPolicy')
	delete from GxQscripts where name = 'LMSetEnityAssocForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSetEnityAssocForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMSetEnityAssocForMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMSetEnityAssocForMonitoringPolicy',  '00010002008800030000', 'LMSetEnityAssocForMonitoringPolicy', '00010002008800030000')
GO

