

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMSendAlertProcessingWorkQueueReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMSendAlertProcessingWorkQueueReq.sp,v $ $Id: LMSendAlertProcessingWorkQueueReq.sp,v 1.1.2.2 2018/03/27 09:19:17 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMSendAlertProcessingWorkQueueReq <<<'

IF EXISTS (select * from sysobjects where name='LMSendAlertProcessingWorkQueueReq')
	drop procedure LMSendAlertProcessingWorkQueueReq
IF EXISTS (select * from GxQscripts where name='LMSendAlertProcessingWorkQueueReq')
	delete from GxQscripts where name = 'LMSendAlertProcessingWorkQueueReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSendAlertProcessingWorkQueueReq')
	delete from GXDBVersions where aliasname = 'LMSendAlertProcessingWorkQueueReq'
GO
print '... Creating Procedure: LMSendAlertProcessingWorkQueueReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMSendAlertProcessingWorkQueueReq
  @newClientId int,
  @oldClientId int,
  @errorCode INT output,
  @errorString nvarchar(MAX) output
AS
Set transaction isolation level read uncommitted
-- newClientId is new Top MA
-- oldClientId is old MA
-- After sending workQueue Request to both clients, newClientId will have AlertRules & oldClientId will have empty AlertRules
DECLARE @clientId INT
--DECLARE @errorCode INT = 0
--DECLARE @errorString nvarchar(MAX) = ''
DECLARE @noOfWQRequestToSend INT = 2
DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))
SET @clientId = ISNULL(@newClientId , 0)
WHILE (@noOfWQRequestToSend > 0)
BEGIN
	IF @clientId > 0
	BEGIN
		-- send workQueue Request to next lm cloud to process Alert.
		-- Also cache of deleted MA will be having alert Rules . So send WQ to that MA also . That MA will get empty response from lmgetsearchalertandinfo.sp
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clientId, 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="0" operationType="8"/>'
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
		IF @errorCode <> 0
		BEGIN
			GOTO errorexit
		END
	END
	DELETE FROM @workQOutPutTbl
	SET @clientId = ISNULL(@oldClientId,0)
	SET @noOfWQRequestToSend = (@noOfWQRequestToSend - 1)
END
errorexit:
--SELECT @errorCode ,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'LMSendAlertProcessingWorkQueueReq')
	delete from GxQscripts where name = 'LMSendAlertProcessingWorkQueueReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSendAlertProcessingWorkQueueReq')
	delete from GXDBVersions where aliasname = 'LMSendAlertProcessingWorkQueueReq'
GO

insert into GXDBVersions values(2, 'LMSendAlertProcessingWorkQueueReq',  '00010001000200020000', 'LMSendAlertProcessingWorkQueueReq', '00010001000200020000')
GO

