

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMSearchOperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMSearchOperations.sp,v $ $Id: LMSearchOperations.sp,v 1.17.12.38 2018/09/18 18:52:21 snandhini Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMSearchOperations <<<'

IF EXISTS (select * from sysobjects where name='LMSearchOperations')
	drop procedure LMSearchOperations
IF EXISTS (select * from GxQscripts where name='LMSearchOperations')
	delete from GxQscripts where name = 'LMSearchOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSearchOperations')
	delete from GXDBVersions where aliasname = 'LMSearchOperations'
GO
print '... Creating Procedure: LMSearchOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMSearchOperations
  @userId INTEGER,
  @inputxml_req xml,
  @o_xmlMsg xml		OUTPUT
AS
	DECLARE		@errorCode INTEGER = 0
	DECLARE		@errStr	NVARCHAR(MAX) = ''
	DECLARE 	@input XML = @inputxml_req
	DECLARE		@opertaionsType INTEGER = 0
	DECLARE		@searchId INTEGER = 0
	DECLARE		@entityType     int = 9647
	DECLARE		@nowTime INTEGER = dbo.GetUnixTime(GetUTCDate());
	DECLARE		@searchInfoXml xml
	DECLARE		@searchInfoOldXml xml
	Declare		@includeMySearchesOnly int
	DECLARE @appType int
	DECLARE		@origSearchInfoXMLTbl table
	(
		searchId		  int,
		origSearchInfoXML XML
	)
DECLARE @newTemplate INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name='UseNewAlertTemplate'),0)
	DECLARE		@recentSearchCount INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMRecentSearchCountPerUser'),20)
	SET @opertaionsType = ISNULL((SELECT R.ref.value('@operationType','INTEGER') AS data FROM @input.nodes('LogMonitoring_SearchOperationReq') R ( ref )),0)
	SET @includeMySearchesOnly = ISNULL((SELECT R.ref.value('@includeMySearchesOnly','INTEGER') AS data FROM @input.nodes('LogMonitoring_SearchOperationReq') R ( ref )),1)
	BEGIN TRY
	BEGIN TRANSACTION LMSearchOperationsTran
	DECLARE @LMSerachTemp TABLE
		(
			searchId			integer,
			searchName			nvarchar(1024),
			isPrivate			tinyint,
			creatorUserId		INTEGER,
			status 				INTEGER,
			dashInfo			xml,
			appType				INTEGER,
			searchInfo			nvarchar(max),
			associations		xml,
			policiesForAlert 	xml
		);
	DECLARE @LMSearchSec TABLE
		(
			searchId INTEGER,
			type INTEGER,
			userid INTEGER,
			userGroupId INTEGER,
			externalUserGroupId INTEGER,
			providerId INTEGER,
			capabilities BIGINT
		);
	DECLARE @supportedCriteriaForRepeatedAlerts Table
	(
		lmAlertType int
	)
	DECLARE @alertPropCount INTEGER = 0
	DECLARE @i INTEGER
	DECLARE @curAlertXml XML
	DECLARE @curAlertId INTEGER
	DECLARE @curAlertname NVARCHAR(MAX)
	Insert into @supportedCriteriaForRepeatedAlerts
	select 2 -- RATE_OF_CHANGE
	union
	select 3 --INSTANT_FIELD_VALUE_FILTER
	union
	select 5 --Compare events
	DECLARE @dashBoards TABLE (dashId INTEGER, dashName NVARCHAR(1024), creator INTEGER,status INTEGER , appType INTEGER, dashBoardProp XML)
	DECLARE @alertInfoForSearch TABLE (alertOperation int,notificationType int,emailIdsList xml,
	thisManyTimes int, withinTheseManyMinutes int,alertId int,alertName nvarchar(max),searchId int,
	linesAboveMatchedLine int, linesBelowMatchedLine int, lmAlertType int, alertCriteria NVARCHAR(max), workflowEntity xml, notifMessageHtml NVARCHAR(max),additionalInfo NVARCHAR(max),alertConfigInfo xml, rateOfChangeAlertInfo xml,associatedPolicyList xml,lmGroupByField NVARCHAR(max),useGroupBy int,dynamicRecipientList xml, colNameForRecipient nvarchar(512),timezoneInfo NVARCHAR(max),status int,addColsInEmail int,colsToDisplayInAlertEmail nvarchar(max))
	DECLARE @LMSearchdeleteData TABLE(searchId INT,alertId INT,isImplicitShldDelete INT)
	INSERT INTO @LMSerachTemp
	SELECT
			ISNULL(ref.value('@searchId','INTEGER'),0) as searchId,
			ref.value('@searchName','NVARCHAR(1024)'),
			ref.value('@isPrivate','TINYINT'),
			(SELECT ISNULL(ref1.value('@userId','INTEGER'),0) as userid FROM ref.nodes('creator') R(ref1)) as creator,
			ref.value('@status','INTEGER'),
			ISNULL(ref.query('dashInfo'),'<dashInfo/>'),
			isnull( ref.value('@appType','INTEGER') , 1 ),
			ref.value('@urlInfo','NVARCHAR(MAX)'),
			ref.query('secAssociations'),
			ISNULL(ref.query('policiesForAlert'),'')
			FROM @input.nodes('LogMonitoring_SearchOperationReq/searchInfo') R ( ref )
	--SELECT * FROM @LMSerachTemp
	--Set Operation
	IF(@opertaionsType != 5)
	begin
		-- Check whether this user is creator. Or else he needs to be admin at CS level.
		if exists(select 1 from LMUserSearch inner join @LMSerachTemp LMUserInput on
			LMUserInput.searchId=LMUserSearch.searchId where LMUserSearch.creatorUserId!=@userId)
		begin
			IF object_id('tempdb.dbo.#searchListTmp') is not null
                DROP TABLE #searchListTmp
create table  #searchListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
			exec dbo.sec_getuserObjects @userID, 2018, 2, '#searchListTmp'
			DECLARE @capabiliesWant     int
			declare @userHasRight int
			set @userHasRight = 0
set @capabiliesWant = POWER(2, (1-1))
			if exists(select 1 from #searchListTmp sec WHERE (capabilities & @capabiliesWant) <> 0 and
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
			begin
				set @userHasRight = 1
			end
			if @userHasRight = 0
			begin
				DECLARE @errorMsg NVARCHAR(MAX) = ''
				SET @errorCode = 6
				IF(@opertaionsType = 3)--delete
				BEGIN
					SET @errorMsg = 'User does not have permission to delete search'
				END
				ELSE if (@opertaionsType<>10 and @opertaionsType<>11 and @opertaionsType<>12)
				begin
					SET @errorMsg = 'User does not have permission to modify search details'
				end
				else
				begin
					SET @errorMsg = 'User does not have permission to perform operation on alert'
				end
				RAISERROR (@errorMsg, -- Message text.
						16, -- Severity.
							1 -- State.
				);
			end
		end
	end
	-- @opertaionsType 13 , 14 ,15 are used for creating , modifying , deleting columnView for saved search.
	IF(@opertaionsType = 13 OR @opertaionsType = 14 OR @opertaionsType = 15)
	BEGIN
		DECLARE @searchUrlInfo XML
		DECLARE @searchTabXml XML
		DECLARE @defaultTabName NVARCHAR(50)
		DECLARE @tabName NVARCHAR(50)
		SET @searchUrlInfo = ISNULL(( SELECT TOP 1 searchInfo FROM @LMSerachTemp ) , '')
		SET @searchTabXml = ISNULL((SELECT @searchUrlInfo.query('LogMonitoring_SearchURLInfo/searchTabs')) , '')
		SET @defaultTabName = ISNULL( (SELECT ref.value('@defaultTabName','nvarchar(max)') FROM @searchUrlInfo.nodes('LogMonitoring_SearchURLInfo') R(ref)) , '')
		SET @searchUrlInfo = (SELECT  TOP 1 LMUserSearch.searchInfo FROM LMUserSearch inner join @LMSerachTemp LMSearchTemp on LMUserSearch.searchId  = LMSearchTemp.searchid)
		IF(@opertaionsType <> 15) -- Operation on default View name
		BEGIN
			-- Below statement is to add or modify the default view Name
			IF @searchUrlInfo.exist('/LogMonitoring_SearchURLInfo/@defaultTabName') = 1
			BEGIN
				-- modify existing defaultTabName
				SET @searchUrlInfo.modify(' replace value of (LogMonitoring_SearchURLInfo/@defaultTabName) [1] with sql:variable("@defaultTabName") ')
			END
			ELSE
			BEGIN
				-- add new defaultviewName
				SET @searchUrlInfo.modify(' insert attribute defaultTabName {sql:variable("@defaultTabName")} as first into (/LogMonitoring_SearchURLInfo)[1] ')
			END
		END
		IF(@opertaionsType = 13) -- creating new view
		BEGIN
		-- Now append searchTabXML to searchUrlInfo
			SET @searchUrlInfo.modify('insert sql:variable("@searchTabXml") into (LogMonitoring_SearchURLInfo)[1] ')
		END
		IF(@opertaionsType = 14) -- modify existing view
		BEGIN
			DECLARE @oldTabName nvarchar(max)
			SET @tabName = ISNULL((select ref.value('@tabName','nvarchar(max)') from @searchTabXml.nodes('searchTabs') R(ref)),'')
			SET @oldTabName =ISNULL( (SELECT ref.value('@oldTabName','nvarchar(max)') FROM @searchTabXml.nodes('searchTabs') R(ref)) , '' )
			IF @oldTabName <> ''
			BEGIN
				-- Delete the columns under oldTabName and update it with new TabName
				set @searchUrlInfo.modify('delete //LogMonitoring_SearchURLInfo/searchTabs[@tabName=sql:variable("@oldTabName")] ')
			END
			ELSE
			BEGIN
				-- now parse the searchUrlInfo xml and delete child xml with attribute = tabName of value @tabName and insert new @searchTabXml
				SET @searchUrlInfo.modify('delete //LogMonitoring_SearchURLInfo/searchTabs[@tabName=sql:variable("@tabName")] ')
			END
			SET @searchUrlInfo.modify('insert sql:variable("@searchTabXml") into (LogMonitoring_SearchURLInfo)[1] ')
		END
		IF(@opertaionsType = 15) -- delete search tab
		BEGIN
			SET @tabName = ISNULL((select ref.value('@tabName','nvarchar(max)') from @searchTabXml.nodes('searchTabs') R(ref)) , '')
			SET @searchUrlInfo.modify('delete //LogMonitoring_SearchURLInfo/searchTabs[@tabName=sql:variable("@tabName")] ')
		END
		UPDATE lmSearch
		SET lmSearch.searchInfo = @searchUrlInfo
		FROM LMUserSearch lmSearch
		inner join @LMSerachTemp LMSearchTemp
		ON lmSearch.searchId = LMSearchTemp.searchid
	END
	IF(@opertaionsType = 5)
	BEGIN
			--fetch each row from @lmsearchtemp and iterate
			DECLARE @curSearchName			VARCHAR(1024)
			DECLARE @CurIsPrivate			tinyint
			DECLARE @curCreatorUserId		INTEGER
			DECLARE @curStatus 				INTEGER
			DECLARE @curDashInfo			xml
			DECLARE @curAppType				INTEGER
			DECLARE @curSearchInfo			nvarchar(max)
			DECLARE @curAssociations		xml
			DECLARE searchCursor CURSOR FOR
			SELECT searchName, isPrivate, creatorUserId,status, dashInfo, appType, searchInfo, associations
			FROM @LMSerachTemp
			OPEN searchCursor
			FETCH NEXT FROM searchCursor
			INTO @curSearchName, @CurIsPrivate, @curCreatorUserId, @curStatus, @curDashInfo, @curAppType, @curSearchInfo, @curAssociations
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF EXISTS(SELECT * FROM LMUserSearch WITH (NOLOCK) WHERE searchName = @curSearchName AND creatorUserId = @curCreatorUserId AND monitoringAppType = @curAppType)
				BEGIN
					SET @errorCode = 2
					IF (@errStr = '')
					BEGIN
						SET @errStr = 'SearchName already exists: ' + @curSearchName
					END
					ELSE
					BEGIN
						SET @errStr = @errStr + ', SearchName already exists: ' + @curSearchName
					END
					DELETE FROM @LMSerachTemp WHERE searchName = @curSearchName AND creatorUserId = @curCreatorUserId AND appType = @curAppType
					FETCH NEXT FROM searchCursor
					INTO @curSearchName, @CurIsPrivate, @curCreatorUserId, @curStatus, @curDashInfo, @curAppType, @curSearchInfo, @curAssociations
					CONTINUE
				END
				-- This is addeded to eliminate index error(size > 900)--> So truncating the lenght of searchName
				IF (LEN(@curSearchName) > 200)
				BEGIN
					DECLARE @oldSearchName VARCHAR(1024) = @curSearchName
					SET @curSearchName = left(@curSearchName , 200) +  CONVERT( NVARCHAR(MAX) , HashBytes('MD5' , @curSearchName) , 2 )
					UPDATE lmtemp
					SET lmtemp.searchName = @curSearchName
					FROM @LMSerachTemp lmtemp
					WHERE lmtemp.searchName = @oldSearchName
				END
				INSERT INTO LMUserSearch(searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)
				VALUES (@curSearchName, @CurIsPrivate, @curCreatorUserId, @curStatus, @curSearchInfo, @nowTime, 0, @curAppType)
				SET @searchId = @@IDENTITY
				IF @searchId IS NULL
				BEGIN
					SET @errorCode = 3
					IF (@errStr = '')
					BEGIN
						SET @errStr = 'Failed to save search: ' + @curSearchName
					END
					ELSE
					BEGIN
						SET @errStr = @errStr + ', Failed to save search: ' + @curSearchName
					END
					DELETE FROM @LMSerachTemp WHERE searchName = @curSearchName AND creatorUserId = @curCreatorUserId AND appType = @curAppType
					FETCH NEXT FROM searchCursor
					INTO @curSearchName, @CurIsPrivate, @curCreatorUserId, @curStatus, @curDashInfo, @curAppType, @curSearchInfo, @curAssociations
					CONTINUE
				END
				IF ((@curStatus & 2)<>0)
				BEGIN
					SET @searchInfoXml = @curSearchInfo
					-- When Saved search is added, alert will always be added. no need to pick up operation type from xml
					Insert into @alertInfoForSearch(alertOperation,notificationType ,thisManyTimes , withinTheseManyMinutes ,alertId ,alertName,emailIdsList,searchId,linesAboveMatchedLine,linesBelowMatchedLine,
						lmAlertType , alertCriteria, additionalInfo, notifMessageHtml,lmGroupByField,useGroupBy,workflowEntity, alertConfigInfo, rateOfChangeAlertInfo,associatedPolicyList,dynamicRecipientList,colNameForRecipient,timezoneInfo,status,addColsInEmail,colsToDisplayInAlertEmail)
					SELECT 5,
					ISNULL(R.alert.value('@notifType','INTEGER'),0),
					ISNULL(R.alert.value('@thisManyTimes','INTEGER'),0),
					ISNULL(R.alert.value('@withinTheseManyMinutes','INTEGER'),0),
					ISNULL(R.alert.value('(alertEntity/@alertId)[1]','INTEGER'),0),
					dbo.decodeInvalidXMLCharsCLR(ISNULL(R.alert.value('(alertEntity/@alertName)[1]','nvarchar(256)'),'')),
					ISNULL(R.alert.query('emailIds'),''),
					@searchId,
					ISNULL(R.alert.value('@linesAboveMatchedLine','INTEGER'),0),
					ISNULL(R.alert.value('@linesBelowMatchedLine','INTEGER'),0),
					ISNULL(R.alert.value('@alertType','INTEGER'),0),
					ISNULL(R.alert.value('@alertCriteria','nvarchar(max)'),''),
					ISNULL(R.alert.value('@additionalInfo','nvarchar(max)'),''),
					ISNULL(R.alert.value('@notifMessageHtml','nvarchar(max)'),''),
					ISNULL(R.alert.value('@lmGroupByField','nvarchar(max)'),''),
					ISNULL(R.alert.value('@useGroupBy','INTEGER'),0),
					R.alert.query('workflowEntity'),
					R.alert.query('alertConfigInfo'),
					R.alert.query('rateOfChangeAlertInfo'),
					ISNULL(R.alert.query('associatedPolicyList'),''),
					R.alert.query('dynamicRecipientsList'),
					ISNULL(R.alert.value('@colNameForComputingReceipients','nvarchar(512)'),''),
					ISNULL(R.alert.value('@timezoneInfo','nvarchar(max)'),''),
					ISNULL(R.alert.value('@status','INTEGER'),1),
					ISNULL(R.alert.value('@addColsInEmail','INTEGER'),0),
					ISNULL(R.alert.value('@colsToDisplayInAlertEmail','nvarchar(max)'),'')
					FROM
					@searchInfoXml.nodes('LogMonitoring_SearchURLInfo/alertInfoLst') as R(alert)
				END
				FETCH NEXT FROM searchCursor
				INTO @curSearchName, @CurIsPrivate, @curCreatorUserId, @curStatus, @curDashInfo, @curAppType, @curSearchInfo, @curAssociations
			END
			CLOSE searchCursor
			DEALLOCATE searchCursor
			--delete all recent searches except the top 20
			DELETE FROM LMUserSearch
			WHERE searchId NOT IN (SELECT TOP (@recentSearchCount) lms1.searchId FROM LMUserSearch lms1 WHERE (lms1.status & 1) <> 0 ORDER BY lms1.searchId DESC)
			AND (status & 1) <> 0
			--add dashboard
			IF (((SELECT status FROM LMUserSearch WHERE searchId = @searchId) & 4)<>0)
			BEGIN
				DECLARE @dashInfo XML = ISNULL((SELECT TOP 1 dashInfo FROM @LMSerachTemp),'<dashInfo/>')
				set @appType  = ISNULL((select TOP 1 appType FROM @LMSerachTemp),1)
				DECLARE @dashStatus INTEGER = 0
				INSERT INTO @dashBoards(dashId,dashName,creator,status,appType,dashBoardProp)
				SELECT ISNULL(R.dash.value('@dashBoardId','INTEGER'),0),
							ISNULL(R.dash.value('@dashBoardName','NVARCHAR(1024)'),''),
							ISNULL((SELECT R.usr.value('@userId','INTEGER') FROM @dashInfo.nodes('dashInfo/creator') as R(usr)),@userId),
							ISNULL(R.dash.value('@status','INTEGER'),0),
							@appType,
							ISNULL(R.dash.value('@dashBoardProp[1]','NVARCHAR(MAX)'),CAST('<LogMonitoring_DashBoardProp/>'  AS NVARCHAR(MAX)))
							FROM
							@dashInfo.nodes('dashInfo') as R(dash)
				IF NOT EXISTS(SELECT 1 FROM @dashBoards WHERE (status & 4 <> 0 OR status & 8 <> 0 OR creator = @userId) AND dashId <> 0) AND NOT EXISTS (SELECT 1 FROM @dashBoards WHERE (status & 4 <> 0 OR status & 8 <> 0 OR creator = @userId) AND dashId = 0)
				BEGIN
					--if no dashboard information is sent chck if a default dashboard exists
					IF EXISTS (SELECT TOP 1 dashBoardId FROM LMdashBoard WHERE creatorUserId = @userId AND (status & 2) <> 0 AND monitoringAppType = @appType ORDER BY dashBoardId)
					BEGIN
						INSERT INTO @dashBoards(dashId,dashName,creator,status,appType,dashBoardProp)
						SELECT TOP 1 dashBoardId,dashBoardName,creatorUserId,status,monitoringAppType,dashBoardProp FROM LMdashBoard WHERE creatorUserId = @userId AND (status & 2) <> 0 AND monitoringAppType = @appType ORDER BY dashBoardId
					END
					ELSE
					BEGIN
						--Create a default dash board
						--This is creation part. So take appType from temp table and insert into db.
							set @appType = isnull((select monitoringAppType from LMUserSearch where searchId=@searchId),1)
						INSERT INTO @dashBoards(dashId,dashName,creator,status,appType,dashBoardProp)
						SELECT 0,'',@userId,2,@appType,''
					END
				END
				DECLARE @createDashXML XML = (SELECT @opertaionsType as '@operationType',
					dashId as 'dashBoardInfo/@dashBoardId',
					dashName as 'dashBoardInfo/@dashBoardName',
					1 as 'dashBoardInfo/@isPrivate',
					ISNULL(status,0) as 'dashBoardInfo/@status',
					ISNULL(appType,1) as 'dashBoardInfo/@appType',
					CONVERT(NVARCHAR(MAX),dashBoardProp) as 'dashBoardInfo/@dashBoardProp',
					creator as 'dashBoardInfo/creator/@userId'
					FROM @dashBoards WHERE dashId = 0
					FOR XML PATH('LogMonitoring_DashBoardOperationReq'))
				IF @createDashXML IS NOT NULL --If New dash board has to be created for this
				BEGIN
					DECLARE @createDashXMLResp XML
					exec LMDashBoardOperations @userId,@createDashXML,@createDashXMLResp OUTPUT
					DECLARE @newDashID INTEGER = ISNULL((SELECT ref.value('@dashBoardId','INTEGER') FROM @createDashXMLResp.nodes('LogMonitoring_DashBoardListResp/dashBoardInfoList') as R(ref)),0)
					IF @newDashID <> 0
					BEGIN
						INSERT INTO LMDashSearchAssoc
						SELECT @newDashID, searchId
						FROM LMUserSearch
						WHERE searchName IN (SELECT searchName FROM @LMSerachTemp) AND monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp)
					END
					ELSE
					BEGIN
						SET @errorCode  = (SELECT ref.value('@errorCode','INTEGER') FROM @createDashXMLResp.nodes('LogMonitoring_GenericEntityResponse') as R(ref))
						SET @errStr =  ISNULL((SELECT ref.value('@errorString','INTEGER') FROM @createDashXMLResp.nodes('LogMonitoring_GenericEntityResponse') as R(ref)),'')
						IF @errorCode IS NULL OR @errStr IS NULL OR @errStr = ''
							RAISERROR('Failed to create dashboard, Please check logs for more info.',16,1)
						ELSE
						BEGIN
								SET @errorCode = 4
								RAISERROR(@errStr,16,1)
						END
					END
				END
				ELSE
				BEGIN
					DELETE FROM LMDashSearchAssoc
						WHERE dashboardId IN (SELECT dashId FROM @dashBoards WHERE dashId <> 0)
						AND searchId IN (SELECT searchId FROM LMUserSearch WHERE searchName IN (SELECT searchName FROM @LMSerachTemp) AND monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp))
					DECLARE @curDashId INTEGER = (SELECT TOP 1 dashId FROM @dashBoards WHERE dashId <> 0)
					INSERT INTO LMDashSearchAssoc
					SELECT @curDashId, searchId FROM LMUserSearch WHERE searchName IN (SELECT searchName FROM @LMSerachTemp) AND monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp)
					-- update new dashboard props as per latest search in that dashboard
					UPDATE LMDashBoard
					SET dashBoardProp = (SELECT dashBoardProp FROM @dashBoards WHERE dashId <> 0)
					WHERE dashBoardId = (SELECT dashId FROM @dashBoards WHERE dashId <> 0)
				END
			END
			--get creator
			DECLARE @creator INTEGER = 0;
			SELECT @creator = creatorUserId
			FROM LMUserSearch
			WHERE searchId = @searchId
			DECLARE @creatorCap BIGINT = CAST(POWER(2.0, 31  - 1) AS bigint) --View
											| CAST(POWER(2.0, 33 - 1) AS bigint)  -- Execute
												| CAST(POWER(2.0, 34 - 1) AS bigint) -- edit
													| CAST(POWER(2.0, 35 - 1) AS bigint) -- delete
	END
	-- MODIFY Operation
	IF(@opertaionsType = 2)
	BEGIN
		IF EXISTS (SELECT 1 FROM @LMSerachTemp WHERE searchId <> 0 )
		BEGIN
		--Check if the search name already exists
		IF EXISTS (SELECT 1 FROM @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch WITH (NOLOCK)
						ON lmtemp.searchName = lmsearch.searchName
								AND lmtemp.creatorUserId = lmsearch.creatorUserId AND lmtemp.searchId <> lmsearch.searchId AND lmtemp.appType=lmsearch.monitoringAppType)
		BEGIN
			SET @errorCode = 2
			RAISERROR ('Search with same name already exists', -- Message text.
						16, -- Severity.
							1 -- State.
            );
		END
			Insert into @origSearchInfoXMLTbl
			select LMUserSearch.searchId,LMUserSearch.searchInfo
			from LMUserSearch
			inner join @LMSerachTemp LMSearchTemp
			on LMSearchTemp.searchId = LMUserSearch.searchid
			--update name
			UPDATE lmsearch
			SET lmsearch.searchName = lmtemp.searchName,lmsearch.modified = @nowTime
			FROM @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
			ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.searchName IS NOT NULL OR lmtemp.searchName like '')
			WHERE lmsearch.searchName <> lmtemp.searchName
			--update private
			UPDATE lmsearch
			SET lmsearch.isPrivate = lmtemp.isPrivate,lmsearch.modified = @nowTime
			FROM @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
			ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.isPrivate IS NOT NULL)
			--update status
			-- Now since we have implemented security and admin can see others alerts
			-- we should update status for dashboard only when creator is trying to modify it.
			-- Since dashboard isnt shared across users.
			-- We throw error in case invalid status is set for dashboard
			if exists(select 1 from @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
				ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.status IS NOT NULL )
				and lmsearch.creatorUserId!=@userId
				and (  ((lmsearch.status & 4)=0 AND (lmtemp.status & 4)<>0) OR
					((lmsearch.status & 4)<>0 AND (lmtemp.status & 4)=0)
					)
				)
				begin
					SET @errorCode = 6
					RAISERROR ('Only creator of a saved search can modify dashboard information. ', -- Message text.
						16, -- Severity.
							1 -- State.
					);
				end
			UPDATE lmsearch
			SET lmsearch.status = lmtemp.status,lmsearch.modified = @nowTime
			FROM @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
			ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.status IS NOT NULL )
			select @searchInfoOldXml = lmsearch.searchInfo
			from @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
			ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.searchInfo IS NOT NULL)
			--update urlinfo
			UPDATE lmsearch
			SET lmsearch.searchInfo = lmtemp.searchInfo,lmsearch.modified = @nowTime
			FROM @LMSerachTemp lmtemp INNER JOIN LMUserSearch lmsearch
			ON lmtemp.searchId = lmsearch.searchid  AND (lmtemp.searchInfo IS NOT NULL)
			--TODO:dashboard assoc change
			DECLARE searchListCur CURSOR LOCAL
			FOR SELECT searchId FROM @LMSerachTemp WHERE searchId <> 0
			OPEN searchListCur
			FETCH FROM searchListCur INTO @searchId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				-- If the searchId is not in lmuserSearch, then it is a Invalid search, Just throw error.
				-- This Case occurs mostly when we remove any entity from implicit sesarch , By that way the search itself will be deleted.
				IF NOT EXISTS(SELECT 1 FROM LMUserSearch WHERE searchId = @searchId)
				BEGIN
					SET @errorCode = 3
					SET @errStr = 'Failed to modify search. Invalid search information provided. Please refresh and retry'
					RAISERROR(@errStr,16,1)
				END
				DELETE FROM LMDashSearchAssoc WHERE searchId = @searchId
				IF (((SELECT status FROM LMUserSearch WHERE searchId = @searchId) & 2)<>0)
				begin
					select @searchInfoXml = searchInfo from LMUserSearch
					where searchId = @searchId
					Insert into @alertInfoForSearch(alertOperation,notificationType ,thisManyTimes , withinTheseManyMinutes ,alertId ,alertName,emailIdsList,searchId,linesAboveMatchedLine,linesBelowMatchedLine,
					lmAlertType,alertCriteria, additionalInfo, notifMessageHtml,lmGroupByField,useGroupBy, workflowEntity, alertConfigInfo,rateOfChangeAlertInfo,associatedPolicyList,dynamicRecipientList,colNameForRecipient,timezoneInfo,status,addColsInEmail,colsToDisplayInAlertEmail)
					SELECT ISNULL(R.alert.value('@alertOperation','INTEGER'),0),
					ISNULL(R.alert.value('@notifType','INTEGER'),0),
					ISNULL(R.alert.value('@thisManyTimes','INTEGER'),0),
					ISNULL(R.alert.value('@withinTheseManyMinutes','INTEGER'),0),
					ISNULL(R.alert.value('(alertEntity/@alertId)[1]','INTEGER'),0),
					dbo.decodeInvalidXMLCharsCLR(ISNULL(R.alert.value('(alertEntity/@alertName)[1]','nvarchar(256)'),'')),
					ISNULL(R.alert.query('emailIds'),''),
					@searchId,
					ISNULL(R.alert.value('@linesAboveMatchedLine','INTEGER'),0),
					ISNULL(R.alert.value('@linesBelowMatchedLine','INTEGER'),0),
					ISNULL(R.alert.value('@alertType','INTEGER'),0),
					ISNULL(R.alert.value('@alertCriteria','nvarchar(max)'),''),
					ISNULL(R.alert.value('@additionalInfo','nvarchar(max)'),''),
					ISNULL(R.alert.value('@notifMessageHtml','nvarchar(max)'),''),
					ISNULL(R.alert.value('@lmGroupByField','nvarchar(max)'),''),
					ISNULL(R.alert.value('@useGroupBy','INTEGER'),0),
					R.alert.query('workflowEntity'),
					R.alert.query('alertConfigInfo'),
					R.alert.query('rateOfChangeAlertInfo'),
					ISNULL(R.alert.query('associatedPolicyList'),''),
					R.alert.query('dynamicRecipientsList'),
					ISNULL(R.alert.value('@colNameForComputingReceipients','nvarchar(512)'),''),
					ISNULL(R.alert.value('@timezoneInfo','nvarchar(max)'),''),
					ISNULL(R.alert.value('@status','INTEGER'),1),
					ISNULL(R.alert.value('@addColsInEmail','INTEGER'),0),
					ISNULL(R.alert.value('@colsToDisplayInAlertEmail','nvarchar(max)'),'')
					FROM
					@searchInfoXml.nodes('LogMonitoring_SearchURLInfo/alertInfoLst') as R(alert)
				end
				-- If there exists any invalid alertId in @alertInfoForSearch then we throw error. AlertId can get invalid in case alert is deleted directly via qscript and webconsole xml isnt updated.
				-- It can also happen when webconsole sends xml with deleted alertId for modify request
				declare @invalidAlertName nvarchar(max)
				if exists(select 1 from @alertInfoForSearch alertInfoForSearch left join NTNotificationRule on alertInfoForSearch.alertId=NTNotificationRule.id where alertOperation=2 and (NTNotificationRule.id is NULL OR NTNotificationRule.revision=0 OR (NTNotificationRule.status&2)>0))
				begin
					select @invalidAlertName = alertName from @alertInfoForSearch alertInfoForSearch left join NTNotificationRule on alertInfoForSearch.alertId=NTNotificationRule.id where alertOperation=2 and (NTNotificationRule.id is NULL OR NTNotificationRule.revision=0 OR (NTNotificationRule.status&2)>0)
					SET @errorCode = 3
					if (len(@invalidAlertName)>0)
					begin
						set @errStr = 'Failed to modify Search. Invalid information provided for alert ['+@invalidAlertName+']. Please delete alert or refresh search details and retry'
					end
					else
					begin
						set @errStr = 'Failed to modify Search. Invalid alert information provided. Please delete alerts for this search or refresh search details and retry'
					end
					RAISERROR(@errStr,16,1)
				end
				-- In case groupBy Field has modified for any alert from before, we remove all detected alerts for that rule
				IF (((SELECT status FROM LMUserSearch WHERE searchId = @searchId and creatorUserId=@userId) & 4)<>0)
				BEGIN
					DECLARE @dashInfo1 XML = ISNULL((SELECT dashInfo FROM @LMSerachTemp),'<dashInfo/>')
					DECLARE @appType1 INT = ISNULL((SELECT monitoringAppType FROM LMUserSearch where searchId = @searchId), 1)
						INSERT INTO @dashBoards(dashId,dashName,creator,status,appType,dashBoardProp)
						SELECT ISNULL(R.dash.value('@dashBoardId','INTEGER'),0),
								ISNULL(R.dash.value('@dashBoardName','NVARCHAR(1024)'),''),
								ISNULL((SELECT R.usr.value('@userId','INTEGER') FROM @dashInfo1.nodes('dashInfo/creator') as R(usr)),@userId),
								ISNULL(R.dash.value('@status','INTEGER'),0),
								@appType1,
								ISNULL(R.dash.value('@dashBoardProp[1]','NVARCHAR(MAX)'),CAST('<LogMonitoring_DashBoardProp/>'  AS NVARCHAR(MAX)))
								FROM
								@dashInfo1.nodes('dashInfo') as R(dash)
					IF NOT EXISTS(SELECT 1 FROM @dashBoards WHERE (status & 4 <> 0 OR status & 8 <> 0 OR creator = @userId) AND dashId <> 0) AND NOT EXISTS (SELECT 1 FROM @dashBoards WHERE (status & 4 <> 0 OR status & 8 <> 0 OR creator = @userId) AND dashId = 0)
					BEGIN
						--if no dashboard information is sent chck if a default dashboard exists
						IF EXISTS (SELECT TOP 1 dashBoardId FROM LMdashBoard WHERE creatorUserId = @userId AND (status & 2) <> 0 AND monitoringAppType = @appType1 ORDER BY dashBoardId)
						BEGIN
							INSERT INTO @dashBoards(dashId,dashName,creator,appType,dashBoardProp)
							SELECT TOP 1 dashBoardId,dashBoardName,creatorUserId,monitoringAppType,dashBoardProp FROM LMdashBoard WHERE creatorUserId = @userId AND (status & 2) <> 0 AND monitoringAppType = @appType1 ORDER BY dashBoardId
						END
						ELSE
						BEGIN
							--Create a default dash board
							set @appType1 = (
								select monitoringAppType
								from LMUserSearch where searchId = @searchId
							)
							INSERT INTO @dashBoards(dashId,dashName,creator,status,appType,dashBoardProp)
							SELECT 0,'',@userId,2,@appType1,''
						END
					END
					DECLARE @createDashXML1 XML = (SELECT 5 as '@operationType',
						dashId as 'dashBoardInfo/@dashBoardId',
						dashName as 'dashBoardInfo/@dashBoardName',
						1 as 'dashBoardInfo/@isPrivate',
						ISNULL(status,0) as 'dashBoardInfo/@status',
						ISNULL(appType,1) as 'dashBoardInfo/@appType',
						CONVERT(NVARCHAR(MAX),dashBoardProp) as 'dashBoardInfo/@dashBoardProp',
						creator as 'dashBoardInfo/creator/@userId'
						FROM @dashBoards WHERE dashId = 0
						FOR XML PATH('LogMonitoring_DashBoardOperationReq'))
					DELETE FROM LMDashSearchAssoc WHERE dashboardId IN (SELECT dashId FROM @dashBoards WHERE dashId <> 0) AND searchId = @searchId
					INSERT INTO LMDashSearchAssoc
					SELECT dashId,@searchId FROM @dashBoards WHERE dashId <> 0 AND dashId IN (SELECT dashboardId FROM LMDashBoard)
					IF @createDashXML1 IS NOT NULL --If New dash board has to be created for this
					BEGIN
						DECLARE @createDashXMLResp1 XML
						exec LMDashBoardOperations @userId,@createDashXML1,@createDashXMLResp1 OUTPUT
						DECLARE @newDashID1 INTEGER = ISNULL((SELECT ref.value('@dashBoardId','INTEGER') FROM @createDashXMLResp1.nodes('LogMonitoring_DashBoardListResp/dashBoardInfoList') as R(ref)),0)
						IF @newDashID1 <> 0
							INSERT INTO LMDashSearchAssoc VALUES(@newDashID1,@searchId)
						ELSE
						BEGIN
							SET @errorCode  = (SELECT ref.value('@errorCode','INTEGER') FROM @createDashXMLResp1.nodes('LogMonitoring_GenericEntityResponse') as R(ref))
							SET @errStr =  ISNULL((SELECT ref.value('@errorString','INTEGER') FROM @createDashXMLResp1.nodes('LogMonitoring_GenericEntityResponse') as R(ref)),'')
							IF @errorCode IS NULL OR @errStr IS NULL OR @errStr = ''
								RAISERROR('Failed to create dashboard, Please check logs for more info.',16,1)
							ELSE
							BEGIN
								SET @errorCode = 4
								RAISERROR(@errStr,16,1)
							END
						END
					END
					ELSE
					BEGIN
						-- update new dashboard props as per latest search in that dashboard
						UPDATE lmdash
						SET lmdash.dashBoardProp = dashTemp.dashBoardProp
						FROM LMDashBoard lmdash
						INNER JOIN @dashBoards dashTemp
						ON dashTemp.dashId = lmdash.dashBoardId
						WHERE dashTemp.dashId <> 0
					END
				END
				FETCH FROM searchListCur INTO @searchId
			END
			-- Check whether this is an implicit and not associated to dashboard/alert/schedules that means it was earlier associated to dashboard and now removed.
			delete LMUserSearch
			from LMUserSearch
			inner join (
						select distinct LMUserSearch.searchId
		                from LMUserSearch
						inner join @LMSerachTemp LMSerachTemp on LMUserSearch.searchId = LMSerachTemp.searchId
						and IsNull(convert(xml,LMUserSearch.searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0)=1 -- Is an implicit search
						left join LMDashSearchAssoc on LMDashSearchAssoc.searchId = LMUserSearch.searchId
						left join TM_subtaskOptions on TM_subtaskOptions.optionId = 951244723
						and TM_subtaskOptions.value = convert(nvarchar(max),LMUserSearch.searchId)
		                where convert(xml,LMUserSearch.searchInfo).exist('/LogMonitoring_SearchURLInfo/alertInfoLst')=0  -- not associated to any alerts.
                        and LMDashSearchAssoc.searchId is null -- Not associated to any dashboard
                        and TM_subtaskOptions.optionId is null
			) t
			on LMUserSearch.searchId = t.SearchId
		END
	END
	IF(@opertaionsType = 3)
	BEGIN
	--If you are deleting saved search then you are deleting sharedsearch also
	-- get sharedUserList
	declare @xml xml
	declare @shareId int
	declare @searchIdToDelete int
	declare cur_searchIds cursor
	static for
	select searchId from @LMSerachTemp
	open cur_searchIds
		if @@CURSOR_ROWS > 0
		begin
			fetch next from cur_searchIds into @searchIdToDelete
			while @@FETCH_STATUS = 0
			begin
				set @shareId = (select SharedEntityId from App_SharedEntityInfo where OriginalEntityId = @searchIdToDelete and SharedEntityType = 134 ) -- 134 will filter only shared searches.
				exec sec_deleteSecurityAssociationsForEntity 9674, @shareId
				fetch next from cur_searchIds into @searchIdToDelete
			end
		end
	close cur_searchIds
	deallocate cur_searchIds
		delete shared
		from App_SharedEntityInfo shared
			inner join @LMSerachTemp lm
				on shared.OriginalEntityId = lm.searchId and shared.SharedEntityType = 134
		--End of deleting shared search details ;
		-- If you are deleting saved search then you are deleting alert as well as dashboard
		Update @LMSerachTemp
		set status=14
		where status=2
		DELETE lmsa
		FROM LMDashSearchAssoc lmsa INNER JOIN LMuserSearch lms
				ON lmsa.searchid = lms.searchId
					INNER JOIN @LMSerachTemp lmtemp
						ON lmsa.searchid = lmtemp.searchid
							 WHERE lmsa.searchid IN (SELECT lmtemp1.searchId
									FROM @LMSerachTemp lmtemp1
										WHERE lmtemp1.searchId <> 0 AND (lmtemp1.status & 4) <> 0)
		-- Check whether this is an implicit and not associated to dashboard/alert/schedules that means it was earlier associated to dashboard and now removed.
			delete LMUserSearch
			from LMUserSearch
			inner join (
						select distinct LMUserSearch.searchId
		                from LMUserSearch
						inner join @LMSerachTemp LMSerachTemp on LMUserSearch.searchId = LMSerachTemp.searchId
						and IsNull(convert(xml,LMUserSearch.searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0)=1 -- Is an implicit search
						left join LMDashSearchAssoc on LMDashSearchAssoc.searchId = LMUserSearch.searchId
						left join TM_subtaskOptions on TM_subtaskOptions.optionId = 951244723
						and TM_subtaskOptions.value = convert(nvarchar(max),LMUserSearch.searchId)
		                where convert(xml,LMUserSearch.searchInfo).exist('/LogMonitoring_SearchURLInfo/alertInfoLst')=0  -- not associated to any alerts.
                        and LMDashSearchAssoc.searchId is null -- Not associated to any dashboard
                        and TM_subtaskOptions.optionId is null
			) t
			on LMUserSearch.searchId = t.SearchId
		declare @deleteSearchId int
		declare @deleteSearchXml xml
		DECLARE deleteSearchListCur CURSOR LOCAL
		FOR SELECT LMUserSearch.searchId,convert(xml,LMUserSearch.searchInfo)
			FROM @LMSerachTemp lmtemp1
			inner join LMUserSearch
			on lmtemp1.searchId=LMUserSearch.searchId
			WHERE lmtemp1.searchId <> 0 and
			( (LMUserSearch.status & lmtemp1.status) = LMUserSearch.status )
		OPEN deleteSearchListCur
		FETCH FROM deleteSearchListCur INTO @deleteSearchId,@deleteSearchXml
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- When Saved search is delete, alert will always be deleted. no need to pick up operation type from xml
			Insert into @alertInfoForSearch(alertOperation,alertId)
			SELECT 3,ISNULL(R.alert.value('(alertEntity/@alertId)[1]','INTEGER'),0)
			FROM @deleteSearchXml.nodes('LogMonitoring_SearchURLInfo/alertInfoLst') as R(alert)
			FETCH FROM deleteSearchListCur INTO @deleteSearchId,@deleteSearchXml
		end
		Update LMUserSearch
		set status = LMUserSearch.status & (14-lmtemp.status)
		from @LMSerachTemp lmtemp
        WHERE LMUserSearch.searchid = lmtemp.searchid
		DELETE lmsa
        FROM LMUserSearch lmsa INNER JOIN @LMSerachTemp lmtemp
        ON lmsa.searchid = lmtemp.searchid
        WHERE lmsa.status=0
		DELETE lmsa
		FROM LMUserSearch lmsa INNER JOIN @LMSerachTemp lmtemp
			ON lmsa.searchid = lmtemp.searchid
				 WHERE lmsa.searchid IN (SELECT lmtemp1.searchId
									FROM @LMSerachTemp lmtemp1
										WHERE lmtemp1.searchId <> 0 AND (lmtemp1.status & 1) <> 0 ) AND (lmsa.status & 1) = lmsa.status --AND lmsa.creatorUserId=@userId
		IF EXISTS (SELECT 1 FROM @LMSerachTemp WHERE searchId = 0 AND (status & 1) <> 0)
			DELETE FROM LMUserSearch WHERE (status & 1) <> 0 And (creatorUserId=@userId OR @includeMySearchesOnly=0)
		IF EXISTS (SELECT 1 FROM @LMSerachTemp WHERE searchId = 0 AND (status & 2) <> 0)
		BEGIN
			DELETE FROM LMUserSearch WHERE (status & 2) <> 0 AND (status & 4) = 0
			And (creatorUserId=@userId OR @includeMySearchesOnly=0)
			UPDATE LMUserSearch
			SET status = 4
			WHERE (status & 2) <> 0 AND (status& 4) <> 0
		END
		--DELETE FROM LMDashSearchAssoc WHERE searchid NOT IN (SELECT LMUserSearch.searchid FROM LMUserSearch)
		--Delete all dangling LM search schedules
		Update TM_Task
		set deleted = 1
		where taskId in
		(
			select taskId from TM_subtask with (nolock)
			where operationType = 5015
		)
		AND taskId NOT IN
		(
			SELECT DISTINCT subtask.taskId FROM
			TM_SubTask subtask WITH (NOLOCK) INNER JOIN TM_SubTaskOptions subtaskoptions WITH (NOLOCK)
				ON subtaskoptions.optionId = 951244723 AND subtask.subTaskId = subtaskoptions.subTaskId
					 INNER JOIN LMUserSearch lmsearch WITH(NOLOCK)
			ON  lmsearch.status <> 1 AND value = lmsearch.searchId
		)
		--Delete the search from assoc table if it is associated to any dashBoard
		--DELETE FROM LMDashSearchAssoc WHERE searchid IN (SELECT searchId
		--													FROM
		--													@LMSerachTemp WHERE creatorUserId = @userId and searchId <> 0)
	END
	IF(@opertaionsType = 8)
	begin
		declare @LMSearchOrderData table
		(
			searchId int,
			orderId int
		)
		delete from @LMSearchOrderData
		Insert into @LMSearchOrderData
		select searchId,convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@orderId)[1]','int')
		from @LMSerachTemp
		Update LMUserSearch
		set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@orderId)[1]) with sql:column("LMSearchOrderData.orderId")')
		from @LMSearchOrderData LMSearchOrderData
		where LMUserSearch.searchId=LMSearchOrderData.searchId
	end
	else IF(@opertaionsType = 9)
	begin
		declare @LMSearchModifyData table
		(
			searchId int,
			browserURL nvarchar(max),
			solrQuery nvarchar(max),
			searchLabel nvarchar(max),
			trendBrowserURL nvarchar(max),
			solrQueryWithoutTime nvarchar(max),
			colsToDisplayInAlertEmail nvarchar(max),
			policiesForAlert XML
		)
		delete from @LMSearchModifyData
		Insert into @LMSearchModifyData
		select searchId,
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@browserURL)[1]','nvarchar(max)'),
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@solrQuery)[1]','nvarchar(max)'),
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@searchLabel)[1]','nvarchar(max)'),
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@trendBrowserURL)[1]','nvarchar(max)'),
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@solrQueryWithoutTime)[1]','nvarchar(max)'),
		convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@colsToDisplayInAlertEmail)[1]','nvarchar(max)'),
		(
			SELECT
				R.ref.value('(@val)[1]', 'int') AS '@val'
				from policiesForAlert.nodes('policiesForAlert') R(ref)
			FOR XML PATH('associatedPolicyList')
		)
		from @LMSerachTemp
		--check if same browserURL is part of another search already or not, if so dont update and throw error that search already exists
		DECLARE @browserURL nvarchar(max)
		SET @browserURL = (SELECT TOP 1 browserURL FROM @LMSearchModifyData)
		SET @appType  = ISNULL((SELECT TOP 1 appType FROM @LMSerachTemp),1)
		IF exists(SELECT * FROM LMUserSearch WHERE searchInfo.value('(/LogMonitoring_SearchURLInfo/@browserURL)[1]','nvarchar(max)') = @browserURL AND monitoringAppType = @appType AND status != 1 AND creatorUserId = @userId)
		BEGIN
			SET @errorMsg = 'Search already exists'
			RAISERROR (@errorMsg,16, 1);
		END
		ELSE
		BEGIN
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@browserURL)[1]) with sql:column("LMSearchModifyData.browserURL")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.browserURL is not null
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@trendBrowserURL)[1]) with sql:column("LMSearchModifyData.trendBrowserURL")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.trendBrowserURL is not null
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@solrQuery)[1]) with sql:column("LMSearchModifyData.solrQuery")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.solrQuery is not null
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@searchLabel)[1]) with sql:column("LMSearchModifyData.searchLabel")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.searchLabel is not null
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@solrQueryWithoutTime)[1]) with sql:column("LMSearchModifyData.solrQueryWithoutTime")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.solrQueryWithoutTime is not null
			Update LMUserSearch
			set searchInfo.modify('replace value of ((/LogMonitoring_SearchURLInfo/@colsToDisplayInAlertEmail)[1]) with sql:column("LMSearchModifyData.colsToDisplayInAlertEmail")')
			from @LMSearchModifyData LMSearchModifyData
			where LMUserSearch.searchId=LMSearchModifyData.searchId
			and LMSearchModifyData.colsToDisplayInAlertEmail is not null
			UPDATE APP_LMAlertInfo
			SET AlertProp.modify('delete /alertInfoLst/associatedPolicyList')
			FROM @LMSearchModifyData LMSearchModifyData
			WHERE APP_LMAlertInfo.SearchId = LMSearchModifyData.searchId
			AND LMSearchModifyData.policiesForAlert IS NOT NULL
			UPDATE APP_LMAlertInfo
			SET AlertProp.modify('insert sql:column("LMSearchModifyData.policiesForAlert") into (/alertInfoLst)[1] ')
			FROM @LMSearchModifyData LMSearchModifyData
			WHERE APP_LMAlertInfo.SearchId = LMSearchModifyData.searchId
			AND LMSearchModifyData.policiesForAlert IS NOT NULL
		END
	end
	else IF(@opertaionsType = 10) -- Enabling the Alert
	begin
		declare @LMSearchEnableData table
		(
			searchId int,
			alertId int
		)
		Insert into @LMSearchEnableData
		select searchId,
			convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity/@alertId)[1]','int')
		from @LMSerachTemp
		delete from @LMSearchEnableData
		where alertId is null or alertId<=0
		-- Also delete invalid alerts
		delete LMSearchEnableData
		from @LMSearchEnableData LMSearchEnableData
		left join NTNotificationRule
		on LMSearchEnableData.alertId=NTNotificationRule.id
		where NTNotificationRule.id is null OR NTNotificationRule.alertTypeId!=65 Or NTNotificationRule.revision=0
		OR (NTNotificationRule.status&2)>0
		UPDATE APP_LMAlertInfo
		SET AlertProp.modify(' replace value of (alertInfoLst/@status) [1] with ("1")')
		FROM @LMSearchEnableData LMSearchEnableData
		WHERE APP_LMAlertInfo.AlertId = LMSearchEnableData.alertId
		-- When Enabling Alert , The lastRunTime should be updated , else the alert condition occured in disabled state will be processed.
		Update NTNotificationQueryMapping
		set lastRuntime=getUTCdate()
		from @LMSearchEnableData LMSearchEnableData
		inner join NTNotificationQueryMapping on
		NTNotificationQueryMapping.Ntnotificationid=LMSearchEnableData.alertId
		inner join NTNotificationrule on
		LMSearchEnableData.alertId= NTNotificationRule.id
		where (NTNotificationRule.status & 1)>0
		--Enable alert.
		Update NTNotificationRule
		set status = status - 1
		from @LMSearchEnableData LMSearchEnableData
		where (status & 1)>0
		and LMSearchEnableData.alertId= NTNotificationRule.id
	end
	else IF(@opertaionsType = 11) --Disable
	begin
		declare @LMSearchDisableData table
		(
			searchId int,
			alertId int
		)
		Insert into @LMSearchDisableData
		select searchId,
			convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity/@alertId)[1]','int')
		from @LMSerachTemp
		delete from @LMSearchDisableData
		where alertId is null or alertId<=0
		-- Also delete invalid alerts
		delete LMSearchDisableData
		from @LMSearchDisableData LMSearchDisableData
		left join NTNotificationRule
		on LMSearchDisableData.alertId=NTNotificationRule.id
		where NTNotificationRule.id is null OR NTNotificationRule.alertTypeId!=65 Or NTNotificationRule.revision=0
		OR (NTNotificationRule.status&2)>0
		UPDATE APP_LMAlertInfo
		SET AlertProp.modify(' replace value of (alertInfoLst/@status) [1] with ("0")')
		FROM @LMSearchDisableData LMSearchDisableData
		WHERE APP_LMAlertInfo.AlertId = LMSearchDisableData.alertId
		--Disable alert.
		Update NTNotificationRule
		set status = status | 1
		from @LMSearchDisableData LMSearchDisableData
		where LMSearchDisableData.alertId= NTNotificationRule.id
	end
	else IF(@opertaionsType = 12) --Delete
	begin
		Insert into @LMSearchdeleteData
		select searchId,
			convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity/@alertId)[1]','int'),
			0
		from @LMSerachTemp
		delete from @LMSearchdeleteData
		where alertId is null or alertId<=0
		-- No need to delete invalid alerts here from temp table here.
		Update LMUserSearch
		set status = status - 8
		from @LMSearchdeleteData LMSearchdeleteData
		where LMUserSearch.searchId = LMSearchdeleteData.searchId
		and (status&8)>0
		-- First we figure all implicit searches from searchurlinfo
		-- In case its an implicit search, then we delete the search also. Only if its not associated to any other entity.
		Update LMSearchdeleteData
		set isImplicitShldDelete = 1
		from @LMSearchdeleteData LMSearchdeleteData, LMUserSearch
		where LMSearchdeleteData.searchId = LMUserSearch.searchId
		and IsNull(convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0)=1
		--Check whether search is associated to any other alert of same search
		Update LMSearchdeleteData
		set isImplicitShldDelete = 0
		from @LMSearchdeleteData LMSearchdeleteData
		inner join APP_LMAlertInfo alertTbl
		on LMSearchdeleteData.searchId = alertTbl.SearchId AND LMSearchdeleteData.alertId <> alertTbl.AlertId AND LMSearchdeleteData.isImplicitShldDelete = 1
		-- In case its implicit and associated to dashboard then dont delete.
		Update LMSearchdeleteData
		set isImplicitShldDelete = 0
		from @LMSearchdeleteData LMSearchdeleteData,LMDashSearchAssoc with (nolock)
		where LMSearchdeleteData.isImplicitShldDelete = 1
		and LMSearchdeleteData.searchId = LMDashSearchAssoc.searchId
		-- In case its associated to schedules, then dont delete.
		Update LMSearchdeleteData
		set isImplicitShldDelete = 0
		from @LMSearchdeleteData LMSearchdeleteData inner join TM_subtaskOptions
		on LMSearchdeleteData.isImplicitShldDelete = 1
		and TM_subtaskOptions.optionId = 951244723
		and TM_subtaskOptions.value = convert(nvarchar(max),LMSearchdeleteData.searchId)
		inner join TM_subtask with (nolock) on
		TM_subtask.subtaskid = TM_subtaskOptions.subtaskId
		where TM_subtask.operationType = 5015
		--Check whether search is associated with shared search too.
		Update LMSearchdeleteData
		set isImplicitShldDelete = 0
		from @LMSearchdeleteData LMSearchdeleteData,App_SharedEntityInfo with (nolock)
		where LMSearchdeleteData.isImplicitShldDelete = 1
		and LMSearchdeleteData.searchId = App_SharedEntityInfo.OriginalEntityId
		delete LMUserSearch from LMUserSearch
		inner join @LMSearchdeleteData LMSearchdeleteData
		on LMUserSearch.searchId = LMSearchdeleteData.searchid
		and LMSearchdeleteData.isImplicitShldDelete = 1
		--Delete alert.
		Update NTNotificationRule
		set status = 2,revision=0
		from @LMSearchdeleteData LMSearchdeleteData
		where LMSearchdeleteData.alertId= NTNotificationRule.id
		DELETE lmAlert
		FROM APP_LMAlertInfo lmAlert
		INNER JOIN @LMSearchdeleteData LMSearchdeleteData
		ON LMSearchdeleteData.alertId = lmAlert.AlertId
	end
	declare @indicateAlertResync int = 0
	-- First check for delete alert Op
	-- If exists any alert which has been deleted, then we set a flag so that workqueue can be sent
	if exists(select 1 from @alertInfoForSearch AlertInfo
		where AlertInfo.alertOperation=3 or AlertInfo.alertOperation=5 or AlertInfo.alertOperation=2)
	begin
		set @indicateAlertResync = 1
	end
	IF(@opertaionsType >= 9 and @opertaionsType <= 12) -- when we are modifying search query or enabling/disabling/deleting alerts, we need to resync alerts
	begin
		set @indicateAlertResync = 1
	end
	delete NTD from NTDetectedAlerts NTD
	inner join @alertInfoForSearch deletedSearches on
	deletedSearches.alertId=NTD.NTNotificationId
	and deletedSearches.alertOperation=3
	Update NTNotificationRule
	set revision=0,status=2
	from @alertInfoForSearch deletedSearches
	where NTNotificationRule.id = deletedSearches.alertId
	and deletedSearches.alertOperation=3
	DELETE lmAlert FROM APP_LMAlertInfo lmAlert
	INNER JOIN @alertInfoForSearch deletedSearches on
	deletedSearches.alertId=lmAlert.AlertId
	and deletedSearches.alertOperation=3
	delete from @alertInfoForSearch
	where alertOperation=3
	-- Now do the below only for saved searches
	IF (((SELECT status FROM LMUserSearch WHERE searchId = @searchId) & 2)<>0)
	begin
			declare @alertOperation int
			declare @notificationType int
			declare @emailIdsList xml
			declare @searchAlertId int
			declare @searchalertName nvarchar(max)
			declare @localSearchId int
			declare @defaultHtmlTemplate nvarchar(max)
			declare @defaultTextTemplate nvarchar(max)
			declare @lmAlertType int
			declare @alertConfigInfo xml
			declare @workflowEntity xml
			declare @wfEntityNVarchar nvarchar(max)
			declare @notifMessageHtml nvarchar(max)
			DECLARE @additionalInfo xml
			DECLARE @dynamicRecipientList xml
			DECLARE @colNameForRecipient  nvarchar(512) = ''
			DECLARE @timezoneInfo xml
			set @defaultTextTemplate = 'Search Criteria: <SEARCH CRITERIA> , Log Line : <INDEX 1> , <SEARCH QUERY STRING>'
			set @workflowEntity = ''
			set @notifMessageHtml = ''
			if 	(@lmAlertType<>2)
			begin
				IF @newTemplate = 0
					set @defaultHtmlTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> <SUBJECT END><table cellspacing="0" cellpadding="0" style="border-top-width: 0px; border-right-style: solid; border-top-style: solid; border-right-color: #dedede; border-bottom-style: solid; border-top-color: #dedede; border-left-style: solid; border-left-width: 0px; border-right-width: 0px; border-bottom-color: #dedede; border-left-color: #dedede; border-bottom-width: 0px" border="1" width="100%" align="center"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0" align="center"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> </td> </tr> <tr> <td colspan="1" width="100%" align="left">   <ul><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3">Search Criteria:   &lt;SEARCH CRITERIA&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH QUERY STRING&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH URL INFO&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH CRITERA MATCHED LINES&gt; </font></li><font color="#000000" size="3" face="Helvetica,sans-serif">&lt;TABLE DATA&gt; </font>  </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
				ELSE
					set @defaultHtmlTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> <SUBJECT END><table cellspacing="0" cellpadding="0" style="border-top-width: 0px; border-right-style: solid; border-top-style: solid; border-right-color: #2f4e66; border-bottom-style: solid; border-top-color: #2f4e66; border-left-style: solid; border-left-width: 0px; border-right-width: 0px; border-bottom-color: #2f4e66; border-left-color: #2f4e66; border-bottom-width: 0px" border="1" width="100%" align="center"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0" align="center"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#f5f5f5"> <ul style="margin-bottom: 7px; margin-top: 7px"> <font size="3" face="sans-serif" color="#444444"><b>CommCell: </b></font><font color="#444444" size="3" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </ul> </td> </tr> <tr> <td colspan="1" width="100%" align="left">   <ul><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3">Search Criteria:   &lt;SEARCH CRITERIA&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH QUERY STRING&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH URL INFO&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH CRITERA MATCHED LINES&gt; </font></li><font color="#444444" size="3" face="sans-serif">&lt;TABLE DATA&gt; </font>  </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
			end
			else
			begin
				IF @newTemplate = 0
					set @defaultHtmlTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> <SUBJECT END><table cellspacing="0" cellpadding="0" style="border-top-width: 0px; border-right-style: solid; border-top-style: solid; border-right-color: #dedede; border-bottom-style: solid; border-top-color: #dedede; border-left-style: solid; border-left-width: 0px; border-right-width: 0px; border-bottom-color: #dedede; border-left-color: #dedede; border-bottom-width: 0px" border="1" width="100%" align="center"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0" align="center"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> </td> </tr> <tr> <td colspan="1" width="100%" align="left">   <ul><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3">Search Criteria:   &lt;SEARCH CRITERIA&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH QUERY STRING&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH URL INFO&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> &lt;SEARCH CRITERA MATCHED LINES&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="Helvetica,sans-serif" color="#000000" size="3"> Condition cleared : &lt;CONDITION CLEARED Y/N&gt; </font></li><font color="#000000" size="3" face="Helvetica,sans-serif">&lt;TABLE DATA&gt; </font>  </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
				ELSE
					set @defaultHtmlTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> <SUBJECT END><table cellspacing="0" cellpadding="0" style="border-top-width: 0px; border-right-style: solid; border-top-style: solid; border-right-color: #dedede; border-bottom-style: solid; border-top-color: #2f4e66; border-left-style: solid; border-left-width: 0px; border-right-width: 0px; border-bottom-color: #2f4e66; border-left-color: #2f4e66; border-bottom-width: 0px" border="1" width="100%" align="center"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0" align="center"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#f5f5f5"> <ul style="margin-bottom: 7px; margin-top: 7px"> <font size="3" face="sans-serif" color="#444444"><b>CommCell: </b></font><font color="#444444" size="3" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </ul> </td> </tr> <tr> <td colspan="1" width="100%" align="left">   <ul><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3">Search Criteria:   &lt;SEARCH CRITERIA&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH QUERY STRING&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH URL INFO&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> &lt;SEARCH CRITERA MATCHED LINES&gt; </font></li><li style="margin-bottom: 4px; margin-top: 4px">  <font face="sans-serif" color="#444444" size="3"> Condition cleared : &lt;CONDITION CLEARED Y/N&gt; </font></li><font color="#444444" size="3" face="sans-serif">&lt;TABLE DATA&gt; </font>  </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
			end
			-- next update/add alerts.
			DECLARE AddUpdateSearchListCur CURSOR LOCAL
				FOR SELECT alertOperation,notificationType,emailIdsList,alertId ,alertName,searchId,lmAlertType, alertConfigInfo,workflowEntity, notifMessageHtml,dynamicRecipientList,colNameForRecipient  FROM @alertInfoForSearch
			OPEN AddUpdateSearchListCur
			FETCH FROM AddUpdateSearchListCur INTO @alertOperation,@notificationType,@emailIdsList,@searchAlertId,@searchalertName,@localSearchId,@lmAlertType,@alertConfigInfo,@workflowEntity,@notifMessageHtml,@dynamicRecipientList,@colNameForRecipient
			WHILE @@FETCH_STATUS = 0
			BEGIN
				if @alertOperation=2
				begin
					update NTNotificationRule
					set notificationName=@searchalertName,notifType=@notificationType
					where id=@searchAlertId
					-- Always overwrite alert messages and email Lists
					delete from NTMessageformat
					where NTNotificationId=@searchAlertId
					delete from NTNotificationNonGalaxyUsers
					where NTNotificationId=@searchAlertId
					-- Dynamic recipient List
					-- Overwrite the existing  data if there is new data
					IF @dynamicRecipientList is not null and @dynamicRecipientList.exist('*')=1
					BEGIN
DELETE FROM NtNotificationProp where componentNameId=@searchAlertId and attrName = ('Dynamic Alert Recipients') and modified=0
						Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values (@searchAlertId, 'Dynamic Alert Recipients', 1, cast(@dynamicRecipientList as nvarchar(max)), dbo.GetUnixTime(GETUTCDATE()), 0)
					END
					IF @colNameForRecipient <> ''
					BEGIN
DELETE FROM NtNotificationProp where componentNameId=@searchAlertId and attrName = ('ColumnName deciding dynamic recipients') and modified=0
						Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values (@searchAlertId, 'ColumnName deciding dynamic recipients', 1, @colNameForRecipient, dbo.GetUnixTime(GETUTCDATE()), 0)
					END
				end
				else if @alertOperation=5 -- setting New Alert.
				begin
					declare @thisAlertId int
					set @thisAlertId = 0
					DECLARE @xmlEntities		AS nvarchar(MAX)= '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><clients includeAll="0"/><clientGroups includeAll="0"/><libraries includeAll="0"/><mediaAgents includeAll="0"/><storagePolcies includeAll="0"/><trackingPolicies includeAll="0"/><trackingSchedules/><trackingJobs/></CVGui_CommCellTreeNode>'
					DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
IF LEN(@searchalertName) >= 128
					BEGIN
						DECLARE @search NVARCHAR(MAX)= ''
						DECLARE @isImplicit INTEGER = ISNULL((SELECT TOP 1 CONVERT(XML,searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int') FROM LMUserSearch WITH(NOLOCK) WHERE searchId = @localSearchId),0)
						IF (@isImplicit = 1)
						BEGIN
							SET @search = 'search and '
						END
SET @errorMsg = 'Failed to create '+@search+'alert.Length of alert name should be less than ' + CONVERT(NVARCHAR(10),128)
						RAISERROR (@errorMsg, -- Message text.
							16, -- Severity.
								1 -- State.
						);
					END
					INSERT NTNotificationRule (	categoryId,				alertTypeId,
											notificationName,		revision,
											lastModified,			description,
											notifType,				notifOwner,
											locale,					status,
											ruleState,				ruleState2,
											lastTimeTriggered,		lastTimeTriggered2,
											lastTimeChecked,		hasAttachments,
											hasAttachments2,		xmlEntityList,
											origCCId,				GUID)
select						categoryId,				65,
											@searchalertName,			1,
											@nowTime,				'',
											@notificationType,				@userId,
											0,						4096,			-- 0 DefaultLocale US-English .. Create alerts in enabled state -- NT_STATUS_LM_ALERT
											0,						0,
											@emptyDateTime,			@emptyDateTime,
											@emptyDateTime,			0,
											0,						@xmlEntities,
											2,				newid()
from NTAlerttype where id = 65
					SET @thisAlertId = @@Identity
					set @searchAlertId = @thisAlertId
					IF @dynamicRecipientList is not null and @dynamicRecipientList.exist('*')=1
						Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values (@searchAlertId,'Dynamic Alert Recipients',1,cast(@dynamicRecipientList as nvarchar(max)),dbo.GetUnixTime(GETUTCDATE()),0)
					IF @colNameForRecipient <> ''
						Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
values (@searchAlertId,'ColumnName deciding dynamic recipients',1, @colNameForRecipient ,dbo.GetUnixTime(GETUTCDATE()),0)
					INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
select 75,1,@thisAlertId,1025,0,0
					INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
					VALUES (@thisAlertId, 1, null, null, 0)
					INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
					VALUES (@thisAlertId, 2, null, null, 0)
					declare @additionalInfoxml xml
					set @additionalInfoXml = (select @localSearchId '@externalQueryId',
						3 '@queryType'
						for xml path('externalQueryInfo'),root('CVGui_QueryAdditionalInfo'))
					declare @i_queryId int
					select @i_queryId=queryId from NTqueryList
					where IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)=3
					Insert into NTNotificationQueryMapping(QueryId,NTNotificationId,nextRunTime,lastRuntime,isScheduled,taskId,criteriaXml,xmlInfo,
						queryCriteriaString,queryParamDisplayString)
					select @i_queryId, @thisAlertId,
						'12/31/9999 23:59:59',
						0,
						0,
						0,
						'','<?xml version="1.0" encoding="UTF-16" standalone="no" ?>'+convert(nvarchar(max),@additionalInfoXml),'',''
					Update @alertInfoForSearch
					set alertId=@thisAlertId
					where searchId=@localSearchId
					and alertName=@searchalertName
				end
				-- Now update alert status based on searchId status
				if exists(SELECT 1 FROM @alertInfoForSearch WHERE alertId = @searchAlertId
					and status = 1)
				begin
					-- when new alert is set , update the lastRunTime to latestDateTime
					Update NTNotificationQueryMapping
					set lastRuntime=getUTCdate()
					from NTNotificationQueryMapping inner join NTNotificationrule on
					NTNotificationQueryMapping.NTnotificationid= NTNotificationRule.id
					where (NTNotificationRule.status & 1)>0
					Update NTNotificationRule
					set status = status - 1
					where id=@searchAlertId
					and (status&1)>0
				end
				else
				begin
					Update NTNotificationRule
					set status = status | 1
					where id=@searchAlertId
				end
				declare @notifTypesList table
				(
					notifType int,
					isText int
				)
				delete from @notifTypesList
				Insert into @notifTypesList
				select 1,0
				union
				select 4,1
				union
				select 8,1
				union
				select 512,0
				union
				select 1024,0
				union
				select 8192,0
				union
				select 32768,1
				INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
									SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
									baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
				select @searchAlertId, notifType , 1,
							case when isText=1 then @defaultTextTemplate
							else ''
							end,
								N'',
0, 0, 0, 0, 2,
									'', '', '', '',
							case when isText=0 then 1
							else 0
							end ,
							case when isText=0 then @defaultHtmlTemplate
							else ''
							end
				from @notifTypesList
				where (notifType & @notificationType)>0
				-- For workflow content is different
				if ((@notificationType & 65536)>0)
				begin
					set @wfEntityNVarchar = convert(nvarchar(max),@workflowEntity)
					set @wfEntityNVarchar = replace(@wfEntityNVarchar,'<workflowEntity ','<entity ')
					set @wfEntityNVarchar = replace(@wfEntityNVarchar,'</workflowEntity>','</entity>')
					INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
									SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
									baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
					select @searchAlertId, 65536 , 1, @wfEntityNVarchar,
								N'',
0, 0, 0, 0, 2,
									'', '', '', '',
							1, @notifMessageHtml
				end
				-- Now fill the email list
				insert into NTNotificationnongalaxyusers(NTnotificationID,nonGalaxyUserName,escalationLevel,recipientType)
				select distinct @searchAlertId,ltrim(rtrim(R.Email.value('@val','nvarchar(510)'))),1,0
				from @emailIdsList.nodes('emailIds') as R(Email)
				set @emailIdsList = (select nonGalaxyUserName '@val'
					from NTnotificationNonGalaxyUsers
					where NTnotificationID=@searchAlertId and escalationLevel=1
					for xml path('emailIds'))
				update @alertInfoForSearch
				set emailIdsList = @emailIdsList
				where alertId=@searchAlertId
				if (@alertOperation=5 OR @alertOperation=2)
				begin
					declare @reportingOptionsCur int
					declare @notifyWhenConditionClearsCur int
					declare @persistIntervalCur int
					declare @repeatIntervalCur int
					declare @isPersistOptionChecked int
					declare @isRepeatOptionChecked int
					set @reportingOptionsCur = 0
					set @notifyWhenConditionClearsCur = @alertConfigInfo.value('(alertConfigInfo/@notifyWhenConditionClears)[1]','int')
					set @persistIntervalCur = IsNull(@alertConfigInfo.value('(alertConfigInfo/@persistInterval)[1]','int'),0)
					set @repeatIntervalCur  = IsNull(@alertConfigInfo.value('(alertConfigInfo/@repeatInterval)[1]','int'),0)
					set @isPersistOptionChecked = IsNull(@alertConfigInfo.value('(alertConfigInfo/@isPersistOptionChecked)[1]','int'),0)
					set @isRepeatOptionChecked = IsNull(@alertConfigInfo.value('(alertConfigInfo/@isRepeatOptionChecked)[1]','int'),0)
					declare @alertStatus int = 0
					select @alertStatus = status from NTNotificationRule
					where id=@searchAlertId
					if @isPersistOptionChecked=0
					begin
						set @persistIntervalCur = 0
					end
					if @isRepeatOptionChecked=0
					begin
						set @repeatIntervalCur = 0
					end
					-- #define NT_STATUS_LM_TREND_ALERT			16384
					if @lmAlertType=2
					begin
						-- Its a trend Alert. its a regular alert
set @alertStatus = @alertStatus  | 16384
					end
else if ((@alertStatus & 16384)>0)
					begin
set @alertStatus = @alertStatus - 16384
					end
					if @lmAlertType=1
					begin
set @alertStatus = @alertStatus | 4096
					end
else if ((@alertStatus & 4096)>0)
					begin
set @alertStatus = @alertStatus - 4096
					end
					if @lmAlertType=3
					begin
set @alertStatus = @alertStatus | 65536
					end
else if ((@alertStatus & 65536)>0)
					begin
set @alertStatus = @alertStatus - 65536
					end
					if @lmAlertType=4
					begin
set @alertStatus = @alertStatus | 131072
					end
else if ((@alertStatus & 131072)>0)
					begin
set @alertStatus = @alertStatus - 131072
					end
					-- When lm alert type has changed for alert, we delete all existing alerts from ntdetectedalerts table
					if (@alertOperation=2)
					begin
						declare @currentLMAlertType int
						declare @currentSearchXML xml
						declare @origLMGroupByFieldInDB nvarchar(max) = ''
						declare @modifiedLMGroupByField nvarchar(max) = ''
						declare @origUseGroupByInDB int = 0
						declare @modifiedUseGroupByInDB nvarchar(max) = ''
						select @currentSearchXML = origSearchInfoXMLTbl.origSearchInfoXML from @origSearchInfoXMLTbl origSearchInfoXMLTbl
						where searchId=@localSearchId
						select @currentLMAlertType = IsNull(Tbl.Col.value('../@alertType','int'),0),
						@origLMGroupByFieldInDB=IsNull(Tbl.Col.value('../@lmGroupByField','nvarchar(max)'),''),
						@origUseGroupByInDB =IsNull(Tbl.Col.value('../@useGroupBy','int'),0)
						from @currentSearchXML.nodes('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity[@alertId=sql:variable("@searchAlertId")])') as Tbl(Col)
						select @modifiedLMGroupByField = lmGroupByField ,
							@modifiedUseGroupByInDB = useGroupBy
						from @alertInfoForSearch
						where alertId=@searchAlertId
						if (@currentLMAlertType!=@lmAlertType)
						begin
							update NTDetectedAlerts
							set processStat=8
							where ntnotificationid=@searchAlertId
						end
						-- when group by value of field changes and useGroupBy Option selected,then we mark all existing alerts processed.
						if (@modifiedLMGroupByField<>@origLMGroupByFieldInDB and @modifiedUseGroupByInDB=1)
						begin
							update NTDetectedAlerts
							set processStat=8
							where ntnotificationid=@searchAlertId
						end
						-- when useGroupBy option changes, then we disable all existing alerts.
						if (@modifiedUseGroupByInDB<>@origUseGroupByInDB )
						begin
							update NTDetectedAlerts
							set processStat=8
							where ntnotificationid=@searchAlertId
						end
					end
					-- #define NT_STATUS_STICKY_NOTIFICATIONRULES			8192
					-- #define NT_STATUS_LM_VALUE_FILTER			65536
					-- #define NT_STATUS_VALUE_CHANGE				131072
					if 	not exists(select 1 from @supportedCriteriaForRepeatedAlerts where lmAlertType=@lmAlertType)
					begin
						set @reportingOptionsCur=1025 -- NT_REPORT_CURRENT_RESULTS|NT_REPORT_IMMEDIATE
						set @notifyWhenConditionClearsCur = 0
						set @persistIntervalCur = 0
						set @repeatIntervalCur  = 0
if ((@alertStatus & 8192)>0)
						begin
set @alertStatus = @alertStatus - 8192
						end
					end
					else
					begin
set @alertStatus = @alertStatus  | 8192
						-- FOR LM value based instant alerts if no repeat interval is selected, we treat like regular alert.
						if (@repeatIntervalCur=0 and @lmAlertType=3)
						begin
set @alertStatus = @alertStatus  - 8192
							set @reportingOptionsCur=1025
						end
						if (@repeatIntervalCur>0)
						begin
							set @reportingOptionsCur|=2 -- NT_REPORT_REPEATED
						end
						if (@notifyWhenConditionClearsCur>0)
						begin
							set @reportingOptionsCur|=4 -- NT_REPORT_NOTIFY_CONDITION_CLEAR
						end
					end
					-- if lm alertType is match the below criteria then notify only if condition persists for isnt supported
					if (@lmAlertType=3)
					begin
						set @persistIntervalCur = 0
					end
					Update NTNotificationRule
					set status = @alertStatus,
					lastModified = @nowTime
					where id=@searchAlertId
					-- Now update reporting options and repeat after time.
					Update NTSelCriteria
					set reportingOptions = @reportingOptionsCur,
					persistTimeSeconds = @repeatIntervalCur, -- persisttime stores repeat every value
					delayTimeSeconds =  @persistIntervalCur
					where Ruleid=@searchAlertId
				end
				FETCH FROM AddUpdateSearchListCur INTO @alertOperation,@notificationType,@emailIdsList,@searchAlertId,@searchalertName,@localSearchId,@lmAlertType,@alertConfigInfo,@workflowEntity,@notifMessageHtml,@dynamicRecipientList,@colNameForRecipient
			end
		-- Now that we have the alertId for all alerts in @alertInfoForSearch, we will fill them in xml also.
		IF(@opertaionsType = 2 OR @opertaionsType = 5)
		begin
			DECLARE @currSearchId INTEGER
			DECLARE @currSearchInfo xml
			DECLARE searchAlertCursor CURSOR FOR
			SELECT lmsearch.searchId, lmsearch.searchInfo
			FROM @LMSerachTemp lmtemp JOIN LMUserSearch lmsearch ON lmtemp.searchName = lmsearch.searchName AND lmsearch.monitoringAppType =  lmtemp.appType
			OPEN searchAlertCursor
			FETCH NEXT FROM searchAlertCursor
			INTO @currSearchId, @currSearchInfo
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @currSearchInfo.modify('delete //alertInfoLst')
				DECLARE @searchAlertInfoXml xml
				SET @searchAlertInfoXml = (SELECT notificationType '@notifType',
				thisManyTimes '@thisManyTimes',
				withinTheseManyMinutes '@withinTheseManyMinutes',
				linesBelowMatchedLine '@linesBelowMatchedLine',
				linesAboveMatchedLine '@linesAboveMatchedLine',
				lmAlertType '@alertType',
				alertCriteria '@alertCriteria',
				notifMessageHtml '@notifMessageHtml',
				additionalInfo '@additionalInfo',
				timezoneInfo '@timezoneInfo',
				lmGroupByField '@lmGroupByField',
				useGroupBy '@useGroupBy',
				status as '@status',
				addColsInEmail as '@addColsInEmail',
				colsToDisplayInAlertEmail as '@colsToDisplayInAlertEmail',
				emailIdsList.query('.'),
				alertConfigInfo.query('.'),
				alertId 'alertEntity/@alertId',
				alertName 'alertEntity/@alertName',
				workflowEntity.query('.'),
				rateOfChangeAlertInfo.query('.'),
				associatedPolicyList.query('.')
				FROM @alertInfoForSearch
				FOR xml path('alertInfoLst'))
				set @currSearchInfo = (select @currSearchInfo.value('(LogMonitoring_SearchURLInfo/@orderId)[1]','int') as '@orderId',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@searchType)[1]','int') as '@searchType',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@serviceURL)[1]','nvarchar(max)') as '@serviceURL',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@browserURL)[1]','nvarchar(max)') as '@browserURL',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@trendBrowserURL)[1]','nvarchar(max)') as '@trendBrowserURL',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@solrQuery)[1]','nvarchar(max)') as '@solrQuery',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@solrQueryWithoutTime)[1]','nvarchar(max)') as '@solrQueryWithoutTime',
				@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@searchLabel)[1]','nvarchar(max)') as '@searchLabel',
				--IsNull(@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@addColsInEmail)[1]','int'),0) as '@addColsInEmail',
				--IsNull(@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@colsToDisplayInAlertEmail)[1]','nvarchar(max)'),'') as '@colsToDisplayInAlertEmail',
				IsNull(@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0) as '@isImplicitSearch',
				IsNull(@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@showAsSharedSearchUrl)[1]','int'),0) as '@showAsSharedSearchUrl',
				IsNull(@currSearchInfo.value('(LogMonitoring_SearchURLInfo/@monitoringType)[1]','int'),0) as '@monitoringType',
				@currSearchInfo.query('LogMonitoring_SearchURLInfo/*')--,
				--@searchAlertInfoXml.query('.')
				for xml path('LogMonitoring_SearchURLInfo'))
				UPDATE LMUserSearch
				SET searchInfo = @currSearchInfo
				where searchId = @currSearchId
				SET @alertPropCount = ISNULL(@searchAlertInfoXml.value('count(alertInfoLst)','INTEGER'),0)
				IF(@alertPropCount > 0)
				BEGIN
					SET @i = 1
					WHILE (@i <= @alertPropCount)
					BEGIN
						SET @curAlertXml = (SELECT @searchAlertInfoXml.query('(alertInfoLst)[sql:variable("@i")]'))
						SET @curAlertId = (SELECT R.alert.value('@alertId','int') FROM @curAlertXml.nodes('alertInfoLst/alertEntity') as R(alert))
						IF NOT EXISTS(SELECT 1 FROM APP_LMAlertInfo WHERE AlertId = @curAlertId)
						BEGIN
							SET @curAlertname = (SELECT R.alert.value('@alertName','nvarchar(max)') FROM @curAlertXml.nodes('alertInfoLst/alertEntity') as R(alert))
							--Alerts for same search should be with different name.
							IF EXISTS(SELECT 1 FROM APP_LMAlertInfo
										WHERE SearchId = @searchId and AlertProp.value('(alertInfoLst/alertEntity/@alertName)[1]','nvarchar(max)') = @curAlertname)
							BEGIN
								SET @errorCode = 2
								RAISERROR ('Alert with same name already exists for search', -- Message text.
											16, -- Severity.
												1 -- State.
								);
							END
							INSERT INTO APP_LMAlertInfo(AlertId,SearchId,AlertProp)
							VALUES(@curAlertId,@searchId,@curAlertXml)
						END
						ELSE
						BEGIN
							UPDATE APP_LMAlertInfo
							SET AlertProp = @curAlertXml
							WHERE AlertId = @curAlertId
						END
						SET @i = @i + 1;
					END
				END
				FETCH NEXT FROM searchAlertCursor
				INTO @currSearchId, @currSearchInfo
			END
		END
	end
	COMMIT TRANSACTION LMSearchOperationsTran
	DECLARE @alertProp table(searchId int , alertXml xml)
	DECLARE @searchUrlTble table(searchId int,searchUrl xml)
	DECLARE @searchAlertTbl TABLE(searchId INTEGER,alertId INTEGER,alertXML XML)
	INSERT INTO @searchAlertTbl(searchId,alertId,alertXML)
	SELECT lmAlert.SearchId,lmAlert.AlertId,lmAlert.AlertProp
	FROM LMUserSearch as searchTbl WITH (NOLOCK)
	INNER JOIN @LMSerachTemp tempTbl
	ON searchTbl.searchName = tempTbl.searchName
	INNER JOIN APP_LMAlertInfo lmAlert WITH (NOLOCK)
	ON lmAlert.SearchId = searchTbl.searchId
	INNER JOIN NTnotificationRule ntTbl WITH (NOLOCK)
	ON ntTbl.id = lmAlert.AlertId AND (ntTbl.status&2)=0
	--Getting status of alert(Enabled or Disabled) from NTNotificationRule Table
	UPDATE searchAlertTbl
	SET alertXML.modify('replace value of (alertInfoLst/@status) [1] with ("1") ')
	FROM @searchAlertTbl searchAlertTbl
	INNER JOIN NTNotificationRule ntNotificationTbl
	ON searchAlertTbl.alertId = ntNotificationTbl.id
	WHERE (ntNotificationTbl.status &1) = 0 AND (ntNotificationTbl.status&2)=0 --> Enabled and non deleted alerts
	UPDATE searchAlertTbl
	SET alertXML.modify('replace value of (alertInfoLst/@status) [1] with ("0") ')
	FROM @searchAlertTbl searchAlertTbl
	INNER JOIN NTNotificationRule ntNotificationTbl
	ON searchAlertTbl.alertId = ntNotificationTbl.id
	WHERE (ntNotificationTbl.status &1) <> 0 AND (ntNotificationTbl.status&2)=0 --> Disabled and non deleted alerts
	INSERT INTO @alertProp(searchId , alertXml)
	SELECT A.searchid,
		   (SELECT alertXML.query('.')
		   FROM @searchAlertTbl searchAlertTbl
		   WHERE searchAlertTbl.searchId = A.searchId
		   FOR XML PATH(''),type) as alertProp
	FROM LMUserSearch as A
	INNER JOIN @LMSerachTemp tempTbl
	ON A.searchName = tempTbl.searchName
	INSERT INTO @searchUrlTble
	SELECT searchTbl.searchId,searchTbl.searchInfo
	FROM LMUserSearch searchTbl
	INNER JOIN @LMSerachTemp tempTbl
	ON searchTbl.searchName = tempTbl.searchName
	UPDATE searchUrlTbl
	SET searchUrl.modify('insert ( sql:column("alertTbl.alertXml") ) as first into (/LogMonitoring_SearchURLInfo[1])')
	FROM @searchUrlTble searchUrlTbl
	INNER JOIN @alertProp alertTbl
	ON searchUrlTbl.searchId = alertTbl.searchId
	IF (@opertaionsType = 2)
	BEGIN
		DECLARE @DashSearch TABLE (searchId INTEGER, dashBoards XML)
		INSERT INTO @DashSearch(searchId)
		SELECT searchId FROM @LMSerachTemp
		UPDATE tempds
		SET dashBoards = (SELECT dsb.dashBoardId  as '@dashBoardId',
									dsb.dashBoardName as '@dashBoardName',
									dsb.status as '@status',
									CONVERT(NVARCHAR(MAX),dsb.dashBoardProp) as '@dashBoardProp',
									dsb.creatorUserId as 'creator/@userId'
								FROM @DashSearch ds INNER JOIN LMDashSearchAssoc dsa
										ON ds.searchId = dsa.searchId
											INNER JOIN LMDashBoard dsb
												ON dsb.dashBoardId = dsa.dashBoardId
												WHERE ds.searchId = tempds.searchId FOR XML PATH('dashInfo'))
		FROM @DashSearch tempds
		SET @o_xmlMsg = ISNULL((SELECT lmsearch.searchId as '@searchId',
							lmsearch.searchName as '@searchName',
							lmsearch.isPrivate as '@isPrivate',
							lmsearch.status as '@status',
							CONVERT(NVARCHAR(MAX),searchUrlTbl.searchUrl) as '@urlInfo',
							lmsearch.creatorUserId as 'creator/@userId',
							lmd.dashBoards as 'node()'
							FROM LMUserSearch lmsearch with (nolock) INNER JOIN @LMSerachTemp lmtemp
								ON lmtemp.searchId = lmsearch.searchid
									LEFT JOIN @DashSearch lmd
										ON lmd.searchId = lmtemp.searchId
											INNER JOIN @searchUrlTble searchUrlTbl
												ON searchUrlTbl.searchId = lmsearch.searchId
							FOR XML PATH('LogMonitoring_SearchInfo')),'<LogMonitoring_SearchInfo/>')
	END
	ELSE IF(@opertaionsType = 5)
	BEGIN
		IF EXISTS (SELECT TOP 1 lms.searchId,lms.searchName, lms.isPrivate, lms.status, CONVERT(NVARCHAR(MAX),lms.searchInfo),
		lms.creatorUserId, lmd.dashBoardId,lmd.dashBoardName,lmd.creatorUserId
		FROM LMUserSearch lms with (nolock) LEFT JOIN LMDashSearchAssoc lmsa with (nolock)
		ON lms.searchId = lmsa.searchid
		LEFT JOIN LMDashBoard lmd with (nolock)
		ON lmsa.dashBoardId = lmd.dashBoardId
		WHERE lms.searchName IN (SELECT searchName FROM @LMSerachTemp) AND lms.monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp))
		BEGIN
			IF @errStr <> ''
			BEGIN
				SET @o_xmlMsg = ISNULL((SELECT TOP 1 @errstr as '@errorString',
							lmd.dashBoardId as  'dInfo/@dashBoardId',
							lmd.dashBoardName as  'dInfo/@dashBoardName',
							CONVERT(NVARCHAR(MAX),lmd.dashBoardProp) as 'dInfo/@dashBoardProp',
							lmd.creatorUserId as 'dInfo/creator/@userId'
							FROM LMUserSearch lms with (nolock) LEFT JOIN LMDashSearchAssoc lmsa with (nolock)
								ON lms.searchId = lmsa.searchid
									LEFT JOIN LMDashBoard lmd with (nolock)
										ON lmsa.dashBoardId = lmd.dashBoardId
							WHERE lms.searchName IN (SELECT searchName FROM @LMSerachTemp) AND lms.monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp)
							FOR XML PATH('LogMonitoring_ImportDashInfoResp')),'<LogMonitoring_ImportDashInfoResp/>')
			END
			ELSE
			BEGIN
				SET @o_xmlMsg = ISNULL((SELECT TOP 1 lms.searchId as '@searchId',
							lms.searchName as '@searchName',
							lms.isPrivate as '@isPrivate',
							lms.status as '@status',
							CONVERT(NVARCHAR(MAX),searchUrlTbl.searchUrl) as '@urlInfo',
							lms.creatorUserId as 'creator/@userId',
							lmd.dashBoardId as  'dashInfo/@dashBoardId',
							lmd.dashBoardName as  'dashInfo/@dashBoardName',
							CONVERT(NVARCHAR(MAX),lmd.dashBoardProp) as 'dashInfo/@dashBoardProp',
							lmd.creatorUserId as 'dashInfo/creator/@userId'
							FROM LMUserSearch lms with (nolock) LEFT JOIN LMDashSearchAssoc lmsa with (nolock)
								ON lms.searchId = lmsa.searchid
									LEFT JOIN LMDashBoard lmd with (nolock)
										ON lmsa.dashBoardId = lmd.dashBoardId
											INNER JOIN @searchUrlTble searchUrlTbl
												ON searchUrlTbl.searchId = lms.searchId
							WHERE lms.searchName IN (SELECT searchName FROM @LMSerachTemp) AND lms.monitoringAppType = (SELECT TOP 1 appType FROM @LMSerachTemp)
							FOR XML PATH('LogMonitoring_SearchInfo')),'<LogMonitoring_SearchInfo/>')
			END
		END
		ELSE
		BEGIN
			SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errStr AS '@errorString' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
		END
	END
	ELSE IF(@opertaionsType = 12)
	BEGIN
		--Send webconsole what all searches are deleted while deleting alert. So in next request, webconsole will send operationType as 5.
		SET @o_xmlMsg =ISNULL((SELECT DISTINCT searchDelTbl.searchId as '@searchId'
								FROM @LMSearchdeleteData searchDelTbl
								WHERE searchDelTbl.isImplicitShldDelete = 1 -- If it is 0, then search is saved search or implicit search associated with any other entity, so search will not be deleted.
								FOR XML PATH('searchInfoList'),root('LogMonitoring_SearchListResp')),'<LogMonitoring_SearchListResp/>')
	END
	ELSE
	BEGIN
		SET @o_xmlMsg = (SELECT @errorCode AS '@errorCode' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
	END
	IF @indicateAlertResync = 1
	BEGIN
		DECLARE @clientId INT
		DECLARE @workQOutPutTbl       TABLE (errCode INT, errString NVARCHAR(MAX))
		DECLARE @errorString nvarchar(100);
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
		            (     serverURL NVARCHAR(512),
		                  clientId INT,
		                  clientName NVARCHAR(256),
		                  cloudId INT,
		                  hostName NVARCHAR(256),
		                  basePort INT,
		                  engineName  NVARCHAR(256),
		                  serverType INT,
		                  indexServerClientId INT,
		                  internalCloudName NVARCHAR(256)
		            )
		CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
		SET @clientId = ISNULL((select top 1  dm2Tbl.clientId from #getIndexServers dm2Tbl
								INNER JOIN APP_Client appClient WITH(NOLOCK) ON dm2Tbl.clientId = appClient.id WHERE appClient.status & 2 <> 2 ORDER BY dm2Tbl.clientId) , 0)
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		IF @clientId > 0
		BEGIN
			-- send workQueue Request to First lm cloud to process Alert.
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clientId, 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="0" operationType="8"/>'
			SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
			IF @errorCode <> 0
			BEGIN
				GOTO ERROR_EXIT
			END
		END
ERROR_EXIT:
	END --IF @indicateAlertResync = 1
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION LMSearchOperationsTran
	IF @errorCode =0 SET @errorCode = 1
	DECLARE @errorMessage NVARCHAR(4000) = ERROR_MESSAGE()
	SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'LMSearchOperations')
	delete from GxQscripts where name = 'LMSearchOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMSearchOperations')
	delete from GXDBVersions where aliasname = 'LMSearchOperations'
GO

insert into GXDBVersions values(2, 'LMSearchOperations',  '00010017001200380000', 'LMSearchOperations', '00010017001200380000')
GO

