

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMRestoreToPrecookedDashboard.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMRestoreToPrecookedDashboard.sp,v $ $Id: LMRestoreToPrecookedDashboard.sp,v 1.1.2.12 2018/02/27 19:48:09 logeshg Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMRestoreToPrecookedDashboard <<<'

IF EXISTS (select * from sysobjects where name='LMRestoreToPrecookedDashboard')
	drop procedure LMRestoreToPrecookedDashboard
IF EXISTS (select * from GxQscripts where name='LMRestoreToPrecookedDashboard')
	delete from GxQscripts where name = 'LMRestoreToPrecookedDashboard'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMRestoreToPrecookedDashboard')
	delete from GXDBVersions where aliasname = 'LMRestoreToPrecookedDashboard'
GO
print '... Creating Procedure: LMRestoreToPrecookedDashboard'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMRestoreToPrecookedDashboard
  @userId INTEGER,
  @monitoringAppType INTEGER,
  @o_xmlMsg xml     OUTPUT
AS
BEGIN TRY
BEGIN TRANSACTION RestoreToPrecookedDashboard
	DECLARE @errorMessage NVARCHAR(4000) = ''
	DECLARE @errorCode INTEGER = 0
	DECLARE @capabilties     int
	DECLARE @hasPermission int = 0
set @capabilties = POWER(2, (1-1))
EXEC sec_checkPermissionOnEntity @userId, @capabilties, @hasPermission OUTPUT, 2018, 0
	if(@hasPermission = 1)
	begin
	DECLARE @curUtcDateTime BIGINT
	DECLARE @dashboardId INT
	DECLARE @searchId INT
	DECLARE @DashBoardName NVARCHAR(50) = 'System Created Activity Monitoring' --activity monitoring default dashboard
	DECLARE @browserURLField NVARCHAR(max)
	DECLARE @solrQueryField NVARCHAR(max)
	DECLARE @searchLabelField NVARCHAR(max)
	DECLARE @searchUrlXml xml
	DECLARE @searchUrl NVARCHAR(MAX)
	DECLARE @hasOpDashboard BIT
	if(@monitoringAppType = 1)
	begin
	set @hasOpDashboard = (select 1 from LMDashBoard with(nolock) where dashBoardName = 'Operation Dashboard' AND monitoringAppType = 1 AND (status & 4) > 0)
	end
	declare @SIDS TABLE
	(
		subTaskId integer
	)
		declare @SCSIDS TABLE
		(
			searchId integer
		)
	SET @curUtcDateTime = datediff(second, '01/01/1970', GetUTCdate())
		insert into @SCSIDS
			select LMDSA.searchId from LMDashSearchAssoc LMDSA with(nolock) inner join LMDashBoard LMD with(nolock) on LMD.dashBoardId = LMDSA.dashBoardId inner join LMUserSearch LMUS with(nolock) on LMDSA.searchId = LMUS.searchId where LMUS.monitoringAppType = @monitoringAppType and LMD.monitoringAppType = @monitoringAppType and LMD.status in (4,8)--(4,8) indicates System created
	--ALERTS
	UPDATE NT SET revision = 0, status = 2
	FROM NTnotificationRule NT
	INNER JOIN APP_LMAlertInfo alertInfo
	ON alertInfo.AlertId = NT.id and NT.status&1 = 0 AND (NT.status&2)=0-->enabled and non deleted onces.
	INNER JOIN LMUserSearch LMUS
	ON alertInfo.SearchId = LMUS.searchId
	INNER JOIN @SCSIDS SCSIDS
	ON LMUS.searchId = SCSIDS.searchId	where (LMUS.status & 4) >= 4 --> DASHBOARD.
	--SCHEDULES
	insert into @SIDS
			select TM_SubTaskOptions.subTaskId from TM_SubTask with(nolock) inner join TM_SubTaskOptions with(nolock) on
		TM_SubTaskOptions.subTaskId = TM_SubTask.subTaskId
			inner join @SCSIDS SCSIDS on SCSIDS.searchId = TM_SubTaskOptions.value
			where TM_SubTaskOptions.optionId = convert(nvarchar(max),951244723)
	delete TM from TM_Task TM inner join TM_SubTask on TM.taskId = TM_SubTask.taskId inner join @SIDS SIDS on SIDS.subTaskId = TM_SubTask.subTaskId
	delete TM_SO from TM_SubTaskOptions TM_SO inner join @SIDS SIDS on SIDS.subTaskId = TM_SO.subTaskId
	delete TM_S from TM_SubTask TM_S inner join @SIDS SIDS on SIDS.subTaskId = TM_S.subTaskId
	--Delete from app_reports
		delete RPT from app_reports as RPT inner join @SCSIDS as SCSIDS on
		RPT.definition.value('(/CustomReport/pages/Page/dataSets/dataSet/DataSet/lmDataSet/searchInfo/searchId/text())[1]', 'INTEGER') = SCSIDS.searchId
	where RPT.definition.value('(/CustomReport/pages/Page/dataSets/dataSet/DataSet/lmDataSet/searchInfo/searchId/text())[1]', 'INTEGER') is not null
		--Delete from searches joining system created search ids
		delete LMUS from LMUserSearch as LMUS inner join @SCSIDS as SCSIDS on LMUS.searchId = SCSIDS.searchId
		--delete from LM dashboard share
			delete APE from App_SharedEntityInfo as APE inner join LMDashboard as LMD on APE.OriginalEntityId = LMD.dashBoardId
				where APE.SharedEntityType = 137 and LMD.status in (4,8) and LMD.monitoringAppType = @monitoringAppType
			--delete from LM Search share
			delete APE from App_SharedEntityInfo as APE inner join @SCSIDS as SCSIDS on APE.OriginalEntityId = SCSIDS.searchId
				where APE.SharedEntityType = 134
	--Delte from dashboard table
		delete LMD from LMDashboard LMD where LMD.status in (4,8) and LMD.monitoringAppType = @monitoringAppType
	if(@monitoringAppType = 2)
	begin
		--Activity dashboard
	--clear previous script entry
	DELETE FROM LMDashBoard WHERE dashBoardName = 'Activity Monitoring' AND monitoringAppType = 2 AND status = 4
	--creating dashboard
	DECLARE @dashBoardProp XML = CONVERT(XML, '<LogMonitoring_DashBoardProp isClientNavigation="0" clientNavigationApp="Activity Monitoring" />')
	-- status = 8 indicates pre-created dashboard which is available for all users
	INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)
		VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)
	SET @dashboardId = @@IDENTITY
	--creating searches
	--Clients with Most Edited Content
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20pie%20hostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype pie hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '1' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Clients with Most Edited Content' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Clients with Most Edited Content',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Clients with Most Edited Content' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Top Users Editing Content
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20donut%20user%2Chostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '2' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Top Users Editing Content' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Top Users Editing Content',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Top Users Editing Content' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Most Edited Files
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22WRITE%22%2C%22CREATE%22%2C%22DELETE%22%2C%22MOVE%22&amp;fieldList=TemplateName%2Cuseroperation_ss&amp;keyWord=graphtype%20pie%20sourcefilename&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Activity+Monitoring%22%29&amp;fq=%28useroperation_ss%3A%22WRITE%22+OR+useroperation_ss%3A%22CREATE%22+OR+useroperation_ss%3A%22DELETE%22+OR+useroperation_ss%3A%22MOVE%22%29&amp;q=*%3A*&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype pie sourcefilename&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;WRITE,CREATE,DELETE,MOVE&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '3' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Edited Files' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Most Edited Files',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Edited Files' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Most Active Users
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20donut%20user%2Cuseroperation&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,useroperation&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '4' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Active Users' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Most Active Users',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Active Users' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Most Failed Activity
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;result_sf=%22FAILED%22&amp;fieldList=TemplateName%2Cresult_sf&amp;keyWord=graphtype%20donut%20user%2Cuseroperation&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28result_sf%3A%22FAILED%22%29&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,useroperation&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;result_sf:&lt;/b&gt;FAILED&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '5' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Activity' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Most Failed Activity',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Activity' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Most Failed Logins
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22LOGIN%22&amp;result_sf=%22FAILED%22&amp;fieldList=TemplateName%2Cuseroperation_ss%2Cresult_sf&amp;keyWord=graphtype%20donut%20user%2Chostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;q=*%3A*+AND+%28isLMDoc%3A2%29+AND+%28TemplateName%3A%22Activity+Monitoring%22%29+AND+%28useroperation_ss%3A%22LOGIN%22%29+AND+%28result_sf%3A%22FAILED%22%29&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut user,hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;&lt;b&gt;useroperation_ss:&lt;/b&gt;LOGIN&lt;br&gt;&lt;b&gt;result_sf:&lt;/b&gt;FAILED&lt;br&gt; &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '6' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Logins' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Most Failed Logins',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Failed Logins' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	SET @browserURLField = '?viewId=1&amp;TemplateName=%22Activity%20Monitoring%22&amp;useroperation_ss=%22LOGIN%22&amp;fieldList=TemplateName&amp;excludeFieldList=useroperation_ss&amp;keyWord=graphtype%20donut%20processname%2C%20hostname&amp;startTime=&amp;endTime=&amp;estimatedTimeDiff&amp;gap&amp;isAllTime=true&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3Cmark%3E&amp;hl.simple.post=%3C%2Fmark%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Activity+Monitoring%22%29&amp;fq=+-%28useroperation_ss%3A%22LOGIN%22%29&amp;q=*%3A*&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype donut processname, hostname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Activity Monitoring&lt;br&gt;useroperation_ss: - LOGIN  &lt;b&gt;Time Range:&lt;/b&gt;All Time&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '7' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Used Applications' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Most Used Applications',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Most Used Applications' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Activity dashboard
	--APP_SMCreatePreCookedDashboards
	set @DashBoardName = 'System Resources'
    set @dashBoardProp = CONVERT(XML, '<LogMonitoring_DashBoardProp isClientNavigation="1" clientNavigationApp="Resource Monitoring" />')
    --creating "system resources" dashboard
    IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)
        BEGIN
            SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)
            UPDATE LMDashBoard set dashBoardProp = @dashBoardProp where dashBoardId = @dashboardId
            UPDATE LMDashBoard set status = 8 where dashBoardId = @dashboardId
        END
    ELSE
        BEGIN
            -- status = 8 indicates the pre created read only dashboard
            INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)
                VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)
            SET @dashboardId = @@IDENTITY
    END
    --creating searches
    --CPU vs Memory
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22System%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(cpuusage)%2C%20avg(freephysicalmemory)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ccpuusage_df%2Cphysicalmemorykb_if%2Cvirtualmemorykb_if%2Cevents_if%2Cmutexes_if%2Cserialno_sf%2Cregcode_sf%2Cfreephysicalmemory_if%2Cfreevirtualmemory_if&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22System+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(cpuusage), avg(freephysicalmemory)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;System Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '1' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'CPU vs Memory' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('CPU vs Memory',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'CPU vs Memory' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Disk Free Space
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Disk%20IO%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20timechart%20avg(freebytespercent)%20by%20diskdevice&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Cdiskdevice_lf%2Ceventtime_sf%2Cwritespersec_if%2Cwritebytespersec_if%2Creadspersec_if%2Creadbytespersec_if%2Cavgdiskwritequeuelength_if%2Cavgdiskreadqueuelength_if&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Disk+IO+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(freebytespercent) by diskdevice&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Disk IO Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '2' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Disk Free Space' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Disk Free Space',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Disk Free Space' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
    --Network Data Sent vs Received
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Network%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(bytesreceivedpersec)%2C%20avg(bytessentpersec)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ceventtime_sf%2Cinterfacename_lf%2Cbytesreceivedpersec_if%2Cbytessentpersec_if%2Cbandwidth_if%2Cpacketsreceivedpersec_if%2Cpacketssentpersec_if&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Network+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(bytesreceivedpersec), avg(bytessentpersec)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Network Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '3' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Network Data Sent vs Received' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Network Data Sent vs Received',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Network Data Sent vs Received' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
    SET @DashBoardName = 'Commvault Resource Usage'
    --creating "Commvault Resource Usage" dashboard
    IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)
        BEGIN
            SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName AND monitoringAppType = 2 AND creatorUserId = 1)
            UPDATE LMDashBoard set dashBoardProp = @dashBoardProp where dashBoardId = @dashboardId
            UPDATE LMDashBoard set status = 8 where dashBoardId = @dashboardId
        END
    ELSE
        BEGIN
            -- status = 8 indicates the read only dashboard
            INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)
                VALUES(@DashBoardName,1,1,8,@curUtcDateTime,0,2,@dashBoardProp)
            SET @dashboardId = @@IDENTITY
    END
    --Commserve Process CPU Usage
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22QSDK.exe%22%2C%22EvMgrs.exe%22%2C%22cvd.exe%22%2C%22AppMgrSvc.exe%22%2C%22JobMgr.exe%22%2C%22MediaManager.exe%22%2C%22CVJavaService.exe%22%2C%22AuxCopyMgr.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(cpu)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if%2Creadcount_if%2Creadsize_if%2Cprocessname_lf%2CMonitoringPolicyName&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22QSDK.exe%22+OR+processname_sf%3A%22EvMgrs.exe%22+OR+processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22AppMgrSvc.exe%22+OR+processname_sf%3A%22JobMgr.exe%22+OR+processname_sf%3A%22MediaManager.exe%22+OR+processname_sf%3A%22CVJavaService.exe%22+OR+processname_sf%3A%22AuxCopyMgr.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(cpu) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;QSDK.exe,EvMgrs.exe,cvd.exe,AppMgrSvc.exe,JobMgr.exe,MediaManager.exe,CVJavaService.exe,AuxCopyMgr.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '1' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process CPU Usage' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Commserve Process CPU Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process CPU Usage' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
    --Commserve Process Memory Usage
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22QSDK.exe%22%2C%22EvMgrs.exe%22%2C%22cvd.exe%22%2C%22AppMgrSvc.exe%22%2C%22JobMgr.exe%22%2C%22MediaManager.exe%22%2C%22CVJavaService.exe%22%2C%22AuxCopyMgr.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(Memory)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2CMonitoringPolicyName%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if%2Creadcount_if%2Creadsize_if%2Cprocessname_lf&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22QSDK.exe%22+OR+processname_sf%3A%22EvMgrs.exe%22+OR+processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22AppMgrSvc.exe%22+OR+processname_sf%3A%22JobMgr.exe%22+OR+processname_sf%3A%22MediaManager.exe%22+OR+processname_sf%3A%22CVJavaService.exe%22+OR+processname_sf%3A%22AuxCopyMgr.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(Memory) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;QSDK.exe,EvMgrs.exe,cvd.exe,AppMgrSvc.exe,JobMgr.exe,MediaManager.exe,CVJavaService.exe,AuxCopyMgr.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '2' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process Memory Usage' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Commserve Process Memory Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Commserve Process Memory Usage' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
    --Media Agent Process CPU Usage
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22cvd.exe%22%2C%22IndexingService.exe%22%2C%22CVMountd.exe%22%2C%22SIDB2.exe%22%2C%22CvMountd%22%2C%22AuxCopy.exe%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(cpu)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22IndexingService.exe%22+OR+processname_sf%3A%22CVMountd.exe%22+OR+processname_sf%3A%22SIDB2.exe%22+OR+processname_sf%3A%22CvMountd%22+OR+processname_sf%3A%22AuxCopy.exe%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(cpu) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;cvd.exe,IndexingService.exe,CVMountd.exe,SIDB2.exe,CvMountd,AuxCopy.exe&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '3' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process CPU Usage' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Media Agent Process CPU Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process CPU Usage' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Media Agent Process Memory Usage
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Processes%20Statistics%22&amp;processname_sf=%22cvd.exe%22%2C%22IndexingService.exe%22%2C%22CVMountd.exe%22%2C%22SIDB2.exe%22%2C%22CvMountd%22%2C%22AuxCopy.exe%22%2C%22cvd%22%2C%22Indexing%22&amp;fieldList=TemplateName%2Cprocessname_sf&amp;keyWord=graphtype%20timechart%20avg(Memory)%20by%20processname&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Ccpu_df%2Cprocessid_if%2Cthreads_if%2Chandles_if%2Cmemory_if%2Cwritecount_if%2Cwritesize_if&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Processes+Statistics%22%29&amp;fq=%28processname_sf%3A%22cvd.exe%22+OR+processname_sf%3A%22IndexingService.exe%22+OR+processname_sf%3A%22CVMountd.exe%22+OR+processname_sf%3A%22SIDB2.exe%22+OR+processname_sf%3A%22CvMountd%22+OR+processname_sf%3A%22AuxCopy.exe%22+OR+processname_sf%3A%22cvd%22+OR+processname_sf%3A%22Indexing%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype timechart avg(Memory) by processname&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Processes Statistics&lt;br&gt;&lt;b&gt;processname_sf:&lt;/b&gt;cvd.exe,IndexingService.exe,CVMountd.exe,SIDB2.exe,CvMountd,AuxCopy.exe,cvd,Indexing&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '4' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process Memory Usage' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Media Agent Process Memory Usage',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Process Memory Usage' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--Agent DIsk Read vs Media Agent Disk Write
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Stream%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=graphtype%20compare%20avg(ida_read_throughput)%2C%20avg(ma_disk_write_throughput)&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;visibleCols=eventTime%2Ctag_ss%2Ceventtime_sf%2Cjob_id_if%2Cpipeline_id_if%2Capp_type_if%2Cdata_type_if%2Cida_read_if%2Cida_read_size_if%2Cida_read_throughput_df&amp;graphScale=spline&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A2%29&amp;fq=%28TemplateName%3A%22Stream+Statistics%22%29&amp;fq=%28eventTime:[NOW-1DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
    SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;Search Query: &lt;/b&gt;graphtype compare avg(ida_read_throughput), avg(ma_disk_write_throughput)&lt;br&gt;&lt;b&gt;TemplateName:&lt;/b&gt;Stream Statistics&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-1DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '5' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Agent DIsk Read vs Media Agent Disk Write' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Agent DIsk Read vs Media Agent Disk Write',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Agent DIsk Read vs Media Agent Disk Write' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
    --Media Agent Data Transferred
    SET @browserURLField = '?viewId=1&amp;TemplateName=%22Stream%20Writer%20Statistics%22%2C%22Stream%20Reader%20Statistics%22&amp;fieldList=TemplateName&amp;keyWord=select%20eventTime%2C%20totalbytesrecieved%2C%20totalbytessent&amp;startTime=NOW-1DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=86400000&amp;gap=1HOUR&amp;isAllTime=false&amp;dataView=tableView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
    SET @solrQueryField = ''
    SET @searchLabelField = ''
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '6' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Data Transferred' AND monitoringAppType = '2' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Media Agent Data Transferred',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'2')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Media Agent Data Transferred' AND monitoringAppType = '2' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--APP_SMCreatePreCookedDashboards
	end
	else
	begin
	--App_LMCreateAuditEventDashboard.script
	set @DashBoardName = 'Audit and Event Dashboard'
	--creating dashboard
        IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName)
        BEGIN
            SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName)
        END
        ELSE
        BEGIN
            -- status = 4 indicates the default dasboard
            INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType)
                VALUES(@DashBoardName,1,1,4,@curUtcDateTime,0,1)
            SET @dashboardId = @@IDENTITY
        END
	--Event Viewer and Webconsole Audit events
	--creating searches
	SET @browserURLField = '?viewId=1&amp;MonitoringPolicyName=%22Gui%20Audit%20Trail%20Policy%22%2C%22Gui%20Event%20Viewer%20Policy%22%2C%22WebConsole%20Audit%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100" trendBrowserURL="?viewId=1&amp;MonitoringPolicyName=%22Gui%20Audit%20Trail%20Policy%22%2C%22Gui%20Event%20Viewer%20Policy%22%2C%22WebConsole%20Audit%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=graphtype%20compare&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=linear&amp;compareScale=1&amp;rows=100'
	SET @solrQueryField = 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A1%29&amp;fq=%28MonitoringPolicyName%3A%22Gui+Audit+Trail+Policy%22+OR+MonitoringPolicyName%3A%22Gui+Event+Viewer+Policy%22+OR+MonitoringPolicyName%3A%22WebConsole+Audit+Policy%22%29&amp;fq=%28eventTime:[NOW-30DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc'
	SET @searchLabelField = 'Search Info&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;Gui Audit Trail Policy,Gui Event Viewer Policy,WebConsole Audit Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;'
SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '2' + '" searchType="0" browserURL="' + @browserURLField + '" solrQuery="' + @solrQueryField + '" searchLabel="' + @searchLabelField + '" isImplicitSearch="0" />'     SET @searchUrlXml = CONVERT(XML,@searchUrl)     IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Event Viewer and Webconsole Audit events' AND monitoringAppType = '1' AND creatorUserId = 1)     BEGIN         INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType)         VALUES('Event Viewer and Webconsole Audit events',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,'1')         SET @searchId = @@IDENTITY         INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)     END     ELSE     BEGIN         SET @searchId = (SELECT TOP 1 searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Event Viewer and Webconsole Audit events' AND monitoringAppType = '1' AND creatorUserId = 1)          IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId)         BEGIN             INSERT INTO lmdashsearchAssoc(dashBoardId,searchId)             VALUES(@dashboardId,@searchId)             UPDATE LMUserSearch             SET status =  status | 4             WHERE searchId = @searchId         END     END
	--App_LMCreateAuditEventDashboard.script
	--F5 Dashboard
	exec QS_LMCreateF5DashBoardAndSearch
	--F5 Dashboard
	--Operation Dashboard
	if(@hasOpDashboard = 1)
		exec QS_LMCreateDefaultDashBoardAndSearch
	--Operation Dashboard
	end
	set @errorMessage = ''
	end
	else
	begin
		set @errorCode = 2 -- indicates user permission error
		set @errorMessage = 'User does not have permission to perform this operation.'
	end
	SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
	COMMIT TRANSACTION RestoreToPrecookedDashboard
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION RestoreToPrecookedDashboard
	set @errorMessage= ERROR_MESSAGE()
	set @errorCode = ERROR_NUMBER()
    SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'LMRestoreToPrecookedDashboard')
	delete from GxQscripts where name = 'LMRestoreToPrecookedDashboard'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMRestoreToPrecookedDashboard')
	delete from GXDBVersions where aliasname = 'LMRestoreToPrecookedDashboard'
GO

insert into GXDBVersions values(2, 'LMRestoreToPrecookedDashboard',  '00010001000200120000', 'LMRestoreToPrecookedDashboard', '00010001000200120000')
GO

