

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMPruneFileTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMPruneFileTable.sp,v $ $Id: LMPruneFileTable.sp,v 1.3 2014/03/13 11:07:59 saggarwal Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMPruneFileTable <<<'

IF EXISTS (select * from sysobjects where name='LMPruneFileTable')
	drop procedure LMPruneFileTable
IF EXISTS (select * from GxQscripts where name='LMPruneFileTable')
	delete from GxQscripts where name = 'LMPruneFileTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPruneFileTable')
	delete from GXDBVersions where aliasname = 'LMPruneFileTable'
GO
print '... Creating Procedure: LMPruneFileTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMPruneFileTable
AS
DECLARE @duplicateFilePathTbl table
(
      clientid int,
      monitorPolicyId int,
      filePath nvarchar(1024)COLLATE  SQL_Latin1_General_CP1_CS_AS
)
DECLARE @duplicateFilePathFileIdTbl table
(   clientid int,
      monitorPolicyId int,
      filePath nvarchar(1024)COLLATE  SQL_Latin1_General_CP1_CS_AS,
      clientFileId int
)
DECLARE @duplicateMaxFileIdTbl table
(   clientid int,
      monitorPolicyId int,
      filePath nvarchar(1024)COLLATE  SQL_Latin1_General_CP1_CS_AS,
      clientFileId int
)
delete S from SRM..SRMLMFiles S JOIN APP_MonitoringPolicy M on M.monitorPolicyId=S.monitorPolicyId
WHERE M.status=3
-- Rolled over files
insert into @duplicateFilePathTbl
select clientId,monitorPolicyId,filePath from SRM..SRMLMFiles group by clientId,monitorPolicyId,filePath having count(*)>1 OPTION (recompile)
-- Rolled over files'clientfileids
insert into @duplicateFilePathFileIdTbl
select S.clientId,S.monitorPolicyId,S.filePath,S.clientFileId from SRM..SRMLMFiles as S inner join @duplicateFilePathTbl as T on S.clientId=T.clientid and S.monitorPolicyId=T.monitorPolicyId and S.filePath = T.filePath  OPTION (recompile)
-- Latest among rolled over files.
insert into @duplicateMaxFileIdTbl
select clientId,monitorPolicyId,filePath,MAX(clientFileId) from SRM..SRMLMFiles group by clientId,monitorPolicyId,filePath having count(*)>1 OPTION (recompile)
--we need to keep latest version of rolled over files even if there's no corresponding data in lines table
delete from @duplicateFilePathFileIdTbl
from @duplicateFilePathFileIdTbl T1 Join @duplicateMaxFileIdTbl T2 on T1.clientid = T2.clientid and T1.monitorPolicyId = T2.monitorPolicyId and T1.filePath = T2.filePath and T1.clientFileId = T2.clientFileId OPTION (recompile)
-- we need to keep old versions for which we still have data in lines table
delete from @duplicateFilePathFileIdTbl
from @duplicateFilePathFileIdTbl as T Join SRM..SRMLMLines AS S with(nolock)  ON T.clientFileId = S.clientFileId and T.clientid = S.clientId and T.monitorPolicyId = S.monitorPolicyId OPTION (recompile)
--now delete rolled over duplicates from srmlmfiles
delete S
from SRM..SRMLMFiles as S Join @duplicateFilePathFileIdTbl AS T on S.clientFileId = T.clientFileId and S.clientId = T.clientid and S.filePath = T.filePath and S.monitorPolicyId = T.monitorPolicyId OPTION (recompile)
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'LMPruneFileTable')
	delete from GxQscripts where name = 'LMPruneFileTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPruneFileTable')
	delete from GXDBVersions where aliasname = 'LMPruneFileTable'
GO

insert into GXDBVersions values(2, 'LMPruneFileTable',  '00010003000000000000', 'LMPruneFileTable', '00010003000000000000')
GO

