

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMPopulateTemplateInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMPopulateTemplateInfo.sp,v $ $Id: LMPopulateTemplateInfo.sp,v 1.5.2.2 2018/03/27 09:18:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMPopulateTemplateInfo <<<'

IF EXISTS (select * from sysobjects where name='LMPopulateTemplateInfo')
	drop procedure LMPopulateTemplateInfo
IF EXISTS (select * from GxQscripts where name='LMPopulateTemplateInfo')
	delete from GxQscripts where name = 'LMPopulateTemplateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateTemplateInfo')
	delete from GXDBVersions where aliasname = 'LMPopulateTemplateInfo'
GO
print '... Creating Procedure: LMPopulateTemplateInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMPopulateTemplateInfo
  @userId int,
  @inputXml xml,
  @outputXml xml OUTPUT
AS
	Set transaction isolation level read uncommitted
	declare @templateId integer = 0
	declare @templateName nvarchar(max)
	declare @templateXml nvarchar(max)
	declare @description nvarchar(max)
	declare @templateForMonitoringType integer
	declare @status integer
	declare @hashedDescription nvarchar(max)
	declare @numberOfRowsMatching int
	-- SET XACT_ABORT ON
	BEGIN TRY
		--BEGIN TRANSACTION LMTemplateTran
			set @templateName = isnull((select ref.value('@templateName','nvarchar(max)') from @inputXml.nodes('LogMonitoring_LMTemplateOperationReq/lmTemplate/LMTemplateEntity') as R(ref)),'')
			select  @templateXml = 	isnull( ref.value('@LMTemplateXML','nvarchar(max)') , '</LogMonitoring_TemplateXML>'),
					@description = 	isnull(ref.value('@description','nvarchar(max)'),''),
					@templateForMonitoringType =  isnull(ref.value('@templateForMonitoringType','integer'),0) ,
					@status = 	isnull(ref.value('@status','integer'),2)
			from @inputXml.nodes('LogMonitoring_LMTemplateOperationReq/lmTemplate') as R(ref)
			-- Do md5 hashing for description(combination of all columns)
			set @description = LTRIM(RTRIM(@description))
			set @hashedDescription = master.dbo.fn_varbintohexstr(HashBytes('MD5', @description))
			set @templateName = LTRIM(RTRIM(@templateName))
			--set @templateName = @templateName
			if not exists (select 1 from APP_Template where templateDescription = @hashedDescription)
			begin
					set @numberOfRowsMatching = (select count(*) from APP_Template where CHARINDEX(@templateName,templateName) > 0)
					if(@numberOfRowsMatching > 0)
					begin
						set @templateName = (@templateName + '_' + convert(nvarchar(max) , @numberOfRowsMatching))
					end
					insert into APP_Template(commcellId , templateName , templateXML , templateDescription , created , modified, templateForMonitoringType , status)
					values( 2 , @templateName , @templateXml , @hashedDescription , dbo.GetUnixTime(GETUTCDATE()) , 0 , @templateForMonitoringType , @status )
					set @templateId = @@IDENTITY
			end
			else
			begin
					set @templateId = isnull( (select templateid from APP_Template where templateDescription = @hashedDescription) , 0 )
					set @templateName = (select templatename from APP_Template where templateId = @templateId)
					update APP_Template
					set templateXML = @templateXml , created = dbo.GetUnixTime(GETUTCDATE())
					where templateid = @templateId
			end
		--COMMIT TRANSACTION LMTemplateTran
		--set @templateName = (  isnull( (select templateName from APP_Template where templateId = @templateId) , 'Template Already Exists') )
		set @outputXml =	(
								select @templateId as 'LMTemplates/LMTemplateEntity/@templateId' , @templateName as 'LMTemplates/LMTemplateEntity/@templateName'
								for xml path('LogMonitoring_GetListOfTemplatesResp')
							)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		--ROLLBACK TRANSACTION LMTemplateTran
		set @outputXml =	(
								select -1 as 'LMTemplates/LMTemplateEntity/@templateId'
								for xml path('LogMonitoring_GetListOfTemplatesResp')
							)
	END CATCH
	select @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMPopulateTemplateInfo')
	delete from GxQscripts where name = 'LMPopulateTemplateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateTemplateInfo')
	delete from GXDBVersions where aliasname = 'LMPopulateTemplateInfo'
GO

insert into GXDBVersions values(2, 'LMPopulateTemplateInfo',  '00010005000200020000', 'LMPopulateTemplateInfo', '00010005000200020000')
GO

