

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMPopulateTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMPopulateTemplate.sp,v $ $Id: LMPopulateTemplate.sp,v 1.8.34.3 2019/10/08 23:02:19 vdevassy Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMPopulateTemplate')
BEGIN
	print '>>> Drop Stored Procedure: LMPopulateTemplate <<<'
	drop procedure LMPopulateTemplate
END
IF EXISTS (select * from GxQscripts where name='LMPopulateTemplate')
	delete from GxQscripts where name = 'LMPopulateTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateTemplate')
	delete from GXDBVersions where aliasname = 'LMPopulateTemplate'
GO
print '... Creating Procedure: LMPopulateTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMPopulateTemplate
  @i_xml XML 
AS
  DECLARE @xmlStr xml
SET NOCOUNT ON
SET NOCOUNT ON
--Add the templates name here
DECLARE @TemplateNameTable TABLE(spName NVARCHAR(1024),templateName NVARCHAR(1024),Description NVARCHAR(1024))
INSERT INTO @TemplateNameTable VALUES('LMGetAlertDataSetForCI','Alert','Template used for indexing Alert data')
INSERT INTO @TemplateNameTable VALUES('LMGetGUIAuditDataSetForCI','Audit Trail','Template used for indexing Audit Trail data')
INSERT INTO @TemplateNameTable VALUES('LMGetEventViewerDataSetForCI','Event Viewer','Template used for indexing Event Viewer data')
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID('#TokenList'))         DROP TABLE #TokenList
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID('#TokenList1'))         DROP TABLE #TokenList1
CREATE TABLE #TokenList
(
	id INTEGER IDENTITY(0,1),
	TokenId INTEGER,
	TokenValue NVARCHAR(1024),
	ColumnName NVARCHAR(1024),
	FieldName NVARCHAR(1024),
	DataType INTEGER,
	primaryTypeFormat INTEGER DEFAULT 0,
	dataFormat NVARCHAR(128) DEFAULT NULL,
	isFacet INTEGER,
	showAsColumn INTEGER DEFAULT 1,
	supportedOpTypes XML
)
CREATE TABLE #TokenList1
(
	id INTEGER IDENTITY(0,1),
	TokenId INTEGER,
	TokenValue NVARCHAR(1024),
	ColumnName NVARCHAR(1024),
	FieldName NVARCHAR(1024),
	DataType INTEGER,
	primaryTypeFormat INTEGER DEFAULT 0,
	dataFormat NVARCHAR(128) DEFAULT NULL,
	isFacet INTEGER,
	showAsColumn INTEGER DEFAULT 1,
	supportedOpTypes XML
)
BEGIN TRY
BEGIN TRANSACTION
		DECLARE @storedProcedure NVARCHAR(1024)
		DECLARE @templateName NVARCHAR(1024)
		DECLARE @templateType INTEGER = 5
		DECLARE @commcellId INTEGER = 2
		DECLARE @description NVARCHAR(2048)
		DECLARE @status INTEGER = 0
		DECLARE @now INTEGER = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @templeteId INTEGER
IF ( CURSOR_STATUS('global', 'lmtemplateCur') >= 0 OR CURSOR_STATUS('local', 'lmtemplateCur') >= 0 ) CLOSE lmtemplateCur IF ( CURSOR_STATUS('global','lmtemplateCur') = -1 OR CURSOR_STATUS('local','lmtemplateCur') = -1 )														DEALLOCATE lmtemplateCur
		DECLARE lmtemplateCur CURSOR FOR
		SELECT spName,templateName,Description FROM @TemplateNameTable
		OPEN lmtemplateCur
		FETCH NEXT FROM lmtemplateCur INTO @storedProcedure,@templateName,@description
		WHILE @@FETCH_STATUS = 0
		BEGIN
			TRUNCATE TABLE #TokenList
			TRUNCATE TABLE #TokenList1
		--Alert Template
			IF(@templateName = 'Alert')
			BEGIN
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Alert ID','','alertid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'NTNotificationID','','notificationid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'EscalationLevel','','escalationlevel',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Detected Date','','alertdate',2,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Detected Time','','alerttime',3,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Severity','','alertseverity',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'JobId','','jobid',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'CommCell ID','','commcellid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'CommCell','','commcellname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Client ID','','clientid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Client','','clientname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Name','','alertname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Type','','alerttype',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Alert Criteria','','alertcriteria',1,1)
				INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)
				SELECT MessageID,Message,'','',1,0,0 FROM EvLocaleMsgs WHERE MessageID IN
				(select tokenID from NTmessageTokensForAlert) AND LocaleID = 0 AND (Message NOT LIKE '%/%' AND Message NOT LIKE '%-%') ORDER BY MessageID
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,primaryTypeFormat,isFacet)  VALUES(0,'Alert Description','','alertdescription',1,22,0)
UPDATE #TokenList SET ColumnName = TokenValue WHERE TokenId = 0 UPDATE #TokenList SET ColumnName = RTRIM(LTRIM(LOWER(TokenValue))) WHERE TokenId <> 0 UPDATE #TokenList SET ColumnName = LTRIM(REPLACE(ColumnName,'<','')) WHERE TokenId <> 0 UPDATE #TokenList SET ColumnName = RTRIM(REPLACE(ColumnName,'>','')) WHERE TokenId <> 0 UPDATE #TokenList SET ColumnName = dbo.ProperCase(ColumnName) WHERE TokenId <> 0 UPDATE #TokenList SET FieldName = RTRIM(LTRIM(LOWER(TokenValue))) WHERE TokenId <> 0 UPDATE #TokenList SET FieldName = LTRIM(REPLACE(FieldName,'<','')) WHERE TokenId <> 0 UPDATE #TokenList SET FieldName = RTRIM(REPLACE(FieldName,'>','')) WHERE TokenId <> 0 UPDATE #TokenList SET FieldName = RTRIM(REPLACE(FieldName,' ','_')) WHERE TokenId <> 0		UPDATE #TokenList SET FieldName = 'alert_'+FieldName WHERE TokenId <> 0
			END
		--Event Template
			ELSE IF (@templateName = 'Event Viewer')
			BEGIN
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Event ID','Event ID','eventid',0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Occurrence Date','Occurrence Date','occurrencedate',2,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Occurrence Time','Occurrence Time','occurrencetime',3,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Event Severity','Event Severity','eventseverity',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'JobId','JobId','jobid',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'CommCell ID','CommCell ID','commcellid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'CommCell','CommCell','commcellname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Client ID','Client ID','clientid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Computer','Computer','computer',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Event Code','Event Code','eventcode',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'User ID','User ID','userid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'User','User','username',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Library ID','Library ID','libraryid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Library','Library','libraryname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Media Agent ID','Media Agent ID','maid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Media Agent','Media Agent','maname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Media Id','Media Id','mediaid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Media','Media','medianame',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Drive Id','Drive Id','driveid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Drive','Drive','drivename',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Program','Program','program',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,primaryTypeFormat,isFacet)  VALUES(0,'Description','Description','description',1,22,0)
			END
		--GUI Audit Template
			ELSE IF (@templateName = 'Audit Trail')
			BEGIN
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Audit ID','Audit ID','opid',0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Audit Date','Audit Date','auditdate',2,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Audit Time','Audit Time','audittime',3,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Audit Severity','Audit Severity','severitylevel',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'CommCell ID','CommCell ID','commcellid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'CommCell','CommCell','commcellname',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'User ID','User ID','userid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'User','User','username',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet,showAsColumn)	VALUES(0,'Locale  ID','Locale  ID','localeid',0,0,0)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,isFacet)	VALUES(0,'Operation','Operation','operation',1,1)
INSERT INTO #TokenList(TokenId,TokenValue,ColumnName,FieldName,DataType,primaryTypeFormat,isFacet)  VALUES(0,'Details','Details','details',1,22,0)
			END
			UPDATE #TokenList SET primaryTypeFormat = (CASE DataType WHEN 0 THEN 0 WHEN 2 THEN 9 WHEN 3 THEN 17 WHEN 1 THEN 21 END)
			UPDATE #TokenList SET dataFormat = 'DD-MM-YYYY' WHERE DataType = 2
			UPDATE #TokenList SET dataFormat = 'HH:MM:SS'  WHERE DataType = 3
			UPDATE #TokenList SET supportedOpTypes = (CASE DataType WHEN 0 THEN '<supportedOpTypes val="0"/>
				<supportedOpTypes val="1"/>
				<supportedOpTypes val="4"/>
				<supportedOpTypes val="5"/>
				<supportedOpTypes val="6"/>
				<supportedOpTypes val="7"/>
				<supportedOpTypes val="8"/>' WHEN 2 THEN  '<supportedOpTypes val="0"/>
				<supportedOpTypes val="1"/>
				<supportedOpTypes val="4"/>
				<supportedOpTypes val="5"/>
				<supportedOpTypes val="6"/>
				<supportedOpTypes val="7"/>
				<supportedOpTypes val="8"/>' WHEN 3 THEN ' <supportedOpTypes val="0"/>
				<supportedOpTypes val="1"/>
				<supportedOpTypes val="4"/>
				<supportedOpTypes val="5"/>
				<supportedOpTypes val="6"/>
				<supportedOpTypes val="7"/>' WHEN 1 THEN ' <supportedOpTypes val="2"/>
				<supportedOpTypes val="3"/>
				<supportedOpTypes val="0"/>
				<supportedOpTypes val="1"/>' ELSE '<supportedOpTypes val="2"/>
				<supportedOpTypes val="3"/>
				<supportedOpTypes val="0"/>
				<supportedOpTypes val="1"/>' END)
			IF EXISTS (SELECT 1 FROM APP_Template WHERE templateName = @templateName and templateForMonitoringType = @templateType)
			BEGIN
			   SET @templeteId = (SELECT templateId FROM APP_Template WHERE templateName = @templateName and templateForMonitoringType = @templateType)
			END
			ELSE
			BEGIN
				INSERT INTO APP_Template
				VALUES(@commcellId,@templateName,'',@description,@now,0,@templateType,@status)
				SET @templeteId = (SELECT templateId FROM APP_Template WHERE templateName = @templateName and templateForMonitoringType = @templateType)
			END
			DELETE FROM APP_TemplateColumn WHERE templateId = @templeteId
			DELETE  FROM #TokenList WHERE id NOT IN(SELECT MIN(id)  FROM #TokenList GROUP BY ColumnName)
			INSERT INTO #TokenList1(TokenId ,TokenValue ,ColumnName ,FieldName,DataType,primaryTypeFormat,dataFormat,isFacet,supportedOpTypes,showAsColumn)
			SELECT TokenId ,TokenValue ,ColumnName ,FieldName,DataType,primaryTypeFormat,dataFormat,isFacet,supportedOpTypes,showAsColumn FROM #TokenList ORDER BY id
			INSERT INTO APP_TemplateColumn
			SELECT @commcellId,@templeteId,ColumnName FROM #TokenList1 ORDER BY id
			DECLARE @tempColXML XML = (SELECT token.id as '@index',
					1 as '@isIndexed',
					1 as '@isStored',
					token.FieldName as '@solrFieldName',
					token.isFacet as '@isFacet',
					token.showAsColumn as '@showAsColumn',
					token.DataType as '@primaryDataType',
					token.primaryTypeFormat  as '@primaryTypeFormat',
					token.dataFormat as '@format',
					87 as 'column/@_type_',
					tempCol.columnId as 'column/@columnId',
					tempCol.columnName as 'column/@columnName',
					token.supportedOpTypes as 'node()'
			FROM APP_TemplateColumn tempCol INNER JOIN #TokenList1 token
			ON tempCol.columnName = token.ColumnName AND tempCol.templateId = @templeteId
			ORDER BY id
			FOR XML PATH('columns'))
			DECLARE @templateXML XML= (SELECT
					@storedProcedure as '@defaultContent',
					5 as '@templateForMonitoringType',
					@tempColXML as 'node()'
					FOR XML PATH('LogMonitoring_TemplateXML'))
			UPDATE APP_Template SET templateXML = CONVERT(nvarchar(max),@templateXML)
			WHERE templateName = @templateName and templateForMonitoringType = @templateType
			FETCH NEXT FROM lmtemplateCur INTO @storedProcedure,@templateName,@description
		END
IF ( CURSOR_STATUS('global', 'lmtemplateCur') >= 0 OR CURSOR_STATUS('local', 'lmtemplateCur') >= 0 ) CLOSE lmtemplateCur IF ( CURSOR_STATUS('global','lmtemplateCur') = -1 OR CURSOR_STATUS('local','lmtemplateCur') = -1 )														DEALLOCATE lmtemplateCur
--Enble CI for all alerts
MERGE NTmessageFormat msgFOrmat
USING (SELECT distinct ntrule.id,msgFOrmat1.escalationLevel,notificationName,ntrule.notifType,131072 as messagetype, ntTemplate.defaultformatstring as formatString,'' as formattedMessage,'' as formatstringhtml
              FROM NTnotificationRule ntrule
              INNER JOIN NTnotificationTemplate ntTemplate ON ntrule.alertTypeId = ntTemplate.NTalertTypeID AND ntTemplate.messageType = 131072 AND ntTemplate.locale = 0
                     INNER JOIN NTmessageFormat msgFOrmat1
                           ON msgFOrmat1.NTNotificationID = ntrule.id AND ntTemplate.messageFormatType = 0 AND (ntrule.notifType & msgFOrmat1.messageType) = msgFOrmat1.messageType) ntf
ON msgFOrmat.NTNotificationID = ntf.id AND ntf.escalationLevel = msgFOrmat.escalationLevel AND msgFOrmat.messageType = 131072
WHEN NOT MATCHED THEN
INSERT (NTNotificationID,messageType,escalationLevel,formatString,formattedMessage,SubJFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,baseDir,userName,password,rssID,messageFormatType,formatStringHtml,attachmentPath,attachmentName)
VALUES(ntf.id,131072,ntf.escalationLevel,ntf.formatString,ntf.formattedMessage,0,0,0,0,0,NULL,NULL,NULL,NULL,0,ntf.formatStringHtml,NULL,NULL);
UPDATE NTnotificationRule
SET notifType = notifType | 131072
WHERE id IN(SELECT NTnotificationID FROM NTmessageFormat WHERE messageType = 131072)
UPDATE NTmessageTokensForAlert
SET flag = flag | 131072
WHERE (flag|8192) <> 0
COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
ROLLBACK TRANSACTION
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'LMPopulateTemplate')
	delete from GxQscripts where name = 'LMPopulateTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateTemplate')
	delete from GXDBVersions where aliasname = 'LMPopulateTemplate'
GO

insert into GXDBVersions values(2, 'LMPopulateTemplate',  '00010008003400030000', 'LMPopulateTemplate', '00010008003400030000')
GO

