

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMPopulateSizeOfIndexedData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMPopulateSizeOfIndexedData.sp,v $ $Id: LMPopulateSizeOfIndexedData.sp,v 1.2.2.6 2020/01/23 11:29:12 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMPopulateSizeOfIndexedData')
BEGIN
	print '>>> Drop Stored Procedure: LMPopulateSizeOfIndexedData <<<'
	drop procedure LMPopulateSizeOfIndexedData
END
IF EXISTS (select * from GxQscripts where name='LMPopulateSizeOfIndexedData')
	delete from GxQscripts where name = 'LMPopulateSizeOfIndexedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateSizeOfIndexedData')
	delete from GXDBVersions where aliasname = 'LMPopulateSizeOfIndexedData'
GO
print '... Creating Procedure: LMPopulateSizeOfIndexedData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMPopulateSizeOfIndexedData
  @fileSize BIGINT,
  @mpId int,
  @skipOutPut INTEGER = 0
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
Set transaction isolation level read uncommitted
SET @errorCode = 0
SET @errorMsg = ''
-- DECLARE @o_errorCode integer;
--Below code used to update size of indexed data for each day based on monitoringPolicy
--The 60 days older rows will be pruned
--attrName = 'size' indicates the size of indexed data based on the monitoringPolicy for each day.
DECLARE @nowTime INTEGER = dbo.GEtUnixTime(GetUTCdate())
DECLARE @midNightDate DATETIME
SET @midNightDate = ( SELECT Convert(DATETIME, DATEDIFF(DAY, 0, GETUTCDATE())))
DECLARE @midNightEpochDate BIGINT
SET @midNightEpochDate = DBO.GetUnixTime(@midNightDate)
BEGIN TRY
	IF @fileSize > 0
	BEGIN
		DECLARE @attrName NVARCHAR(max) = 'size_'+ CONVERT(nvarchar(max),@midNightEpochDate)
		MERGE APP_MonitoringPolicyProp as mpprop
		USING (SELECT @mpId as mpid,@fileSize as Size,@nowTime as nowTime ) as inputVals
			ON mpprop.monitorPolicyId = inputVals.mpid AND mpprop.attrName = @attrName
		WHEN MATCHED
			THEN UPDATE SET mpprop.attrVal =CONVERT(BIGINT, mpprop.attrVal) + inputVals.Size,mpprop.modified = inputVals.nowTime
		WHEN NOT MATCHED
			THEN INSERT(monitorPolicyId,commcellId,attrName,attrType,attrVal,created,modified)
					VALUES(inputVals.mpid,2,@attrName,7,inputVals.Size, inputVals.nowTime, inputVals.nowTime);
	END
END TRY
BEGIN CATCH
	SET @errorCode = ERROR_NUMBER()
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
IF @skipOutPut = 0
	SELECT @errorCode,@errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'LMPopulateSizeOfIndexedData')
	delete from GxQscripts where name = 'LMPopulateSizeOfIndexedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateSizeOfIndexedData')
	delete from GXDBVersions where aliasname = 'LMPopulateSizeOfIndexedData'
GO

insert into GXDBVersions values(2, 'LMPopulateSizeOfIndexedData',  '00010002000200060000', 'LMPopulateSizeOfIndexedData', '00010002000200060000')
GO

