

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMPopulateSharedEntityInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMPopulateSharedEntityInfo.sp,v $ $Id: LMPopulateSharedEntityInfo.sp,v 1.5.2.11 2018/03/27 08:51:46 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMPopulateSharedEntityInfo <<<'

IF EXISTS (select * from sysobjects where name='LMPopulateSharedEntityInfo')
	drop procedure LMPopulateSharedEntityInfo
IF EXISTS (select * from GxQscripts where name='LMPopulateSharedEntityInfo')
	delete from GxQscripts where name = 'LMPopulateSharedEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateSharedEntityInfo')
	delete from GXDBVersions where aliasname = 'LMPopulateSharedEntityInfo'
GO
print '... Creating Procedure: LMPopulateSharedEntityInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMPopulateSharedEntityInfo
  @userId int,
  @inputXml xml,
  @outputXml xml OUTPUT
AS
	Set transaction isolation level read uncommitted
	declare @OriginalEntityId int ,@operation int
	declare @sharedId int
	declare @errorCode int= 0
	declare @err_message nvarchar(max)
	declare @creatorUserId int
	declare @shareInfoList xml
	declare @origSharedEntityAssocList table
	(
		userId int,
		groupId int,
		providerId int
	)
	declare @spResult table
	(
		errorCode int,
		errorString nvarchar(max)
	)
	declare @message nvarchar(max) = ''
	declare @rootNode nvarchar(max)
	DECLARE @shareType INT = 0
	SET @outputXml  = '<LogMonitoring_SharedEntityInfo/>'
	BEGIN TRY
	BEGIN TRANSACTION LMSharedEntityInfoTran
	--security check...
	SET @rootNode = @inputXml.value('local-name(/*[1])','nvarchar(max)')
	IF (patindex('%CreateSharedEntityReq%',@rootNode)>0)
	BEGIN
		SET @operation = 1
		SET @OriginalEntityId =  ( select ref.value('@originalEntityId','INT') from @inputXml.nodes('LogMonitoring_CreateSharedEntityReq/sharedEntity') as R(ref))
		SET @shareType =  ISNULL((select ref.value('@sharetype','INT') from @inputXml.nodes('LogMonitoring_CreateSharedEntityReq/sharedEntity') as R(ref)) , 0)
	END
	ELSE IF(patindex('%ModifySharedEntityReq%',@rootNode)>0)
	BEGIN
		set @operation = 2
		set @OriginalEntityId =  ( select ref.value('@originalEntityId','INT') from @inputXml.nodes('LogMonitoring_ModifySharedEntityReq/sharedEntity') as R(ref))
		SET @shareType =  ISNULL((select ref.value('@sharetype','INT') from @inputXml.nodes('LogMonitoring_ModifySharedEntityReq/sharedEntity') as R(ref)) , 0)
		SET @creatorUserId = (select creatorUserId from LMUserSearch where searchId = @OriginalEntityId)
	END
	ELSE IF(patindex('%DeleteSharedEntityReq%',@rootNode)>0)
	BEGIN
		set @operation = 3
		--set @OriginalEntityId =  ( select ref.value('@originalEntityId','INT') from @inputXml.nodes('LogMonitoring_DeleteSharedEntityReq/sharedEntity') as R(ref))
		--SET @shareType =  ISNULL((select ref.value('@sharetype','INT') from @inputXml.nodes('LogMonitoring_DeleteSharedEntityReq/sharedEntity') as R(ref)) , 134)
		SET @sharedId = (SELECT ref.value('@sharedEntityId','INT') FROM @inputXml.nodes('LogMonitoring_DeleteSharedEntityReq/sharedEntityId') AS R(ref))
		SET @shareType = ISNULL((SELECT TOP 1 SharedEntityType FROM App_SharedEntityInfo WHERE SharedEntityId = @sharedId),0)
		IF @shareType = 0
		BEGIN
			SET @err_message = 'Invalid Operation'
			goto ERROR_EXIT
		END
		SET @OriginalEntityId = ISNULL((SELECT TOP 1 OriginalEntityId FROM App_SharedEntityInfo WHERE SharedEntityId = @sharedId),0)
	END
	ELSE IF(CHARINDEX('UnShareSharedEntityReq',@rootNode)>0)
	BEGIN
		SET @operation = 4
		-- user unsharing himself ..
		DECLARE @shareId INT
		DECLARE @SecurityAssociationToUnShare_Xml xml = (select 3 as '@associationsOperationType',
																0 as 'associations/properties/@isCreatorAssociation',
216 as 'associations/properties/categoryPermission/categoriesPermissionList/@permissionId',
'Search Share' as 'associations/properties/categoryPermission/categoriesPermissionList/@permissionName',
																107 as 'associations/properties/categoryPermission/categoriesPermissionList/@categoryId',
																122 as 'associations/properties/categoryPermission/categoriesPermissionList/@_type_'
														for xml path('App_SecurityAssociationForEntityList')
														)
		DECLARE @userIdXml xml = ISNULL((
			select @userId as '@userId'
			for xml path('userOrGroup') ),'')
		--Need to append userId xml inside security xml.
		SET @SecurityAssociationToUnShare_Xml.modify( ' insert sql:variable("@userIdXml") into (/App_SecurityAssociationForEntityList/associations)[1] ')
		DECLARE @sharedentityIdsToUnshare TABLE
			(
				sharedId INT
			)
		DECLARE @searchEntitiesToUnshare TABLE(searchId INT)
		INSERT INTO @searchEntitiesToUnshare
		SELECT ISNULL(Tbl.Col.value('@searchId', 'INT'),0) FROM
		@inputXml.nodes('/LogMonitoring_UnShareSharedEntityReq/searchList') AS Tbl(Col)
		INSERT INTO @sharedentityIdsToUnshare
		SELECT shareTbl.SharedEntityId
		FROM App_SharedEntityInfo shareTbl WITH(NOLOCK)
		INNER JOIN @searchEntitiesToUnshare searchTbl
ON searchTbl.searchId = shareTbl.OriginalEntityId and SharedEntityType = 134
		INSERT INTO @sharedentityIdsToUnshare
		SELECT ISNULL(Tbl.Col.value('@sharedEntityId', 'INT'),0) FROM
		@inputXml.nodes('/LogMonitoring_UnShareSharedEntityReq/sharedEntityId') AS Tbl(Col)
		set  @shareId = (select top 1 sharedId from @sharedentityIdsToUnshare)
		INSERT INTO @spResult
		EXEC sec_setSecurityAssociationsFromEntity @SecurityAssociationToUnShare_Xml, @userId, 0, 1,9674, @shareId, 0, 0, 0, 0, 0, 0, 0, 0
		SET @errorCode = ISNULL((select top 1 errorCode from @spResult),0)
		SET @err_message = ISNULL((select top 1 errorString from @spResult),'')
	END
	ELSE
	BEGIN
			---Invalid operation
			SET @err_message = 'Invalid Operation'
			goto ERROR_EXIT
	END
	-- IF it is create or modify operation, creatorUserId will be needed.
	IF @operation = 1 OR @operation = 2 OR @operation = 3
	BEGIN
		IF @shareType = 134 -- SEARCH
		BEGIN
			SET @creatorUserId = (select creatorUserId from LMUserSearch where searchId = @OriginalEntityId)
		END
		ELSE IF @shareType = 137 -- DASHBOARD
		BEGIN
			SET @creatorUserId = (select creatorUserId from LMDashBoard where dashBoardId = @OriginalEntityId)
		END
		ELSE
		BEGIN
			---Invalid operation
			SET @err_message = 'Invalid ShareType'
			goto ERROR_EXIT
		END
		if @creatorUserId <> @userId
		begin
			IF object_id('tempdb.dbo.#searchListTmp') is not null
			DROP TABLE #searchListTmp
create table  #searchListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
			exec dbo.sec_getuserObjects @userId, 2018, 2, '#searchListTmp'
			DECLARE @capabiliesWant  int
			declare @userHasRight int
			set @userHasRight = 0
set @capabiliesWant = POWER(2, (1-1))
			if exists(select 1 from #searchListTmp sec WHERE (capabilities & @capabiliesWant) <> 0 and
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
			begin
				set @userHasRight = 1
			end
			if @userHasRight = 0
			begin
				SET @errorCode = 6
				set @err_message = 'User have no permission to make share operation'
				RAISERROR (@err_message, -- Message text.
									16, -- Severity.
										1 -- State.
							);
				goto ERROR_EXIT
			end
		end
	END
		-- 1 = Create Operation
		-- 2 = Modify Operation
		-- 3 = Delete Operation
		if (@operation = 1)
		begin
			set @message = ( select ref.value('@message','nvarchar(max)') from @inputXml.nodes('LogMonitoring_CreateSharedEntityReq/sharedEntity') as R(ref))
			IF EXISTS(select 1 from App_SharedEntityInfo where OriginalEntityId = @OriginalEntityId AND SharedEntityType = @shareType)
			BEGIN
				--error  condition duplicate name.
				SET @err_message = 'share already Exists'
				RAISERROR (@err_message, 16,1)
				goto ERROR_EXIT
			END
			declare @monitoringPolicy xml
			set @monitoringPolicy = isnull ((
											 select t.c.query('sharedPolicies')
											 from @inputXml.nodes('LogMonitoring_CreateSharedEntityReq/sharedEntity') t(c)
											 for xml path('') , root('monitoringPolicy')
											 ) ,
											 '<monitoringPolicy />'
											)
			insert into App_SharedEntityInfo(sharedentityType,originalEntityId,MonitoringPolices)
			select  ref.value('@sharetype','INT') , ref.value('@originalEntityId','INT') , @monitoringPolicy
			from @inputXml.nodes('LogMonitoring_CreateSharedEntityReq/sharedEntity') as R(ref)
			select @sharedId = @@IDENTITY
			--new
		--	declare @sec_errCode int
		--	declare @sec_errString nvarchar(max)
		--	exec sec_setCreatorForEntity @userId, 0, '107, 31', @sec_errCode OUTPUT, @sec_errString OUTPUT, 9674, @sharedId
		end -- createSharedEntityReq Ends
		else if (@operation = 2)
		begin
			set @message = ( select ref.value('@message','nvarchar(max)') from @inputXml.nodes('LogMonitoring_ModifySharedEntityReq/sharedEntity') as R(ref))
			set @OriginalEntityId =  ( select ref.value('@originalEntityId','INT') from @inputXml.nodes('LogMonitoring_ModifySharedEntityReq/sharedEntity') as R(ref))
			set @sharedId = IsNull((select ref.value('@sharedEntityId' , 'int')
							 from @inputXml.nodes('LogMonitoring_ModifySharedEntityReq/sharedEntity/sharedEntityId') as R(ref)),0)
			if @sharedId = 0
			begin
				set @sharedId = (select sharedentityid from app_sharedentityinfo where originalentityid = @OriginalEntityId  and SharedEntityType = @shareType )
			end
			/*
			Insert into @origSharedEntityAssocList
			select userId,groupId,providerId
			from UMUserandGroupEntityAssociation
			where umuserandgroupentityassociation.entityType=9674		-- LM_SHARED_ENTITY_INFO
			and objectId=@sharedId
			-- delete from umuserandgroupentityassociation(overWriteOperation)
			delete from UMUserandGroupEntityAssociation
			where umuserandgroupentityassociation.entityType=9674		-- LM_SHARED_ENTITY_INFO
			and objectId=@sharedId
			*/
			--exec sec_getSecurityForEntity @userId, @shareInfoList output, 9674, @sharedId
			--calling userId with admin because user has no permission on othere users can be viewed by admin only.
			exec sec_getSecurityForEntity 1, @shareInfoList output, 9674, @sharedId  -- LM_SHARED_ENTITY_INFO = 9674
			Insert into @origSharedEntityAssocList
			SELECT isnull( ref.value('@userId','INTEGER'),0)  ,
case when ref.value('@_type_', 'INTEGER') = 15 then isnull( ref.value('@userGroupId','INTEGER'),0)
when ref.value('@_type_', 'INTEGER') = 62 then isnull( ref.value('@groupId','INTEGER'),0)
						else 0
					end,
case when ref.value('@_type_', 'INTEGER') = 15 and G.umdsProviderId > 0 then 1
when ref.value('@_type_', 'INTEGER') = 62 then 1
						 else 0
					end
			FROM @shareInfoList.nodes('associations/userOrGroup') R ( ref ) left outer join UMGroups G
on ref.value('@_type_', 'INT') = 15 and ref.value('@userGroupId','INT') = G.id
			-- deleting the already inserted user list
			exec sec_deleteSecurityAssociationsForEntity 9674, @sharedId
		end
		else if (@operation = 3)
		begin
			declare @sharedentityIdsToDelete table
			(
				sharedId int
			)
			Insert into @sharedEntityIdsToDelete
			select ISNULL(Tbl.Col.value('@sharedEntityId', 'int'),0) from
			@inputXml.nodes('/LogMonitoring_DeleteSharedEntityReq/sharedEntityId') as Tbl(Col)
			-- we support only one share to delete at one time , so ..
			declare @shareIdToDelete int
			set @shareIdToDelete = (select top 1 sharedId from @sharedEntityIdsToDelete)
			exec sec_deleteSecurityAssociationsForEntity 9674, @shareIdToDelete
			delete App_SharedentityInfo from App_SharedentityInfo, @sharedEntityIdsToDelete EntitiestoDelete
			where App_SharedentityInfo.SharedentityId=EntitiestoDelete.sharedId
		end
		if (@operation = 1 OR @operation = 2) --create or modify operation
		begin
			 -- Handle user entity associations.
				declare @sec_errCode int
				declare @sec_errString nvarchar(max)
				--SEND creatorUserId instead of userId because master or viewAll capability Users can overWrite the userId
DECLARE @permissionList VARCHAR(20) = CAST(107 AS VARCHAR(10)) + ',' + CAST(216 AS VARCHAR(10))
				exec sec_setCreatorForEntity @creatorUserId, 0, @permissionList, @sec_errCode OUTPUT, @sec_errString OUTPUT, 9674, @sharedId
			 DECLARE @shareToTable TABLE (sharedTo NVARCHAR(MAX), userType INT, shareToName NVARCHAR(MAX), errorCode INT, errorString NVARCHAR(MAX))
			 DELETE @shareToTable
			 declare @assocCount int
			 declare @i int = 1
			 SET @assocCount = @inputXml.value('count(//.[@userType])', 'INT')
			 declare @i_userId int=0 -- Need to replace this with original entity creator.
			 WHILE (@i <= @assocCount)
			 BEGIN
				declare @assocXML xml
				set @assocXML = ''
				SET @assocXML = @inputXml.query('(//.[@userType])[sql:variable("@i")]')
				declare @permission int
				SET @permission = ISNULL (( SELECT ref.value('@permission', 'INT')
									FROM @assocXML.nodes ('sharedTo') R(ref)), 0)
			--	DELETE @shareToTable
				INSERT INTO @shareToTable
				EXEC AppSharingSetUserConfig @assocXML,@i_userId, 0
				declare @sharedTo nvarchar(max) = ''
				declare @userType int = 0
				declare @errorString nvarchar(max)=''
				SELECT TOP 1 @sharedTo = sharedTo, @userType = userType, @errorCode = errorCode, @errorString = errorString
				FROM @shareToTable
				if @errorCode<>0
				begin
					set @err_message = 'Invalid operation'
					goto ERROR_EXIT
				end
				set @i = @i + 1
			 end
			  -- convert @shareToTable to xml and call sec_setSecurityAssociationsFromEntity sp.
				declare @association_Xml xml
				declare @SecurityAssociationForEntityList_Xml xml = '<App_SecurityAssociationForEntityList />'
				declare @associationOpType int = 1
				if @operation = 1
				begin
					set @associationOpType = 2
				end
				else
				begin
					set @associationOpType = 1
				end
			DECLARE @prop_Xml XML
SET @prop_Xml = (SELECT 216 AS '@permissionId' , 'Search Share' AS '@permissionName'
							FOR XML PATH ('permissions'), ROOT('properties')
							)
				set @association_Xml =
				(select case when userType = 1 then sharedTo end as '@userId' , case when userType = 3 then sharedTo end as '@userGroupId' , case when userType = 4 then sharedTo end as '@groupId' ,
						case when userType = 1 then shareToName end as '@userName' , case when userType = 3 then shareToName end as '@userGroupName' , case when userType = 4 then shareToName end as '@externalGroupName' ,
						case userType when 1 then '13' when 3 then '15' when 4 then '62' end as '@_type_'
 				from @shareToTable as shareTable
				for xml path('userOrGroup') , root('associations') )
				set @SecurityAssociationForEntityList_Xml.modify('insert attribute associationsOperationType {sql:variable("@associationOpType")} into (/App_SecurityAssociationForEntityList)[1]')
				set @SecurityAssociationForEntityList_Xml.modify( ' insert sql:variable("@association_Xml") into (/App_SecurityAssociationForEntityList)[1]  ')
				set @SecurityAssociationForEntityList_Xml.modify( ' insert sql:variable("@prop_Xml") into (/App_SecurityAssociationForEntityList/associations)[1]  ')
				--exec sec_setSecurityAssociationsFromEntity @SecurityAssociationForEntityList_Xml, @userId, 0, 0,9674, @sharedId, 0, 0, 0, 0, 0, 0, 0, 0
				--Adding skipSecurity check while inserting into security tables.
				insert into @spResult
				exec sec_setSecurityAssociationsFromEntity @SecurityAssociationForEntityList_Xml, @userId, 0, 1,9674, @sharedId, 0, 0, 0, 0, 0, 0, 0, 0
				-- populated userLists into table
		end
		COMMIT TRANSACTION LMSharedEntityInfoTran
		declare @sharedEntityEmailInfo xml
		declare @modifiedEntityList table
		(
			userId int,
			groupId int,
			provider int
		)
		if (@operation = 2 )
		begin
			--exec sec_getSecurityForEntity @userId, @shareInfoList output, 9674, @sharedId
			--calling userId with admin because user has no permission on othere users can be viewed by admin only.
			exec sec_getSecurityForEntity 1, @shareInfoList output, 9674, @sharedId  -- LM_SHARED_ENTITY_INFO = 9674
			Insert into @modifiedEntityList
			SELECT isnull( ref.value('@userId','INTEGER'),0)  ,
case when ref.value('@_type_', 'INTEGER') = 15 then isnull( ref.value('@userGroupId','INTEGER'),0)
when ref.value('@_type_', 'INTEGER') = 62 then isnull( ref.value('@groupId','INTEGER'),0)
						else 0
					end,
case when ref.value('@_type_', 'INTEGER') = 15 and G.umdsProviderId > 0 then 1
when ref.value('@_type_', 'INTEGER') = 62 then 1
						 else 0
					end
			FROM @shareInfoList.nodes('associations/userOrGroup') R ( ref ) left outer join UMGroups G
on ref.value('@_type_', 'INT') = 15 and ref.value('@userGroupId','INT') = G.id
			except
			select * from @origSharedEntityAssocList
		end
		else
		begin
			Insert into @modifiedEntityList
			select isnull( ref.value('@userId','INTEGER'),0)  ,
case when ref.value('@_type_', 'INTEGER') = 15 then isnull( ref.value('@userGroupId','INTEGER'),0)
						when ref.value('@_type_', 'INTEGER') = 62 then isnull( ref.value('@groupId','INTEGER'),0)
						else 0
					end,
case when ref.value('@_type_', 'INTEGER') = 15 and G.umdsProviderId > 0 then 1
when ref.value('@_type_', 'INTEGER') = 62 then 1
						 else 0
					end
			from @SecurityAssociationForEntityList_Xml.nodes('App_SecurityAssociationForEntityList/associations/userOrGroup') R(ref) left outer join UMGroups G
on ref.value('@_type_', 'INT') = 15 and ref.value('@userGroupId','INT') = G.id
		end
		DECLARE @sendMail INT = 1
		IF(@shareType = 134)
		BEGIN
			DECLARE @monitorType INT
			SET @monitorType = ISNULL((SELECT m.c.value('@monitoringType','INT')
				FROM LMUserSearch s
				OUTER APPLY s.searchInfo.nodes('LogMonitoring_SearchURLInfo') as m(c)
				WHERE s.searchId = @OriginalEntityId),0)
			IF @monitorType = 12
			BEGIN
				--This is a datacube alert. so dont send mail. This search is created from webservice part.
				SET @sendMail = 0
			END
		END
		--above is to fetch modified user lists;
		if exists(select 1 from @modifiedEntityList) AND @sendMail = 1
		begin
		DECLARE @searchUrl 			NVARCHAR(MAX) = ''
		DECLARE @adminEmail         NVARCHAR(MAX) = ''
		DECLARE @posIdx             INT = 0
		SELECT @searchUrl = value FROM GXGlobalParam
		WHERE name = 'WebConsoleURL' AND modified = 0
		SELECT @adminEmail=(SELECT email FROM UMUsers WHERE flags&0x040=0x040)
		SET @posIdx = PATINDEX('%/webconsole/%', @searchUrl)
		IF @posIdx = 0
		BEGIN
			SET @posIdx = PATINDEX('%/webconsole%', @searchUrl)
			IF @posIdx = 0
			BEGIN
				SET @errorCode = 6
				SET @err_message = 'webserverUrl is empty'
				RAISERROR (@err_message, -- Message text.
									16, -- Severity.
										1 -- State.
							);
				goto ERROR_EXIT
			END
			SET @searchUrl =  REVERSE(RIGHT(REVERSE (@searchUrl), len(@searchUrl) -
				NULLIF(charindex('elosnocbew/', REVERSE(@searchUrl)) - 2,0))) + '/'
		END
		ELSE
		BEGIN
			SET @searchUrl = LEFT(@searchUrl, @posIdx+LEN('/webconsole/')-1)
		END
		-- Get appType and add url accordingly.
		DECLARE @appType INT = 1
		IF(@shareType = 134)
		BEGIN
			SET @appType = (SELECT TOP 1 monitoringAppType
			FROM LMUserSearch WITH (NOLOCK) WHERE searchId = @OriginalEntityId)
		END
		ELSE IF(@shareType = 137)
		BEGIN
			SET @appType = (SELECT TOP 1 monitoringAppType
			FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardId = @OriginalEntityId)
		END
		IF @appType = 1
		BEGIN
			SET @searchUrl = @searchUrl + 'logMonitoring.do'
		END
		ELSE
		BEGIN
			SET @searchUrl = @searchUrl + 'sysMonitoring.do'
		END
			declare @usersharedTo xml
			declare @mailSubject nvarchar(max) = N''
			declare @emailBody nvarchar(max) = N''
			declare @emailFrom nvarchar(max)
			declare @emailsFromGroup table(userId int , email nvarchar(max))
		insert into @emailsFromGroup (userId , email )
		select id , email
		from UMUsers
		where id in
		(
			select distinct userid
			from UMUserGroup
			where groupid in
			(
				select groupId
				from  @modifiedEntityList m
				where groupId <> 0 and provider = 0 and userId = 0
			)
			except
			select userid
			from @modifiedEntityList m
			where m.groupId = 0 and m.provider = 0
		)
		--select * from @modifiedEntityList
		--select * from @emailsFromGroup
		declare @emailList xml
		set @emailList = (
						select emailListTbl.email  as '@email', emailListTbl.userType as '@userType', emailListTbl.userId as 'user/@userId', emailListTbl.groupId as 'group/@userGroupId', emailListTbl.externalGroupId as 'externalGroup/@groupId'
						from
						(
						select
						case when userId <> 0 then (select UMUsers.email from UMUsers where UMUsers.id = modified.userId)
							 when groupId <> 0 and provider <> 0 then (select UMGroups.email from UMGroups where modified.groupId=UMGroups.Id)
						end as email
						,
						case when userId <> 0 then 1
							when groupId <>0 and provider = 0 then 3
							when groupId <> 0 and provider <> 0 then 4
						end as userType
						,
						case when userId <> 0 then userId
						end as userId
						,
						case when groupId <>0 and provider = 0 then groupId
						end as groupId
						,
						case when groupId <> 0 and provider <> 0 then groupId
						end as externalGroupId
						from @modifiedEntityList modified
						where (modified.userId <> 0) or (modified.groupId <> 0 and modified.provider <> 0)
						union
						select email as email , 1 as userType , userId as userId , NULL as groupId ,NULL as externalGroupId
						from @emailsFromGroup
						) as emailListTbl
						for xml path('sharedTo')
						)
		set @usersharedTo = isnull(@emailList,'<sharedTo></sharedTo>')
		--new
			DECLARE @originalEntityName NVARCHAR(max)
			DECLARE @sharedusername NVARCHAR(max)
			DECLARE @shareEntityName NVARCHAR(MAX)
			DECLARE @entityName NVARCHAR(MAX)
			IF @shareType = 134 -- SEARCH
			BEGIN
				SET @originalEntityName = (select searchName from LMUserSearch where searchid = @OriginalEntityId)
				SET @entityName = 'Search'
				SET @shareEntityName = 'shareId'
			END
			ELSE IF @shareType = 137 -- DASHBOARD
			BEGIN
				SET @originalEntityName = (select dashBoardName from LMDashBoard where dashBoardId = @OriginalEntityId)
				SET @entityName = 'DashBoard'
				SET @shareEntityName = 'dashBoardId'
			END
			SET @sharedusername = (select login from UMUsers where id = @creatorUserId)
			SET @mailSubject = 'A '+ @entityName +' has been shared by ' + @sharedusername
			DECLARE @adminEmailAccnt NVARCHAR(MAX) = ''
			DECLARE @adminID            as integer  = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67), 1)
			SELECT @adminEmailAccnt = Email from umusers where id=@adminId
			DECLARE @link nvarchar(max)
			SET @link = ISNULL(@searchUrl,'')
			SET @link = ISNULL(@link,'') + '?'+@shareEntityName+'='
			SET @link = ISNULL(@link,'') + ISNULL(convert(nvarchar(max),@OriginalEntityId),'')
			IF(@message = '')
			BEGIN
				SET @message = 'Please have a look on this share'
			END
			set @emailBody = '<!doctype html><html><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head><body margin-top:0px;=""><table cellpadding="0" cellspacing="0" style="width: 600px; margin-top: 0px; padding: 0px 0px 10px 10px; font-family: Verdana, Helvetica, sans-serif;"><tr><td colspan="2" align="left" valign="middle" style="width: 100%;border-bottom-style: solid; border-bottom-color: #e31138; border-bottom-width: medium; line-hight:1.25; min-widht:200px;"><table cellpadding="0px" cellspacing="0" width="100%;" style="display: inline-block; float: left; "><tbody><tr><td colspan="1" align="left" valign="middle" style="width: 80%;solid;"><table cellpadding="0px" width="85%;" style="display: inline-block; float: left;"><tbody><tr><td style="font-family:Verdana, Helvetica, sans-serif;"><a style="font-size: 1.4em; font-weight: bold; color: #00a3d4; padding-top: 5px; padding-bottom: 5px; text-decoration: none; font-family:Verdana, Helvetica, sans-serif; min-width:200px; line-hight:1.25;" href="'+@link+'">'+@entityName+'</a></td></tr><tr><td style="font-weight: bold; color: #5c7684; line-height: 1.5em; padding-top: 5px; padding-bottom: 0px; font-family:Verdana, Helvetica, sans-serif;">Shared by '+@sharedusername+'</td></tr></tbody></table></td></tr></tbody></table></td></tr><tr><td style="margin-top: 0px; margin-bottom: 0px;"></td></tr><tr><td style="font-weight: bold; font-size: 1.2em; color: #00a3d4; padding-bottom: 0px; padding-top: 20px;">Message</td></tr><tr><td style="font-size: .875em; color: #5c7684; padding-bottom: 10px; padding-top: 0px;">'+@message+'</td></tr><tr><td style="font-size: .6em; color: #5c7684; padding-bottom: 0px;">In case of any problems please contact the <a style="color: #00a3d4;" href="mailto:'+@adminEmailAccnt+'">Administrator </td></tr><tr><td colspan="2" style="width: 100%;border-bottom-style: solid; border-bottom-color: #e31138; border-bottom-width:thin;"></td></tr></table></body></html> '
			set @sharedEntityEmailInfo = (select @mailSubject as '@mailSubject',
				@emailBody as '@mailBody',
				@usersharedTo.query('.')
				for xml path('emailInfo'))
		end
		set @outputXml = (select @sharedId as 'sharedEntityId/@sharedEntityId',
				@sharedEntityEmailInfo.query('.'),
				@errorCode as 'entityResponse/@errorCode',
				@err_message as 'entityResponse/@errorString'
				for xml path('LogMonitoring_SharedEntityOpResponse')
		)
ERROR_EXIT:
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION LMSharedEntityInfoTran
	set @outputXml = (select 1 as 'entityResponse/@errorCode',
				@err_message as 'entityResponse/@errorString'
				for xml path('LogMonitoring_SharedEntityOpResponse')
		)
	END CATCH
	select @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMPopulateSharedEntityInfo')
	delete from GxQscripts where name = 'LMPopulateSharedEntityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMPopulateSharedEntityInfo')
	delete from GXDBVersions where aliasname = 'LMPopulateSharedEntityInfo'
GO

insert into GXDBVersions values(2, 'LMPopulateSharedEntityInfo',  '00010005000200110000', 'LMPopulateSharedEntityInfo', '00010005000200110000')
GO

