

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMIsValidToAssociatePolicyWithSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMIsValidToAssociatePolicyWithSubclient.sp,v $ $Id: LMIsValidToAssociatePolicyWithSubclient.sp,v 1.1.4.7 2018/04/23 23:27:05 logeshg Exp $";
--
--  +========================================================================+
--  |   Procedure:  LMIsValidToAssociatePolicyWithSubclient()
--  |
--  | Description:  Given a storagePolicyId and monitoirng policyId, return back 1 if both fall under same client. Else 0
--  |		InputAreas: input comes from subclient level and policyLevel(subclient--> 0 , storagepolicy-->0 and valid policyId will be passed.)
--  |       Input:  storagePolicyId,monitoirng policyId
--  |
--  |      Output:  1 --> if both fall under same clientId , 0 --> if not
--  |
--  |      Return:  xxx
--  |
--  |   Revisions  Author                       Description
--  |   ---------  -------              --------------------------------
--  |   1.1        Logesh                       Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMIsValidToAssociatePolicyWithSubclient <<<'

IF EXISTS (select * from sysobjects where name='LMIsValidToAssociatePolicyWithSubclient')
	drop procedure LMIsValidToAssociatePolicyWithSubclient
IF EXISTS (select * from GxQscripts where name='LMIsValidToAssociatePolicyWithSubclient')
	delete from GxQscripts where name = 'LMIsValidToAssociatePolicyWithSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsValidToAssociatePolicyWithSubclient')
	delete from GXDBVersions where aliasname = 'LMIsValidToAssociatePolicyWithSubclient'
GO
print '... Creating Procedure: LMIsValidToAssociatePolicyWithSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMIsValidToAssociatePolicyWithSubclient
  @i_subClientId INTEGER,
  @i_storagePolicyId INTEGER,
  @i_monitoringPolicyId INTEGER,
  @i_localeId INTEGER = 0
AS
  DECLARE @isValidToAssociate INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET @isValidToAssociate = 0
SET @errorCode = 0
SET @errorString = ''
DECLARE @cloudStoragePolicy INT , @clientStoragePolicy INT
DECLARE @cloudPolicyId INT , @clientCloudId INT
IF @i_storagePolicyId = 0 AND @i_monitoringPolicyId = 0
BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = 'Missing storage policy and monitoirng policy info'
	GOTO EXITPROC
END
IF @i_subClientId = 0
BEGIN
	-- This case can only happen , when this sp is called from policy Level.
	-- Now , get subclientId from associated policy.
	SET @i_subClientId = ISNULL((SELECT TOP 1 componentNameId FROM APP_SubClientProp WITH(NOLOCK) WHERE attrName = 'AnalyticsMonitoringPolicyId' AND attrVal = @i_monitoringPolicyId AND modified = 0),0)
	IF(@i_subClientId = 0)
	BEGIN
		-- which means , no policy associated with subclient , so for now making valid to 1.
		SET @isValidToAssociate = 1
		GOTO EXITPROC
	END
END
IF @i_storagePolicyId = 0
BEGIN
	-- fetch storage policyId from db.
	SET @i_storagePolicyId = ISNULL((SELECT TOP 1 dataArchGrpID FROM APP_Application WITH(NOLOCK) WHERE id = @i_subClientId),0)
END
IF @i_monitoringPolicyId = 0
BEGIN
	-- fetch storage policyId from db.
	SET @i_monitoringPolicyId = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @i_subClientId AND attrName = 'AnalyticsMonitoringPolicyId' AND modified = 0),0)
END
-- IF policy is not associated to subclient , then make it as valid and send.
IF @i_monitoringPolicyId = 0
BEGIN
	SET @isValidToAssociate = 1
	GOTO EXITPROC
END
SET @cloudStoragePolicy = ISNULL((SELECT TOP 1 cloudId FROM ArchContentIndexingRules WITH(NOLOCK) WHERE archGroupId = @i_storagePolicyId  AND enabled = 1),0)
IF @cloudStoragePolicy = 0
BEGIN
SET @errorCode = (3228 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	GOTO EXITPROC
END
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
-- Below statement gives cloud associated with search Engine.
-- CloudType = 3 are search Engines.
SET @clientStoragePolicy = ISNULL((SELECT TOP 1 ClientId FROM DM2SearchServerCoreInfo WITH(NOLOCK) WHERE CloudId = @cloudStoragePolicy AND CloudType = 3),0)
IF @clientStoragePolicy = 0
BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = 'Failed to get client info for storage policy'
	GOTO EXITPROC
END
SET @cloudPolicyId = ISNULL((SELECT TOP 1 attrVal FROM APP_MonitoringPolicyProp WITH(NOLOCK) WHERE attrName = 'Cloud Id' and monitorPolicyId = @i_monitoringPolicyId),0)
IF @cloudPolicyId = 0
BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = 'Failed to get cloud info for monitoring policy'
	GOTO EXITPROC
END
SET @clientCloudId = ISNULL((SELECT TOP 1 ClientId FROM #getIndexServers WHERE CloudId = @cloudPolicyId),0)
IF @clientCloudId = 0
BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = 'Failed to get client info for cloud'
	GOTO EXITPROC
END
IF @clientStoragePolicy = @clientCloudId
BEGIN
	SET @isValidToAssociate = 1
END
ELSE
BEGIN
SET @errorCode = (3229 | (CAST(POWER(2, 24) AS BIGINT) * 35))
END
EXITPROC:
IF (@errorCode <> 0 AND @errorCode <> (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
BEGIN
	DECLARE @monitoringPolicyName NVARCHAR(MAX),@storagePolicyName NVARCHAR(MAX),@subclientName NVARCHAR(MAX)
	SET @monitoringPolicyName = ISNULL((SELECT TOP 1 MonitorPolicyName FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE monitorPolicyId =  @i_monitoringPolicyId),'')
	SET @storagePolicyName = ISNULL((SELECT TOP 1 name FROM archGroup WITH(NOLOCK) WHERE id =  @i_storagePolicyId),'')
	SET @subclientName = ISNULL((SELECT TOP 1 subclientName FROM APP_Application WITH(NOLOCK) WHERE id =  @i_subClientId),'')
	IF(@monitoringPolicyName = '')
	BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString= 'Error while fetching monitoring policy info'
	END
	ELSE IF(@storagePolicyName = '')
	BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString= 'Error while fetching storage policy info'
	END
	ELSE IF(@subclientName = '')
	BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString= 'Error while fetching subclient info'
	END
	ELSE
	BEGIN
		SET @errorString= (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=@errorCode and LocaleID=@i_localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @monitoringPolicyName)
		SET @errorString = REPLACE(@errorString, '^2%s', @subclientName)
		SET @errorString = REPLACE(@errorString, '^3%s', @storagePolicyName)
IF(@errorCode = (3229 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		BEGIN
			SET @errorString = REPLACE(@errorString, '^4%s', @monitoringPolicyName)
		END
	END
END
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
SELECT @isValidToAssociate,@errorCode,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'LMIsValidToAssociatePolicyWithSubclient')
	delete from GxQscripts where name = 'LMIsValidToAssociatePolicyWithSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsValidToAssociatePolicyWithSubclient')
	delete from GXDBVersions where aliasname = 'LMIsValidToAssociatePolicyWithSubclient'
GO

insert into GXDBVersions values(2, 'LMIsValidToAssociatePolicyWithSubclient',  '00010001000400070000', 'LMIsValidToAssociatePolicyWithSubclient', '00010001000400070000')
GO

