

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMIsSubclientAssociatedWithMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMIsSubclientAssociatedWithMonitoringPolicy.sp,v $ $Id: LMIsSubclientAssociatedWithMonitoringPolicy.sp,v 1.1.2.3 2018/03/27 09:05:09 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LMIsSubclientAssociatedWithMonitoringPolicy()
--  |
--  | Description:  Given a client, return back list of media agents that it can talk to
--  |
--  |       Input:  subclientId
--  |
--  |      Output:  1 --> if associated , 0 --> if not associated
--  |
--  |      Return:  xxx
--  |
--  |   Revisions  Author                       Description
--  |   ---------  -------              --------------------------------
--  |   1.1        Logesh						Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMIsSubclientAssociatedWithMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='LMIsSubclientAssociatedWithMonitoringPolicy')
	drop procedure LMIsSubclientAssociatedWithMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='LMIsSubclientAssociatedWithMonitoringPolicy')
	delete from GxQscripts where name = 'LMIsSubclientAssociatedWithMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsSubclientAssociatedWithMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMIsSubclientAssociatedWithMonitoringPolicy'
GO
print '... Creating Procedure: LMIsSubclientAssociatedWithMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LMIsSubclientAssociatedWithMonitoringPolicy
  @i_subClientId INTEGER
AS
  DECLARE @isSubclientAssociated INTEGER
	IF EXISTS (
		SELECT 1
		FROM APP_MonitoringPolicy policyTbl
		INNER JOIN APP_MonitoringPolicyProp policyPropTbl
		ON policyTbl.monitorPolicyId = policyPropTbl.monitorPolicyId
		WHERE policyTbl.status <> 3 AND policyPropTbl.attrName LIKE 'SubClient Id' AND policyPropTbl.attrVal = @i_subClientId
	)
	BEGIN
		SET @isSubclientAssociated	= 1
	END
	ELSE
	BEGIN
		SET @isSubclientAssociated = 0
	END
	SELECT @isSubclientAssociated
GO

IF EXISTS (select * from GxQscripts where name = 'LMIsSubclientAssociatedWithMonitoringPolicy')
	delete from GxQscripts where name = 'LMIsSubclientAssociatedWithMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsSubclientAssociatedWithMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMIsSubclientAssociatedWithMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMIsSubclientAssociatedWithMonitoringPolicy',  '00010001000200030000', 'LMIsSubclientAssociatedWithMonitoringPolicy', '00010001000200030000')
GO

