

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMIsNASClientAssociatedWithAnotherPolicy.sp] ---------- 

--
-- gets the asociation list with the policyid and returns true if
-- there is another nas policy that has the same NAS client in the given assoc list already associated
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMIsNASClientAssociatedWithAnotherPolicy <<<'

IF EXISTS (select * from sysobjects where name='LMIsNASClientAssociatedWithAnotherPolicy')
	drop procedure LMIsNASClientAssociatedWithAnotherPolicy
IF EXISTS (select * from GxQscripts where name='LMIsNASClientAssociatedWithAnotherPolicy')
	delete from GxQscripts where name = 'LMIsNASClientAssociatedWithAnotherPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsNASClientAssociatedWithAnotherPolicy')
	delete from GXDBVersions where aliasname = 'LMIsNASClientAssociatedWithAnotherPolicy'
GO
print '... Creating Procedure: LMIsNASClientAssociatedWithAnotherPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMIsNASClientAssociatedWithAnotherPolicy
  @associations XML,
  @monitoringPolicyId INT,
  @commcellID INT
AS
  DECLARE @isAlreadyAssociated int = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @AllNASClients TABLE(clientId INT)
DECLARE @NASPolicies TABLE(policyId INT)
DECLARE @newclientList table ( clientId int)
DECLARE @newclientGroupList   table ( clientGroupId int)
DECLARE @excludedNewClientList    table ( clientId int)
DECLARE @oldClientAssoc table (clientId int,policyId int)
INSERT INTO @AllNASClients
    SELECT client.id FROM App_Client client
WHERE client.status & 0x0080 = 0x0080
AND client.status & 0x00002  = 0
INSERT INTO @NASPolicies
	SELECT monitorPolicyId FROM APP_MonitoringPolicyProp
	WHERE commcellId = @commcellID
	AND attrName =  'OSType' AND attrVal = 3 --LogMonitoring::OSType_NAS
DELETE NASpol
	FROM @NASPolicies NASpol
	INNER JOIN APP_MonitoringPolicy monpol
		ON NASpol.policyId = monpol.monitorPolicyId and monpol.commcellID=@commcellId
	WHERE monpol.status=3
INSERT INTO @excludedNewClientList
    SELECT DISTINCT ref.value('@clientId','integer')
    FROM @associations.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 3 and ISNULL(ref.value('flags[1]/@exclude','integer'),0)=1
IF EXISTS( SELECT 1 FROM @associations.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)  WHERE ref.value('@_type_','integer')= 2)
	BEGIN
		INSERT INTO @newclientList
			SELECT clientId FROM @AllNASClients
	END
ELSE
	BEGIN
		INSERT INTO @newClientList
		SELECT DISTINCT ref.value('@clientId','integer')
		FROM @associations.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 3 and ISNULL(ref.value('flags[1]/@exclude','integer'),0)=0
		INSERT INTO @newclientGroupList
		SELECT DISTINCT ref.value('@clientGroupId','integer')
		FROM @associations.nodes('LogMonitoring_MonitoringPolicy/associations') R (ref)
WHERE ref.value('@_type_','integer')= 28 and ISNULL(ref.value('flags[1]/@exclude','integer'),0)=0
		-- add nas clients from client group to newClientList
		INSERT INTO @newClientList
	        SELECT allNAS.clientId from @newclientGroupList newCG
			INNER JOIN APP_ClientGroupAssoc cgassoc
				ON newCG.clientGroupID = cgassoc.clientGroupId
			INNER JOIN @AllNASClients allNAS
				ON allNAS.clientId=cgassoc.clientID
	END
	DELETE newClients
	FROM @newclientList newClients
	INNER JOIN @excludedNewClientList  excluded
	ON excluded.clientId = newClients.clientId
INSERT INTO @oldClientAssoc
   SELECT DISTINCT   nasClients.clientId,MAE.monitorPolicyId
   FROM  @NASPolicies naspolicy
   INNER JOIN APP_MonitorAssocEntity MAE
ON MAE.monitorPolicyId = nasPolicy.policyId and MAE.commcellID=@commcellId AND MAE.flags = 3 AND exclude = 0
   INNER JOIN @AllNasClients nasClients
   ON MAE.clientId=nasClients.clientId
INSERT INTO @oldClientAssoc
	SELECT nasClients.clientId, MAE.monitorPolicyId
	FROM APP_MonitorAssocEntity MAE
	INNER JOIN @NASPolicies nasPolicies
ON nasPolicies.policyId = MAE.monitorPolicyId and MAE.flags = 2 and MAE.commcellID=@commcellId
	CROSS JOIN @AllNasClients nasClients
INSERT INTO @oldClientAssoc
	SELECT nasClients.clientId, MAE.monitorPolicyId
	FROM APP_MonitorAssocEntity MAE
	INNER JOIN @NASPolicies nasPolicies
ON nasPolicies.policyId = MAE.monitorPolicyId and MAE.flags = 28 and MAE.commcellID=@commcellId
	INNER JOIN APP_ClientGroupAssoc cgAssoc
	ON cgAssoc.clientGroupId=MAE.clientGroupId
	INNER JOIN @AllNasClients nasClients
	ON nasClients.clientId=cgAssoc.clientId
--remove the exclusions
DELETE oldAssoc
FROM @oldClientAssoc oldAssoc
INNER JOIN APP_MonitorAssocEntity MAE
ON MAE.monitorPolicyId = oldAssoc.policyId  and MAE.commcellID=@commcellId
and MAE.clientId = oldAssoc.clientId AND MAE.flags = 3
WHERE MAE.exclude = 1
--now if oldAssoc contains clients in newClientlist
IF EXISTS (SELECT 1
   FROM @newclientList newClients
   INNER JOIN @oldClientAssoc oldClients
   ON newClients.clientId = oldClients.clientId
   WHERE oldClients.policyId <> @monitoringPolicyId)
   SET @isAlreadyAssociated = 1
SELECT @isAlreadyAssociated
GO

IF EXISTS (select * from GxQscripts where name = 'LMIsNASClientAssociatedWithAnotherPolicy')
	delete from GxQscripts where name = 'LMIsNASClientAssociatedWithAnotherPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsNASClientAssociatedWithAnotherPolicy')
	delete from GXDBVersions where aliasname = 'LMIsNASClientAssociatedWithAnotherPolicy'
GO

insert into GXDBVersions values(2, 'LMIsNASClientAssociatedWithAnotherPolicy',  '00000000000000000000', 'LMIsNASClientAssociatedWithAnotherPolicy', '00000000000000000000')
GO

