

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMIsMonitoringPolicytAssociatedWithSubClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMIsMonitoringPolicytAssociatedWithSubClient.sp,v $ $Id: LMIsMonitoringPolicytAssociatedWithSubClient.sp,v 1.1.2.4 2018/03/27 08:53:33 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LMIsMonitoringPolicytAssociatedWithSubClient()
--  |
--  | Description:  Given a monitoring policy , this function will return whether it is associated with any subclient
--  |
--  |       Input:  monitoring policyId
--  |
--  |      Output:  1 --> if associated , 0 --> if not associated
--  |
--  |      Return:  xxx
--  |
--  |   Revisions  Author                       Description
--  |   ---------  -------              --------------------------------
--  |   1.1        Logesh                       Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMIsMonitoringPolicytAssociatedWithSubClient <<<'

IF EXISTS (select * from sysobjects where name='LMIsMonitoringPolicytAssociatedWithSubClient')
	drop procedure LMIsMonitoringPolicytAssociatedWithSubClient
IF EXISTS (select * from GxQscripts where name='LMIsMonitoringPolicytAssociatedWithSubClient')
	delete from GxQscripts where name = 'LMIsMonitoringPolicytAssociatedWithSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsMonitoringPolicytAssociatedWithSubClient')
	delete from GXDBVersions where aliasname = 'LMIsMonitoringPolicytAssociatedWithSubClient'
GO
print '... Creating Procedure: LMIsMonitoringPolicytAssociatedWithSubClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LMIsMonitoringPolicytAssociatedWithSubClient
  @i_monitoringPolicyId INTEGER,
  @i_localeId INTEGER = 0
AS
  DECLARE @isMonitoringPolicyAssociated INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
	SET @errorCode = 0
	SET @errorString = ''
DECLARE @subclientName NVARCHAR(128)
	SET @subclientName = ISNULL((SELECT TOP 1 subClientTbl.subclientName
								FROM APP_Application subClientTbl WITH(NOLOCK)
								INNER JOIN APP_SubClientProp subClientProp WITH(NOLOCK)
								ON	subClientTbl.id = subClientProp.componentNameId AND
									subClientTbl.subclientStatus & 4 = 0 AND
									subClientProp.attrName = 'AnalyticsMonitoringPolicyId' AND subClientProp.modified = 0 AND
									subClientProp.attrVal = CONVERT(NVARCHAR(MAX),@i_monitoringPolicyId)
								),
								NULL
								)
	IF @subclientName IS NULL
	BEGIN
		SET @isMonitoringPolicyAssociated = 0
	END
	ELSE
	BEGIN
		SET @isMonitoringPolicyAssociated = 1
		-- Since policy is associated with subclient , we should throw error ,saying cannot be deleted.
DECLARE @monitoringPolicyName NVARCHAR(255)
		SET @monitoringPolicyName = ISNULL((SELECT TOP 1 MonitorPolicyName FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE monitorPolicyId =  @i_monitoringPolicyId),'')
SET @errorCode = (3227 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString= (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=@errorCode and LocaleID=@i_localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @monitoringPolicyName)
		SET @errorString = REPLACE(@errorString, '^2%s', @subclientName)
	END
    SELECT @isMonitoringPolicyAssociated,@errorCode,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'LMIsMonitoringPolicytAssociatedWithSubClient')
	delete from GxQscripts where name = 'LMIsMonitoringPolicytAssociatedWithSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsMonitoringPolicytAssociatedWithSubClient')
	delete from GXDBVersions where aliasname = 'LMIsMonitoringPolicytAssociatedWithSubClient'
GO

insert into GXDBVersions values(2, 'LMIsMonitoringPolicytAssociatedWithSubClient',  '00010001000200040000', 'LMIsMonitoringPolicytAssociatedWithSubClient', '00010001000200040000')
GO

