

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMIsApplicationLicenseValid.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMIsApplicationLicenseValid.sp,v $ $Id: LMIsApplicationLicenseValid.sp,v 1.2.12.8 2018/04/06 19:47:29 logeshg Exp $";
--	+===================================================================+
--	| APPGetApplicationLicenses - Get licenses for user					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMIsApplicationLicenseValid <<<'

IF EXISTS (select * from sysobjects where name='LMIsApplicationLicenseValid')
	drop procedure LMIsApplicationLicenseValid
IF EXISTS (select * from GxQscripts where name='LMIsApplicationLicenseValid')
	delete from GxQscripts where name = 'LMIsApplicationLicenseValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsApplicationLicenseValid')
	delete from GXDBVersions where aliasname = 'LMIsApplicationLicenseValid'
GO
print '... Creating Procedure: LMIsApplicationLicenseValid'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMIsApplicationLicenseValid
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId int,
  @lmAppType int,
  @showLMapp int OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
-----------------------------------------------------------
--- LOCALS                                              ---
-----------------------------------------------------------
DECLARE @userCapsAtCommcell 	bigint = 0
SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
FROM #tempAppGetApplicationSecurityObjects sec
		WHERE		commCellId <> 0
					AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
					AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
					AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
					AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
					AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
					AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
					AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
					AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
					AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
					AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
					AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
declare @monitoringTypesForAppType table
(
	monitoringType int
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- ENABLE_SYSTEM_MONITORING "EnableSystemMonitoring"
declare @keyForLMType nvarchar(max) = 'bEnableCIForLogMonitoring'
SET @showLMapp = 0
-- For system monitoring key used is different.
if @lmAppType=2
begin
	set @keyForLMType = 'EnableSystemMonitoring'
end
INSERT INTO @monitoringTypesForAppType
SELECT monitoringType FROM dbo.LMGetMonitoringTypesForAppType(@lmAppType)
DECLARE @isNewSecurity INT = (SELECT dbo.isNewSecurity())
IF NOT EXISTS(SELECT entityId FROM APP_AdvanceSettings WHERE keyName = @keyForLMType  AND VALUE Like 'false' AND enabled = 1 AND deleted = 0 and entityId > 0)
BEGIN
	IF object_id('tempdb.dbo.#AppGetApplicationLicenses_LMObjects') is not null DROP TABLE #AppGetApplicationLicenses_LMObjects
	CREATE TABLE #AppGetApplicationLicenses_LMObjects (monitoringPolicyId INT)
	IF @isNewSecurity = 1
	BEGIN
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 110, '#AppGetApplicationLicenses_LMObjects'
	END
	DECLARE @rightsAtCommcell INT = 0
	IF @isNewSecurity = 0
	BEGIN
SET @rightsAtCommcell = (SELECT (@userCapsAtCommcell & CAST(POWER(2.0, 33 - 1) AS bigint)))
	END
	ELSE
	BEGIN
EXEC sec_checkPermissionOnEntity @userId, 110, @rightsAtCommcell OUTPUT, 1, 2
	END
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
	            (     serverURL NVARCHAR(512),
	                  clientId INT,
	                  clientName NVARCHAR(256),
	                  cloudId INT,
	                  hostName NVARCHAR(256),
	                  basePort INT,
	                  engineName  NVARCHAR(256),
	                  serverType INT,
	                  indexServerClientId INT,
	                  internalCloudName NVARCHAR(256)
	            )
	CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
	IF (@rightsAtCommcell = 1)
	BEGIN
		IF EXISTS (SELECT 1 FROM APP_MonitoringPolicyProp MPP WITH(NOLOCK) JOIN APP_MonitoringPolicy MP WITH(NOLOCK) ON MPP.monitorPolicyId = MP.monitorPolicyId
		inner join APP_MonitoringPolicyProp MPPType on  MPPType.monitorPolicyId = MP.monitorPolicyId
		and MPPType.attrName = 'Monitoring Type'
		inner join @monitoringTypesForAppType  monitoringTypesForAppType on monitoringTypesForAppType.monitoringType=MPPType.attrVal
		WHERE MPP.attrName='Cloud Id' AND MP.status != 3
		AND MPP.attrVal IN (SELECT convert(NVARCHAR(10),cloudId) FROM #getIndexServers))
		begin
			SET @showLMapp = 1
		end
	END
	ELSE
	BEGIN
		DECLARE @monitoringPolicyAssocUser TABLE (mpid integer)
		IF @isNewSecurity = 0
		BEGIN
			INSERT INTO @monitoringPolicyAssocUser
SELECT logMonitoringPolicyId from #tempAppGetApplicationSecurityObjects where logMonitoringPolicyId<>0 AND  (capabilities & CAST(POWER(2.0, 33 - 1) AS bigint) <> 0)
		END
		ELSE
		BEGIN
			INSERT INTO @monitoringPolicyAssocUser
			SELECT monitoringPolicyId
				FROM #AppGetApplicationLicenses_LMObjects
		END
		DELETE @monitoringPolicyAssocUser
		FROM @monitoringPolicyAssocUser MA JOIN APP_MonitoringPolicy MP WITH(NOLOCK) ON MA.mpid = MP.monitorPolicyId
		where MP.status = 3
		-- Delete Mps of not the appropriate type.
		DELETE @monitoringPolicyAssocUser
		FROM @monitoringPolicyAssocUser MA inner JOIN APP_MonitoringPolicyProp MPPType WITH(NOLOCK) ON MA.mpid = MPPType.monitorPolicyId
		and MPPType.attrName = 'Monitoring Type'
		left join @monitoringTypesForAppType  monitoringTypesForAppType on monitoringTypesForAppType.monitoringType=MPPType.attrVal
		where monitoringTypesForAppType.monitoringType is null
		IF EXISTS (SELECT cloudId FROM #getIndexServers WHERE cloudId in (select CONVERT(INT,MPP.attrVal) from APP_MonitoringPolicyProp MPP Join @monitoringPolicyAssocUser MA on MPP.monitorPolicyId = MA.mpid where MPP.attrName='Cloud Id'))
			SET @showLMapp = 1
	END
	-- Currently check for shared searches only for both LM apptype and system monitoring apptype.
	IF(@showLMapp = 0 /*and @lmAppType<>2*/)
	BEGIN
	-- if shared search exists for this user userId.
		EXEC LM_isUserHasSharedEntity @userId,@lmAppType,@showLMapp OUTPUT
	END
END
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'LMIsApplicationLicenseValid')
	delete from GxQscripts where name = 'LMIsApplicationLicenseValid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMIsApplicationLicenseValid')
	delete from GXDBVersions where aliasname = 'LMIsApplicationLicenseValid'
GO

insert into GXDBVersions values(2, 'LMIsApplicationLicenseValid',  '00010002001200080000', 'LMIsApplicationLicenseValid', '00010002001200080000')
GO

