

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMHyperVOperationOnClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Seema Aggarwal
--	Date:   10/11/2012
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMHyperVOperationOnClient <<<'

IF EXISTS (select * from sysobjects where name='LMHyperVOperationOnClient')
	drop procedure LMHyperVOperationOnClient
IF EXISTS (select * from GxQscripts where name='LMHyperVOperationOnClient')
	delete from GxQscripts where name = 'LMHyperVOperationOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMHyperVOperationOnClient')
	delete from GXDBVersions where aliasname = 'LMHyperVOperationOnClient'
GO
print '... Creating Procedure: LMHyperVOperationOnClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMHyperVOperationOnClient
  @iClientId INT, 
  @iOperation INT,
  @o_monitoringPolicyId INT =0 OUTPUT,
  @o_wasOperationAlreadyDone INT =0 OUTPUT,
  @o_errorCode INT =0 OUTPUT,
  @o_errorMessage VARCHAR(2048) ='' OUTPUT,
  @iReturn INT=0
AS
  DECLARE @r_monitoringPolicyId INT
  DECLARE @r_wasOperationAlreadyDone INT
  DECLARE @r_errorCode INT
  DECLARE @r_errorMessage VARCHAR(2048)
BEGIN
	SET @o_wasOperationAlreadyDone =0
	DECLARE @workTokenParams NVARCHAR(MAX)
	DECLARE @enableMonitoringPolicy TABLE(clientId int,policyId int DEFAUlt 0)
	DECLARE @systemCreatedHyperVPolicy INT=0
	DECLARE @HyperVPolicy INT =0
	IF(@iOperation =2) -- Get Enabled protocol
	BEGIN
		  IF OBJECT_ID('tempdb.dbo.#monitoringPolicyList') IS NOT NULL
			DROP TABLE #monitoringPolicyList
		  CREATE TABLE #monitoringPolicyList( mpid int,status int)
		exec LMGetEnableMonitoringPolicyForClient @iClientId,9,1,@HyperVPolicy OUTPUT,''
		IF(@HyperVPolicy<>0)
		BEGIN
				--HyperV policy is enabled
				SELECT @o_monitoringPolicyId=@HyperVPolicy,@o_wasOperationAlreadyDone=0,@o_errorCode=0,@o_errorMessage=''
				GOTO EXIT_PROC
		END
		--CHECK IF THERE IS ANY VALID HYperV POLICY with cloud configured
		SET  @systemCreatedHyperVPolicy = ISNULL((Select TOP 1 monitorPolicyId from APP_MonitoringPolicyProp WITH(NOLOCK) where attrName='System Created HyperV Policy' and attrVal=1   order by monitorPolicyId ),0)
		IF EXISTS (SELECT 1 FROM APP_MonitoringPolicy  where monitorPolicyId=@systemCreatedHyperVPolicy and status=0)
		BEGIN
			SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=0,@o_errorCode=0,@o_errorMessage=''  --Monitoring policy is present but not selected for this client.
				GOTO EXIT_PROC
		END
		--@systemCreated policy is disabled or not present. Let see if any user created policy
		 --Check if any HyperV enabled policy present
		 SET @HyperVPolicy = ISNULL((SELECT TOP 1 MP.monitorPolicyId from APP_MonitoringPolicyProp Prop JOIN APP_MonitoringPolicy MP ON Mp.monitorPolicyId= PRop.monitorPolicyId  where attrNAme='Monitoring Type' and attrVal=9 and status=0),0)
		 IF(@HyperVPolicy<>0)
		 BEGIN
				SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=0,@o_errorCode=0,@o_errorMessage='' --Monitoring policy is present but not selected for this client.
				GOTO EXIT_PROC
		 END
		 --Now there is no valid HyperV policy. Just see if System created policy is disabled because it has no cloudInfo, lets set cloud info now.
		 --Check if system created policy is disabled because there was no valid cloud during installtion and there is LM cloud present now. Just add cloud and enable it.
		 IF(@systemCreatedHyperVPolicy<>0)
		BEGIN
			IF EXISTS(SELECT 1 from APP_MonitoringPolicy where monitorPolicyId=@systemCreatedHyperVPolicy and status=1 )
			BEGIN
				IF NOT EXISTS(SELECT 1 FROM APP_MonitoringPolicyProp where attrName='Cloud Id'  and monitorPolicyId =@systemCreatedHyperVPolicy)
				BEGIN
					--cloud is not configure. Check now if any valid LM cloud is present.
						IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
				CREATE TABLE #getIndexServers
				(     serverURL NVARCHAR(512),
					  clientId INT,
					  clientName NVARCHAR(256),
					  cloudId INT,
					  hostName NVARCHAR(256),
					  basePort INT,
					  engineName  NVARCHAR(256),
					  serverType INT,
					  indexServerClientId INT,
					  internalCloudName NVARCHAR(256)
				)
					CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
					DECLARE @cloudId INT
					DECLARE @cloudName NVARCHAR(MAX)
					SELECT TOP 1 @cloudId= ISNULL(cloudId,0),@cloudName=internalCloudName from #getIndexServers order by cloudId asc
					IF(@cloudId<>0)
					BEGIN
						--Lets insert cloud from system created policy and enable the policy.
						   INSERT INTO APP_MonitoringPolicyProp VALUES(@systemCreatedHyperVPolicy,2,'Cloud Id',7,@cloudId,datediff(second, '01/01/1970', GETUTCDATE()),datediff(second, '01/01/1970', GETUTCDATE()))
						   INSERT INTO APP_MonitoringPolicyProp VALUES(@systemCreatedHyperVPolicy,2,'Cloud Name',1,@cloudName,datediff(second, '01/01/1970', GETUTCDATE()),datediff(second, '01/01/1970', GETUTCDATE()))
						   UPDATE APP_MonitoringPolicy
						   set status=0
						   where monitorPolicyId=@systemCreatedHyperVPolicy
						   SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=0,@o_errorCode=0,@o_errorMessage=''
							GOTO EXIT_PROC
					END
					ELSE
						BEGIN
							SELECT @o_monitoringPolicyId=-2,@o_wasOperationAlreadyDone=0,@o_errorCode=2,@o_errorMessage='No Valid Monitoring Policy Cloud Present'
							GOTO EXIT_PROC
						END
					END
			END
			--No Valid policy found
			SELECT @o_monitoringPolicyId=-1,@o_wasOperationAlreadyDone=0,@o_errorCode=3,@o_errorMessage='Enabled HyperV Policy not found'
				GOTO EXIT_PROC
		END
	END
	DECLARE @instanceId INT = (SELECT TOp 1  instance from APP_Application  where clientId=@iClientId and appTypeId=106)
	DECLARE @inputmembersXml XML= (SELECT attrVal from APP_InstanceProp where componentNameId=@instanceId and attrName='Vs Member Servers' and modified=0)
	DECLARE @operationDone TABLE (clientId int)
	DECLARE @inputClient TABLE (iClientId int)
		INSERT INTO @inputClient
		SELECT @iClientId
		UNION
		SELECT T.col.value('@clientId[1]','int')
		FROM @inputmembersXml.nodes('App_MemberServers/memberServers/client') as T(col)
		WHERE T.col.value('@_type_[1]','int')=3
		UNION
		SELECT clientId
		FROM APP_ClientGroupAssoc JOIN  @inputmembersXml.nodes('App_MemberServers/memberServers/client') as T(col) ON T.col.value('@clientGroupId[1]','int')=clientGroupId
		WHERE T.col.value('@_type_[1]','int')=28
	--Update enabled monitoring policies for @clientIds
	INSERT INTO @enableMonitoringPolicy(clientId,policyId)
	SELECT DISTINCT  iClientId,M.monitorPolicyID from APP_MonitoringPolicy M JOIN APP_MonitoringPolicyProp Prop ON Prop.monitorPolicyId=M.monitorPolicyId and attrName='Monitoring Type' and attrVal='9' --HyperV Monitoring
		JOIN
		(SELECT iClientId,monitorPolicyId from APP_MonitorAssocEntity JOIN @inputClient ON iClientId=clientId and exclude=0
		UNION
		SELECT iClientId,monitorPolicyId from APP_MonitorAssocEntity MP JOIN APP_ClientGroupAssoc CG ON  CG.clientGroupId=MP.clientGroupId  and flags=28
								JOIN @inputClient ON iClientId= CG.clientId
		UNION
		SELECT iClientId,monitorPolicyId from APP_MonitorAssocEntity CROSS JOIN @inputClient  where flags=2
		EXCEPT
		SELECT iClientId,monitorPolicyId FROM APP_MonitorAssocEntity JOIN @inputClient ON iClientId=clientId  and exclude=1)TBl ON TBL.monitorPolicyId=M.monitorPolicyId AND status<>3 and status <>1
		ORDER BY iClientId,M.monitorPolicyId
	IF(@iOperation=1) --enable
	BEGIN
		--check if monitoring policy is alerady enabled
		INSERT INTO @operationDone
		SELECT iClientId FROM @inputClient INPUT LEFT OUTER JOIN @enableMonitoringPolicy ON clientID=iClientId WHERE clientId is NULL
		IF NOT  EXISTS(SELECT 1 FROM @operationDone )
		BEGIN
			SET @o_wasOperationAlreadyDone=1
			SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=1,@o_errorCode=0,@o_errorMessage=''
				GOTO EXIT_PROC
		END
		SET  @systemCreatedHyperVPolicy = ISNULL((Select TOP 1 monitorPolicyId from APP_MonitoringPolicyProp where attrName='System Created HyperV Policy' and attrVal=1   order by monitorPolicyId ),0)
		IF(@systemCreatedHyperVPolicy =0)
			SET @systemCreatedHyperVPolicy =ISNULL((SELECT TOP 1 MP.monitorPolicyId from APP_MonitoringPolicyProp Prop JOIN APP_MonitoringPolicy MP ON Mp.monitorPolicyId= PRop.monitorPolicyId  where attrNAme='Monitoring Type' and attrVal=9 and status=0),0)
		IF(@systemCreatedHyperVPolicy=0)
		BEGIN
			SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=0,@o_errorCode=1,@o_errorMessage= 'HyperV policy not found'
				GOTO EXIT_PROC
			RETURN
		END
		IF EXISTS(SELECT 1 FROM APP_MonitorAssocEntity where monitorPolicyId=@systemCreatedHyperVPolicy and flags=2)
		BEGIN
			DELETE TBL
			FROM APP_MonitorAssocEntity TBL JOIN @operationDone Op ON Op.clientId=TBL.clientId and TBl.exclude=1
		END
		ELSE
		BEGIN
			INSERT INTO APP_MonitorAssocEntity(monitorPolicyId,commcellId,flags,created,clientId,exclude,clientGroupId)
			SELECT @systemCreatedHyperVPolicy,2,3,dbo.GetUnixTime(GETDATE()),clientId,0,0
			FROM @operationDone
		END
		 INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId, 8,(SELECT @systemCreatedHyperVPolicy as '@monitoringPolicyId' , 1 as '@operationType',clientId as '@clientId'
								 FOR XML PATH ('TMMsg_MonitoringPolicyChangeReq')),        dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1        ---TMMsg::MonitoringPolicyOperationType_EDIT --WORK_TOKEN_LOGM
								 FROM @operationDone
		SELECT @o_monitoringPolicyId=@systemCreatedHyperVPolicy,@o_wasOperationAlreadyDone=0,@o_errorCode=0,@o_errorMessage=''
		GOTO EXIT_PROC
	END
	ELSE  IF(@iOperation=0) --disable
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM @enableMonitoringPolicy)
		BEGIN
			SET @o_wasOperationAlreadyDone=1
			SELECT @o_monitoringPolicyId=0,@o_wasOperationAlreadyDone=1,@o_errorCode=0,@o_errorMessage=''
				GOTO EXIT_PROC
		END
		DELETE TBL FROM APP_MonitorAssocEntity TBL JOIN @enableMonitoringPolicy EM ON policyId=monitorPolicyId  AND flags=3 and TBL.clientId=EM.ClientId and exclude=0
		--Exclude the clients if all clients is selected.
		INSERT INTO APP_MonitorAssocEntity(monitorPolicyId,commcellId,flags,created,clientId,exclude,clientGroupId)
		SELECT monitorPolicyId,2,3,dbo.GetUnixTime(GETDATE()),EM.clientId,1,0
		FROM APP_MonitorAssocEntity JOIN @enableMonitoringPolicy EM ON policyId=monitorPolicyId AND flags=2
		order by monitorPolicyId
		SET @systemCreatedHyperVPolicy = (SELECT TOP 1 policyId FROM @enableMonitoringPolicy ORDER by policyId)
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId, 8,(SELECT policyId as '@monitoringPolicyId' , 1 as '@operationType',clientId as '@clientId'
								 FOR XML PATH ('TMMsg_MonitoringPolicyChangeReq')),        dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1    ---TMMsg::MonitoringPolicyOperationType_EDIT --WORK_TOKEN_LOGM
								 FROM @enableMonitoringPolicy
		SELECT @o_monitoringPolicyId=@systemCreatedHyperVPolicy,@o_wasOperationAlreadyDone=1,@o_errorCode=0,@o_errorMessage=''
				GOTO EXIT_PROC
	END
END
EXIT_PROC:
IF (@iReturn=1)
	SELECT @o_monitoringPolicyId,@o_wasOperationAlreadyDone,@o_errorCode,@o_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'LMHyperVOperationOnClient')
	delete from GxQscripts where name = 'LMHyperVOperationOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMHyperVOperationOnClient')
	delete from GXDBVersions where aliasname = 'LMHyperVOperationOnClient'
GO

insert into GXDBVersions values(2, 'LMHyperVOperationOnClient',  '00000000000000000000', 'LMHyperVOperationOnClient', '00000000000000000000')
GO

