

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetUnloadedCoresTimeInterval.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Logesh G
--	Date:   02/12/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetUnloadedCoresTimeInterval.sp,v $ $Id: LMGetUnloadedCoresTimeInterval.sp,v 1.1.2.7 2018/03/27 09:08:14 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMGetUnloadedCoresTimeInterval()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Logesh G LMGetUnloadedCoresTimeInterval to give timeRange , userInfo while reIndexing. Those data to be used by task mgr to kick lm job.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetUnloadedCoresTimeInterval <<<'

IF EXISTS (select * from sysobjects where name='LMGetUnloadedCoresTimeInterval')
	drop procedure LMGetUnloadedCoresTimeInterval
IF EXISTS (select * from GxQscripts where name='LMGetUnloadedCoresTimeInterval')
	delete from GxQscripts where name = 'LMGetUnloadedCoresTimeInterval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetUnloadedCoresTimeInterval')
	delete from GXDBVersions where aliasname = 'LMGetUnloadedCoresTimeInterval'
GO
print '... Creating Procedure: LMGetUnloadedCoresTimeInterval'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetUnloadedCoresTimeInterval
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @mpIdTbl TABLE(mpId INT , startTime BIGINT , endTime BIGINT)
DECLARE @startTime BIGINT = 0
DECLARE @endTime BIGINT = 0
DECLARE @loginName NVARCHAR(MAX)
SET @loginName = (SELECT login FROM UMUsers WHERE id = @userId)
INSERT INTO @mpIdTbl(mpId)
SELECT ref.value('@val','INT') FROM @inputXml.nodes('LogMonitoring_GetReIndexTimeRangeReq/mpId') AS R(ref)
SET @startTime = ISNULL((SELECT ref.value('@startTime','NVARCHAR(MAX)') FROM @inputXml.nodes('LogMonitoring_GetReIndexTimeRangeReq') AS R(ref)) , 0 )
SET @endTime = ISNULL((SELECT ref.value('@endTime','NVARCHAR(MAX)') FROM @inputXml.nodes('LogMonitoring_GetReIndexTimeRangeReq') AS R(ref)) , 0)
IF @startTime <> 0 AND @endTime <> 0
BEGIN
	--Below statement will convert input times into midnight time respectively
	DECLARE @inputTime DATETIME = DATEADD(s, @startTime,'1970-01-01 00:00:00')
	SET @startTime = dbo.GetUnixTime( Convert(DATETIME, DATEDIFF(DAY, 0,@inputTime)))
	SET @inputTime = DATEADD(s, @endTime,'1970-01-01 00:00:00')
	SET @endTime = dbo.GetUnixTime( Convert(DATETIME, DATEDIFF(DAY, 0,@inputTime)))
END
DECLARE @midNightDate DATETIME
SET @midNightDate = ( SELECT Convert(DATETIME, DATEDIFF(DAY, 0,GETUTCDATE())))
set @outputXml = ISNULL((
select	mpTbl.mpId as '@mpId' ,
		monPol.MonitorPolicyName as '@mpName',
		(
			SELECT requestedTbl.StartTime AS '@startPeriod', requestedTbl.endTime AS '@endPeriod'
			FROM
			(
				SELECT startTime,
						endTime
				FROM App_LmCoreReqInfo reqTbl
				WHERE reqTbl.policyId = mpTbl.mpId
				UNION all
				SELECT dbo.GetUnixTime( dateadd(day, - CONVERT(INT,propTbl.attrVal),@midNightDate)) as startTime,
					   dbo.GetUnixTime(@midNightDate) as endTime
				FROM APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
				WHERE propTbl.attrName LIKE 'age ci data after days' AND propTbl.monitorPolicyId = mpTbl.mpId
			) AS requestedTbl
			order by requestedTbl.StartTime asc
			for xml path('requestedTimeInterval') , type
		)
from @mpIdTbl mpTbl
inner join APP_MonitoringPolicy monPol
on mpTbl.mpId = monPol.monitorPolicyId
INNER JOIN APP_MonitoringPolicyProp policyProp
ON policyProp.monitorPolicyId = monPol.monitorPolicyId
where monPol.status <> 3 AND policyProp.attrName like 'SubClient Id' AND policyProp.attrVal > 0
for xml path('reIndexTimeRangeInfoList') , root('LogMonitoring_reIndexTimeRangeResp')
)
,
	'<LogMonitoring_reIndexTimeRangeResp />'
)
IF @outputXml IS NOT NULL
BEGIN
--adding reIndexing timeRange
set @outputXml.modify('insert attribute startPeriod {sql:variable("@startTime")} into (/LogMonitoring_reIndexTimeRangeResp)[1]')
set @outputXml.modify('insert attribute endPeriod {sql:variable("@endTime")} into (/LogMonitoring_reIndexTimeRangeResp)[1]')
set @outputXml.modify('insert attribute userId {sql:variable("@userId")} into (/LogMonitoring_reIndexTimeRangeResp)[1]')
set @outputXml.modify('insert attribute loginName {sql:variable("@loginName")} into (/LogMonitoring_reIndexTimeRangeResp)[1]')
END
ELSE
BEGIN
	SET @outputXml = ''
END
select @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetUnloadedCoresTimeInterval')
	delete from GxQscripts where name = 'LMGetUnloadedCoresTimeInterval'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetUnloadedCoresTimeInterval')
	delete from GXDBVersions where aliasname = 'LMGetUnloadedCoresTimeInterval'
GO

insert into GXDBVersions values(2, 'LMGetUnloadedCoresTimeInterval',  '00010001000200070000', 'LMGetUnloadedCoresTimeInterval', '00010001000200070000')
GO

