

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetSubClientListForCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetSubClientListForCloud.sp,v $ $Id: LMGetSubClientListForCloud.sp,v 1.1.2.6 2018/03/27 09:07:59 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMGetSubClientListForCloud()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Logesh G LMGetSubClientListForCloud to give one pass subclient for given cloud.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetSubClientListForCloud <<<'

IF EXISTS (select * from sysobjects where name='LMGetSubClientListForCloud')
	drop procedure LMGetSubClientListForCloud
IF EXISTS (select * from GxQscripts where name='LMGetSubClientListForCloud')
	delete from GxQscripts where name = 'LMGetSubClientListForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSubClientListForCloud')
	delete from GXDBVersions where aliasname = 'LMGetSubClientListForCloud'
GO
print '... Creating Procedure: LMGetSubClientListForCloud'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetSubClientListForCloud
  @userId INTEGER,
  @outputXml XML OUTPUT
AS
DECLARE @lmCloudTbl TABLE(cloudId INT ,cloudName NVARCHAR(MAX),clientId INT)
INSERT INTO @lmCloudTbl
EXEC AppGetLMAnalyticsNodes @userId
SET @outputXml = (
						SELECT lmCloudTbl.cloudId AS '@cloudId' ,
							(
								SELECT  appTbl.id AS '@subclientId',appTbl.subclientName AS '@subclientName'
								FROM APP_Application appTbl WITH(NOLOCK)
								INNER JOIN APP_SubClientProp propTbl WITH(NOLOCK)
								ON appTbl.id = propTbl.componentNameId
								WHERE propTbl.attrName = 'is turbo subclient' AND propTbl.attrVal = 1 AND (appTbl.subclientStatus & 4 = 0) AND propTbl.modified = 0 AND
								appTbl.clientId =  (lmCloudTbl.clientId)
								FOR XML PATH('subClientInfo') , TYPE
							)
						FROM @lmCloudTbl lmCloudTbl
						FOR XML PATH('subClientInfo') , ROOT('LogMonitoring_GetLMSubClientListForCloudResp')
			)
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetSubClientListForCloud')
	delete from GxQscripts where name = 'LMGetSubClientListForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSubClientListForCloud')
	delete from GXDBVersions where aliasname = 'LMGetSubClientListForCloud'
GO

insert into GXDBVersions values(2, 'LMGetSubClientListForCloud',  '00010001000200060000', 'LMGetSubClientListForCloud', '00010001000200060000')
GO

