

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetSubClientAssociatedMonitoringPolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetSubClientAssociatedMonitoringPolicies.sp,v $ $Id: LMGetSubClientAssociatedMonitoringPolicies.sp,v 1.1.2.3 2018/03/27 09:20:01 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  LMGetSubClientAssociatedMonitoringPolicies()
--  |
--  | Description:  Given a subclientId , this sp will return list of monitoring policy ids which are associated to given subclient.
--  |
--  |   Revisions  Author                       Description
--  |   ---------  -------              --------------------------------
--  |   1.1        Logesh                       Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetSubClientAssociatedMonitoringPolicies <<<'

IF EXISTS (select * from sysobjects where name='LMGetSubClientAssociatedMonitoringPolicies')
	drop procedure LMGetSubClientAssociatedMonitoringPolicies
IF EXISTS (select * from GxQscripts where name='LMGetSubClientAssociatedMonitoringPolicies')
	delete from GxQscripts where name = 'LMGetSubClientAssociatedMonitoringPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSubClientAssociatedMonitoringPolicies')
	delete from GXDBVersions where aliasname = 'LMGetSubClientAssociatedMonitoringPolicies'
GO
print '... Creating Procedure: LMGetSubClientAssociatedMonitoringPolicies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LMGetSubClientAssociatedMonitoringPolicies
  @i_subClientId INTEGER
AS
  DECLARE @monitoringPolicyId INTEGER;
  DECLARE @monitoringType INTEGER;
DECLARE @policyTbl TABLE(policyId INT , policyType INT)
INSERT INTO @policyTbl(policyId)
SELECT DISTINCT policyTbl.monitorPolicyId as monitoringPolicyId
FROM APP_MonitoringPolicy policyTbl WITH(NOLOCK)
INNER JOIN APP_MonitoringPolicyprop policyPropTbl WITH(NOLOCK)
ON policyTbl.monitorPolicyId = policyPropTbl.monitorPolicyId AND policyTbl.status <> 3 AND policyPropTbl.attrName = 'SubClient Id' and CONVERT(INTEGER,policyPropTbl.attrVal) = @i_subClientId
INNER JOIN APP_MonitoringPolicyProp continuousTbl WITH(NOLOCK)
ON policyTbl.monitorPolicyId = continuousTbl.monitorPolicyId AND continuousTbl.attrName = 'Continuous monitoring' AND CONVERT(INTEGER,continuousTbl.attrVal) = 1
UPDATE @policyTbl
SET policyType = ISNULL(CONVERT(INTEGER,propTbl.attrVal),0)
FROM @policyTbl policyTbl
INNER JOIN APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
ON policyTbl.policyId = propTbl.monitorPolicyId AND propTbl.attrName = 'Monitoring Type'
SELECT policyId,policyType FROM @policyTbl
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetSubClientAssociatedMonitoringPolicies')
	delete from GxQscripts where name = 'LMGetSubClientAssociatedMonitoringPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSubClientAssociatedMonitoringPolicies')
	delete from GXDBVersions where aliasname = 'LMGetSubClientAssociatedMonitoringPolicies'
GO

insert into GXDBVersions values(2, 'LMGetSubClientAssociatedMonitoringPolicies',  '00010001000200030000', 'LMGetSubClientAssociatedMonitoringPolicies', '00010001000200030000')
GO

